// Persistence of Vision Ray Tracer Scene Description File
// File: scene3_.pov
// Vers: 3.6.1
// Desc: Scene 3 of Duel-Entry : Radar screen, UFO "bleeps" up 
// Date: 23.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 23.09.04 (dd.mm.yy)

//Description
// Scene 3 of Duel-Entry
// A radar screen is in view and quickly shows that the UFO is tracked.
// The watchful eye might see the "First contact: 1200", a hint at
// "highnoon".

/*Commandline
+KFI1 +KFF125 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#default{finish{ambient 1 diffuse 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 10
}

#declare Animation_Time = 5;

#include "duel.inc"
#include "timers.inc"
#include "glare.inc"

plane{z,.8 hollow
  pigment{
    gradient y color_map{
      [0 rgb y*.03]
      [.02 rgb y*.02]
      [1 rgb y*.02]
    }
    scale 3.242
    translate -y*2.5*Animation_Time*clock
  }
}

//These values will be used for the image-maps,
// but the camera gets modified to do the zoom
#declare Camera_Location = <0,0,-1>;
#declare Camera_Look_At = <0,0,0>;

//Clock for Cam-Movement
#declare Camera_Clock = Clock_Cubic(2,.5);

camera{
  location <0,0,-1>
  look_at <0,0,0>
  translate <-.14,.12,.2>*Camera_Clock
}

#declare Radar = 
texture{
  pigment{
    radial
    color_map{
      [0 rgbt <0,1,0,1>]
      [.22 rgbt <0,1,0,1>]
      [.245 rgb y*.5]
      [.2475 rgb y]
      [.25 rgb <.2,2,.2>]
      [.255 rgbt <0,1,0,1>]
      [1 rgbt <0,1,0,1>]
    }
    rotate x*-90 translate <.5,.5,0>
    phase -clock*Animation_Time*.5+.56
  }
  finish{ambient 1 diffuse 0}
}
texture{
  pigment{
    spherical color_map{
      [0 rgbt 1]
      //Outer circle
      [.09 rgbt 1]
      [.095 rgb .1]
      [.1 rgbt 1]
      //Middle circle
      [.49 rgbt 1]
      [.495 rgb .1]
      [.5 rgbt 1]
      //center spot
      [.95 rgbt 1]
      [.955 rgb .1]
      [1 rgb .1]
    }
    scale <1,1.33,1>*.4 translate <.5,.5,0>
  }
  finish{ambient 1 diffuse 0}
}


#declare Bleep1_Clock = Duration_Faded(1.8,2,<.1,1>);
#declare Overlay1_Clock = Duration_Faded(1.8,2.2,<.05,.2>);

#declare Bleep2_Clock = Duration_Faded(3.8,2,<.1,1>);
#declare Overlay2_Clock = Duration_Faded(3.8,2.2,<.05,.2>);


Glare_PlaceImage(Radar,.499)

#if (Bleep1_Clock)
  #declare Bleep1st = pigment{image_map{tga "texts\sc3_bl1.tga"}}
  Radar_Layer(Bleep1st,.5,<2,1,1-Bleep1_Clock>,1)
#end
#if (Overlay1_Clock)
  #declare Overlay1st = pigment{image_map{tga "texts\sc3_ov1.tga"}}
  Radar_Layer(Overlay1st,.501,<2,1,1-Overlay1_Clock>,1)
#end

#if (Bleep2_Clock)
  #declare Bleep2nd = pigment{image_map{tga "texts\sc3_bl2.tga"}}
  Radar_Layer(Bleep2nd,.502,<2,1,1-Bleep2_Clock>,1)
#end
#if (Overlay2_Clock)
  #declare Overlay2nd = pigment{image_map{tga "texts\sc3_ov2.tga"}}
  Radar_Layer(Overlay2nd,.503,<2,1,1-Overlay2_Clock>,1)
#end

