// Persistence of Vision Ray Tracer Scene Description File
// File: scene6_.pov
// Vers: 3.6.1
// Desc: Scene 6 of Duel-Entry : UFO's descent stops, moves horizontal
// Date: 28.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 03.10.04 (dd.mm.yy)

//Description
// Scene 6 of Duel-Entry
// A flyby of the UFO with my Glare-Effect applied. The glare is needed
// to show how the Jet sees the UFO in the next scene.

//Warning!!!
// This scene needs 2 passes: a first pass to generate Highlight-TGA-Images for
// the second pass, when the highlights will be added to the scene via my Glare-
// Macros for additional effect. If you're re-rendering the 1st pass, note that
// at the end of this scene, a commented line needs to be re-inserted to avoid
// loading the JPEGs supplied with the ZIP (which only reach from frame 26 to 62,
// which covers the needed data for the 75 original frames.

/*Commandline
1st Pass:
+KFI1 +KFF75 +FT +SF26 +EF62
2nd Pass:
+KFI1 +KFF75 +AM2 +A0.3 +R2
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 3;
//Set to 1 for Glare-Pass, 2 for final pass
// (ZIP comes with jpegs of first pass)
#declare Render_Pass = 2;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 25
}

#include "glare.inc"
#include "timers.inc"
#include "look_at.inc"
#include "bsplines.inc"
#include "bkdrp_desert.inc"

// UFO
//=====
#declare UFO_Path = array[4]
  {
    <0,180,20,0>,<0,-150,-5,0>,
    <0,20,-50,0>,<0,0,-60,0>,
  }

#if (!file_exists("splines/sc6_ufo.spl"))
  BSpline2Linear_Ext(UFO_Path,5000,75,"splines/sc6_ufo.spl","UFO_Path","UFO_PathLin")
#end
#include "splines/sc6_ufo.spl"


#declare UFO_Condition = 0;
#if (Render_Pass=1)
  #declare UFO_Textured = -1;
  #declare UFO_Lights = off;
#else
  #declare UFO_Textured = 1;
  #declare UFO_Lights = on;
#end

#declare UFO_LightClock = Animation_Time*clock+.5;

#include "ufo.inc"

object{UFO
  rotate Look_At(BSpline_Dir(UFO_Path,Linear_Mover(UFO_PathLin,clock)))
  translate Linear_Pos(UFO_PathLin,clock)
  pigment{rgb 0}
}

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

//Calls Macro to create Desert-Background
#if (Render_Pass=1)
  light_source{Desert_SunPos rgb 1}
#else
  Create_Backdrop()
  //Three point lighting to simulate ground-reflected/ambient light
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.2 shadowless}
#end

// Camera
//========
#declare Camera_Location = <6,25,-40>;
#declare Camera_Look_At = Linear_Pos(UFO_PathLin,Clock_Cubic(0,3)*.85)-y*80*(1-Clock_Cubic(0,2));

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Glare
//=======
// Glare is actually, much like the subtitles, a textured
// layer in front of the camera. It requires a first pass
// which collects specularity-data by rendering the scene
// with black textures and only specular highlights for
// surfaces which shall have the glare-effect.
#if (Render_Pass=2)
  #declare Glare_Clock = Duration_Faded(1,1.5,<.2,.15>);
  
  #if (Glare_Clock)
  //The following line is needed when the first pass was rendered to TGA
  //#declare Glare_Pigment=pigment{image_map{tga concat("scene6_",str(frame_number,-2,0),".tga")}}
  //In the ZIP, the JPEGs for the Glare are included
  #declare Glare_Pigment=pigment{image_map{jpeg concat("sc6_glare/scene6_",str(frame_number,-2,0),".jpg")}}
  
  Glare_OverblurredLayer(
    Glare_Pigment,
    .5,    //Distance to camera
    <2,80*Glare_Clock>, //Exponent & Brightness of color-map/image
    .2,    //Radius
    50,    //Samples
    2      //Recursions
  )
  #end
  
  //Ground-Texture
  #declare Clear = pigment{rgbt <.7,.3,.1,1>}
  #declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5>}

  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }

#end

