// Persistence of Vision Ray Tracer Scene Description File
// File: scene12_.pov
// Vers: 3.6.1
// Desc: Scene 12 of Duel-Entry : Jet waits for UFO to shoot first
// Date: 03.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 03.10.04 (dd.mm.yy)

//Description
// Scene 12 of Duel-Entry
// The jet ackowledges the UFO's ability and waits for his counter-attack.

/*Commandline
+KFI1 +KFF100 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 4;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

//Various Shakes for various objects
#declare Override_Shake=on;
Create_Shake(3,.02,84,"splines/sc12_jet.spl","Jet_Hover")
Create_Shake(5,.01,42,"splines/sc12_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,1,1,1>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

object{Jet
  rotate y*-90
  translate <0,25,0>+Linear_Pos(Jet_Hover,clock)
  }

// Camera
//========
#declare Camera_Location = <2,25.5,-3>;
#declare Camera_Look_At = <1,24.5,-.5>;

//Controls the subtle shake of the camera
#declare Focal_Distance = vlength(Camera_Look_At-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*Focal_Distance; 

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Subtitle
//==========
#declare txtJet_Clock = Duration(.5,3);
#if (txtJet_Clock)
  #declare txt_Jet = pigment{image_map{tga "texts/sc12_j.tga"}}
  Text_Layer(txt_Jet,.5,<2,1,0>,1)
#end

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}
//Lightgroup to avoid shadows
light_group{
  light_source{Desert_SunPos rgb 1 shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}