// Persistence of Vision Ray Tracer Scene Description File
// File: scene14_.pov
// Vers: 3.6.1
// Desc: Scene 14 of Duel-Entry : Jet shoots second missile, shot from beneath
// Date: 29.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 29.09.04 (dd.mm.yy)

//Description
// Scene 14 of Duel-Entry
// Counter-Scene to UFO's second shot: Jet, viewed from beneath, firing 2nd
// missile.

/*Commandline
+KFI1 +KFF50 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 2;

global_settings{
  assumed_gamma 1
  max_trace_level 56
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

//Various Shakes for various objects
Create_Shake(3,.02,67,"splines/sc14_jet.spl","Jet_Hover")
Create_Shake(4,.01,37,"splines/sc14_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
//Arealight from below as the view is focused on details underneath
//the jet.
light_source{<0,6,5> rgb Desert_BaseColor*.3
  area_light x*5,z*5,25,25 orient circular adaptive 2
}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,1,1,0>;
#declare Jet_Exhaust = .5;

#include "jet.inc"

object{Jet
  rotate y*-90
  translate <0,25,0>+Linear_Pos(Jet_Hover,clock)
  }

// Missile
//=========
//Clocks for the Missile
#declare MisDrop_Clock = Clock_Cubic(.5,.5);
#declare MisGo_Clock = Clock_Cubic(.85,4);
//Position for the missile
#declare Missile_Align = vrotate(Jet_MissilePos_4,y*-90)+y*25+Linear_Pos(Jet_Hover,clock);
#declare Missile_Move = <-.25,-.3,0>*MisDrop_Clock+<50,0,0>*MisGo_Clock;
#declare Missile_Position = Missile_Align+Missile_Move;

object{
  Missile(MisDrop_Clock)
  //Fit to Jet
  translate Jet_MissilePos_4
  rotate y*-90
  translate <0,25,0>+Linear_Pos(Jet_Hover,clock)
  //Move
  translate Missile_Move
}

// Camera
//========
#declare Camera_Location = <5,22,-4.5>;
#declare Camera_Look_At = <2,24,2>;

//Controls the subtle shake of the camera
#declare Focal_Distance = vlength(Camera_Look_At-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*Focal_Distance; 

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Smoke
//=======
#if (MisDrop_Clock & MisDrop_Clock != 1)
  #declare A=0;
  #while (A<5)
    Add_Smoke(
      Missile_Position-x*.75,
      <-20,0,0>,
      .1,
      2)
    #declare A=A+1;
  #end
#end

Parsys_Run()

//This orients the shadow-parts of the smoke-particles, since we're
//looking from below and have a proper lightsource there, the "sunlight"
//has to be modified for the particles.
#declare Desert_SunPos = <0,6,5>;
Show_Smoke()

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

disc{
  y*10,y,120 hollow
  pigment{
    spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
  }
  no_shadow
}
