// Persistence of Vision Ray Tracer Scene Description File
// File: scene18_.pov
// Vers: 3.6.1
// Desc: Scene 18 of Duel-Entry : UFO tries to evade Missile #2
// Date: 05.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 05.10.04 (dd.mm.yy)

//Description
// Scene 18 of Duel-Entry
// The UFO tries to evade, moving away from camera.

/*Commandline
+KFI1 +KFF50 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 2;

global_settings{
  assumed_gamma 1
  max_trace_level 256
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(4,.075,1,"splines/sc18_ufo.spl","UFO_Hover")
Create_Shake(8,1,7,"splines/sc18_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}

// UFO
//=====
#declare UFO_Condition = 0;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = Animation_Time*clock+.72;

#include "ufo.inc"

#declare UFO_Tilt = Clock_Cubic(0,.5);
#declare UFO_DeTilt = Clock_Cubic(.5,1);
#declare UFO_Move = Clock_Cubic(0,1.5);

object{UFO
  rotate y*90
  rotate x*15*(UFO_Tilt-UFO_DeTilt)
  translate z*8*UFO_Move
  translate <0,25,0>+Linear_Pos(UFO_Hover,clock)
  }

// Camera
//========
#declare Camera_Location = <0+2*clock,25.2,-7>;
#declare Camera_Focal = <-2+2*clock,25,0>;

#declare Camera_FocalLength = vlength(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location)+Linear_Pos(Cam_Focal,clock)*.02;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate x*.5*Animation_Time*clock}

light_group{
  light_source{Desert_SunPos rgb Desert_SunColor shadowless}
  light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4> shadowless}
  light_source{<0,6,5> rgb Desert_BaseColor*.3 shadowless}
  disc{
    y*5,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}
