// Persistence of Vision Ray Tracer Scene Description File
// File: scene26_.pov
// Vers: 3.6.1
// Desc: Scene 26 of Duel-Entry : UFO-Drop
// Date: 07.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 07.10.04 (dd.mm.yy)

//Description
// Scene 26 of Duel-Entry
// UFO tumbles towards the ground

/*Commandline
+KFI1 +KFF125 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 6;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 200 //<- Lots of transparent particles require high trace_level
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "io_macs.inc"
#include "bkdrp_ns.inc" //<- Modified version of "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(33,1,94,"splines/sc26_ufo.spl","UFO_Shake")
Create_Shake(52,1,81,"splines/sc26_cam.spl","Cam_Focal")

// Backdrop
//==========
#declare Desert_HFDetail = 900;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 10;

//Three-point lighting on the ground is integrated into modified version
// of the background. It still only places the sunlight, hence the other
// two lightsources for other in-scene objects still need to be placed.
Create_Backdrop()
//Three point lighting to simulate ground-reflected/ambient light
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4>*2 shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.4 shadowless}

// UFO
//======
#declare UFO_Pos = <0,1200,0>-y*20*pow(1+Animation_Time*clock,2);
#declare Mis_Impact = Load_Value("ufo/ufo_hit.vec");

#declare UFO_Condition = 1;
#declare UFO_Textured = 1;
#declare UFO_Lights = 0;
#declare UFO_LightClock = 0;

#include "ufo.inc"

object{UFO
  rotate <90,90-10*clock,0>
  rotate x*(-210-230*Animation_Time*clock)
  translate UFO_Pos+Linear_Pos(UFO_Shake,clock)*.2
}

#declare Mis_Impact = vrotate(vrotate(Mis_Impact,<90,90-10*clock,0>),x*(-210-230*Animation_Time*clock))+UFO_Pos;

// Camera
//========
#declare Camera_Location = vrotate(UFO_Pos+<0,25-15*clock,-14-8*clock>,y*(135+200*Clock_Cubic(0,2)+230*Clock_Cubic(2,4)));

#declare Camera_Focal = UFO_Pos+y*(6-2*clock);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*.08;

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Smoke
//=======
#declare Particle_Rotation = Look_At(Camera_Location-UFO_Pos);

//Smoke-Trail from UFO
ParticleGroup_Begin("particles/smoke25",<1/50,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*clock,50,.05)
ParticleGroup_LinearWind(-z,5,.1)
ParticleGroup_End()

//Particle for Smoke-Trail
#macro SmokeTrail_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Particle_Rotation;
  #local _Data4 = Data[4];
  intersection{
    sphere{0,1 hollow
    pigment{
      cylindrical
      color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.2 transmit .4+.6*pow(Ager,3)]}
      translate _Data4*(10+2*Age)
      warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
      translate _Data4*-(10+2*Age)
      scale .6
      rotate y*_Data4.y*360
    }
    #if (Preview_Booms)
      pigment{rgb <.2,.2,.2>}
    #end
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_shadow
  }
#end

#macro Add_AgedSmoke(Pos,Dir,Size,Age,Born)
  Particle_Add("particles/smoke25",
    array[5]{
    <0,Age,Born+clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
    <20,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })
#end


//Adds smoke
#if (frame_number=1)
  #declare A=0;
  #while (A<40)
    Add_AgedSmoke(Mis_Impact+y*A,<0,0,0>,1.5,2.5,-A/50)
    #declare A=A+1;
  #end
  Save_Value(Mis_Impact,"particles/sc26.vec")
#end

#if (frame_number!=1)
  #declare Former_Position = Load_Value("particles/sc26.vec");
  #declare Current_Position = Mis_Impact;
  Save_Value(Mis_Impact,"particles/sc26.vec")
  #declare _Dist = vlength(Former_Position-Current_Position);  
  #declare _Nor = (Former_Position-Current_Position);
  #declare A=0;
  #while (A<ceil(_Dist))
    Add_AgedSmoke(Mis_Impact+_Nor*A/(ceil(_Dist)),<0,0,0>,1.5,2.5,-A/25)
    #declare A=A+1;
  #end
#end

//Add_Smoke(Mis_Impact,<0,0,0>,2,2.5)
Parsys_Run()
Show_Particles("particles/smoke25","SmokeTrail_Particle")
