// Persistence of Vision Ray Tracer Scene Description File
// File: scene27_.pov
// Vers: 3.6.1
// Desc: Scene 27 of Duel-Entry : UFO-Drop and Impact
// Date: 08.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 09.10.04 (dd.mm.yy)

//Description
// Scene 27 of Duel-Entry
// UFO leaves smoke-trail behind as it plummets to the ground. It hits the
// earth near the camera and creates a plume of dust, which spreads towards
// the camera and causes it to shake violently.

/*Commandline
+KFI1 +KFF75 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 3;

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 200
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(6,1,46,"splines/sc27_cam1.spl","Cam_Focal")
Create_Shake(13,1,62,"splines/sc27_cam2.spl","Cam_Shake")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;
Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4>*2 shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.4 shadowless}

// UFO
//=====
#declare UFO_Pos = <0,400,0>-y*400*Clock_Linear(0,2);
#declare Mis_Impact = Load_Value("ufo/ufo_hit.vec");

//UFO in "Hit"-Condition
#declare UFO_Condition = 1;
#declare UFO_Textured = 1;
#declare UFO_Lights = 0;
#declare UFO_LightClock = 0;
#include "ufo.inc"

object{UFO
  rotate <90,90-10*clock,0>
  rotate x*(-276-230*Clock_Linear(0,2)*2)
  translate UFO_Pos
}

#declare Mis_Impact = vrotate(vrotate(Mis_Impact,<90,90-10*clock,0>),x*(-276-230*Clock_Linear(0,2)*2))+UFO_Pos;

// Camera
//========
#declare Camera_Location = <30,5,-35>;
#declare Camera_Focal = UFO_Pos+y*(6-2*clock);
#declare Camera_Look_At = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Shake,Clock_Linear(2,1))*.22*Duration(2,1);
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,Clock_Linear(0,2))*.04*Duration(0,2);

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Smoke and Dust
//================
//Generates Normal for the Particles' orientation
#declare Particle_Rotation = Look_At(Camera_Location-UFO_Pos);

//Smoke-Trail from UFO
ParticleGroup_Begin("particles/smoke27",<1/50,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*clock,50,.05)
ParticleGroup_LinearWind(-z,5,.1)
ParticleGroup_End()
//Dust kicked off by impact
ParticleGroup_Begin("particles/dust27",<1/25,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*clock,50,.05)
ParticleGroup_LinearWind(-z,5,.1)
ParticleGroup_End()

//Smoke-Particle
#macro SmokeTrail_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Particle_Rotation;
  #local _Data4 = Data[4];
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.2+.3 transmit .4+.6*pow(Ager,3)]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_shadow
  }
#end
//Placing Macro
#macro Add_AgedSmoke(Pos,Dir,Size,Age,Born)
  Particle_Add("particles/smoke27",
    array[5]{
    <0,Age,Born+clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
    <20,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })
#end

//Desert-Dust-Particle
#macro Dust_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Particle_Rotation;
  #local _Data4 = Data[4];
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb min(_Data4.y+.4,1)*Desert_BaseColor]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .8
        rotate y*_Data4.y*360
      }
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale (1+3*min(Ager*20,1))*(Data[1].y+4*Ager)
    translate _Pos*<1,min(Ager*20,1),1>
    no_shadow
  }
#end

//Add smoke-trail
#if (frame_number=1)
  #declare A=0;
  #while (A<250)
    Add_AgedSmoke(Mis_Impact+y*200*A/50,<0,0,0>,1.5,2.5,-A/50)
    #declare A=A+1;
  #end
  Save_Value(Mis_Impact,"particles/sc27.vec")
#end
#if (frame_number!=1 & Clock_Linear(0,2)!=1)
  #declare Former_Position = Load_Value("particles/sc27.vec");
  Save_Value(Mis_Impact,"particles/sc27.vec")
  #declare _Dist = vlength(Former_Position-Mis_Impact);  
  #declare _Nor = (Former_Position-Mis_Impact);
  #declare A=0;
  #while (A<ceil(_Dist))
    Add_AgedSmoke(Mis_Impact+_Nor*A/(ceil(_Dist)),<0,0,0>,1.5,2.5,(-A/ceil(_Dist))*clock_delta*Animation_Time)
    #declare A=A+1;
  #end
#end

//Add Dust-Plume
#declare _R=seed(frame_number);
#if (Clock_Linear(1.95,2) & Clock_Linear(1.95,1)!=1)
  #declare A=0;
  #while (A< (50+400*pow(Clock_Linear(2,.5),2)) )
    #declare Rot= (90-45*Clock_Linear(2.4,.4))*(rand(_R)*2-1);
    #declare Pos = vrotate(<3+(35*Clock_Linear(2,.5))*sqrt(rand(_R)),.25,0>,y*(45+Rot));
    #declare Dir = vrotate(vrotate(<0,1,0>*(100-90*pow(Clock_Linear(2,.5),.25))*sqrt(rand(_R)),z*(-10-25*rand(_R))),y*(45+Rot));
    Particle_Add("particles/dust27",
      array[5]{
        <0,2,clock*Animation_Time+clock_delta*Animation_Time*rand(_R)>,
        <0,1,0>,
        Pos,
        Dir,
        <rand(_R),rand(_R),rand(_R)>
      })
    #declare A=A+1;
  #end
#end

//Run the particle-simulation
Parsys_Run()
//Show particles
Show_Particles("particles/smoke27","SmokeTrail_Particle")
Show_Particles("particles/dust27","Dust_Particle")

// Shockwave
//===========
#if ( Clock_Linear(2,.5) )
  #declare Shockwave_Dirty =
    pigment{
      bozo
      color_map{
        [0 rgbt 1]
        [1 rgbt 1 transmit .7+.3*Clock_Linear(2,.5)]
      }
      scale .02
      translate y*.1*Clock_Linear(2,.5)
      warp{black_hole <0,0,0>,1.2 falloff 2 strength 2+2*Clock_Linear(2,1)}
    }
  #declare Shockwave_None = pigment{rgbt <0,0,0,1>}
  disc{y*.001,y,1,.4 hollow
    pigment{
      spherical
      pigment_map{
        [0 Shockwave_None]
        [.01 Shockwave_Dirty]
        [.35+.4*Clock_Linear(2,.5) Shockwave_None]
        [1 Shockwave_None]
      }
    }
    scale 6+35*sqrt(Clock_Linear(2,.5))
    finish{ambient .5}
    no_shadow
  }
#end