// Persistence of Vision Ray Tracer Scene Description File
// File: scene28_.pov
// Vers: 3.6.1
// Desc: Scene 28 of Duel-Entry : Dust fades away and reveals the devestated UFO
// Date: 10.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 12.10.04 (dd.mm.yy)

//Description
// Scene 28 of Duel-Entry
// Dust fades away and camera moves up to the wrecked UFO. It's sparking
// and loses some greenish, alien liquid.

/*Commandline
+KFI1 +KFF175 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 7;
#declare _FR = seed(frame_number);

#default{finish{ambient 0}}
global_settings{
  assumed_gamma 1
  max_trace_level 200
}

//Set to 1 for lower Res of meshes and simpler particles
#declare Preview = 0;

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_cr.inc" //<- modified backdrop with hole in ground for the crater

// Shakes
//========
Create_Shake(16,1,43,"splines/sc28_dust.spl","Dust_Shake")
Create_Shake(35,1,35,"splines/sc28_sprk.spl","Sparks_Shake")
Create_Shake(15,1,24,"splines/sc28_oil.spl","Oil_Shake")
Create_Shake(10,1,64,"splines/sc28_cam.spl","Cam_Shake")

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 0;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;
Create_Backdrop()
light_source{<-1,1,-1>*Desert_SunPos rgb <.2,.2,.4>*2 shadowless}
light_source{<-1,-1,1>*Desert_SunPos rgb Desert_BaseColor*.4 shadowless}

// UFO
//=====
#declare UFO_Pos = <0,-9,-2>;

//UFO in "Wrecked"-Condition when dust
//fades away
#if (frame_number=1 | Clock_Linear(1,1)!=0)
  #declare UFO_Condition = 2;
#else
  #declare UFO_Condition = -1;
#end

#declare UFO_Textured = 1;
#declare UFO_Lights = 0;
#declare UFO_LightClock = 0;

#include "ufo.inc"

#declare UFO_Transform =
  transform{
    rotate y*90
    rotate z*-90
    rotate x*87
    rotate z*35
    translate UFO_Pos
  }
#declare UFO_TrFunction = function{transform{UFO_Transform}}

#declare UFO_Object=object{UFO transform UFO_Transform}
object{UFO_Object pigment{rgb x}}

//Some calculations for the origin of the sparks
#declare Spark_Origin = vrotate(<1.1,0,0>,y*35)+y*1.1;
#declare _Sx = Spark_Origin.x;
#declare _Sy = Spark_Origin.y;
#declare _Sz = Spark_Origin.z;

#declare Spark_Origin = UFO_TrFunction(_Sx,_Sy,_Sz);
#declare Cockpit_Center = UFO_TrFunction(0,1,0);

// Camera
//======== 
#declare Camera_Location = y*5+<4,-9.5,3>+<29,22,-32>-<29,22,-32>*Clock_Cubic(1,4);
#declare Camera_Focal = <0,-4,-2>-<0,4,-1.5>*Clock_Cubic(2,2);
#declare Camera_Focal = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Focal;
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Shake,Clock_Linear(0,7))*(.02-.01*Clock_Linear(4,1));

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Dust Layer in front of Camera
//===============================
#if (Clock_Linear(0,4)!=1)
#declare Dust_Texture =
  texture{
    pigment{
      bozo
      color_map{
        [0 rgb Desert_BaseColor*.16 transmit Clock_Cubic(1,3)]
        [1 rgb Desert_BaseColor*(.25-.1*Clock_Linear(1,3)) transmit Clock_Linear(1,3)]
      }
      scale .18
      translate Linear_Pos(Dust_Shake,Clock_Linear(0,5))*.2
      warp{turbulence .2 omega .6 octaves 12 lambda 2.5}
      translate -Linear_Pos(Dust_Shake,Clock_Linear(0,5))*.2
      translate <0,12,1>*Clock_Linear(0,2)+<8,0,1>*Clock_Cubic(1,3)
    }
    finish{ambient .7 diffuse 0}
  }
Glare_PlaceImage(Dust_Texture,1)
#end


// Crater
//========
#declare Crater_MainTex = texture{pigment{rgb Desert_BaseColor}}
#declare Crater_CenterTex =
  texture{
    pigment{
      bozo
      color_map{
        [0 rgb Desert_BaseColor]
        [1 rgb Desert_BaseColor*.9]
      }
      scale 1.5
      warp{black_hole <0,-6,0>,19 falloff 2 strength 6}
      warp{black_hole <0,-6,0>,13 falloff 2 strength 4}
      warp{black_hole <0,-6,0>,8 falloff 2 strength 2}
    }
    normal{
      bozo .1 no_bump_scale poly_wave 2 scale .8
      warp{black_hole <0,-6,0>,19 falloff 2 strength 6}
      warp{black_hole <0,-6,0>,13 falloff 2 strength 4}
      warp{black_hole <0,-6,0>,8 falloff 2 strength 2}
      turbulence .2 omega .65 octaves 11 lambda 2.5
    }
  }


#declare Crater_Object=
object{
  #if (!Preview)
    #include "crater.msh"
  #else
    #include "crater_l.msh"
  #end
  texture{
    spherical
    texture_map{
      [0 Crater_MainTex scale 1/20]
      [.2 Crater_CenterTex scale 1/20]
      [1 Crater_CenterTex scale 1/20]
    }
    scale 20
  }
  scale 1.5
  translate y*.01
}

object{Crater_Object}

// Smoke, Sparks and Liquid
//==========================
//Generates Normal for the Particles' orientation
#declare Particle_Rotation = Look_At(Camera_Location-Camera_Focal);

//Smoke-Group
ParticleGroup_Begin("particles/smoke28",<1/25,1/25,0>)
ParticleGroup_TurbWind(3,.65,12,.05,y*50*Animation_Time*clock,30,.05)
ParticleGroup_End()
//Spark-Group
ParticleGroup_Begin("particles/sparks28",<1/25,1/25,0>)
ParticleGroup_Object("UFO_Object", 1, 1, 0, "none", "none")
ParticleGroup_Object("Crater_Object", 1, 1, 0, "none", "none")
ParticleGroup_Gravity(8,-y)
ParticleGroup_End()
//Liquid-Group
ParticleGroup_Begin("particles/oil28",<1/25,1/25,0>)
ParticleGroup_Object("UFO_Object", .01, .9, 0, "none", "none")
ParticleGroup_Object("Crater_Object", .01, .9, 0, "none", "none")
ParticleGroup_Gravity(12,-y)
ParticleGroup_End()

// Particle-Macros
//=================

//Particle for Smoke
#macro SmokeTrail_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  #local _CamPos = Camera_Location;
  #local _Rot = Particle_Rotation;
  #local _Data4 = Data[4];
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.1 transmit .4+.6*pow(Ager,3)]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
      #if (Preview)
        pigment{rgb .2}
      #end
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate _Rot
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    #if (!Preview)
      no_shadow no_reflection
    #end
  }
  #if (!Preview)
  //Shadow
  #local Shadow_Rotation = Look_At(vnormalize(Desert_SunPos)*1750-_Pos);
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.2+.3 transmit .8]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate Shadow_Rotation
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_image no_reflection
  }
  //Reflection
  #local Reflection_Rotation = Look_At(Cockpit_Center-_Pos);
  intersection{
    sphere{0,1 hollow
      pigment{
        cylindrical
        color_map{[0 rgbt <0,0,0,1>][1 rgb _Data4.y*.1 transmit .4+.6*pow(Ager,3)]}
        translate _Data4*(10+2*Age)
        warp{turbulence .6 omega .45 lambda 2.5 octaves 9}
        translate _Data4*-(10+2*Age)
        scale .6
        rotate y*_Data4.y*360
      }
      #if (Preview)
        pigment{rgb .2}
      #end
    }
    box{<-1.1,0,-1.1>,1.1 pigment{rgbt 1}}
    rotate x*-90
    scale <1,1,.5>
    rotate Reflection_Rotation
    scale 1/1.8*(Data[1].y+1.5*min(Age,1)+.3*min(Age*10,1))*3
    translate _Pos
    no_shadow no_image
  }
  #end
#end
//Particle for Sparks
#macro Spark_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  #local _Pos = Data[2];
  sphere{0,1 hollow
    pigment{rgbt 1}
    #if (Preview)
      pigment{rgb <1,1,0>}
    #end
    interior{
      media{
        emission 8
        method 2 intervals 5 samples 1,1
        density{spherical poly_wave 2 color_map{[0 rgb 0][.5 rgb <.7,.2,0>][1 rgb <1,.8,.3>]}}
      }
    }
    scale <1,1,1>*Data[1].y
    scale <1,1,3>
    rotate Look_At(Data[3])
    translate _Pos
    no_shadow
  }
#end
//Particle for Liquid
#macro Oil_Particle(Data)
  #local Age=Data[0].x;
  #local MaxAge=Data[0].y;
  #local Ager = Age/MaxAge;
  sphere{0,2,1-Ager*.95
    scale <1,1,1.75>*Data[1].y
    rotate Look_At(Data[3])
    translate Data[2]
  }
#end

// Sparks
//========
#declare Spark_Size = Linear_Pos(Sparks_Shake,mod(Animation_Time*clock,2)/2);
#if (Spark_Size.x > .2)
  sphere{0,1 hollow
    pigment{rgbt 1}
    interior{
      media{
        emission 8
        method 2 intervals 5 samples 1,1
        density{spherical poly_wave 2 color_map{[0 rgb 0][.5 rgb <.7,.2,0>][1 rgb <1,.8,.3>]}}
      }
    }
    scale .4+.1*Spark_Size
    translate Spark_Origin
  }
#end

#if (Spark_Size.x > .4)
  #declare A=0;
  #while (A<5+max(Spark_Size.y*10,0))
    #declare Dir = vnormalize(<rand(_FR),rand(_FR),rand(_FR)>*2-1)*(3+3*rand(_FR))+y*max(Spark_Size.z,0);
    Particle_Add("particles/sparks28",
      array[4]{
        <0,.75,clock*Animation_Time+clock_delta*Animation_Time*rand(SmokeRand)>,
        <10,.1,0>,
        Spark_Origin,
        Dir}
      )
    #declare A=A+1;
  #end
#end

// Liquid
//========
#declare Oil_Start = <-.2,-4,.4>;
#declare Oily = trace(UFO_Object,Oil_Start,-y);

#declare A=0;
#while (A<3+7*Clock_Linear(2,1))
  #declare Dir = vnormalize(Linear_Pos(Oil_Shake,clock)*.4+vnormalize(<rand(_FR),rand(_FR),rand(_FR)>*2-1)*.2+y*.3)*1.5;
  Particle_Add("particles/oil28",
    array[4]{
    <0,2.5,clock*Animation_Time+clock_delta*Animation_Time*rand(_FR)>,
    <10,.03,0>,
    Oily+y*.1,
    Dir
    })
#declare A=A+1;
#end

// Smoke
//=======
//Placing Macro for smoke
#macro Add_AgedSmoke(Pos,Dir,Size,Age,Born)
  Particle_Add("particles/smoke28",
    array[5]{
    <0,Age,Born+clock*Animation_Time>,
    <20,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })
#end

#declare _R = seed(25);

#declare SmallSmokeTrails = 5;
#declare SmSmoke = Load_Array("ufo/smoke.arr");

#declare A=0;
#while (A<1)
  //Main Smoke-Column by UFO
  Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,0)
  Add_AgedSmoke(UFO_Pos+<-4,-1,0>,<0,35,0>,1.5,2.5,-clock_delta*Animation_Time/2)
  //Small Smoke-Trails
  #declare B=0;
  #while (B<SmallSmokeTrails)
    Add_AgedSmoke(SmSmoke[B+9],<0,15,0>,.1,1,0)
    #declare B=B+1;
  #end
  #declare A=A+1;
#end

//Run the particle-simulation
Parsys_Run()
//The visible part of the smoke is lit via a lightgroup, as the lighting
// calculations for the particles skyrocket when the shadow-part throws
// shadows onto the visible part.
light_group{
  light_source{vnormalize(Desert_SunPos)*1750 rgb 1 shadowless}
  union{
    Show_Particles("particles/smoke28","SmokeTrail_Particle")
    pigment{rgb x}
  }
  global_lights off
}

Show_Particles("particles/sparks28","Spark_Particle")
blob{threshold .2 
  Show_Particles("particles/oil28","Oil_Particle")
  sphere{0,1,1 translate -20}
  hollow
  pigment{rgbt 0 transmit .85}
  pigment{rgbft <.2,1,.3,.4,.6>}
  #if (Preview)
    pigment{rgb 1}
  #end
  interior{
    ior 1.65
    fade_power 2 fade_distance .15 fade_color <.2,1,.3>*.25
  }
  finish{
    specular 1 roughness .005
  }
}
