// Persistence of Vision Ray Tracer Scene Description File
// File: scene29_.pov
// Vers: 3.6.1
// Desc: Scene 29 of Duel-Entry : Jet shoots last missiles
// Date: 13.10.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 13.10.04 (dd.mm.yy)

//Description
// Scene 29 of Duel-Entry
// Jet shoots the last missiles to finish the UFO off. The final
// sentence is begun: "Some things..."

/*Commandline
+KFI1 +KFF125 +AM2 +A0.3 +R1
*/

//Homepage:
// www.nolights.de
//Email:
// LOWERCASEONLYtimISNTnikias[AT]gmx.netWARE

#declare Animation_Time = 5;

global_settings{
  assumed_gamma 1
  max_trace_level 200
}

#include "duel.inc"
#include "booms.inc"
#include "timers.inc"
#include "bkdrp_desert.inc"

// Shakes
//========
Create_Shake(8,1,34,"splines/sc29_cam.spl","Cam_Focal")
Create_Shake(9,1,52,"splines/sc29_jet.spl","Burner_Strength")

// A few timers
//==============
#declare Start_CamDescend = 1.5; //+2 seconds for descent
#declare Start_CamDistance = <10,4,1.5>;
#declare Drop_Missiles=Start_CamDescend+2+.25; //+.5 seconds for drop  

// Backdrop
//==========
#declare Desert_HFDetail = 450;
#declare Desert_HF_Smooth = on;
#declare Desert_BaseColor = <.7,.3,.1>;
#declare Desert_UseDetailTex = false;
#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1200,-900>;
#declare Desert_SunArealights = 25;
#declare Desert_SunColor = 1;
#declare Desert_SunSizeMultiplier=1;

#declare Desert_Clouds = on;
#declare Desert_CloudTransform = transform{translate x*.01*clock*Animation_Time}
#declare Desert_CloudPercentage = 40;
#declare Desert_CloudShadow = off;

#declare Desert_ObjectScale = 1;

Create_Backdrop()
//Two lights for blue ambient to show up properly on several angles
//of the objects
light_source{<-1,1,-1>*Desert_SunPos+x*1000 rgb <.2,.2,.4>*.15 shadowless}
light_source{<-1,1, 1>*Desert_SunPos+x*1000 rgb <.2,.2,.4>*.15 shadowless}
light_source{<0,2,0> rgb Desert_BaseColor*.4 shadowless}

// Jet
//=====
#declare Jet_Condition = 0;
#declare Jet_Textured = 1;
#declare Jet_Missiles = <0,0,0,0>;
#declare Jet_Exhaust = .5+1*(Linear_Pos(Burner_Strength,clock)*.1).x;

#include "jet.inc"

object{Jet
  rotate y*-90
  translate <0,25,0>
  }

// Missile #1
//============
#declare Remaining_Time = Animation_Time-(Drop_Missiles+1.35);

#declare Mis1Drop_Clock = Clock_Cubic(Drop_Missiles,.5);
#declare Mis1SpeedUp_Clock = Clock_Linear(Drop_Missiles+.35,1);
#declare Mis1Move_Clock = Clock_Linear(Drop_Missiles+1.35,Remaining_Time);

#declare Mis1Twist1_Clock = Clock_Cubic(Drop_Missiles+.05,.5);
#declare Mis1Twist2_Clock = Clock_Cubic(Drop_Missiles+.55,Remaining_Time);

#declare Mis1_Vel = (1000/6.5);

#declare Missile1_Move = vrotate(Jet_MissilePos_3,y*-90)+y*25+<-1.2,-1.3,.2>*Mis1Drop_Clock;
//Speed up till desired velocity
#declare Missile1_Move = Missile1_Move+x*Mis1_Vel/2*pow(Mis1SpeedUp_Clock,2);
//Move by desired velocity
#declare Missile1_Move = Missile1_Move+Mis1_Vel*Mis1Move_Clock*Remaining_Time;

object{
  Missile(Mis1Drop_Clock)
  rotate z*120*pow(Mis1Twist1_Clock,2)
  rotate z*240*Mis1Twist2_Clock*Remaining_Time
  rotate y*-90
  translate Missile1_Move
}

// Missile #2
//============
#declare Remaining_Time = Animation_Time-(Drop_Missiles+1.45);

#declare Mis2Drop_Clock = Clock_Cubic(Drop_Missiles+.1,.5);
#declare Mis2SpeedUp_Clock = Clock_Linear(Drop_Missiles+.45,1);
#declare Mis2Move_Clock = Clock_Linear(Drop_Missiles+1.45,Remaining_Time);

#declare Mis2Twist1_Clock = Clock_Cubic(Drop_Missiles+.15,.5);
#declare Mis2Twist2_Clock = Clock_Cubic(Drop_Missiles+.65,Remaining_Time);

#declare Mis2_Vel = (1000/6.5);

#declare Missile2_Move = vrotate(Jet_MissilePos_2,y*-90)+y*25+<-1.2,-1.4,-.15>*Mis2Drop_Clock;
//Speed up till desired velocity
#declare Missile2_Move = Missile2_Move+x*Mis2_Vel/2*pow(Mis2SpeedUp_Clock,2);
//Move by desired velocity
#declare Missile2_Move = Missile2_Move+Mis2_Vel*Mis2Move_Clock*Remaining_Time;

object{
  Missile(Mis2Drop_Clock)
  rotate z*100*pow(Mis1Twist1_Clock,2)
  rotate z*200*Mis1Twist2_Clock*Remaining_Time
  rotate y*-90
  translate Missile2_Move
}

// Camera
//========
#declare Cam_Distance = y*Start_CamDistance.x;
#declare Cam_Distance = y*(Cam_Distance-Start_CamDistance.y*Clock_Cubic(Start_CamDescend,2));
#declare Cam_Distance = y*(Cam_Distance-Start_CamDistance.z*Clock_Cubic(Start_CamDescend+1,1));
#declare Cam_Distance = vrotate(Cam_Distance,z*(15+95*Clock_Cubic(Start_CamDescend,2))); 

#declare Camera_Location = <0,25,0>;
#declare Camera_Location = Camera_Location+Cam_Distance;//-Linear_Pos(Cam_Focal,1-clock)*.1*Duration_Faded(2,4,<.25,0>);

#declare Camera_Focal = <-1,25,0>-<-1,1.1,0>*Clock_Cubic(Start_CamDescend+1,1);

//Normalizing Looking-Direction
#declare Camera_Focal = Camera_Location+vnormalize(Camera_Focal-Camera_Location);
#declare Camera_Look_At = Camera_Focal;

//Add shaking of focal-point
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,clock)*.02*<1,1,Duration_Faded(3,4,<.25,0>)>;
#declare Camera_Look_At = Camera_Look_At+Linear_Pos(Cam_Focal,Clock_Linear(3.9,.5))*.07*Duration_Faded(3.9,.5,<.05,.2>);

camera{
  location Camera_Location
  look_at Camera_Look_At
}

// Subtitle
//==========
#declare txtJet_Clock = Duration(.5,2.5);
#if (txtJet_Clock)
  #declare txt_Jet = pigment{image_map{tga "texts\sc29_j.tga"}}
  Text_Layer(txt_Jet,.5,<2,1,0>,1)
#end

// Smoke-Effect
//==============
#macro Add_Smoke(Pos,Dir,Size,Age,Aged)
  Particle_Add("particles/smoke",
    array[5]{
    <0,Age,clock*Animation_Time-Aged>,
    <0,Size,0>,
    Pos,
    Dir,
    <rand(SmokeRand),rand(SmokeRand),rand(SmokeRand)>
    })

#end

//Create Smoke at start, not during entire flight
// for Missile 1
#if (Mis1Drop_Clock & Mis1Drop_Clock != 1)
  #declare A=0;
  #while (A<15)
    Add_Smoke(
      Missile1_Move-x*.75,
      <-20,0,0>,
      .1,
      2,
      clock_delta*Animation_Time/10*A)
    #declare A=A+1;
  #end
#end
// for Missile 2
#if (Mis2Drop_Clock & Mis2Drop_Clock != 1)
  #declare A=0;
  #while (A<15)
    Add_Smoke(
      Missile2_Move-x*.75,
      <-20,0,0>,
      .1,
      2,
      clock_delta*Animation_Time/10*A)
    #declare A=A+1;
  #end
#end

Parsys_Run()
Show_Smoke()

// Animated Ground
//=================
#declare Clear = pigment{rgbt <.7,.3,.1,1>}
#declare Variation = pigment{bozo color_map{[0 rgb <.7,.3,.1>*.8][1 rgb <.7,.3,.1>*1.2]}scale 1/120*<2,2,4.5> translate -x*.5*Animation_Time*clock}

light_group{
  light_source{
    vnormalize(Desert_SunPos)*1750
    rgb Desert_SunColor
    shadowless
  }
  light_source{<-1,1,-1>*Desert_SunPos+x*1000 rgb <.2,.2,.4>*.15 shadowless}
  light_source{<-1,1, 1>*Desert_SunPos+x*1000 rgb <.2,.2,.4>*.15 shadowless}
  light_source{<0,2,0> rgb Desert_BaseColor*.4 shadowless}
  disc{
    y*2,y,120 hollow
    pigment{
      spherical pigment_map{[0 Clear][.4 Variation][1 Variation]} scale 120
    }
    no_shadow
  }
  global_lights off
}