// Persistence of Vision Ray Tracer Scene Description File
// File: ufo.pov
// Vers: 3.5
// Desc: Basic UFO-Object 
// Date: 10.09.04 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 11.09.04 (dd.mm.yy)

//Required Files
// bsplines.inc
// io_macs.inc
// mmm.inc
// x_over.inc
// bkdrp_desert.inc

//Description

//Homepage:
// www.nolights.de
//Email:
// Tim.Nikias(@)nolights.de

#default{finish{ambient 0}}
background{rgb <.6,.6,.8>}

#declare Desert_UseSun = on;
#declare Desert_SunPos = <200,1500,-400>;
#declare Desert_HFDetail = 300;
#declare Desert_UseDetailTex=off;
#declare Desert_SunArealights = 0;
#declare Desert_Clouds = off;

#include "bkdrp_desert.inc"
//Create_Backdrop()
light_source{Desert_SunPos rgb 1}

#declare UFO_Condition = 2;
#declare UFO_Textured = 1;
#declare UFO_Lights = on;
#declare UFO_LightClock = 4;

#include "ufo.inc"

global_settings{
  assumed_gamma 1
  max_trace_level 25
}

camera{
  //location vrotate(vrotate(<0,3,-12>,z*360*clock)+y*3.5,y*720*clock)
  location <-4,9,-7>
  look_at <0,2,0>
}

object{UFO translate y*2.5}
