#version 3.6 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
//#include "screen.inc" // captions
#include "metals.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

#declare tclock=clock-1000;
#declare pi2=2*pi/360;

#declare place = <0,3.65,-1.5>;
#declare place = <-.5,4.,-1.5>;

/*
light_source { place + <-2,2,0> color <1,1,1>*.2}
light_source { place + <2,2,0> color <1,1,1>*.2}
light_source{place color<1,1,1>*.6}
*/

light_source{ <-3,8,-5> color<1,1,1>}

camera {location place 
right 16/9*x
//angle 40
look_at <0,3.4,0>
}

background { color SkyBlue }

#include "ooltable.inc"

object{table2}

#declare screen = object {
mesh{
triangle{<0,0,0>,<1,0,0>,<1,1,0>}
triangle{<0,0,0>,<0,1,0>,<1,1,0>}
}//mesh
}

#declare imag=concat( "../door4/a" , str(clock,0,0),".ppm" )

object {screen pigment { image_map { ppm 

imag

map_type 0 once}} finish{ambient .6} 
scale<1.25,2,1>*.5 translate <-.3,3.1,0>

translate -3.3*y 
rotate x*90
translate 3.3*y 

no_shadow
}

#include "uball.inc"

#declare pi2=pi*2/360;

//10 frames. short jump 0,3.55,-1 : 0,3.75 ,0  : 0,3.55,.5
#if (clock>999)
#if (clock<1011)
object{cb1 rotate 180*y 
scale .1 translate 
<0,

////////////////////
//jump occurs over 10 frames
////////////////////

3.55+ .2*sin( pi2*18*(clock-1000) )
,
-1 +.15 *(clock-1000)
>}
#end
#end


//15 frames. turn jump 0,3.55,-1 : 0,4 ,0  : 0,3.55,.5
#if (clock>1010)
#if (clock<1026)
object{cb1 rotate 180*y 
rotate y*( -(220/15)*(clock-1010) )
scale .1 
translate <0,
3.55+ .45*sin( pi2*(180/15)*(clock-1010) )
,
.5
>}
#end
#end

//15 frames. back and forth jump 
#if (clock>1025)
#if (clock<1041)
object{cb1 rotate 180*y 
rotate y*(-220+(80/15)*(clock-1025) )
scale .1 
translate <0,
3.55+ .45*sin( pi2*(180/15)*(clock-1025) )
,
.5
>}
#end
#end

//15 frames. back and forth jump half turn
#if (clock>1040)
#if (clock<1056)
object{cb1 rotate 180*y 
rotate y*(-140-(80/15)*(clock-1040) )
scale .1 
translate <0,
3.55+ .45*sin( pi2*(180/15)*(clock-1040) )
,
.5
>}
#end
#end

//15 frames. back and forth jump half turn
#if (clock>1055)
#if (clock<1071)
object{cb1 rotate 180*y 
rotate y*(-140-(40/15)*(clock-1055) )
scale .1 
translate <0,
3.55+ .45*sin( pi2*(180/15)*(clock-1055) )
,
.5
>}
#end
#end

#if (clock>1070)
//15 frames. back and forth jump half turn
object{cb1 rotate 180*y 
//rotate y*(-140-(40/15)*(clock-1055) )
rotate 180*y
scale .1 
translate <0,
3.55+ .45*sin( pi2*(180/15)*(clock-1055) )
,
.5
>}
#end
