#declare w = 2.5;
#declare h = 2;

// ----- main_canvas   
#declare delta = .01; 
#declare use_smooth_canvas = false;
  
#declare rib = spline
{
  cubic_spline        
  -.2  <1, 0, -w * 0.67>
  0.0, <1, h + 0, -w>
  0.2, <1, h + 3, -w>
  0.4, <1, h + 5, -w * 0.67>
  0.5, <1, h + 5.5, 0>                   
  0.6, <1, h + 5, +w * 0.67>
  0.8, <1, h + 3, +w>
  1.0, <1, h + 0, +w>
  1.2  <1, 0, w * 0.67>
}                       

#macro canvas_macro(u_coord, v_coord)
  #declare in = vnormalize(vcross(x, rib(u_coord+.01)-rib(u_coord-.01)));
  #declare w  = .5 + (u_coord-.5) * (1 - .05*abs(sin(v_coord*pi*4)));
  rib(w) + (-12*v_coord) * x +
  0.5 * pow(sin(u_coord*pi), 2) * abs(sin(v_coord*pi*4)) * in
#end

#macro canvas_vertex(u_coord, v_coord)                      
  canvas_macro(u_coord, v_coord), vnormalize(vcross(              
    canvas_macro(u_coord+delta, v_coord) - canvas_macro(u_coord-delta, v_coord),
    canvas_macro(u_coord, v_coord+delta) - canvas_macro(u_coord, v_coord-delta)
  ))
#end  
    
#fopen f "main_canvas.msh" write
                  
#write(f, "mesh {\n")
  
  #declare v_coord = 0; 
  #while (v_coord < 1)
   
    #declare u_coord = 0;
    #while (u_coord < 1)
     
      #if (use_smooth_canvas)        
        #write(f, "  smooth_triangle {")          
        #write(f, canvas_vertex(u_coord, v_coord))          
        #write(f, canvas_vertex(u_coord + delta, v_coord))          
        #write(f, canvas_vertex(u_coord, v_coord + delta))          
        #write(f, "}\n")  
        #write(f, "  smooth_triangle {")          
        #write(f, canvas_vertex(u_coord + delta, v_coord))          
        #write(f, canvas_vertex(u_coord, v_coord + delta))          
        #write(f, canvas_vertex(u_coord + delta, v_coord + delta))          
        #write(f, "}\n")
      #else                                        
        #write(f, "  triangle {")
        #write(f, canvas_macro(u_coord, v_coord)) 
        #write(f, canvas_macro(u_coord + delta, v_coord))
        #write(f, canvas_macro(u_coord, v_coord + delta))
        #write(f, "}\n")
        #write(f, "  triangle {")
        #write(f, canvas_macro(u_coord + delta, v_coord))
        #write(f, canvas_macro(u_coord, v_coord + delta))
        #write(f, canvas_macro(u_coord + delta, v_coord + delta))
        #write(f, "}\n")        
      #end  
      
    #declare u_coord = u_coord + delta;
    #end  
     
  #declare v_coord = v_coord + delta;
  #end    

#write(f, "}")
#fclose f
        

// ----- front_canvas  
#declare inner_rib = spline {      
  cubic_spline        
  -.2  <1, 0, +0.5>
  0.0, <1, h + 0, -.50>
  0.2, <1, h + 2, -1.0>
  0.4, <1, h + 3.2, -.75>
  0.5, <1, h + 3.5, 0>                   
  0.6, <1, h + 3.2, +.75>
  0.8, <1, h + 2, +1.0>
  1.0, <1, h + 0, +.50>
  1.2  <1, 0, -0.5>
}   
 
#macro front_canvas_macro(u_coord, v_coord)
  (1-v_coord) * rib(u_coord) + v_coord * (inner_rib(u_coord)
  + .02 * sin(u_coord*pi) * .5*sin(u_coord*pi*40) * x)
#end 

#macro front_canvas_vertex(u_coord, v_coord)                      
  front_canvas_macro(u_coord, v_coord), .1*vnormalize(vcross(              
    front_canvas_macro(u_coord+delta, v_coord) - front_canvas_macro(u_coord-delta, v_coord),
    front_canvas_macro(u_coord, v_coord+delta) - front_canvas_macro(u_coord, v_coord-delta)
  ))
#end 
    
#fopen f "front_canvas.msh" write

#write(f, "mesh {\n")
  #declare delta_u = .01;  
  #declare delta_v = .1; 
  #declare use_smooth_canvas = false;
  
  #declare v_coord = 0; 
  #while (v_coord < 1)
  
    #declare u_coord = 0;
    #while (u_coord < 1)
    
      #if (use_smooth_canvas)                                         
        #write(f, "  smooth_triangle {")
        #write(f, front_canvas_vertex(u_coord, v_coord))
        #write(f, front_canvas_vertex(u_coord + delta_u, v_coord))
        #write(f, front_canvas_vertex(u_coord, v_coord + delta_v))
        #write(f, "}\n")
        #write(f, "  smooth_triangle {")                              
        #write(f, front_canvas_vertex(u_coord + delta_u, v_coord))
        #write(f, front_canvas_vertex(u_coord, v_coord + delta_v))
        #write(f, front_canvas_vertex(u_coord + delta_u, v_coord + delta_v))
        #write(f, "}\n")
      #else                                   
        #write(f, "  triangle {")
        #write(f, front_canvas_macro(u_coord, v_coord))
        #write(f, front_canvas_macro(u_coord + delta_u, v_coord))
        #write(f, front_canvas_macro(u_coord, v_coord + delta_v))
        #write(f, "}\n")
        #write(f, "  triangle {")                         
        #write(f, front_canvas_macro(u_coord + delta_u, v_coord))
        #write(f, front_canvas_macro(u_coord, v_coord + delta_v))
        #write(f, front_canvas_macro(u_coord + delta_u, v_coord + delta_v))
        #write(f, "}\n")
      #end
      
    #declare u_coord = u_coord + delta_u;
    #end   
    
  #declare v_coord = v_coord + delta_v;
  #end   

#write(f, "}")   
#fclose f