#!/bin/sh -x
# $Header: /home/bmh/irtc/RCS/gen.sh,v 1.4 2005/03/17 17:43:33 bmh Exp bmh $

# generate frame sequence
# $1 = base
# $2 = resolution/detail (hdvd,ldvd,hvcd,lvcd)


if [ $# = 0 ]
then
	echo usage: $0 base resolution
	exit 1
fi

NAME=$1
POV=../$NAME.pov
INI=../$NAME.ini
MACH=../machine.conf

#transcode -i title_vcd/result.yuv -y ffmpeg -F mpeg1video -o test.mpg
#ffmpeg -s 352x288 -i title_vcd/title%03d.png -vcodec mpeg1video -r 25 -hq -y test.mpg
#ffmpeg -s 352x288 -i title_vcd/title%03d.png -target vcd -r 25 -hq -y test.mpg

PNG2YUV="../drsh nimrod png2yuv -f 25 -I p -b 1"
MPEGDVD="../drsh nimrod mpeg2enc -f 9 -b 10000 -g 6 -G 16 -q 1 -Q 4 -H"
MPEGVCD="../drsh nimrod mpeg2enc -f 1 -q 1 -Q 1 -H -V 230 -g 6 -G 15"

#MPEGVCD= mpeg2enc -f 1 -q 1 -H -V 230 -g 6 -G 15 -r 32 -4 1 -2 1
#MPEGVCD= mpeg2enc -f 1

case "$2" in
'hdvd')
	RES=hdvd.ini
	SUFFIX=hdmpg
	;;
'ldvd')
	RES=ldvd.ini
	SUFFIX=ldmpg
	;;
'hvcd')
	RES=hvcd.ini
	SUFFIX=hvmpg
	;;
'lvcd')
	RES=lvcd.ini
	SUFFIX=lvmpg
	;;
*)
	echo unknown resultion/detail
	exit 1
esac

DIR=${NAME}_${SUFFIX}

rm -rf $DIR
mkdir $DIR
cd $DIR
../pdist $MACH $INI $RES $POV

if [ -f ${NAME}001.png ]
then
  $PNG2YUV -j ${NAME}%03d.png >${NAME}.yuv
else
  if [ -f ${NAME}01.png ]
  then
    $PNG2YUV -j ${NAME}%02d.png >${NAME}.yuv
  else
    echo no png files found
    exit 1
  fi
fi
$MPEGDVD -o ../${NAME}.$SUFFIX ${NAME}.yuv
    
