#include <stdio.h>
#include <string.h>

#define DEFSIZE 25

char buf[128];

float ob[8][8]={0.0};
float b[8][8]={0.0};

char *cb[8]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

void
convline(int l, char *ltext)
{
	int i;
	free(cb[l]);
	cb[l]=strdup(ltext);
	for(i=0;i<8;i++)
	{
		switch(ltext[i*2])
		{
		case 'P': b[l][i]=1.0; break;
		case 'p': b[l][i]=1.5; break;
		case 'R': b[l][i]=2.0; break;
		case 'r': b[l][i]=2.5; break;
		case 'N': b[l][i]=3.0; break;
		case 'n': b[l][i]=3.5; break;
		case 'B': b[l][i]=4.0; break;
		case 'b': b[l][i]=4.5; break;
		case 'Q': b[l][i]=5.0; break;
		case 'q': b[l][i]=5.5; break;
		case 'K': b[l][i]=6.0; break;
		case 'k': b[l][i]=6.5; break;
		default:  b[l][i]=0; break;
		}
	}
}

int
main(int argc, char *argv[])
{
	int l=0,i,j,m=0;
	char *p;
	while(fgets(buf,128,stdin)!=NULL)
	{
		p=strchr(buf,'\n');
		if(p!=NULL)
			*p='\0';
		if(strcmp(buf,"[--------------")==0)
		{
			l=0;
		}
		if((buf[1]==' ')&&(buf[3]==' ')&&(buf[5]==' '))
		{
			convline(l++,buf);
		}
		if(strcmp(buf,"--------------]")==0)
		{
			printf("// move %d\n",m);
			if(m>0)
			{
				for(i=0;i<8;i++)
					for(j=0;j<8;j++)
						if(ob[i][j]!=b[i][j])
						{
							if(b[i][j]==0.0)
							{
								printf("#declare fromx[%d]=%d;\n",m,7-i);
								printf("#declare fromy[%d]=%d;\n",m,j);
								printf("#declare moved[%d]=%3.1f;\n",m,ob[i][j]);
							}
							else
							{
								printf("#declare tox[%d]=%d;\n",m,7-i);
								printf("#declare toy[%d]=%d;\n",m,j);
								printf("#declare capture[%d]=%3.1f;\n",m,ob[i][j]);
							}
						}
			}
			else
			{
				printf("#declare ppos=array[%d]\n",DEFSIZE);
				printf("#declare fromx=array[%d]\n",DEFSIZE);
				printf("#declare fromy=array[%d]\n",DEFSIZE);
				printf("#declare moved=array[%d]\n",DEFSIZE);
				printf("#declare tox=array[%d]\n",DEFSIZE);
				printf("#declare toy=array[%d]\n",DEFSIZE);
				printf("#declare capture=array[%d]\n",DEFSIZE);
			}
			for(i=0;i<8;i++)
				for(j=0;j<8;j++)
					ob[i][j]=b[i][j];
			printf("#declare ppos[%d]=\narray[8][8]\n{\t\n",m);
			m++;
			for(i=0;i<8;i++)
			{
				printf("\t{");
				for(j=0;j<8;j++)
				{
					printf("%3.1f%s",b[7-i][j],(j==7)?"":",");
				}
				printf("}%s // %s\n",(i==7)?" ":",",cb[7-i]);
			}
			printf("}\n\n");
		}
	}
}
