// $Header: /home/bmh/irtc/RCS/sc005.pov,v 1.4 2005/03/14 18:06:03 bmh Exp $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=005;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

#declare la=(1.0-interval(clock,0.95,1));

light_source { <-100,500,-300> color rgb 1.49*la }

#declare moven=14;

object{ground}
do_sky(0.75*la)

object{board(0)}
object{debris(500)}

#declare ripple=
height_field
{
	function 128,128 {f_bozo(x*4,y*3+clock*3,z*4)}
	smooth
	translate <-0.5,-1,-0.5>
	scale <3,1,3>
//	pigment {White}
}

#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#declare vt=tpos(v1,v2,0.1,0.5,clock)

#if(clock>0.5)
#declare rp=bpos[7][7];
#declare bpos[7][7]=0.0;
#declare iclock=scurve(clip((clock-0.5)*2.5,0,1));
intersection
{
	object{peice2(rp,0) translate posn(7,7)}
	object{ripple translate posn(7,7) translate <0,(1-iclock)*5,0>}
	cutaway_textures
}
intersection
{
	object{peice2(rp,0) translate posn(5,7)}
	object{ripple translate posn(5,7) translate <0,iclock*5,0>}
	cutaway_textures
}
#end

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

object{peice2(moved[moven],0) translate vt}

disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl(clock+sceneno);
#declare lapos=camlookspl(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


