// $Header: /home/bmh/irtc/RCS/sc007.pov,v 1.7 2005/03/24 10:34:10 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=007;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

light_source { <-100,500,-300> color rgb 1.49 }

#declare moven=19;

object{ground}
do_sky(0.75)

object{board(0)}
object{debris(500)}


#declare md=0.3;
#declare mr=0.6;
#declare ml=2;
#declare mace=
union
{
#local i=0;
#while (i<40)
	cone{<0,mr-0.05,0> 0.1, <0,mr+0.3,0>,0
		rotate <i*53,i*27,i*19>
		translate <ml,0,0>
	}
#local i=i+1;
#end
	cylinder {<-ml/10,0,0>,<ml,0,0>, 0.1}
	sphere {<ml,0,0>, mr}
}


#declare hand=
union
{
	sphere{ 0, 0.30 scale <1,0.66,1>}
	object {mace translate <0,0,0.05>}
}


#macro larm(hvec)
union
{
	sphere{0,0.25}
	cone{0,0.25,<1.33,0,0>,0.175}
	sphere{0,0.175 translate <1.33,0,0>}
	object{hand  translate <0,-0.05,0.1> rotate hvec translate <1.33,0,0>}
}
#end

//object{ larm  translate <0,1,0>}

#macro uarm(hvec,evec)
union
{
	sphere{0,0.33}
	cone{0,0.33,<1.5,0,0>,0.25}
	object{larm(hvec) rotate evec translate <1.5,0,0>}
}
#end

//object{ uarm  translate <0,1,0>}

#macro arm(hvec,evec,svec)
	object{uarm(hvec,evec) scale 0.8 rotate svec}
#end



#declare bpos=ppos[moven-1];

#declare v1=posn(fromy[moven],fromx[moven]);
#declare v2=posn(toy[moven],tox[moven]);

#declare v12=(v1*35+v2*65)/100;

#declare bmov=
spline
{
	quadratic_spline
	0.0, v1,
	0.4, v12,
	0.5, v12,
	0.6, v12,
	1.0, v2
}

#declare vt=bmov(clock);

#declare bpos[fromx[moven]][fromy[moven]]=0.0;

#if(capture[moven]>0.0)
#declare pclock=interval(clock,0.55,1.0);
#end

#declare mclock=interval(clock,0.3,0.8);

object{peice2(moved[moven],0) rotate <0,45*ccurve(mclock),0> translate vt}

#if(mclock>0.0)
#declare sspl=
spline
{
	quadratic_spline
	0.0, <0,0,1>,
//	0.3, <0,0,0>,
	0.5, <1,0,-0.35>,
//	0.7, <0,0,0>,
	1.0, <0,0,1>
}

#declare espl=
spline
{
	quadratic_spline
	0.0, <0,2,0>,
//	0.4, <0,1.5,0>,
	0.5, <0,0,0>,
//	0.7, <0,1.5,0>,
	1.0, <0,2,0>
}

#declare hspl=
spline
{
	quadratic_spline
	0.0, <0,1,0>,
//	0.4, <0,0.8,0>,
	0.5, <0,0,0>,
//	0.8, <0,0.8,0>,
	1.0, <0,1,0>
}

#declare rspl=
spline
{
	quadratic_spline
	0.0, <0,180,0>,
	0.35, <0,180,0>,
	0.4, <0,180,0>,
	0.5, <0,222,0>,
	0.7, <0,200,0>,
	1.0, <0,180,0>
}

object{
	arm(180*hspl(mclock) , -90*espl(mclock), -90*sspl(mclock))
	rotate rspl(mclock)
	translate vt+<0,2.2,0>
	texture {btext}
}



#if(clock>=0.55)
#declare av1=180*hspl(0.5);
#declare av2=-90*espl(0.5);
#declare av3=-90*sspl(0.5);
#declare rv1=rspl(0.5);
#declare tv1=bmov(0.55)+<0,2.2,0>;
//object
//{
//	arm(av1,av2,av3)
//	rotate rv1
//	translate tv1+<10,0,0>
//	pigment {Yellow}
//}
#end
#end

#if(pclock>0)
	#declare pn=bpos[tox[moven]][toy[moven]];
	#declare bpos[tox[moven]][toy[moven]]=0.0;
	#declare p1=posn(toy[moven],tox[moven]);
	object
	{
#if (clock>=0.55)
		difference
		{
			peice2(pn,0)
			object
			{
				arm(av1,av2,av3)
				rotate rv1
    			translate tv1-p1
    		}
    		cutaway_textures
		}
#else
		peice2(pn,0)
#end
		translate <0,-1.55,0>
//		rotate<250*pclock,20*pclock,290*pclock>
		rotate<0,20*pclock,0>
		rotate<250*pclock,0,290*pclock>
		translate <0,1.55,0>
#declare p2=(p1-<-6,4.5*pclock,-6>*pclock);
		translate p2
	}
	glow(p2*<1,0,1>+<0,0.001,0>,(pclock+0.1)*(1-pclock*1.1)*3,pclock)
#end

disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
//#declare campos= tpos2(scamvec,ecamvec,mcamvec,0,1,clock)
//#declare lapos= tpos(svpvec,evpvec,0,1,clock)
#declare campos=camposspl2(clock+sceneno);
#declare lapos=camlookspl2(clock+sceneno);
	location campos
	look_at lapos

#if(detail<2)
	focal_point lapos
#declare ap=lpos(sapno,eapno,0,1,clock)
	aperture ap
#if(detail<1)
	blur_samples 128
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end


