// $Header: /home/bmh/irtc/RCS/sc019.pov,v 1.3 2005/03/28 18:31:52 bmh Exp bmh $

#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "textures.inc"
#include "math.inc"
#include "functions.inc"
//#include "glass.inc"
#include "logo.inc"
#include "shapes.inc"

#declare sceneno=016;
#include "camera.inc"
#include "global.inc"
#include "pieces.pov"
#include "background.pov"

#include "game.inc"


global_settings
{
	ambient_light rgb 1
	max_trace_level 15
}

#declare la=1.0-interval(clock,0.25,0.9);

light_source { <-100,500,-300> color rgb 1.49*la }

#declare moven=30;

object{ground}
do_sky(0.75*la)

object{board(0)}
object{debris(500)}

#declare bpos=ppos[moven-1];

#declare bpos[6][5]=0.0;
#declare bpos[7][6]=0.0;

#declare vt=posn(6,4);
object
{
	peice2(1.0,0)
	scale 1.3333
	translate vt
}

disp_board(bpos)

camera
{
	right <image_width/image_height,0,0>
#declare campos=posn(4,6)+<0,0.5,0>;
#declare lapos=posn(2,6)+<0,4,0>*clock;
	location campos
	look_at lapos
//	sky<0,1,-0.1>
	sky<0,0.1,-1>

#if(detail<2)
	focal_point lapos
#declare ap=0.5+clock;
	aperture ap
#if(detail<1)
	blur_samples 256*ap
	variance 1/1536
#else
	blur_samples 10
	variance 1/256
#end
#end
}

#if(detail>1)
object{thing translate lapos}
#end



