lathe {
  cubic_spline
  5,
  #if (clock < 7)
    <-1, 1.5>, <0, 1.5>, <3, 1.6>, <3 + ((clock - 6) * 1.2), 1.6 + ((clock - 6) * 11.9)>, <4.5, 15.5>
  #else
    <-1, 1.5>, <0, 1.5>, <3, 1.6>, <4.2, 13.5>, <4.5, 15.5>
  #end
  pigment {
    rgbf <1, 1, 1, 0.9>
  }
  finish {
    reflection { 0.15 }
  }        
  interior {
    ior 1.3
  }
  scale 1/30
  translate <0, 2.9, 0>
  photons {
    refraction on
    pass_through
    collect off
  }
}

#declare rad = function (x, z) { sqrt ( (x*x) + (z*z) ) }
#declare rppl = function (x, z, xoff, zoff, sc, prog, damp) { 0 - (cos( min( rad((x - xoff) * sc, (z - zoff) * sc) - prog, 0 ) ) - 1) / ((rad((x - xoff) * sc, (z - zoff) * sc) + 1) * damp) } 

#if (clock < 7)
  disc {
    <0, (1.6 + ((clock - 6) * 11.9)) / 30, 0>, y, (3 + ((clock - 6) * 1.2)) / 30
    pigment { color rgbf <1, 1, 1, 1> }
    finish { reflection { 0.3, 0.8 } }
    interior { ior 1.3 }     
    translate <0, 2.9, 0>
    photons {
      refraction on
      pass_through
      collect off
    }    
  }
#else
  isosurface {    
    function { y - (3.35 + rppl( x, z, 0, 0, pi * 60, (clock - 8) * pi * 4, 60 + 40 * (clock - 8) * (clock - 8) )
                         + rppl( x, z, 0.1, 0, pi * 40, (clock - 10.5) * pi * 4, 60 + 40 * (clock - 10.5) * (clock - 10.5) )) }
    contained_by {
      sphere { <0, 3.35, 0>, 0.14 }
    }
    max_gradient 1.5
    evaluate 1, 4, 0.7
    open
    pigment { color rgbf <1, 1, 1, 1> }
    finish { reflection { 0.3, 0.8 } }
    interior { ior 1.3 }     
    photons {
      refraction on
      pass_through
      collect off
    }    
  }
#end
