//*PMRawBegin
#include "math.inc"
#include "strings.inc"
#include "rand.inc"

//set "ti" to the time (in seconds) if you want to get a single frame of that video part
//otherwise set "ti" to "clock" to generate the video
#declare ti = clock;

#declare backlight = 2;
#if (ti > 35) //fade light down at end of movie within 2sec
  #declare backlight = 2-(ti-35);
#end

global_settings { 
ambient_light rgb <backlight,backlight,backlight>
}
//*PMRawEnd

global_settings {
   adc_bailout 0.00392157
   assumed_gamma 1.5
   noise_generator 2
}

#declare wheelpigment = pigment {
   radial
   
   color_map {
      [ 0 color rgb <0.627451, 0.627451, 0.627451>
      ]
      [ 0.1 color rgb <0.780392, 0.780392, 0.780392>
      ]
      [ 0.2 color rgb <0.627451, 0.627451, 0.627451>
      ]
      [ 0.3 color rgb <0.780392, 0.780392, 0.780392>
      ]
      [ 0.4 color rgb <0.627451, 0.627451, 0.627451>
      ]
      [ 0.5 color rgb <0.780392, 0.780392, 0.780392>
      ]
      [ 0.6 color rgb <0.627451, 0.627451, 0.627451>
      ]
      [ 0.7 color rgb <0.780392, 0.780392, 0.780392>
      ]
      [ 0.8 color rgb <0.627451, 0.627451, 0.627451>
      ]
      [ 0.9 color rgb <0.780392, 0.780392, 0.780392>
      ]
      [ 1 color rgb <0.627451, 0.627451, 0.627451>
      ]
   }
   rotate z*90
}

box {
   //*PMName Ground
   <-50, -0.5, -50>, <50, 0.5, 50>
   
   pigment {
      checker 
      color rgb <0.72549, 0.72549, 0.72549>
      color rgb <0.929412, 0.929412, 0.929412>
      scale 0.01
   }
   scale <100, 1, 100>
   rotate <0, 0, 0>
   translate y*(-1.325)
   //*PMRawBegin
   #declare tmp = 10;
   #if ((ti >= tmp) & (ti <= (tmp+1)))
   translate <0,-(ti-tmp)*23, 0>
   #end
   #if (ti > (tmp+1))
   translate <0,-23, 0>
   #end
   //*PMRawEnd
}

union {
   //*PMName Platform
   
   box {
      //*PMName Platform
      <-0.02, -0.5, -0.03>, <0.02, 0.5, 0.01>
      
      pigment {
         checker 
         color rgb <0.72549, 0.72549, 0.72549>
         color rgb <0.929412, 0.929412, 0.929412>
         scale 0.01
      }
      scale <100, 1, 100>
      rotate <0, 0, 0>
      translate y*(-1.33)
   }
   
   text {
      ttf "cyrvetic.ttf"
      "POV-Ray"
      1, <0, 0>
      scale 0.7
      rotate <0, 0, 0>
      translate <-1.4256, -1.52797, -3.02928>
      
      pigment {
         color rgb <0.5, 0.7, 2>
      }
   }
}
//*PMRawBegin
//Produce and display the ramp
#declare tmp = 11;
#if (ti >= tmp)
 //Produce the ramp
 //maxi goes from 0 to 1
#declare maxi = (ti - tmp)/2;
#if (maxi > 1)
  #declare maxi = 1;
#end
//warning concat("maxi is:",str(maxi,0,4),"\n")
//nun is increased within the while loop by 0.02
#declare nun = 0;
#while (nun < maxi)
  box {
     <-2, -0.1, -0.15>, <2, 0.1, 0.15>
     //rx rotates the ramp parts
     #declare rx = sind(270*nun)*45;
     #declare rz = 0;
     //rz is used to rotate the ramp at the end
     #if (nun >= (5/6))
        #declare rz = (nun-(5/6))*270;
     #end
     rotate <rx, 0, rz>
     translate <0, -0.93, 1.25>
     //hy goes from 1(0) to 0(270) (3/4) of a cycle
     #declare hy = cosd(270*nun);
     //hz neeeds do be 0.5 greater each time
     #declare hz = nun*(0.5/0.01);
     translate <0,(hy-1)*11,hz>
     pigment {
        hexagon 
        color rgb <0.435294, 0.27451, 0.101961>
        color rgb <0.541176, 0.47451, 0.321569>
        color rgb <0.666667, 0.517647, 0.105882>
        scale 0.0001
     }
  }
  #declare nun = nun+0.005;
  #end
#end
//*PMRawEnd

union {
   //*PMName Car
   //*PMRawBegin
   //some default values:
   #declare crz = 0; //car rotate z-axis
   #declare crx = 0; //car rotate x-axis
   #declare cty = 0; //car translate y-axis
   #declare ctz = 0; //car translate z-axis
   
   #if ((ti > 15.5) & (ti <= 29))
   
   //Ramp width: 50
   //Ramp height: 22
   //cstep goes from 0 to 1
   #declare tit = ti;
   //stop in the middle of the flight
   #if (ti > 20.5)
     #declare temp = ti - 20.5;
     #if (temp > 3.5)
       #declare temp = 3.5;
     #end
     #declare tit = tit - temp*0.95;
   #end
   //finnished calc for stop in the middle
   
   #declare cstep = (tit - 15.5)/3.5;
   //values for cposz were generated try-and-error with KmPlot
   //calc car on ramp
   #if (cstep < 1) //car on ramp
     #declare cposz =  (cstep+(cosd(270*(cstep+0.33))*.16))*0.86;
     #declare cty = cosd(270*cposz)*11-11;
   #end
   //finnished calc for ramp
   //car is now flying free
   #if ((cstep >= 1) & (cstep < 1.8929))
     #declare c2step = cstep-1;
     #declare cposz =  1+(0.86*(c2step));
     #declare cty = -62*c2step*c2step+51.83*c2step-11;
   #end
   //end of free flight:
   //cposz: 1.767894; delta: 0.86
   //cty: -14.1517; delta: -58.2638
   //note: cstep is scaled by 3.5^(-1) and cposz by 50
   //speed: 20,689 m/s
   //finnished calc for free flight
   
   #if ((cstep >= 1.8929) & (cstep < 2.0125)) //first touchdown
     #declare c2step = cstep-1.8929;
     #declare cposz = 1.76789+c2step*0.86;
     #declare cty = -14.1517-c2step*0.86*50*sind(28)-62*c2step*c2step;
   #end
   #if ((cstep >= 2.0125) & (cstep < 2.192)) //second touch down in cstep = 2.0125
     //at cstep = 2.0125: cposz = 1.8729; cty = -17.4531
     #declare c2step = cstep-2.0125;
     #declare cposz = 1.8729+c2step*0.9;
     #declare cty = -17.4531-c2step*0.9*50*sind(21);
   #end
   #if ((cstep >= 2.192) & (cstep < 2.25))
     //at cstep = 2.192: cpos = 2.03445; cty = -20.3448
     #declare c2step = cstep-2.192;
     #declare cposz = 2.03445+c2step*0.95;
     #declare cty = -20.3448-c2step*0.95*50*sind(14);
   #end
   #if ((cstep >= 2.25) & (cstep < 2.593))
     //at cstep = 2.25: cpos = 2.0896; cty = -21.011
     #declare c2step = cstep-2.25;
     #declare cposz = 2.0896+c2step*0.97;
     #declare cty = -21.011-c2step*0.95*50*sind(7);
   #end
   #if (cstep >= 2.593)
     //at cstep = 2.56: cpos = 2.3903; cty = -22.843
     #declare c2step = cstep-2.593;
     #declare cposz = 2.4223+c2step;
     #declare cty = -23;
   #end
   
   #warning concat("cstep is: ",str(cstep,0,4),"\n")
   
   //scale on movement on z-axis
   #declare ctz = cposz*50;
   
   //calculate rotation
   #if (cstep < 1)
     #declare crx = sind(270*cposz)*45;
   #end
   #if ((cstep >= 1) & (cstep < 2.1384))
     #declare crx = -45+(cstep-1)*70;
     #if ((cstep > 2) & (crx > 28))
       #declare crx = 28;
     #end
   #end
   #if (cstep >= 2.1384)  //Angle of 14
     #declare crx = 28-(cstep-2.1384)*300;
     #if (crx < 14)
       #declare crx = 14;
     #end
   #end
   #if (cstep >= 2.221)  //Angle of 7
     #declare crx = 14-(cstep-2.221)*50;
     #if (crx < 7)
       #declare crx = 7;
     #end
   #end
   #if (cstep >= 2.53)  //Angle of 0
     #declare crx = 7-(cstep-2.53)*120;
     #if (crx < 0)
       #declare crx = 0;
     #end
   #end
   
   //crz is used to rotate the car around itself
   #declare crz = 0;
   #if ((cstep >= (5/6)) & (cstep < 1))
     #declare crz = (cstep-(5/6))*270;
   #end
   #if ((cstep >= 1) & (cstep < 2.5))
     #declare crz = (cstep-1)*320+45;
     #if (crz > 360)
       #declare crz = 0;
     #end
   #end
   //calculate rotation finished
   
   #declare camramty = cty; //camera ramp translate y
   #declare camramtz = ctz; //camera ramp translate z
   #declare camrammy = crx; //move camera up and down depending on the angle
   
   #end //end of: #if ((ti > 15.5) & (ti <= 29))
   
   
   //I did not use the cstep stuff any longer, since it was a bad idea
   #if ((ti > 29) & (ti <= 31)) //brake with shield
     //ti=29 -> cstep=2.9 -> cty=-23; cposz = 2.73 -> ctz=136,5 -> vz = 14,386m/s
     #declare temp = ti-29;
     #declare ctz = 136.5+14.386*temp-2.902*temp*temp; //after 2sec the speed will be 10km/h
     #declare cty = -23;
     #declare camramty = cty; //camera ramp translate y
     #declare camramtz = ctz; //camera ramp translate z
     #declare camrammy = 0;   //move camera up and down depending on the angle
   #end
   
   #if (ti > 31) //damage the sign
     #declare temp = ti-31;
     #declare ctz = 153.664+2.778*temp-5.3583*temp*temp; //after 0,259sec we will stop
     #if (temp > 0.259) //we stopped, and don't want to roll backwards ;-)
       #declare ctz = 154.02407;
     #end
     #declare cty = -23;
     #declare camramty = cty; //camera ramp translate y
     #declare camramtz = ctz; //camera ramp translate z
     #declare camrammy = 0;   //move camera up and down depending on the angle
   #end
   
   //roll to the begining of the ramp (2m in 0.5 sec)
   #if (ti > 15)
   #declare cnz = 2; //car normal z-axis
   #declare temp = (ti-15)*2*cnz;
   #if (temp > cnz)
     #declare temp = cnz;
   #end
   #declare ctz = ctz + temp;
   #end
   //*PMRawEnd
   
   union {
      //*PMName Driver
      
      blob {
         threshold 0.5
         
         cylinder {
            <-0.00654906, 0.224294, -0.0458333>, <0, -0.5, 0>, 0.288985,
            strength 1
            scale <2, 1, 1>
         }
         
         cylinder {
            <-0.253251, -0.560517, 0.294324>, <-0.160076, -0.808334, 0.796758>, 0.132394,
            strength 1
            translate <0.569507, 0.826857, -0.377043>
         }
         
         cylinder {
            <-0.27017, -0.81468, 1.2347>, <-0.154247, -0.807541, 0.906949>, 0.10898,
            strength 1
            translate <0.569507, 0.826857, -0.377043>
         }
         
         cylinder {
            <-0.865751, -0.556351, 0.269324>, <-0.930909, -0.808334, 0.759258>, 0.132394,
            strength 1
            translate <0.569507, 0.826857, -0.377043>
         }
         
         cylinder {
            <-0.889515, -0.814684, 1.22793>, <-0.945253, -0.808334, 0.861061>, 0.102932,
            strength 1
            translate <0.569507, 0.826857, -0.377043>
         }
         
         cylinder {
            <-0.0320984, -0.634498, 0.290989>, <-0.0328807, -0.5222, 0.288813>, 0.277672,
            strength 1
            translate <0.0284903, 1.20771, -0.329362>
         }
         
         cylinder {
            <0, -0.514684, 0.381738>, <-0.008675, -0.454167, -0.0131354>, 0.1813,
            strength 1
            translate <0.196294, -0.104167, 0.0905961>
         }
         
         cylinder {
            <0, -0.514684, 0.381738>, <-0.00338436, -0.833334, 0.685935>, 0.132394,
            strength 1
            translate <0.196294, -0.104167, 0.0905961>
         }
         
         cylinder {
            <-0.0372282, -0.842337, 0.821541>, <-0.0338438, -0.829167, 0.679167>, 0.107673,
            strength 1
            translate <0.227002, -0.12904, 0.197831>
         }
         
         cylinder {
            <-0.0372282, -0.506351, 0.381705>, <-0.0306668, -0.45, -0.020051>, 0.16613,
            strength 1
            translate <-0.165835, -0.104167, 0.0939805>
         }
         
         cylinder {
            <-0.0372282, -0.506351, 0.381705>, <-0.0338438, -0.829167, 0.679167>, 0.132394,
            strength 1
            translate <-0.165835, -0.104167, 0.0939805>
         }
         
         cylinder {
            <-0.0372282, -0.842337, 0.821541>, <-0.0338438, -0.829167, 0.679167>, 0.107673,
            strength 1
            translate <-0.165835, -0.122493, 0.197831>
         }
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow false
      }
      
      sphere {
         <0.10151, 0.0043196, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <-0.0512251, 0.67257, 0.0805643>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      sphere {
         <-0.10151, 0.0043196, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0.035473, 0.67257, 0.0778184>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      
      torus {
         0.5, 0.25
         scale <0.17, -0.09, 0.176>
         rotate <0, 0, 0>
         translate <-0.00378307, 0.57431, -0.018042>
         
         pigment {
            color rgb <0, 0, 0>
         }
      }
      translate <-1.05322, -0.0596905, -1.47085>
      
      pigment {
         color rgb <0.929412, 0.913725, 0.513725>
      }
      scale 0.45
      //*PMRawBegin
      #declare tmp = 6;
      #if (ti <= tmp)
      translate <0,2-(ti-tmp+1)*2, 0>
      #end
      //*PMRawEnd
   }
   
   cylinder {
      //*PMName brakeshield
      <0, 0, -0.2>, <0, 0, 0.2>, 0.1
      
      pigment {
         color rgb <0.941176, 0.941176, 0.941176>
      }
      scale 1
      rotate x*20.5
      translate <-0.00636656, 0.0912277, -2.40853>
      //*PMRawBegin
      #declare tmp = 9;
      #if (ti <= tmp)
      translate <0,1.5-(ti-tmp+1)*1.5, 0>
      #end
      //*PMRawEnd
   }
   
   union {
      //*PMName brakeshield
      
      cylinder {
         <0, 3.3138, 0>, <0, 0, 0>, 0.01
         scale 1
         rotate x*(-90)
         translate <0, 0.0531398, -2.28123>
      }
      
      union {
         cylinder {
            <0, 3.3138, -0.0246534>, <0, 4.31044, 0.60269>, 0.01
            scale 1
            rotate x*(-73)
            translate <0, 0.0531398, -2.28123>
         }
         
         cylinder {
            <0, 3.3138, -0.0246534>, <-0.737615, 3.88364, -0.800585>, 0.01
            scale 1
            rotate x*(-73)
            translate <0, 0.0531398, -2.28123>
         }
         
         cylinder {
            <0, 3.3138, -0.0246534>, <0.713976, 3.87086, -0.825889>, 0.01
            scale 1
            rotate x*(-73)
            translate <0, 0.0531398, -2.28123>
         }
         
         lathe {
            cubic_spline
            4,
            <0.174411, 2.34719>, <0.94116, 0.6487>, <0.284546, 0.03839>, <-0.343694, -0.241096>
            scale 1
            rotate x*90
            translate <0, 0.973388, -6.87089>
         }
         translate <0, -1, 5.4638>
         //*PMRawBegin
         #declare temp = ti-28;
         //handle scaling
         #if (temp < 0.5)
           scale <0.1,0.1,0.1>
         #end
         #if ((temp >= 0.5) & (temp < 1))
           scale 0.1*(temp-0.5)*20
         #end
         #if (temp >= 1)
           scale <1,1,1>
         #end
         //*PMRawEnd
         scale 1
         translate <0, 0.0618963, -5.57867>
      }
      
      pigment {
         color rgb <0.87451, 0.839216, 0.6>
      }
      translate <0, -0.0665436, 2.34985>
      //*PMRawBegin
      #declare temp = ti-28;
      //handle scaling
      #if (temp < 0)
        scale <0.001,0.001,0.001>
      #end
      #if ((temp >= 0) & (temp < (2/3)))
        scale <1,1,0.01*temp*150>
      #end
      #if (temp >= (2/3))
        scale <1,1,1>
      #end
      //handle rotating
      #if ((temp >= (1/2)) & (temp < 1))
        rotate <(temp-0.5)*20,0,0>
      #end
      #if ((temp >= 1) & (temp < 1.5))
        rotate <10,0,0>
      #end
      #if ((temp >= 1.5) & (temp < 3))
        rotate <10-((temp-1.5)/1.5)*23,0,0>
      #end
      #if (temp >= 3)
        rotate <-13,0,0>
      #end
      //*PMRawEnd
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.163357, -2.57079>
   }
   
   union {
      //*PMName safetyrode
      
      triangle {
         <-0.224629, -0.361128, -0.671395>, <-0.204701, -0.390005, -0.726226>, <-0.199146, -0.371788, -0.723422>
         //*PMRawBegin
         #declare tmp = 8+(18/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.224957, -0.361128, -0.670889>, <-0.248488, -0.326463, -0.649348>, <-0.199146, -0.371721, -0.723319>
         //*PMRawBegin
         #declare tmp = 8+(17/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.224925, -0.361119, -0.670882>, <-0.248458, -0.326909, -0.64938>, <-0.285625, -0.312484, -0.60141>
         //*PMRawBegin
         #declare tmp = 8+(6/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.29035, -0.28921, -0.604361>, <-0.248472, -0.326463, -0.649383>, <-0.285587, -0.312484, -0.601453>
         //*PMRawBegin
         #declare tmp = 8+(15/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.290175, -0.28936, -0.604268>, <-0.302277, -0.241181, -0.581424>, <-0.285559, -0.312484, -0.601212>
         //*PMRawBegin
         #declare tmp = 8+(14/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.290322, -0.290484, -0.604397>, <-0.302811, -0.241181, -0.581103>, <-0.326141, -0.151538, -0.587356>
         //*PMRawBegin
         #declare tmp = 8+(13/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.395759, -0.111351, -0.558925>, <-0.302568, -0.241181, -0.581241>, <-0.325296, -0.151538, -0.587323>
         //*PMRawBegin
         #declare tmp = 8+(12/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.395759, -0.111351, -0.558925>, <-0.450216, -0.0136702, -0.582713>, <-0.325548, -0.151538, -0.587122>
         //*PMRawBegin
         #declare tmp = 8+(11/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.395759, -0.111351, -0.558925>, <-0.450216, -0.0136702, -0.582713>, <-0.487974, -0.0200876, -0.560281>
         //*PMRawBegin
         #declare tmp = 8+(10/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.56339, 0.0614537, -0.580463>, <-0.450216, -0.0136702, -0.582713>, <-0.488319, -0.0201214, -0.560281>
         //*PMRawBegin
         #declare tmp = 8+(9/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.5626, 0.0606643, -0.580463>, <-0.450216, -0.0136702, -0.582713>, <-0.577289, 0.115873, -0.60934>
         //*PMRawBegin
         #declare tmp = 8+(8/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.5626, 0.0606643, -0.580463>, <-0.647514, 0.153895, -0.656963>, <-0.577289, 0.115873, -0.60934>
         //*PMRawBegin
         #declare tmp = 8+(7/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.620337, 0.154484, -0.64455>, <-0.647514, 0.154993, -0.658096>, <-0.577289, 0.115873, -0.60934>
         //*PMRawBegin
         #declare tmp = 8+(6/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.620112, 0.1543, -0.645228>, <-0.647514, 0.154928, -0.657903>, <-0.64669, 0.1606, -0.696391>
         //*PMRawBegin
         #declare tmp = 8+(5/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.620483, 0.153741, -0.743115>, <-0.620077, 0.154575, -0.645103>, <-0.646605, 0.160226, -0.696596>
         //*PMRawBegin
         #declare tmp = 8+(4/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.620373, 0.156943, -0.743121>, <-0.64055, 0.138846, -0.766804>, <-0.646722, 0.160592, -0.696689>
         //*PMRawBegin
         #declare tmp = 8+(3/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.619452, 0.157222, -0.742278>, <-0.640335, 0.138779, -0.766826>, <-0.623796, 0.0970713, -0.810906>
         //*PMRawBegin
         #declare tmp = 8+(2/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.648661, 0.0754545, -0.829626>, <-0.640335, 0.138779, -0.766403>, <-0.623796, 0.0970713, -0.810906>
         //*PMRawBegin
         #declare tmp = 8+(1/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      
      triangle {
         <-0.648661, 0.0754545, -0.829626>, <-0.62471, 0.079235, -0.82936>, <-0.623796, 0.0970713, -0.810906>
         //*PMRawBegin
         #declare tmp = 8+(0/19);
         #if (ti < tmp)
         translate <0,0,100>
         #end
         //*PMRawEnd
      }
      translate z*(-0.02)
      
      pigment {
         color rgb <0.0941176, 0.0941176, 0.0941176>
      }
   }
   
   difference {
      //*PMName Wheel1
      
      cylinder {
         //*PMName Wheel1
         <0.5, 0, 0>, <-0.5, 0, 0>, 0.5
         
         pigment {
            color rgb <0.14902, 0.14902, 0.14902>
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, 0.352>
         //*PMRawBegin
         #declare tmp = 3;
         #if (ti <= tmp)
         translate <-2+(ti-tmp+1)*2,0,0>
         #end
         //*PMRawEnd
      }
      
      cylinder {
         //*PMName Kappe1
         <0.5146, 0, 0>, <0.48, 0, 0>, 0.36231
         
         pigment {
            wheelpigment
            //*PMRawBegin
            rotate <ctz/1.885*360, 0, 0>
            //*PMRawEnd
         }
         
         finish {
            brilliance 2
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, 0.352>
      }
      
      cylinder {
         //*PMName Kappe2
         <-0.5146, 0, 0>, <-0.48, 0, 0>, 0.36231
         
         pigment {
            wheelpigment
            //*PMRawBegin
            rotate <ctz/1.885*360, 0, 0>
            //*PMRawEnd
         }
         
         finish {
            brilliance 2
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, 0.352>
         //*PMRawBegin
         #declare tmp = 2;
         #if (ti <= tmp)
         translate <-0.02+(ti-tmp+1)*0.02,0,0>
         #end
         //*PMRawEnd
      }
      
      box {
         <-0.75, -0.5, -0.5>, <0.75, 0.5, 0.5>
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.52, 0.3446>
         
         pigment {
            color rgb <0.14902, 0.14902, 0.14902>
         }
      }
   }
   
   difference {
      //*PMName Wheel2
      
      cylinder {
         //*PMName Wheel2
         <0.5, 0, 0>, <-0.5, 0, 0>, 0.5
         
         pigment {
            color rgb <0.14902, 0.14902, 0.14902>
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, -2.0291>
         //*PMRawBegin
         #declare tmp = 3;
         #if (ti <= tmp)
         translate <-2+(ti-tmp+1)*2,0,0>
         #end
         //*PMRawEnd
      }
      
      cylinder {
         //*PMName Kappe1
         <0.5146, 0, 0>, <0.48, 0, 0>, 0.36231
         
         pigment {
            wheelpigment
            //*PMRawBegin
            rotate <ctz/1.885*360, 0, 0>
            //*PMRawEnd
         }
         
         finish {
            brilliance 2
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, -2.0291>
      }
      
      cylinder {
         //*PMName Kappe2
         <-0.5146, 0, 0>, <-0.48, 0, 0>, 0.36231
         
         pigment {
            wheelpigment
            //*PMRawBegin
            rotate <ctz/1.885*360, 0, 0>
            //*PMRawEnd
         }
         
         finish {
            brilliance 2
         }
         scale <2, 0.6, 0.6>
         rotate <0, 0, 0>
         translate <0, -0.52419, -2.0291>
         //*PMRawBegin
         #declare tmp = 2;
         #if (ti <= tmp)
         translate <-0.02+(ti-tmp+1)*0.02,0,0>
         #end
         //*PMRawEnd
      }
      
      box {
         <-0.75, -0.5, -0.5>, <0.75, 0.5, 0.5>
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.52, -2.0336>
         
         pigment {
            color rgb <0.14902, 0.14902, 0.14902>
         }
      }
   }
   
   union {
      //*PMName Number
      
      // Number
      box {
         <-0.272643, -0.0389695, -0.0200231>, <0.329482, 0.152648, 0.0326541>
         
         pigment {
            color rgb <1.7, 1.7, 1.7>
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.366667, -3.03333>
      }
      
      text {
         ttf "cyrvetic.ttf"
         "The Jump"
         0.2, <0, 0>
         
         pigment {
            color rgb <0.0588235, 0.0588235, 0.0588235>
         }
         scale 0.13
         rotate <0, 0, 0>
         translate <-0.250841, -0.342764, -3.05666>
      }
      //*PMRawBegin
      #declare tmp = 3;
      #if (ti <= tmp)
      translate <0,0,-4+(ti-tmp+1)*4>
      #end
      //*PMRawEnd
   }
   
   difference {
      //*PMName Bumper
      
      // Bumper
      superellipsoid {
         <0.1, 0.5>
         scale <1.069, -0.08, 0.415>
         rotate <0, 0, 0>
         translate <0, -0.368723, 0.634947>
      }
      
      box {
         <-1.35, -0.5, -0.069238>, <1.35, -0.20733, 0.64359>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0.00438405, 0.0494815>
      }
      
      pigment {
         color rgb <0.83137, 0.83137, 0.83137>
      }
      
      finish {
         brilliance 1.5
      }
      //*PMRawBegin
      #declare tmp = 3;
      #if (ti <= tmp)
      translate <0,0,2-(ti-tmp+1)*2>
      #end
      //*PMRawEnd
   }
   
   union {
      //*PMName Drive Wheel
      
      // Drive wheel
      cylinder {
         <0, -3.05667e-05, 0.0063155>, <0, -0.088662, 0.26713>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-0.14963, -0.00061224, 0>, <0.146794, -0.000440443, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         0.15, 0.02
         scale 1
         rotate x*(-73.5)
         translate <0, 0, 0>
      }
      translate <-0.463958, -0.0950945, -0.254377>
      
      pigment {
         color rgb <0.454902, 0.32549, 0.188235>
      }
      //*PMRawBegin
      #declare tmp = 7;
      #if (ti <= tmp)
      translate <0,1.5-(ti-tmp+1)*1.5, 0>
      #end
      //*PMRawEnd
   }
   
   union {
      //*PMName Seat
      
      // Seat
      box {
         <-0.25, -0.406335, -0.111994>, <0.316667, 0.122176, -0.0393009>
         scale 1
         rotate x*(-9.1)
         translate <0, -0.0191914, -0.196812>
      }
      
      box {
         <-0.253696, -0.443161, 0.0999711>, <0.316851, -0.364838, -0.240564>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.0623592, -0.00446572>, <0, -0.0135575, -0.00586016>, 0.007
         
         pigment {
            color rgb <0.831373, 0.831373, 0.831373>
         }
         
         finish {
            brilliance 1.5
         }
         scale 1
         rotate <0, 0, 0>
         translate <-0.075768, 0.0944659, -0.292714>
      }
      
      cylinder {
         <0, 0.0623592, -0.00446572>, <0, -0.0135575, -0.00586016>, 0.007
         
         pigment {
            color rgb <0.831373, 0.831373, 0.831373>
         }
         
         finish {
            brilliance 1.5
         }
         scale 1
         rotate <0, 0, 0>
         translate <0.14624, 0.0947912, -0.292901>
      }
      
      superellipsoid {
         <0.5, 0.5>
         scale <0.213, 0.1, 0.039>
         rotate <0, 0, 0>
         translate <0.0406126, 0.23321, -0.299142>
      }
      translate <-0.505239, 0, -0.536816>
      
      pigment {
         hexagon 
         color rgb <0.156863, 0.156863, 0.156863>
         color rgb <0.309804, 0.309804, 0.309804>
         color rgb <0.23137, 0.345098, 0.196078>
         scale 0.002
      }
      //*PMRawBegin
      #declare tmp = 5;
      #if (ti <= tmp)
      translate <0,1.5-(ti-tmp+1)*1.5, 0>
      #end
      //*PMRawEnd
   }
   
   union {
      //*PMName Rollsafety
      
      // Roll safety
      cylinder {
         <0, 0.407759, -0.707027>, <1.84387, 0.405741, -0.706365>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <-0.947081, -0.00358968, 0.273814>
         //*PMRawBegin
         #declare tmp = 8;
         #if (ti <= tmp)
         translate <0,1.5-(ti-tmp+1)*1.5, 0>
         #end
         //*PMRawEnd
      }
      
      cylinder {
         <0, 0.407759, -0.707027>, <1.84387, 0.405741, -0.706365>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <-0.946597, -0.00358968, -0.668161>
         //*PMRawBegin
         #declare tmp = 8;
         #if (ti <= tmp)
         translate <0,1.5-(ti-tmp+1)*1.5, 0>
         #end
         //*PMRawEnd
      }
      
      union {
         cylinder {
            <0, 0.45417, -0.27452>, <0, 0.016862, 0.19467>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947323, -0.0471405, -0.160368>
         }
         
         sphere {
            <-0.92838, 0.40419, -0.42945>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.0205191, 0, -0.00384733>
         }
         
         cylinder {
            <0, 0.407759, -0.707027>, <0, 0.405741, -1.64827>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947081, -0.00358968, 0.273814>
         }
         
         sphere {
            <-0.92838, 0.401441, -0.151804>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.0198779, 0.000782282, -1.22282>
         }
         
         cylinder {
            <0, 0.452608, 0.0728758>, <0, -0.00376195, -0.344469>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947323, -0.043946, -1.44224>
         }
         //*PMRawBegin
         #declare tmp = 8;
         #if (ti <= tmp)
         translate <-2+(ti-tmp+1)*2, 0,0>
         #end
         //*PMRawEnd
      }
      
      union {
         cylinder {
            <0, 0.45417, -0.27452>, <0, 0.016862, 0.19467>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947323, -0.0471405, -0.160368>
         }
         
         sphere {
            <-0.92838, 0.40419, -0.42945>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.0205191, 0, -0.00384733>
         }
         
         cylinder {
            <0, 0.407759, -0.707027>, <0, 0.405741, -1.64827>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947081, -0.00358968, 0.273814>
         }
         
         sphere {
            <-0.92838, 0.401441, -0.151804>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.0198779, 0.000782282, -1.22282>
         }
         
         cylinder {
            <0, 0.452608, 0.0728758>, <0, -0.00376195, -0.344469>, 0.03
            scale 1
            rotate <0, 0, 0>
            translate <-0.947323, -0.043946, -1.44224>
         }
         translate <1.84373, -0.000733652, 0.000582596>
         //*PMRawBegin
         #declare tmp = 8;
         #if (ti <= tmp)
         translate <+2-(ti-tmp+1)*2, 0,0>
         #end
         //*PMRawEnd
      }
      
      pigment {
         color rgb <0.788235, 0.0627451, 0.0745098>
      }
   }
   
   difference {
      //*PMName Body
      
      // Car body
      superellipsoid {
         <0.25, 0.2>
         scale <1.05, 0.3, 2>
         rotate <0, 0, 0>
         translate <-0.00607778, -0.296653, -1.02624>
         //*PMRawBegin
         #if (ti <= 1)
         translate <-3+ti*3, 0,0>
         #end
         //*PMRawEnd
      }
      
      difference {
         cylinder {
            //*PMName wheelhole1
            <0.5, 0, 0>, <-0.5, 0, 0>, 0.5
            scale <2.5, 0.7, 0.7>
            rotate <0, 0, 0>
            translate <0, -0.528357, 0.352003>
            //*PMRawBegin
            #declare tmp = 2;
            #if (ti <= tmp)
            translate <-5+(ti-tmp+1)*5, 0,0>
            #end
            //*PMRawEnd
         }
         
         box {
            <-0.65, -0.5, -0.5>, <0.65, 0.5, 0.5>
            scale 1
            rotate <0, 0, 0>
            translate <0, -0.528366, 0.3446>
         }
      }
      
      difference {
         cylinder {
            //*PMName wheelhole2
            <0.5, 0, 0>, <-0.5, 0, 0>, 0.5
            scale <2.5, 0.7, 0.7>
            rotate <0, 0, 0>
            translate <0, -0.52836, -2.0291>
            //*PMRawBegin
            #declare tmp = 2;
            #if (ti <= tmp)
            translate <-5+(ti-tmp+1)*5, 0,0>
            #end
            //*PMRawEnd
         }
         
         box {
            <-0.65, -0.5, -0.5>, <0.65, 0.5, 0.5>
            scale 1
            rotate <0, 0, 0>
            translate <0, -0.52837, -2.0669>
         }
      }
      
      superellipsoid {
         <0.2, 0.2>
         scale <1, 0.5, 0.8>
         rotate <0, 0, 0>
         translate <0, 0.0155505, -0.907857>
         //*PMRawBegin
         #declare tmp = 2;
         #if (ti <= tmp)
         translate <0,3-(ti-tmp+1)*3, 0>
         #end
         //*PMRawEnd
      }
      
      superellipsoid {
         <0.2, 0.2>
         
         pigment {
            color rgb <0.32549, 0.32549, 0.32549>
         }
         scale <0.355, -0.117, -0.221>
         rotate <0, 0, 0>
         translate <-0.471939, -0.457583, -0.24416>
      }
      
      union {
         //*PMName Lights
         
         cylinder {
            <0, 0, -0.005>, <0, 0, 0.005>, 0.052694
            scale 1
            rotate <0, 0, 0>
            translate <-0.66314, -0.205781, 0.968884>
         }
         
         cylinder {
            <0, 0, -0.005>, <0, 0, 0.005>, 0.052694
            scale 1
            rotate <0, 0, 0>
            translate <0.649658, -0.205781, 0.968864>
         }
         
         // Lights
         pigment {
            color rgb <1.90196, 2, 1.41961>
         }
         //*PMRawBegin
         #declare tmp = 4;
         #if (ti <= tmp)
         translate <0,0,0.1-(ti-tmp+1)*0.1>
         #end
         //*PMRawEnd
      }
   }
   
   mesh {
      // Front glass
      triangle {
         <0.89465, 0.40444, -0.43227>, <-0.9186, 0.406, -0.435>, <0.89419, 0, 0.0036175>
      }
      
      triangle {
         <-0.92421, 0, -4.299e-07>, <-0.9186, 0.406, -0.435>, <0.89419, 0, 0.0036175>
      }
      
      pigment {
         color rgbft <0.94902, 0.94902, 0.94902, 0.3, 0.4>
      }
      //*PMRawBegin
      #declare tmp = 7;
      #if (ti <= tmp)
      translate <0,0,1.5-(ti-tmp+1)*1.5>
      #end
      //*PMRawEnd
   }
   
   pigment {
      color rgb <0.52549, 0.0627451, 0.0627451>
   }
   translate <0, 0.82, 0.9>
   rotate <0, 0, 0>
   translate <0, 0.06, 1.12>
   rotate <0, 0, 0>
   translate <0, -0.06, -1.12>
   //*PMRawBegin
   
   translate <0,-0.82,0>
   rotate <0, 0, crz>
   translate <0,0.82,0>
   rotate <crx, 0, 0>
   
   translate <0,cty,ctz>
   //*PMRawEnd
   translate <0, -0.82, -0.9>
}

union {
   //*PMName houses
   //*PMRawBegin
   #declare hr = seed(123);
   #declare hx = -30;
   #declare hz = 0;
   
   #if (ti > 13)
   
   #while (hx < 0)
   #while (hz < 20)
   //*PMRawEnd
   
   union {
      //*PMName House
      
      union {
         //*PMName windows
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <2.11686, 1.23333, -3.7484>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <2.11686, 1.23333, -1.12971>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <2.11686, 1.23333, 2.25467>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <1.27753, 1.23333, 4.6102>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.342565, -1.17007, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-1.29473, 1.23333, 4.62806>
            
            pigment {
               color rgb <0.796078, 0.709804, 0.545098>
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-2.12143, 1.23333, 3.36475>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-2.12143, 1.23333, 1.99808>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-2.12143, 1.23333, -0.635253>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.342565, -1.17007, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-2.17499, 1.23333, -3.61983>
            
            pigment {
               color rgb <0.796078, 0.776471, 0.682353>
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-1.0134, 1.23333, -4.61379>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <0.808615, 1.23333, -4.61379>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <0.0405107, 3.46619, -4.61379>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <0.594955, 3.46619, 4.61612>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
         
         box {
            <-0.4, -0.5, -0.4>, <0.4, 0.5, 0.4>
            scale 1
            rotate <0, 0, 0>
            translate <-0.65957, 3.46619, 4.62133>
            
            pigment {
               //*PMRawBegin
               #declare tr = rand(hr);
               
               #if (tr <= (0.3))
                color rgb <1.261176, 1.24706, 1.0>
               #else
                 color rgb <0.309804, 0.309804, 0.301961>
               #end
               //*PMRawEnd
            }
         }
      }
      
      union {
         //*PMName body
         
         triangle {
            <-1.7, 4.91848, -2.01159>, <-1.7, 3.618, -2.77961>, <-1.7, 3.6162, -1.26124>
         }
         
         box {
            <-2.5, 0, -5>, <2.5, 3, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         triangle {
            <-2.5, 3, 5>, <2.5, 3, 5>, <0, 5.5104, 5>
         }
         
         triangle {
            <-2.5, 3, -5>, <2.5, 3, -5>, <0, 5.5104, -5>
         }
         
         pigment {
            //*PMRawBegin
            #declare tr = rand(hr);
            
            #if (tr <= (1/3))
              color rgb <0.94902, 0.94902, 0.94902>
            #end
            #if ((tr > (1/3)) & (tr < (2/3)))
              color rgb <0.764706, 0.811765, 0.94902>
            #end
            #if (tr >= (2/3))
              color rgb <0.917647, 0.94902, 0.835294>
            #end
            //*PMRawEnd
         }
      }
      
      union {
         //*PMName Top
         
         triangle {
            <-1.84335, 4.92119, -2.01154>, <-0.470226, 4.91284, -2.0164>, <-1.83953, 3.61598, -1.17505>
         }
         
         triangle {
            <-1.84335, 4.92119, -2.01153>, <-0.470226, 4.91284, -2.0164>, <-1.84329, 3.61885, -2.86857>
         }
         
         box {
            <-2.5, -0.15, -5.2>, <1.7691, 0.15, 5.2>
            scale 1
            rotate z*(-45)
            translate <1.63965, 3.71072, 0>
         }
         
         box {
            <-2.5, -0.15, -5.2>, <1.7691, 0.15, 5.2>
            scale 1
            rotate z*45
            translate <-1.16805, 4.22764, 0>
         }
         
         box {
            <-0.25, -0.7, -0.25>, <0.25, 0.7, 0.25>
            scale 1
            rotate <0, 0, 0>
            translate <0.528446, 5.16052, 0.649802>
         }
         
         pigment {
            color rgb <0.733333, 0.360784, 0.129412>
         }
      }
      //*PMRawBegin
      #declare tr = rand(hr);
      #if (tr > 0.5)
      #declare hmx = -1;
      #else
      #declare hmx = 1;
      #end
      #declare tr = rand(hr);
      #if (tr > 0.5)
      #declare hmz = -1;
      #else
      #declare hmz = 1;
      #end
      scale <(1+rand(hr)*0.2)*hmx, 1,(1+rand(hr)*0.5)*hmz>
      rotate <0,rand(hr)*5,0>
      translate <hx*20+rand(hr)*2, 0, hz*60+rand(hr)*2>
      //*PMRawEnd
   }
   //*PMRawBegin
   #declare hz = hz +1;
   #end //inner loop
   #declare hz = 0;
   #declare hx = hx +1;
   #end //outer loop
   #end //if ti > 13
   //*PMRawEnd
   
   pigment {
      color rgb <0.109804, 0.109804, 0.101961>
   }
   //*PMRawBegin
   #declare tmp = (ti-13);
   #if (tmp > 1)
     #declare tmp = 1;
   #end
   //rotate <(-3+tmp*3),0,0>
   translate <650, (-24.325-7+7*tmp), -100>
   //*PMRawEnd
}

union {
   //*PMName Trees1
   //*PMRawBegin
   #declare tre = seed(234);
   #declare tx = 0;
   #declare tz = 0;
   
   #declare tzmax = ti-14;
   #if (tzmax > 0)
   #if (tzmax > 1)
     #declare tzmax = 1;
   #end
   
   #while (tz < (tzmax*150))
   #while (tx < 7)
   //*PMRawEnd
   
   union {
      //*PMName Tree1
      
      sphere {
         <0, 2.59072, -0.0357258>, 1.40286
         
         finish {
            diffuse 0.6
            roughness 0.5
            crand 0.5
         }
         
         pigment {
            //*PMRawBegin
            #declare tt = rand(tre);
            
            #if (tt <= (1/2))
              color rgb <0.3, 1, 0.3>
            #end
            #if ((tt > (1/2)) & (tt < (3/4)))
              color rgb <0.717647, 1, 0.376471>
            #end
            #if (tt >= (3/4))
              color rgb <0.87451, 0.882353, 0.160784>
            #end
            //*PMRawEnd
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 1.63333, 0>, <0, -0.5, 0>, 0.5
         
         pigment {
            color rgbf <0.64314, 0.4549, 0.25882, 0.2>
         }
         
         finish {
            roughness 0.5
            crand 0.3
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      //*PMRawBegin
      #declare tmp = rand(tre);
      scale <1+tmp, 1+tmp,1+tmp>
      translate <tx*5+rand(tre)*2, 0, tz*5+rand(tre)*2>
      //*PMRawEnd
   }
   //*PMRawBegin
   #declare tx = tx +1;
   #end
   #declare tx = 0;
   #declare tz = tz +1;
   #end
   #end
   //*PMRawEnd
   translate <8.2, -24.325, -3.0343>
}

union {
   //*PMName ramp2
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*35
      translate <0, -14.1469, 86.007>
      //*PMRawBegin
      #declare tmp = 13+(8/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*28
      translate <0, -17.3078, 91.1642>
      //*PMRawBegin
      #declare tmp = 13+(7/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*21
      translate <0, -19.8169, 96.6668>
      //*PMRawBegin
      #declare tmp = 13+(6/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*14
      translate <0, -21.6368, 102.424>
      //*PMRawBegin
      #declare tmp = 13+(5/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*7
      translate <0, -22.7399, 108.31>
      //*PMRawBegin
      #declare tmp = 13+(4/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*7
      translate <0, -23.4761, 114.268>
      //*PMRawBegin
      #declare tmp = 13+(3/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 3>
      scale 1
      rotate x*7
      translate <0, -24.2142, 120.231>
      //*PMRawBegin
      #declare tmp = 13+(2/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   box {
      <-4, -0.5, -3>, <4, 0.5, 4>
      scale 1
      rotate x*7
      translate <0, -24.9668, 126.209>
      //*PMRawBegin
      #declare tmp = 13+(1/16);
      #if (ti < tmp)
      translate <0,-1000,0>
      #end
      //*PMRawEnd
   }
   
   pigment {
      hexagon 
      color rgb <0.435294, 0.27451, 0.101961>
      color rgb <0.541176, 0.47451, 0.321569>
      color rgb <0.66667, 0.51765, 0.105882>
      scale 0.0001
   }
}

union {
   //*PMName sign
   
   cylinder {
      <0, 0, 0>, <0, 2, 0>, 0.025
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      pigment {
         color rgb <0.937255, 0.937255, 0.937255>
      }
   }
   
   box {
      <-0.5, -0.3, 0.475>, <0.5, 0.25, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 1.96045, -0.523989>
      
      pigment {
         color rgb <0.258824, 0.258824, 1>
      }
   }
   
   text {
      ttf "cyrvetic.ttf"
      "The Jump"
      1, <0, 0>
      scale <0.15, 0.15, 0.01>
      rotate <0, 0, 0>
      translate <-0.3267, 2.0865, -0.0491>
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   
   text {
      ttf "cyrvetic.ttf"
      "(c) 2006 by"
      1, <0, 0>
      scale <0.1, 0.1, 0.01>
      rotate <0, 0, 0>
      translate <-0.25869, 1.9464, -0.0491>
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   
   text {
      ttf "cyrvetic.ttf"
      "Malte Marwedel"
      1, <0, 0>
      scale <0.1, 0.1, 0.01>
      rotate <0, 0, 0>
      translate <-0.34337, 1.8438, -0.0491>
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   
   text {
      ttf "cyrvetic.ttf"
      "Created for the IRTC"
      1, <0, 0>
      scale <0.1, 0.1, 0.01>
      rotate <0, 0, 0>
      translate <-0.44268, 1.6918, -0.0491>
      
      pigment {
         color rgb <1, 1, 1>
      }
   }
   rotate <0, 0, 0>
   //*PMRawBegin
   #if (ti > 31)
   #declare temp = (ti-31)*3.861; //is one after 0.259sec
   #if (temp > 1)
     #declare temp = 1;
   #end
   rotate <temp*20,0,0,>
   #end
   //*PMRawEnd
   translate <0, -24.312, 156.749>
}
//*PMRawBegin
#declare sunlight = 1;
#if (ti > 35) //fade light down at end of movie within 2sec
  #declare sunlight = 1-(ti-35)/2;
#end

light_source {
   <-100, 1000, 500>, rgb <sunlight, sunlight, sunlight>
}
//*PMRawEnd

camera {
   //*PMName Camera
   perspective
   location <0, 0, 0>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 0, 0>
   //*PMRawBegin
   #if (ti <= 9)
   #declare loc_x = -2.0414;
   #declare loc_y = 0.86393;
   #declare loc_z = 1.819;
   #declare look_x = 0.011367;
   #declare look_y = -0.16524;
   #declare look_z = -0.45545;
   #end
   
   #if ((ti > 9) & (ti <= 10))
   #declare tmp = ti-9;
   //linear moves to:
   //location <-0.11789, 1.66253, -4.54715>
   //look_at <-0.09186, -0.19456, -1.2045>
   //tmp moves from 0 to 1:
   
   #declare loc_x = -2.0414+tmp*(-2.36+2.0414);
   #declare loc_y = 0.86393+tmp*(2.2-0.86393);
   #declare loc_z = 1.819+tmp*(-5-1.819);
   #declare look_x = 0.011367+tmp*(-0.09186-0.011367);
   #declare look_y = -0.16524+tmp*(-(0.19456-0.16524));
   #declare look_z = -0.45545+tmp*(-(1.1-0.45545));
   #end
   
   #if (ti > 10)
   #declare loc_x = -2.36;
   #declare loc_y =  2.2;
   #declare loc_z =  -5;
   #declare look_x = -0.09186;
   #declare look_y =  -0.19456;
   #declare look_z = -1.1;
   #end
   
   #if ((ti > 14.5) &  (ti <= 15.5))
   #declare tmp = ti-14.5;
   #if (tmp > 1)
     #declare tmp = 1;
   #end
   #declare loc_y = 2.2+tmp*2;
   #end
   
   #if (ti > 15.5)
   translate <0,camramty,camramtz>
   #declare loc_y =  4.2+camrammy/15;
   #end
   
   #if (ti > 16.5)
   #declare tmp = ti-16.5;
   #if (tmp > 2)
     #declare tmp = 2;
   #end
   #declare loc_x = -2.36+tmp*2.36;
   #end
   
   #if (ti > 21.25) //special camera movement at time slowdown
   #declare tmp = ti-21.25;
   #if (tmp > 2)
     #declare tmp = 2;
   #end
   #declare loc_z = -5+tmp*5.5;
   #declare look_z = look_z+cosd((tmp-1)*90)*2; //the cosd goes from 0 to 2 and back to 0
   #end
   
   #if (ti > 26)
   #declare tmp = ti-26;
   #if (tmp > 1.5)
     #declare tmp = 1.5;
   #end
   #declare loc_x = 2.36-tmp*4.24;
   #end
   
   #if (ti > 28)
   #declare tmp = ti-28;
   #if (tmp > 2)
     #declare tmp = 2;
   #end
   #declare loc_y = 4.2-tmp*1.1; //reduce height to 2 meters
   #end
   
   #if (ti > 28.5)
   #declare tmp = ti-28.5;
   #if (tmp > 1)
     #declare tmp = 1;
   #end
   #declare loc_z = 6-tmp*6;
   #end
   
   #if (ti > 28.5)
   #declare tmp = ti-28.5;
   #if (tmp > 1.5)
     #declare tmp = 1.5;
   #end
   #declare look_z = -1.1 +tmp*1.5;
   #end
   
   #if (ti > 31.5) //zoom to sign
   #declare tmp = (ti-31.5)/(1.5);
   #if (tmp > 1)
     #declare tmp = 1;
   #end
   #declare look_x = look_x-(look_x*tmp); //goto zero
   #declare loc_x = loc_x-(loc_x*tmp);  //goto zero
   #declare look_y = -0.19456+tmp*0.79456;
   #declare loc_y = 2-tmp*1.4; //goto 0.6
   #declare look_z = 1.15+tmp*2.5;
   #declare loc_z = tmp*2.5;
   //#warning concat("look_x is: ",str(look_x,0,4),"\n")
   //#warning concat("loc_x is: ",str(loc_x,0,4),"\n")
   #end
   
   location <loc_x, loc_y, loc_z>
   look_at <look_x, look_y, look_z>
   //*PMRawEnd
}