#ifndef (Red_Light)
 #declare Red_Light = 1;
#end

#ifndef (Security_Center)
 #declare Security_Center = 1;
#end

#ifndef (Safe_Open)
 #declare Safe_Open = 0;
#end


/* Window View
 location <43,-48/2,-35/2>
 look_at 0*/

/* Safe View
 location <0,8,-28>
 look_at 0*/



#include "cyberspace beeple.inc"
background {rgb <0,0,0>}
sky_sphere {
 pigment {
  bozo
  color_map {
   [13/24 rgb 0]
   [1 rgb <0,1,0>]
  }
  scale <1/128,1/12,1>
  translate <0,clock*3/2,0>
  warp {spherical}
  rotate <90,0,0>
 }
}

light_source {<0,128,0> rgb 1 parallel point_at 0}

//object {Cracker() rotate <0,180,0> translate <0,-1,-5>}
union {
 #declare Beeple_Head_Transform = Cracker_Head_Transform
 #declare Evilness = Cracker_Evilness;
 #declare Beeple_Mouth_Position = Cracker_Mouth_Position;
 #declare Beeple_Right_Arm_Transform = Cracker_Right_Arm_Transform
 #declare Beeple_Left_Arm_Transform = Cracker_Left_Arm_Transform
 #declare Beeple_Right_Leg_Transform = Cracker_Right_Leg_Transform
 #declare Beeple_Left_Leg_Transform = Cracker_Left_Leg_Transform
 #declare Beeple_Hair_Transform = Cracker_Hair_Transform
 Cracker()
 #declare Beeple_Mouth_Position = Cracker_Mouth_2_Position;
 Beeple_Mouth(rgb 0)
 Beeple_Right_Arm_Holds(Cracker_Right_Arm_Holds)
 Beeple_Left_Arm_Holds(Cracker_Left_Arm_Holds)
 //Beeple_Right_Arm_Holds(Red_Fireball)
 //object {Red_Fireball scale 2 translate <0,8.6,0>}
 transform {Cracker_Transform}
}
union {
 #declare Beeple_Head_Transform = Guard_Head_Transform
 #declare Evilness = 0;
 #declare Beeple_Mouth_Position = Guard_Mouth_Position;
 #declare Beeple_Right_Arm_Transform = Guard_Right_Arm_Transform
 #declare Beeple_Left_Arm_Transform = Guard_Left_Arm_Transform
 #declare Beeple_Right_Leg_Transform = Guard_Right_Leg_Transform
 #declare Beeple_Left_Leg_Transform = Guard_Left_Leg_Transform
 #declare Beeple_Hair_Transform = Guard_Hair_Transform
 Guard()
 #declare Beeple_Mouth_Position = Guard_Mouth_2_Position;
 Beeple_Mouth(rgb 0)
 Beeple_Right_Arm_Holds(Guard_Right_Arm_Holds)
 Beeple_Left_Arm_Holds(Guard_Left_Arm_Holds)
 //object {Red_Fireball scale 2 translate <0,8.6,0>}
 transform {Guard_Transform}
}

cylinder {
 <0,1,0> <0,0,0> 4
 pigment {
  crackle
  color_map {
   [1/16 rgb <0,1,0>]
   [1/16 rgb 0]
   [6/16 rgb 0]
   [6/16 rgb <0,0,1>]
   [7/16 rgb <0,0,1>]
   [7/16 rgb 0]
  }
  scale 1/1
 }
}

difference {
 box {<-2,1.5,-2> <2,6,2> pigment {rgb 3/4}}
 box {<-1.6*Safe_Open,2,1.6> <1.6*Safe_Open,5.6,-2.1> pigment {rgb <0,3/4,0>}}
}
difference {
 box {<-1.6,2,1.5> <1.6,5.6,1.6>}
 box {<-1.5,2.1,1.4> <1.5,5.5,1.7>}
 pigment {rgb 0}
}
union {
 cylinder {<1.6,2,1.6> <1.6,2,-2> 1/10}
 cylinder {<1.6,5.6,1.6> <1.6,5.6,-2> 1/10}
 cylinder {<-1.6,2,1.6> <-1.6,2,-2> 1/10}
 cylinder {<-1.6,5.6,1.6> <-1.6,5.6,-2> 1/10}
 pigment {rgb 0}
}

cylinder {<-0.6,2,0.5> <-0.6,4,0.5> 1/2 pigment {rgb <1/4,0,0>}}
cylinder {<0.6,2,0.5> <0.6,4,0.5> 1/2 pigment {rgb <1/4,1/4,0>}}

union {
 text {ttf "timrom" "The decoy works" 1/10 0 pigment {rgb 0}}
 text {ttf "timrom" "every time." 1/10 0 pigment {rgb 0} translate <1,-1,0>}
 box {<-0.2,-1.2,0.1> <11,1,0.1> pigment {rgb 1}}
 scale 1/4
 rotate <45,0,0>
 translate <-1.4,2.25,-1.8>
}

difference {
 box {<-1.8,1.8,-2> <1.8,5.8,-2.05>}
 box {<-1.6,2,-1.75> <1.6,5.6,-2.25>}
 pigment {rgb 0}
}

#ifndef (Barrier_Alpha)
 #declare Barrier_Alpha = 0;
#end

#if (Barrier_Alpha != 1)
cylinder {
 <0,1,0> <0,10,0> 4 open
 pigment {
  gradient y
  pigment_map {
   [0 rgbt <1,1/2,0,1>]
   [1
    cells
    color_map {
     [0 rgbt <1,1/2,0,1/2+Barrier_Alpha/2>]
     [1 rgbt <1,1/2,0,Barrier_Alpha>]
    }
   ]
  }
  translate <0,clock,0>
 }
 hollow
}
#end


#declare Wire_Thickness = 1/32;
#declare Alarm_Light = union {
 cylinder {<0,0,0> <1/8,0,0> 1/2 pigment {rgb 0}}
 sphere_sweep {
  b_spline
  7
  <-1,0,-1/2+Wire_Thickness> Wire_Thickness
  <0,0,-1/2+Wire_Thickness> Wire_Thickness
  <2/3,0,-1/2+Wire_Thickness> Wire_Thickness
  <4/3,0,0> Wire_Thickness
  <2/3,0,1/2-Wire_Thickness> Wire_Thickness
  <0,0,1/2-Wire_Thickness> Wire_Thickness
  <-1,0,1/2-Wire_Thickness> Wire_Thickness
  pigment {rgb 2/4}
  finish {ambient 1 diffuse 0}
 }
 sphere_sweep {
  b_spline
  7
  <-1,-1/2+Wire_Thickness,0> Wire_Thickness
  <0,-1/2+Wire_Thickness,0> Wire_Thickness
  <2/3,-1/2+Wire_Thickness,0> Wire_Thickness
  <4/3,0,0> Wire_Thickness
  <2/3,1/2-Wire_Thickness,0> Wire_Thickness
  <0,1/2-Wire_Thickness,0> Wire_Thickness
  <-1,1/2-Wire_Thickness,0> Wire_Thickness
  pigment {rgb 2/4}
  finish {ambient 1 diffuse 0}
 }
 intersection {
  sphere {0 1 scale <1,1/3,1/3> pigment {rgb <5/4-Red_Light,0,0>} finish {ambient 1 diffuse 0}}
  plane {0-x 0}
 }
}

#declare Wall_Color = pigment {rgb <3/3,0,0>}
#declare Floor_Color = pigment {rgb <2/3,0,0>}
#declare Light_Color = pigment {rgb <2/3,0,0>}

#if (Red_Light)
 #declare Wall_Color = pigment {rgb <0,1/3,1>}
 #declare Floor_Color = pigment {rgb <1/3,1/2,1>}
 #declare Light_Color = pigment {rgb <1,1,1>}
#end

#if (Security_Center)
union {
 #if (Red_Light)
  light_source {<12,15,16> rgb 1 parallel point_at <12,0,16>}
 #end
 union {
  difference {
   box {<0,0,-12> <0,16,32> pigment {Wall_Color}}
   box {<-0.2,-1.4,1.4> <0.2,1.4,-1.4> translate <0,10,-4>}
  }
  box {
   <0,-1.4,1.4> <0,1.4,-1.4>
   pigment {
    gradient y
    triangle_wave
    color_map {
     [0 rgbt <1,1,1,1/2>]
     [1 rgbt <1,1,1,1>]
    }
    translate <0,clock,0>
    scale <1,1/2,1>
   }
   translate <0,10,-4>
  }
  text {ttf "timrom.ttf" "Submarine Control Codes" 0.1 0 scale 1/2 rotate <0,-90,0> translate <0.1,7.75,-6.60>}  
  box {<0,7.6,-7> <0.05,8.2,-1> pigment {bozo color_map {[0 rgb 2/4][1 rgb 1]}}}
  object {Alarm_Light translate <0,10,-1.5>}
  object {Alarm_Light translate <0,10,-6.5>}

  box {<0.1,0,-12> <-0.1,16,32> pigment {Wall_Color} translate <24,0,0>}
  box {<0,0.1,-12> <24,-0.1,32> pigment {Floor_Color}}
  box {<0,0.1,-12> <24,-0.1,32> pigment {Floor_Color} translate <0,16,0>}
  box {<0,0,0.1> <24,16,-0.1> pigment {Wall_Color} translate <0,0,32>}
  
  union {
   box {<3,15.5,20> <7,16,5>}
   box {<17,15.5,20> <21,16,5>}
   box {<10,15.5,20> <14,16,5>}
   box {<3,15.5,0> <7,16,-15>}
   box {<17,15.5,0> <21,16,-15>}
   box {<10,15.5,0> <14,16,-15>}
   pigment {Light_Color}
   finish {ambient 1 diffuse 0}
  }
  
  #declare File_Cabinent = union {
   box {<0,0,32> <4,8,28> pigment {rgb <3/4,3/4,2/3>}}
   difference {
    box {<0.1,4.2,28> <3.8,7.8,27.95>}
    box {<0.3,4.4,27.75> <3.6,7.6,28.25>}
    pigment {rgb 0}
   }
   difference {
    box {<0.1,0.2,28> <3.8,3.8,27.95>}
    box {<0.3,0.4,27.75> <3.6,3.6,28.25>}
    pigment {rgb 0}
   }
  }
  object {File_Cabinent}
  object {File_Cabinent translate <20,0,0>}

  box {<4,1,-9> <12,4,-7> pigment {rgb <2/3,1/3,0>}}
  box {<3.5,4.25,-9.5> <12.5,4,-6.5> pigment {rgb <1/3,1/6,0>}}

  translate <30,-10,4>
 }
}
#end