// Apples and Oranges     George W. Hart     April 1995    File: applorng.pov
// See http://www.li.net/~george/pavilion.html

#include "colors.inc"   
#include "textures.inc"

camera {
   location <0,0,-60>
   up       <0, 36, 0>
   right    <36, 0, 0>
   direction<0 , 0, 60>
   look_at  <0 , 0, 0>
   }

light_source { <  20 ,  20 , -40 > color White }

fog {
   color Black    
   distance 140 
   }

#declare AppRed = color red 0.75 green 0.03 blue 0.12
#declare AppleRed=
texture{
      pigment {AppRed}
      finish {Dull ambient .5}
      }

#declare  c = 1.2
#declare c2 = c*c

//#declare Apple=sphere{<0,0,0>,0.15 texture{AppleRed}}
//#declare Norange=sphere{<0,0,0>,0.14 texture {pigment{Orange}}}

#declare Apple=   //"soft cardiod" r=1.2+sin(theta) rotated about axis
  union{
    quartic{<1,0,0,0,2,0,0,2,-2,-c2,
             0,0,0,0,0,0,0,0,0,0,
             1,0,0,2,-2,-c2,0,0,0,0,
             1,-2,1-c2,0,0>
            texture{AppleRed}
            translate <0,0,-.8>
            }
    intersection{                                //stem
           torus {1,.05 translate <1,0,-.8>}      
           sphere{<0,0,-.8>,.8 }
           texture{pigment{color Brown} finish{ambient .5}}
           }
    bounded_by{sphere{<0,0,0>,1.8}}
    rotate -90*y
    scale .7              //to unit radius
    scale .15             //for placement in unit radius construction
    }


#declare Apple2=     //back of apple, like front, but no stem
  union{
    quartic{<1,0,0,0,2,0,0,2,-2,-c2,
             0,0,0,0,0,0,0,0,0,0,
             1,0,0,2,-2,-c2,0,0,0,0,
             1,-2,1-c2,0,0>
            texture{AppleRed}
            translate <0,0,-.8>
            }
    bounded_by{sphere{<0,0,0>,1.8}}
    rotate 90*y                         //opposite rotation
    scale .7
    scale .15
    }

#declare Apple3=
  union{
    quartic{<1,0,0,0,2,0,0,2,-2,-c2,
             0,0,0,0,0,0,0,0,0,0,
             1,0,0,2,-2,-c2,0,0,0,0,
             1,-2,1-c2,0,0>
            texture{AppleRed}
            translate <0,0,-.8>
            rotate 90*y               //reverse just the apple part...
            }
    intersection{
           torus {1,.05 translate <1,0,-.8>}
           sphere{<0,0,-.8>,.8 }
           texture{pigment{color Brown} finish{ambient .5}}
           rotate -90*y               //...but not the stem
           }
    bounded_by{sphere{<0,0,0>,1.8}}
    scale .7
    scale .15
    texture{pigment{Green}}
    }


#declare Tan = color red 0.858824 green 0.576471 blue 0.439216
#declare LightTan = color red 0.9 green 0.67 blue 0.6

#declare Norange=
  union{
      sphere {<0,0,0>, 1
        texture {
          pigment {color Orange}  
          normal {bumps 0.4   scale 0.02}
          finish {Shiny phong 1 ambient .5}
          }
        }
      cylinder {<0,0,-1.001>,<0,0,-.99>,.06      //belly button
        texture{
          pigment{color Tan}
          normal {bumps 1 scale .005}
          finish{ambient .5}
          }
        }
      cylinder {<0,0,-1.002>,<0,0,-.99>,.045      //belly button middle
        texture{
          pigment{color LightTan}
          normal {bumps .8 scale .005}
          finish{ambient .5}
          }
        }
      rotate -90*y
scale .15
      }

#declare Fork_Metal = texture {
    pigment { Gray40 }
    finish {
        ambient 0.4
        diffuse 0.8
        brilliance 6.0
        reflection 0.6
        phong 0.8
        phong_size 100
    }
}

#declare Fork=
  intersection{
    height_field{gif "fork1.gif" scale <1,256,1>}
    quartic{<0,0,0,0,0,0,0,0,0,0,        //gentle curve along length
             0,0,0,0,0,0,0,0,0,0,
             0,0,0,0,0,0,0,0,0,20,
             -1,0,5,8,0>
            scale .33
            translate <0,.52,.66>}
    quartic{<0,0,0,0,0,0,0,0,0,0,        //same, slightly translated
             0,0,0,0,0,0,0,0,0,0,
             0,0,0,0,0,0,0,0,0,-20,
             +1,0,-5,-8,0>
            scale .33
            translate <0,.5,.66>}
    texture{Fork_Metal}
    scale <2,2,2>
    translate <-1,-1,-1>
    scale <.15,1,1>
    bounded_by{sphere{<0,0,0>,1}}
    scale 1
    rotate <0,0,50>
    rotate <0,-25,0>
    translate<.4,.15,.5>
    }

plane{<0,0,-1>,-20                     //gingham table cloth
  texture{
    pigment{
      image_map{gif "gingham.gif" interpolate 2}
      scale 5
      }
    finish{
      ambient .6
      }
    }
  rotate 25*z
  rotate 88*x
  }

plane{<0,-1,0>,-25                    //sky
  texture{
    pigment{SkyBlue}
    finish{ambient 1}}
  rotate 2*x
  }

//objects positioned by separate program ("GeoMaker") which generates these lines:
  union{  
object{Fork scale .3011196 rotate <50.39178,-16.04504,80.26768> translate <.1549199,.90325,.2635645>}
object{Fork scale .3011194 rotate <230.3919,16.04506,63.73227> translate <.405585,.8218038,-.2635648>}
object{Fork scale .3011196 rotate <-74.14343,-16.04504,99.73232> translate <-.1549199,.90325,.2635646>}
object{Fork scale .3011196 rotate <118.5105,-46.35303,76.38615> translate <.1549199,.6396856,.690021>}
object{Fork scale .3011196 rotate <217.7379,-46.35303,103.6138> translate <-.1549199,.6396857,.690021>}
object{Fork scale .3011194 rotate <-11.87567,-63.43491,161.9999> translate <-.4055849,.1317831,.8529133>}
object{Fork scale .3011196 rotate <37.73789,46.35303,256.3861> translate <-.1549199,-.6396857,-.690021>}
object{Fork scale .3011194 rotate <168.1243,63.43491,198.0001> translate <-.4055849,-.1317831,-.8529133>}
object{Fork scale .3011196 rotate <230.3918,16.04504,-80.26768> translate <.1549199,-.90325,-.2635645>}
object{Fork scale .3011194 rotate <50.39193,-16.04506,-63.73227> translate <.405585,-.8218038,.2635648>}
object{Fork scale .3011196 rotate <-61.48954,46.35303,-76.38615> translate <.1549199,-.6396856,-.690021>}
object{Fork scale .3011196 rotate <105.8566,16.04504,260.2677> translate <-.1549199,-.90325,-.2635646>}
object{Fork scale .3011197 rotate <-61.48971,46.35308,67.61382> translate <.250665,.6085753,-.6900216>}
object{Fork scale .3011193 rotate <105.8566,16.04508,44.26768> translate <.6562498,.6396849,-.2635652>}
object{Fork scale .3011197 rotate <37.73804,46.35309,112.3862> translate <-.2506651,.6085753,-.6900218>}
object{Fork scale .3011197 rotate <168.1241,63.43499,53.99994> translate <.250665,.3450101,-.8529139>}
object{Fork scale .3011197 rotate <168.1242,63.43498,126> translate <-.250665,.3450102,-.8529138>}
object{Fork scale .3011194 rotate <37.73813,46.35306,184.3862> translate <-.6562497,-5.033649E-02,-.6900215>}
object{Fork scale .3011197 rotate <-11.87579,-63.43498,234> translate <-.250665,-.3450102,.8529138>}
object{Fork scale .3011194 rotate <217.7381,-46.35306,175.6138> translate <-.6562498,5.033648E-02,.6900215>}
object{Fork scale .3011197 rotate <-11.87586,-63.43499,-53.99995> translate <.250665,-.3450101,.8529139>}
object{Fork scale .3011197 rotate <217.738,-46.35309,247.6138> translate <-.2506651,-.6085753,.6900218>}
object{Fork scale .3011197 rotate <118.5103,-46.35308,-67.61382> translate <.250665,-.6085754,.6900216>}
object{Fork scale .3011193 rotate <-74.14343,-16.04508,-44.26768> translate <.6562498,-.6396849,.2635652>}
object{Fork scale .3011194 rotate <-61.4898,46.35305,-4.386188> translate <.6562498,-5.033653E-02,-.6900214>}
object{Fork scale .3011198 rotate <105.8565,16.04501,-27.73226> translate <.8111695,-.4264562,-.2635641>}
object{Fork scale .3011193 rotate <230.3919,16.04504,-8.26768> translate <.9069147,-.1317821,-.2635646>}
object{Fork scale .3011193 rotate <50.39191,-16.04504,8.26768> translate <.9069147,.1317821,.2635646>}
object{Fork scale .3011198 rotate <-74.14353,-16.04502,27.73226> translate <.8111695,.4264562,.2635641>}
object{Fork scale .3011194 rotate <118.5102,-46.35305,4.386189> translate <.6562498,5.033654E-02,.6900214>}
object{Fork scale .3011193 rotate <230.3918,16.04508,135.7323> translate <-.6562497,.6396849,-.2635652>}
object{Fork scale .3011198 rotate <50.39188,-16.04502,152.2677> translate <-.8111695,.4264562,.2635641>}
object{Fork scale .3011193 rotate <168.1243,2.954586E-05,162> translate <-.9069147,.2946741,-4.917383E-07>}
object{Fork scale .3011193 rotate <-11.87574,-2.954586E-05,198> translate <-.9069147,-.2946741,4.917383E-07>}
object{Fork scale .3011198 rotate <230.3919,16.04502,207.7323> translate <-.8111695,-.4264562,-.2635641>}
object{Fork scale .3011193 rotate <50.3918,-16.04508,224.2677> translate <-.6562497,-.6396849,.2635652>}
object{Fork scale .3011199 rotate <-61.48962,46.35308,139.6139> translate <-.5013301,.4264564,-.6900216>}
object{Fork scale .3011194 rotate <105.8564,16.04506,116.2677> translate <-.405585,.8218038,-.2635648>}
object{Fork scale .3011203 rotate <168.1242,2.685988E-06,90> translate <-1.862645E-09,.9535861,-4.470348E-08>}
object{Fork scale .3011195 rotate <-11.8759,3.223185E-05,126> translate <-.5605046,.7714672,-5.364418E-07>}
object{Fork scale .3011195 rotate <-11.87575,2.954586E-05,53.99995> translate <.5605047,.7714671,-4.917383E-07>}
object{Fork scale .3011193 rotate <168.1241,2.596454E-05,17.99998> translate <.9069147,.2946741,-4.321337E-07>}
object{Fork scale .3011195 rotate <118.5104,-46.35302,148.3862> translate <-.5605047,.3450108,.690021>}
object{Fork scale .3011192 rotate <-74.14356,-16.04504,171.7323> translate <-.9069147,.1317821,.2635646>}
object{Fork scale .30112 rotate <217.7379,-46.35308,-40.38615> translate <.5013301,-.4264564,.6900216>}
object{Fork scale .3011194 rotate <-11.87598,-63.43491,18.00008> translate <.405585,.1317831,.8529134>}
object{Fork scale .3011204 rotate <-11.87583,-63.4349,90> translate <1.676381E-08,.4264575,.852913>}
object{Fork scale .3011196 rotate <217.7379,-46.35303,31.61379> translate <.5605047,.3450108,.6900211>}
object{Fork scale .3011195 rotate <-61.48956,46.35302,211.6138> translate <-.5605047,-.3450108,-.690021>}
object{Fork scale .3011193 rotate <105.8564,16.04505,188.2677> translate <-.9069147,-.1317821,-.2635646>}
object{Fork scale .3011204 rotate <168.1242,63.4349,270> translate <-1.862645E-09,-.4264575,-.852913>}
object{Fork scale .3011196 rotate <37.7379,46.35302,-31.6138> translate <.5605047,-.3450108,-.690021>}
object{Fork scale .30112 rotate <37.73796,46.35308,40.38615> translate <.5013301,.4264564,-.6900216>}
object{Fork scale .3011194 rotate <168.124,63.43491,-18.00008> translate <.405585,-.1317832,-.8529134>}
object{Fork scale .3011199 rotate <118.5104,-46.35308,220.3862> translate <-.5013301,-.4264564,.6900216>}
object{Fork scale .3011194 rotate <-74.14358,-16.04506,243.7323> translate <-.405585,-.8218038,.2635648>}
object{Fork scale .3011203 rotate <-11.87583,-2.685988E-06,270> translate <-1.862645E-09,-.9535861,4.470348E-08>}
object{Fork scale .3011195 rotate <168.1241,-3.223185E-05,234> translate <-.5605046,-.7714672,5.364418E-07>}
object{Fork scale .3011195 rotate <168.1243,-2.954586E-05,-53.99995> translate <.5605047,-.7714672,4.917383E-07>}
object{Fork scale .3011193 rotate <-11.87591,-2.77552E-05,-17.99998> translate <.9069147,-.2946741,4.61936E-07>}

//apples in back turned so see bump as bottom.  Two near edge show bottom and stem
object{Apple2 rotate <212.0987,-26.565,126.0001> translate <-.5257325,.7236063,.4472128>}
object{Apple2 rotate <354.9935,-26.565,53.99991> translate <.5257325,.7236063,.4472128>}
object{Apple rotate <327.9471,26.565,233.9999> translate <-.5257325,-.7236063,-.4472128>}
object{Apple rotate <81.67176,26.565,-53.99991> translate <.5257325,-.7236063,-.4472128>}
object{Apple3 rotate <250.2416,-26.56502,-90> translate <0,-.8944275,.4472131>}
object{Apple2 rotate <352.8012,-89.99991,90> translate <0,1.635097E-06,1>}
object{Apple rotate <87.81528,89.99991,-90> translate <0,-1.635097E-06,-1>}
object{Apple rotate <192.1943,26.56502,90> translate <0,.8944275,-.4472131>}
object{Apple rotate <38.29308,26.56508,18.00001> translate <.8506505,.2763932,-.4472141>}
object{Apple2 rotate <359.7892,-26.56508,-18.00001> translate <.8506505,-.2763932,.4472141>}
object{Apple3 rotate <243.4233,26.56508,162> translate <-.8506505,.2763932,-.4472141>}
object{Apple2 rotate <5.65341,-26.56508,198> translate <-.8506505,-.2763932,.4472141>}

object{Norange rotate <207.0662,-10.8123,90> translate <0,.982247,.1875922>}
object{Norange rotate <36.01881,-52.6226,90> translate <0,.6070625,.7946541>}
object{Norange rotate <37.08815,52.6226,-90> translate <0,-.6070625,-.7946541>}
object{Norange rotate <287.5984,10.8123,-90> translate <0,-.982247,-.1875922>}
object{Norange rotate <102.4129,52.62265,53.99996> translate <.3568223,.491123,-.7946547>}
object{Norange rotate <16.4337,52.62265,126> translate <-.3568223,.491123,-.7946547>}
object{Norange rotate <106.4782,-52.62265,234> translate <-.3568223,-.491123,.7946547>}
object{Norange rotate <137.5238,-52.62265,-53.99996> translate <.3568223,-.491123,.7946547>}
object{Norange rotate <108.3494,10.81229,-17.99998> translate <.9341726,-.3035306,-.187592>}
object{Norange rotate <341.4856,-10.81229,17.99998> translate <.9341726,.3035306,.187592>}
object{Norange rotate <352.7386,-10.81229,162> translate <-.9341726,.3035306,.187592>}
object{Norange rotate <144.4948,10.81229,198> translate <-.9341726,-.3035306,-.187592>}
object{Norange rotate <100.1808,10.81234,126> translate <-.5773507,.794654,-.1875928>}
object{Norange rotate <57.75895,10.81234,53.99996> translate <.5773507,.794654,-.1875928>}
object{Norange rotate <58.61577,-52.62259,162> translate <-.5773507,.1875928,.794654>}
object{Norange rotate <232.7714,-52.62259,18.00001> translate <.5773507,.1875928,.794654>}
object{Norange rotate <147.6264,52.62259,198> translate <-.5773507,-.1875929,-.7946541>}
object{Norange rotate <148.5961,52.62259,-18.00002> translate <.5773508,-.1875928,-.794654>}
object{Norange rotate <256.583,-10.81234,234> translate <-.5773507,-.7946541,.1875928>}
object{Norange rotate <117.4342,-10.81234,-53.99997> translate <.5773507,-.7946541,.1875928>}

scale 14
rotate <25,20,0>
}
