// Persistence Of Vision raytracer version 2.0 sample file.

// Glass of milk by gordon smith.
// The bottom has not yet found 0 in the y direction.
// It's at about <0,1.43,0>, but i haven't found out for certain.

/* sample quartic written by Alexander Enzmann */
/* Piriform - looks a bit like a Hershey's Kiss along the x axis...*/
#declare bpiriform =
   quartic {
      < 4.0,  0.0,  0.0,  -4.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
        0.0,  0.0,  0.0,   0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0,
        0.0,  0.0,  0.0,   0.0, 0.0,  1.0,  0.0,  0.0,  0.0, 0.0,
        0.0,  0.0,  1.0,   0.0, 0.0 >
      sturm
      }

#declare glassGlass =
   texture {
      pigment {color red 0.98 green 0.98 blue 0.98 filter 0.95}
      finish {
         ambient 0.1
         diffuse 0.1
         specular 0.8
         reflection 0.1
         refraction 0.9
         ior 1.45
         roughness 0.0003
         phong 1 phong_size 400
         }
      }

#declare glass =
   union {
      union {
         difference {
            object {bpiriform}
            object {bpiriform scale 0.95 translate <0.01,0,0>}
            plane {<-1,0,0>, -0.7}
            scale <2,1,1>
            translate <-0.1,0,0>
            bounded_by {sphere {<0,0,0>, 2*2}}
            }
         sphere {<0,0,0>, 0.08}
         object {bpiriform scale <1,2,2> scale 0.3 rotate <0,180,0> translate <-0.04,0,0>}
         texture {glassGlass}
         }
      // milk
      difference {
         object {bpiriform scale 0.95 translate <0.02,0,0>}
         plane {<-1,0,0>, -0.6}
         scale <2,1,1>
         translate <-0.1,0,0>
         texture {pigment {White} finish {ambient 0.4}}
         }
      rotate <0,0,90>
      translate <0,0.25,0>
      }
