// Persistence Of Vision raytracer version 2.2

// *********** ASTROBIKER ***************** Vaughn Dettmann  
// POVray August 1995 competition "Alien Worlds"  

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stormy.inc"
#include "city.inc"
#include "surfaces.inc"
#include "marine.inc"
#include "aerobike.inc"

camera {
   location <0, 0, -150> direction <0, 0, 2>  
   up <0, 1, 0> right <4/3, 0, 0> look_at <0, 0, 0> }

light_source {<-120, 80, -40> color Aquamarine }
light_source {<1550, 400, -1000> color Aquamarine }
light_source {<-1550, 1400, -1000> color LightGrey }

object { SKY no_shadow rotate y*30 }

/*---------------------- THE MOONS--------------*/

#declare MOON1 =
sphere { <0, 0, 0>, 275
   pigment { spotted 
      color_map {
         [ 0 .7 color White filter 1 color White filter .9 ] 
         [.7  1 color White filter .87 color White filter 1 ] }
      scale 25 }  finish {  ambient 1 diffuse .4 }}

#declare MOON2 =
 sphere { <0, 0, 0>, 170
   pigment { spotted 
      color_map {
         [ 0 .7 color White filter 1 color White filter .9 ] 
         [.7  1 color White filter .95 color White filter 1 ] }
      scale 30 }  finish {  ambient 1 diffuse .4 }}

 object { MOON1 no_shadow 
          rotate < 180, 170, -90 > translate < -10, 345, 2600> }

 object { MOON2 no_shadow 
          rotate < 180, 0, 0 > translate < 550, 600, 2750> }

/*---------------------- The Water ------------*/ 
 object { box { <-1200, -20, -1000>, <1200, -18, 700> }
   pigment { Black } 
   finish {
      ambient 1
      diffuse .1
      reflection .8 }}

/*-------------------The Plains -------------*/
#declare PLAINS = object {
 height_field { tga "puddles.tga" smooth }
  pigment { NewTan } 
   finish { 
     crand .2
     ambient .45 diffuse .6
     roughness .00005
     phong 1 phong_size 100 }
   scale <950, 50, 950> 
   translate <-250, -66.5, -100> }

object { PLAINS }

/*------------------The Mountains ------------*/
#declare RANGE = object {
   height_field { tga "range.tga" }
      pigment { NewTan } 
    finish {
     crand .4
     ambient .25 diffuse .7 }
 scale <1400, 650, 1400> }

object { RANGE no_shadow translate < -1500, -100, 2200> } 
object { RANGE no_shadow 
  scale <1.5, 1, 1.5> rotate y*10 translate < -1510, -190, 3100> } 

object { CITY 
  scale <4, 4, 4> translate <-400, 60, 2330> } 
object { CITY 
  scale <4, 4, 4> translate <-500, 31, 2330> } 
object { CITY 
  scale <4, 4, 4> translate <-300, 10, 2330> } 
object { CITY 
  scale <4, 4, 4> rotate <0, -45, 0> translate <-650, 10, 2380> } 
object { CITY2 
  scale <7, 7, 7> translate <-400, -40, 2200> } 
object { CITY2 
  scale <5, 5, 5> translate <-500, -35, 2100> } 
object { CITY2 
  scale <4, 4, 4> translate <-300, -35, 2200> } 

#declare RIDER = union {
object { MARINE rotate x*-40}
object { AEROBIKE }}

object { RIDER scale .83 rotate <0, 50, 5> translate <25, 32, 36> }
