//       Scene by Peter Collins
//         started 01-08-1995
//   last modified 01-08-1995

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
                   

//============================= COLORS ====================================
#declare Radar_Frame_Color=
  texture {
    pigment { color rgb<0.7 0.7 0.7> }
    finish  { reflection 0.1 }
  }

#declare Radar_Base_Color=
  texture {
    pigment { color rgb<0.9 0.95 0.9> }
    finish  { reflection 0.03 }
  }

#declare Radar_Dish_Color=
  texture {
    color White
    finish  { ambient 0.3 }
  }


//=========================================================================
#declare Radar_Dish=
union {
  difference {
    sphere { <0  5 0>  5   }
    sphere { <0  5 0>  4.8 }
    plane  { <0 -1 0> -4   }
    scale <1 0.3 1>
    texture { Radar_Dish_Color }
  }
  difference {
    union {
      cylinder { <3.1 0 0> <0 4 0> 0.08 }
      cylinder { <3.1 0 0> <0 4 0> 0.08  rotate <0  90 0> }
      cylinder { <3.1 0 0> <0 4 0> 0.08  rotate <0 180 0> }
      cylinder { <3.1 0 0> <0 4 0> 0.08  rotate <0 270 0> }
      texture { Radar_Frame_Color }
    }
    difference {
      box { <-5 -5 -5> <5 1.4 5> }
      sphere { <0 5 0> 4.9   scale <1 0.3 1> }
    }
  }
  cylinder { <0 3.4 0> <0 4.1 0> 0.25
    texture { Radar_Dish_Color }
  }
  cylinder { < 0   -1.6 0> <0   -3.1 0> 0.8        //bottom thing
    texture { Radar_Base_Color }
  }
  bounded_by { box { <-5.1 -3.2 -5.1> <5.1 4.2 5.1> } }
  translate <0 3.1 0>
}

//=========================================================================
#declare Radar_Bar =
union {
  difference {
    union {
      cylinder { <5.0 1.5 0> <3.5 -0.2 0> 0.07 }
      cylinder { <2.0 1.5 0> <3.5 -0.2 0> 0.07 }
      cylinder { <0.9 1.5 0> <1.7 -1.3 0> 0.07 }
    }
    sphere { <0 5 0> 4.99   scale <1 0.3 1> }
    plane  { <0 -1 0> -1.19999 }
  }
  cylinder { <3.5 -0.2 0> <1.7 -1.3 0> 0.07 }
  cylinder { <1.7 -1.3 0> <0   -1.7 0> 0.07 }
  bounded_by { box { <-0.1 -1.71 -0.1> <5.1 1.21 0.1> } }
}

#declare Radar_DishSupport=
union {
  torus { 3.5 0.07  translate <0 -0.2 0> }
  torus { 1.7 0.07  translate <0 -1.3 0> }
  object { Radar_Bar   rotate<0  20 0> }
  object { Radar_Bar   rotate<0  40 0> }
  object { Radar_Bar   rotate<0  60 0> }
  object { Radar_Bar   rotate<0  80 0> }
  object { Radar_Bar   rotate<0 100 0> }
  object { Radar_Bar   rotate<0 120 0> }
  object { Radar_Bar   rotate<0 140 0> }
  object { Radar_Bar   rotate<0 160 0> }
  object { Radar_Bar   rotate<0 180 0> }
  object { Radar_Bar   rotate<0 200 0> }
  object { Radar_Bar   rotate<0 220 0> }
  object { Radar_Bar   rotate<0 240 0> }
  object { Radar_Bar   rotate<0 260 0> }
  object { Radar_Bar   rotate<0 280 0> }
  object { Radar_Bar   rotate<0 300 0> }
  object { Radar_Bar   rotate<0 320 0> }
  object { Radar_Bar   rotate<0 340 0> }
  object { Radar_Bar   rotate<0 360 0> }
  texture { Radar_Frame_Color }
  bounded_by { box { <-5.1 -1.71 -5.1> <5.1 1.21 5.1> } }
  translate <0 3.1 0>
}

//=========================================================================
#declare Radar_Base=
union {
  cylinder { <-1.5 -3.1 0> <1.5 -3.1 0> 0.7 }
  difference {
    union {
      cylinder { <-1.6 -3.1  0>   <1.6 -3.1 0>  1.3 }
      box      { <-1.6 -3.099 -1.3> <1.6 -5.1 1.3> }
    }
    box      { <-0.85 -2.7 -1.7> <0.85 -1   1.7> }
    cylinder { < 0    -2.7 -1.7> <0    -2.7 1.7> 0.85 }
  }
  cylinder { <0 -4   0> <0 -5   0> 2.3 }
  cone     { <0 -4.5 0> 2.3 <0 -4.9 0> 3 }
  cylinder { <0 -4.89 0> <0 -5.5 0> 3   }
  texture { Radar_Base_Color }
  bounded_by { box { <-3.1 -5.6 -3.1> <3.1 -1.5 3.1> } }
  translate <0 3.1 0>
}

//=========================================================================

#declare Radar=
union {
  union {
    object { Radar_Dish }
    object { Radar_DishSupport }
    rotate<-20 0 0>
  }
  object { Radar_Base }
  rotate <0 45 0>
}

