#declare My_chrome = texture {
	pigment {color rgb <0.95, 0.95, 1>}
	finish {
		ambient 0.22
		diffuse 0.7
		reflection 0.4
		brilliance 8
		specular 0.8
		roughness 0.04
   }
}

#declare My_glass = texture {
	pigment {color rgbf <0, 0.2, 0.5, 0.3>}
	finish {
		ambient 0.15
		specular 0.8
		roughness 0.01
		reflection 0.2
		refraction 1
		ior 1.2
	}
}
#declare Cutoff = intersection {
	plane {x, 0}
	plane {-y, 0}
	pigment {color rgb <0, 0, 0>}
	finish {ambient 0.15 phong 0.5}
}

#declare Body = union {
	difference {
		sphere {<0, 0, 0>, 0.5 scale <1, 0.4, 0.6>}
		plane {-y, 0}
	}
	difference {
		sphere {<0, 0, 0>, 0.5 scale <1, 0.6, 0.6>}
		plane {y, 0}
	}
}

#declare Half_tail = union {
	cylinder {<0, 0, 0>, <1, 0, 0>, 0.01}
	cylinder {<0, 0, 0>, <1, 0, 0>, 0.01 rotate z*11.3 translate -y*0.2}
	difference {
		union {
			cylinder {<0.2, 0, 0>, <0.2, -0.2, 0>, 0.01}
			cylinder {<0.4, 0, 0>, <0.4, -0.2, 0>, 0.01}
			cylinder {<0.6, 0, 0>, <0.6, -0.2, 0>, 0.01}
			cylinder {<0.8, 0, 0>, <0.8, -0.2, 0>, 0.01}
		}
		plane {y, 0 rotate z*11.3 translate -y*0.2}
	}
}

#declare Tail = union {
	union {
		object {Half_tail translate z*0.05}
		object {Half_tail translate -z*0.05}
		cylinder {<0.2, 0, 0.05>, <0.2, 0, -0.05>, 0.01}
		cylinder {<0.4, 0, 0.05>, <0.4, 0, -0.05>, 0.01}
		cylinder {<0.6, 0, 0.05>, <0.6, 0, -0.05>, 0.01}
		cylinder {<0.8, 0, 0.05>, <0.8, 0, -0.05>, 0.01}
		cylinder {<1, 0, 0.2>, <1, 0, -0.2>, 0.1 scale <1, 0.01, 1>}
		texture {My_chrome}
	}
	sphere {<0, 0, 0>, 0.2 scale <0.5, 0.8, 0.1> translate <1, 0, 0.2>}
	sphere {<0, 0, 0>, 0.2 scale <0.5, 0.8, 0.1> translate <1, 0, -0.2>}
}

#declare Rotor = disc {
	<0, 0.155, 0>, <0, 1, 0>, 1
	pigment {
		radial
		color_map {
		[0.00 0.15 color rgbf <1, 1, 1, 0.8> color rgbf <1, 1, 1, 0.8>]
		[0.15 0.20 color rgbf <1, 1, 1, 0.8> color rgbf <1, 1, 1, 0.6>]
		[0.20 0.25 color rgbf <1, 1, 1, 0.6> color rgbf <1, 1, 1, 0.8>]
		[0.25 0.65 color rgbf <1, 1, 1, 0.8> color rgbf <1, 1, 1, 0.8>]
		[0.65 0.70 color rgbf <1, 1, 1, 0.8> color rgbf <1, 1, 1, 0.6>]
		[0.70 0.75 color rgbf <1, 1, 1, 0.6> color rgbf <1, 1, 1, 0.8>]
		[0.75 1.00 color rgbf <1, 1, 1, 0.8> color rgbf <1, 1, 1, 0.8>]
		}
	}
	finish {ambient 0.2 phong 1}
}

#declare Turbo = union {
	object {
		union {
			sphere {<0, 0, 0>, 0.1 scale <2.5, 1, 1> translate z*0.1}
			sphere {<0, 0, 0>, 0.1 scale <2.5, 1, 1> translate -z*0.1}
		}
		clipped_by {plane {-x, 0.2}}
	}
	union {
		sphere {<0, 0, 0>, 0.1 scale <2.4, 0.6, 1> translate z*0.1}
		sphere {<0, 0, 0>, 0.1 scale <2.4, 0.6, 1> translate -z*0.1}
		cylinder {<0, -0.1, 0>, <0, 0.12, 0>, 0.03}
		cylinder {<0, 0.12, 0>, <0, 0.2, 0>, 0.01}
		cylinder {<0, 0.15, 0>, <0, 0.16, 0>, 0.03}
		cylinder {<0, 0.2, 0>, <0, 0.21, 0>, 0.03}
		texture {My_chrome}
	}
    object {Rotor}
	object {Rotor rotate y*90 translate y*0.05}
	translate y*0.3
}

#declare Bunch = union {
	cylinder {<-0.05, 0, 0>, <0.05, 0, 0>, 0.035 open}
	cylinder {<-0.01, 0, 0>, <0.01, 0, 0>, 0.035}
	sphere {<0, 0, 0>, 0.02 scale <1, 0.4, 0.4>}
	cylinder {<-0.1, 0, 0>, <-0.11, 0, 0>, 0.065 open}
	cylinder {<0.05, 0, 0>, <0.06, 0, 0>, 0.065 open}

	object {
		union {
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*0}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*45}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*90}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*135}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*180}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*225}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*270}
			cylinder {<-0.2, 0, -0.05>, <0.1, 0, -0.05>, 0.015 rotate x*315}
		}
		clipped_by {plane {-x, 0.15}}
	}
}

#declare Guns = union {
	cylinder {<0, 0, -0.4>, <0, 0, 0.4>, 0.05 scale <1, 0.1, 1>}
	object {Bunch translate -z*0.4}
	object {Bunch translate z*0.4}
	translate <0.15, 0.15, 0>
	texture {My_chrome finish {reflection 0.2}}
}

#declare Rocket = union {
	sphere { <0, 0, 0>, 0.1 scale <2, 0.3, 0.3> }
	sphere { <0, 0, 0>, 0.05 scale <0.6, 1, 0.1> translate x*0.18}
	sphere { <0, 0, 0>, 0.05 scale <0.6, 0.1, 1> translate x*0.18}

	texture {
		pigment {color rgb <0.6, 0.6, 0.6>}
	}
	texture {
		pigment {
			gradient x
			color_map {
			[0 0.05 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			[0.05 0.06 color rgb <1, 1, 0.6> color rgb <1, 1, 0.6>]
			[0.06 0.07 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			[0.07 0.08 color rgb <1, 1, 0.6> color rgb <1, 1, 0.6>]
			[0.08 1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			}
			translate -x*0.2
		}
		finish {ambient 0.25 phong 1}
	}
}

#declare F_rocket = union {
	object {Rocket}
	sphere {
		<0, 0, 0>, 0.1
		clipped_by {plane {-x, 0}}
		pigment {
			gradient x
			color_map {
			[0.0 0.5 color rgbf <1, 1, 1, 1> color rgbf <1, 0, 0, 0.6>]
			[0.5 1.0 color rgbf <1, 0, 0, 0.6> color rgbf <1, 0, 0, 0>]
			}
			scale <0.2, 1, 1>
		}
		finish {ambient 4}

		scale <3, 0.2, 0.2>
		translate x*0.22
	}
}

#declare Rockets = union {
	cylinder {<0, 0, -0.5>, <0, 0, 0.5>, 0.05 scale <1, 0.1, 1>}
	object {Rocket translate <0, -0.035, -0.5>}
	object {Rocket translate <0, -0.035, 0.45>}
	object {Rocket translate <0, -0.035, -0.45>}
	translate <0.1, 0, 0>
}

#declare High_part = union {
	torus {
		0.2, 0.01 rotate <90, 90, 0>
		clipped_by {
			box {<-0.1, 0, 0>, <0.1, 0.3, -0.3>}
		}
		translate <-0.2, -0.3, -0.1>
	}
	torus {
		0.2, 0.01 rotate <90, 90, 0>
		clipped_by {
			box {<-0.1, 0, 0>, <0.1, 0.3, 0.3>}
		}
		translate <-0.2, -0.3, 0.1>
	}
}

#declare Low_part = union {
	cylinder {<-0.3, -0.3, -0.3>, <0.3, -0.3, -0.3>, 0.01}
	torus {
		0.05, 0.01 rotate x*90
		clipped_by {
			box {<-0.2, -0.2, -0.1>, <0, 0, 0.1>}
		}
		translate <-0.3, -0.25, -0.3>
	}
	sphere {<-0.35, -0.25, -0.3>, 0.01}
}

#declare Legs = union {
	object {High_part}
	object {High_part translate x*0.4}
	object {Low_part}
	object {Low_part translate z*0.6}
	texture {My_chrome}
}

#declare Projector = union {
	cylinder {<-0.3, -0.1, 0>, <-0.3, -0.2, 0>, 0.01}
	difference {
		sphere {<0, 0, 0>, 0.05}
		plane {x, 0}
		translate <-0.32, -0.2, 0>
	}
	sphere {
		<0, 0, 0>, 0.04
		scale <0.3, 1, 1>
		translate <-0.32, -0.2, 0>
		pigment {color rgb <1, 1, 1>}
		finish {ambient 1}
	}
	cone {		// beam
		<0, 0, 0>, 0.04, <-12, 0, 0>, 0.6
		pigment {color rgbf <1, 1, 1, 0.95>}
		finish {ambient 2.5}
		translate <-0.32, -0.2, 0>
		no_shadow
	}

	pigment {color rgb <1, 0, 0>}
	finish {ambient 0.2 phong 1}
}

#declare Helicopter = union {
	difference {
		object {Body}
		object {Cutoff}
	}
	intersection {
		object {Body}
		object {Cutoff}
		texture {My_glass}
		texture {
			pigment {
				gradient y
				color_map {
				[0 0.01 color rgb <0, 0.4, 0.35> color rgb <0, 0.4, 0.35>]
				[0.01 1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
				}
			}
		}
		texture {
			pigment {
				gradient x
				color_map {
				[0 0.01 color rgb <0, 0.4, 0.35> color rgb <0, 0.4, 0.35>]
				[0.01 1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
				}
			}
			finish {ambient 0.4 phong 1 reflection 0.15}
		}
	}
	object {Tail translate <0.3, 0.2, 0>}
	object {Turbo translate <0.2, 0, 0>}
	object {Guns}
	object {Rockets}
	object {Legs}
	object {Projector}

	pigment {
		bozo
		turbulence 0.3
		color_map {
			[0 0.4 color rgb <0.1, 0.3, 0.25> color rgb <0.2, 0.4, 0.35>]
			[0.4 0.8 color rgb <0.2, 0.4, 0.35> color rgb <0.2, 0.6, 0.55>]
			[0.8 1 color rgb <0.2, 0.6, 0.55> color rgb <0.2, 0.6, 0.55>]
		}
		scale 0.1
	}
	finish {ambient 0.2 metallic phong 1}
}

#declare Helicopter1 = union {
	object {Helicopter}
	object {F_rocket translate <-0.9, -0.3, 0.5>}
}

#declare Helicopter2 = union {
	object {Helicopter}
	object {Rocket translate <0.1, -0.035, 0.5>}
}

