//
// @(#)planet.inc:v1.0
//
// Author       : Kevin B Black
// Date written : 08 August 1995
// Copyright    :  Kevin B Black, 1995
// Abstract     :
//
// ALIEN WORLDS ; DEFINE PLANETS
//
// Declares a large planet with a ring system and a sub orbital moon/planet (for
// effect). Various items are also added to the ring system to make it look more
// "real", including "shepherding" moons.
//
// NOTE : The planet body has a radius of 10000, and should be scaled as
//        appropriate.
//
#declare Planet0_pr=10000 // Radius of planet
#declare Planet0_rx=Planet0_pr/12
#declare Planet0_gx=Planet0_pr/4
#declare Planet0_rbounds = Planet0_pr*2+Planet0_pr/2
#declare Planet0_ringtexture =
texture
{
   pigment
   {
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map
      {
         [0.0 0.1 color Clear color Clear]
         [0.70 color rgb <4/5, 4/5, 5/6> filter 0.7 ]
         [1.0 color White filter 0.8 ]
      }
   }
   finish { ambient 1 diffuse 0 }
   scale 100
}

#declare Planet0_thingsphere =
sphere
{ <0.0, 0.0, 0.0>, 1.0 texture { pigment { White } } scale Planet0_rx/5 }

#declare Planet0_thing =
sphere
{ <0.0, 0.0, 0.0>, 1.0
   texture
   {
      pigment
      {
         White
      }
      finish { Shiny }
      normal { bumps 0.3 turbulence 0.2 scale 0.1 }
   }
   scale Planet0_rx/5
}

#declare Planet0_tx = // For Planet0_thing
   (Planet0_rx*6)

#include "rings0.inc"
#include "rings1.inc"

#declare Planet0 =
union
{
   sphere
   { <0.0, 0.0, 0.0>, Planet0_pr
      texture // Lower texture
      {
         pigment
         {
            spotted
            turbulence 0.8
            colour_map
            {
               [0.0 1.0  colour red 0.8 green 0.6 blue 0.2
                         colour red 0.9 green 0.9 blue 0.0]
            }
            scale Planet0_pr*0.2025
         }
      }
      texture // Upper texture
      {
         pigment
         {
            agate
            turbulence 0.8
            colour_map
            {
               [0.0 0.3 colour Clear colour Tan ]
               [0.591 0.609 colour White colour White ]
               [1.0 colour Brown ]
            }
            scale Planet0_pr*0.9615
         }
      }
      finish
      {
         crand 0.08
         ambient 0.0
         diffuse 1.0
      }
   }

//
// Place a ring system around near planet
//
   difference
   {
      union
      {
         torus // ring7
         { Planet0_pr+Planet0_gx+Planet0_rx/2, Planet0_rx/2 sturm
            texture { Planet0_ringtexture scale Planet0_rx*0.01 }
            scale <1.0,0.01,1.0>
         }
         torus // ring 6
         { Planet0_pr+Planet0_gx+1.5*Planet0_rx, Planet0_rx sturm
            texture { Planet0_ringtexture scale Planet0_rx*0.1 }
            scale <1.0,0.01,1.0>
         }
         torus // ring 5
         { Planet0_pr+Planet0_gx+2.5*Planet0_rx, Planet0_rx sturm
            texture { Planet0_ringtexture scale 1.0 }
            scale <1.0,0.01,1.0>
         }
         torus // ring 4
         { Planet0_pr+Planet0_gx+3.5*Planet0_rx, Planet0_rx sturm
            texture { Planet0_ringtexture scale Planet0_rx*0.5 }
            scale <1.0,0.01,1.0>
         }
// Gap!!!
         torus // ring 3
         { Planet0_pr+Planet0_gx+5.5*Planet0_rx, Planet0_rx/2 sturm
            texture { Planet0_ringtexture scale Planet0_rx*0.3 }
            scale <1.0,0.01,1.0>
         }
         torus // ring 2
         { Planet0_pr+Planet0_gx+6*Planet0_rx, Planet0_rx/2 sturm
            texture { Planet0_ringtexture scale Planet0_rx*0.7 }
            scale <1.0,0.01,1.0>
         }
         torus // ring 1
         { Planet0_pr+Planet0_gx+6.5*Planet0_rx, Planet0_rx/2 sturm
            texture { Planet0_ringtexture scale Planet0_rx*2.0 }
            scale <1.0,0.01,1.0>
         }
      }
      object { Planet0_thingsmask }
   }
   object { Planet0_things }

//
// Place a small shepherds moon in the gap of the ring system
//
   sphere
   { <0.0, 0.0, 0.0>, 1.0
      texture
      {
         pigment
         {
            spotted
            colour_map
            {
               [ 0.0 colour White ]
               [ 0.9 colour White ]
               [ 1.0 colour Red ]
            }
            turbulence 0.2
            omega 0.3
            rotate <0.0 ,0.0 ,90.0>
            scale 0.1
         }
         finish { Shiny }
         normal { bumps 0.3 turbulence 0.2 scale 0.1 }
      }
      scale Planet0_rx/2
      translate <-(Planet0_pr+Planet0_gx+5*Planet0_rx),0,0>
   }

//
// Place a very small shepherds moon at the edge of the ring system
//
   sphere
   { <0.0, 0.0, 0.0>, 1.0
      texture
      {
         pigment
         {
            White
         }
         finish { Shiny }
         normal { bumps 0.3 turbulence 0.2 scale 0.1 }
      }
      scale Planet0_rx/4
      translate <-(Planet0_pr+Planet0_gx+7.5*Planet0_rx),0,0>
      rotate <0.0, 30.0, 0.0>
   }

//
// Oh alright, lets have another large moon/planet.....
//
   sphere
   { <0.0, 0.0, 0.0>, 1.0
      texture
      {
         pigment
         {
            granite
            colour_map
            {
               [ 0.0 colour Yellow ]
               [ 0.2 colour Blue ]
               [ 0.4 colour Cyan ]
               [ 0.9 colour White ]
               [ 1.0 colour Cyan ]
            }
            turbulence 0.2 lambda 7
            omega 0.3 octaves 2.0
            rotate z*90.0 scale 2.0
         }
      }
      scale Planet0_pr/5.0
      translate <-(Planet0_pr+Planet0_pr),0,0>
      rotate <15,15,-35>
   }

   sphere // Give it some clouds, but they may not come out right (depends on rand)
   { <0.0, 0.0, 0.0>, 1.02
      texture
      {
         pigment {
            bozo
            turbulence 0.7 // 0.6
            octaves 1 // 4
            lambda 7.0 // 0.5 // 5.7
            color_map
            {
               [0.0 0.4 colour Clear colour Clear ]
               [0.80 colour rgb <4/5, 4/5, 5/6> filter 0.5]
               [1.0 colour White]
            }
            quick_color red 0.36 green 0.36 blue 1.0
            scale <1.0, 1.0, 0.5> // 500.0
         }
         finish { ambient 0.8 diffuse 0.0 }
      }
      scale Planet0_pr/5.0
      translate <-(Planet0_pr+Planet0_pr),0,0>
      rotate <15,15,-35>
   }
   bounded_by { box { <-Planet0_rbounds,-Planet0_rbounds,-Planet0_rbounds>,
                      <Planet0_rbounds,Planet0_rbounds,Planet0_rbounds> } }
}
