      program Things
      implicit none
C
C Author       : Kevin B Black
C Date written : 16 August 1995
C Abstract     :
C
C Produce two include files containing "things" to go in the ring
C system of the large planet. The two files are called rings0.inc
C and rings1.inc.
C
      integer i,j
      real a,a0,a1,a2,a3,rk
      real rand
C
C Open the files
C
      open(unit=1,file='rings0.inc',status='unknown')
      open(unit=2,file='rings1.inc',status='unknown')
C
C Write preamble
C
      write(1,1000)
1000  format('//',/,'// @(#)rings0:v1.0')
      write(2,1010)
1010  format('//',/,'// @(#)rings1:v1.0')
      write(1,1020)
1020  format(
     *'//',/,
     *'// Author       : Kevin B Black',/,
     *'// Date written : 16 August 1995',/,
     *'// Abstract     :',/,
     *'//')
      write(2,1020)
      write(1,1030)
1030  format('// Stuff added to the planets ring system for effect.')
      write(2,1040)
1040  format('// Masks for stuff added to the planets ring system for ef
     *fect.')
      write(1,1050)
1050  format(
     *'//',/,
     *'// Data created by "things.for".',/,
     *'//')
      write(2,1050)
C
C #declare.....
C
      write(1,1060)
1060  format('#declare Planet0_things =')
      write(2,1070)
1070  format('#declare Planet0_thingsmask =')
      write(1,1080)
1080  format('union',/,'{')
      write(2,1080)
C
C Add things
C
      rk=0.1
      a=0.0
      do j=1,11
         do i=1,8
            a0=rand(1.0)
            a1=rand(1.0)*10.0-5.0
            a2=a+rand(1.0)*90.0
            a3=rand(1.0)*6.0-3.0
            write(1,1090)rk,a0,a1,a2,a3
1090  format(
     *'   object { Planet0_thing scale',F8.3,/,
     *'            translate <-(Planet0_pr+Planet0_gx+Planet0_tx*',
     *F8.5,'), 0.0, 0.0>',/,
     *'            rotate <',F8.2,',',F8.2,',',F8.2,'>',/,
     *'          }')
            write(2,1100)rk*1.1,a0,a1,a2,a3
1100  format(
     *'    object { Planet0_thingsphere scale',F8.3,/,
     *'             translate <-(Planet0_pr+Planet0_gx+Planet0_tx*',
     *F8.5,'), 0.0, 0.0>',/,
     *'             rotate <',F8.2,',',F8.2,',',F8.2,'>',/,
     *'           }')
C
C Update sequencing
C
            rk=rk+0.1
            if(rk.gt.0.8)then
               rk=0.1
            endif
         enddo
         a=a+360.0/10.0
      enddo
      write(1,1110)
1110  format('}')
      write(2,1110)
      close(unit=2)
      close(unit=1)
      end

      real function rand(x)
      implicit none
      real x,a
      logical init
      data init/.TRUE./
      if(init)then
         call seed(3357)
         init=.FALSE.
      endif
      call random(a)
      rand=a*x
      return
      end
