#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

camera {
  location  <0, 8, 248.4>
  direction <0, 0, 1.75>
  look_at   <500, 1, 250>
}

fog { color Black distance 2500 }

light_source { <0, 20, 245> color White }

plane { y, 0
        texture {
                pigment { //modified Blood_Sky
                bozo
                turbulence 0.5
                        color_map 
                                {[0.0, 0.5  color red 0.9 green 0.7 filter 0.3
                                            color red 0.3 green 0.2 filter 0.3]
                                [0.5, 0.6   color red 0.6 green 0.025 filter 0.6
                                            color red 0.9 green 0.7 filter 0.6]
                                [0.6, 1.01  color red 0.6 green 0.025 filter 1.0
                                            color red 0.6 green 0.025 filter 1.0]
                                }
                        }
                finish { ambient 0.6 }
                scale <50, 50, 150>
                rotate <0, 30, 0>
                }
        translate <0, 70, 0>
        rotate <0, 0, -1.75>
        }

plane { y, 0
        texture {
                pigment { Blood_Sky }
                finish { ambient 0.6 }
                scale <50, 50, 100>
                translate <0, 100, 0>
                }
        }

plane { y, 0.01
        texture {
                pigment { Black }
                finish { ambient 0 }
                }
        }
                          
height_field {
    gif "labrnth8.gif" 
    water_level 0.000000
    scale <500, 85.3333, 500>
        texture {
                normal { 
                        bump_map { 
                                tga "bricktex.tga"
                                bump_size 10
                                }
                                rotate <90, 0, 0>
                                scale 6
                        }
                pigment { 
                        gradient y
                        color_map {
                                [ 0.0 color Black ]
                                [ 1.0 color Firebrick ] }
                        }
                finish {
                        ambient 0.75
                        }
                }
    scale <1, 5.859375, 1>
    translate <0, -24, 0>
    }

union {
        triangle { <1, 0, 0> <0, 0, 0.577350269> <0.0577350269, 3, 0> }
        triangle { <1, 0, 0> <0, 0, -0.577350269> <0.0577350269, 3, 0> }
        triangle { <0, 0, 0.577350269> <0, 0, -0.577350269> <0.0577350269, 3, 0> }
        triangle { <1, 0, 0> <0, 0, 0.577350269> <0.0577350269, -3, 0> }
        triangle { <1, 0, 0> <0, 0, -0.577350269> <0.0577350269, -3, 0> }
        triangle { <0, 0, 0.577350269> <0, 0, -0.577350269> <0.0577350269, -3, 0> }

        texture {
                normal {
                        bump_map {
                                tga "blocktx2.tga"
                                map_type 2
                                bump_size 2.5
                                }
                        }
                pigment { color CoolCopper }
                finish { ambient 0.5 }
                }
        
        scale 20
        rotate <0, 45, 0>
        translate < 499.5773503, 61, 250 >
        }

