//  Persistance of Vision Raytracer V2.0
//  Contains 1 lights, 11 textures and 155 primitives.
//  Date : 08/14/1995  
//
//  This Picture was made by Philip Kulp using MORAY
// 

camera {  //  Camera stdcam
  location  <-135.625, -1078.814, 336.998>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <20.401, -74.071, 1.000>
}

// *******  L I G H T S *******
light_source {   // planet_sun
  <257.097, -498.464, 276.381>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  T E X T U R E S  *******
//

#include "phkalien.INC"

// ********  O B J E C T S *******
#declare pwr_plant_primt = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <100.000000, 40.000000, 20.000000>
  rotate <-0.000000, -0.000000, -90.000000>
  translate <-259.325557, 74.418573, 20.000000>
}

#declare Pwrplnt_tank1 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-180.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-130.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank3 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-80.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank4 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-30.000000, 70.000000, 15.000000>
}

#declare tanks_row1 = union {
  object { Pwrplnt_tank1 }
  object { Pwrplnt_tank2 }
  object { Pwrplnt_tank3 }
  object { Pwrplnt_tank4 }
}

#declare Pwrplnt_tank5 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-180.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank6 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-130.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank7 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-80.000000, 70.000000, 15.000000>
}

#declare Pwrplnt_tank8 = object { 
  sphere {<0,0,0>,1}
  texture {
    Chrome_Texture
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <-30.000000, 70.000000, 15.000000>
}

#declare tanks_row2 = union {
  object { Pwrplnt_tank5 }
  object { Pwrplnt_tank6 }
  object { Pwrplnt_tank7 }
  object { Pwrplnt_tank8 }
  translate <0.000000, -75.000000, 0.000000>
}

#declare powerplant_roof = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <25.000000, 35.000000, 10.000000>
  translate <-258.000000, 30.000000, 50.000000>
}

#declare pipe_row1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <3.000000, 3.000000, 150.000000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <-30.000000, -5.000000, 15.000000>
}

#declare pipe_row2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <3.000000, 3.000000, 150.000000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <-30.000000, 70.000000, 15.000000>
}

#declare pipe_middconect = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <3.000000, 3.000000, 75.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <-105.000000, -4.000000, 15.000000>
}

#declare pipe_middle = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <3.000000, 3.000000, 120.000000>
  rotate <-90.000000, -90.000000, -90.000000>
  translate <-228.140096, 31.391832, 15.000000>
}

#declare plnt2pipe_cnctr = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <6.000000, 6.000000, 4.000000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <-215.000000, 31.500000, 15.000000>
}

#declare all_pipes = union {
  object { pipe_row1 }
  object { pipe_row2 }
  object { pipe_middconect }
  object { pipe_middle }
  object { plnt2pipe_cnctr }
}

union {
  object { pwr_plant_primt }
  object { tanks_row1 }
  object { tanks_row2 }
  object { powerplant_roof }
  object { all_pipes }
  scale <0.750000, 0.750000, 0.750000>
  rotate <-0.000000, -0.000000, -80.000000>
  translate <-218.936934, 29.511258, 0.000000>
}

#declare head_primt1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <15.000000, -5.000000, 15.000000>
}

#declare Head_sphere1 = object { 
  sphere {<0,0,0>,1}
  texture {
    head_glass
    scale <50.000000, 50.000000, 50.000000>
  }
  scale <13.000000, 13.000000, 13.000000>
  translate <15.000000, -5.000000, 30.000000>
}

#declare head_office1 = union {
  object { head_primt1 }
  object { Head_sphere1 }
}

#declare head_primt2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <15.000000, -5.000000, 15.000000>
}

#declare Head_sphere2 = object { 
  sphere {<0,0,0>,1}
  texture {
    head_glass
    scale <50.000000, 50.000000, 50.000000>
  }
  scale <13.000000, 13.000000, 13.000000>
  translate <15.000000, -5.000000, 30.000000>
}

#declare head_office2 = union {
  object { head_primt2 }
  object { Head_sphere2 }
  translate <250.000000, 0.000000, 0.000000>
}

#declare head_primt3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <15.000000, -5.000000, 15.000000>
}

#declare Head_sphere3 = object { 
  sphere {<0,0,0>,1}
  texture {
    head_glass
    scale <50.000000, 50.000000, 50.000000>
  }
  scale <13.000000, 13.000000, 13.000000>
  translate <15.000000, -5.000000, 30.000000>
}

#declare head_office3 = union {
  object { head_primt3 }
  object { Head_sphere3 }
  translate <0.000000, -210.000000, 0.000000>
}

#declare head_primt4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  scale <15.000000, 15.000000, 15.000000>
  translate <15.000000, -5.000000, 15.000000>
}

#declare Head_sphere4 = object { 
  sphere {<0,0,0>,1}
  texture {
    head_glass
    scale <50.000000, 50.000000, 50.000000>
  }
  scale <13.000000, 13.000000, 13.000000>
  translate <15.000000, -5.000000, 30.000000>
}

#declare head_office4 = union {
  object { head_primt4 }
  object { Head_sphere4 }
  translate <250.000000, -210.000000, 0.000000>
}

#declare head_offices = union {
  object { head_office1 }
  object { head_office2 }
  object { head_office3 }
  object { head_office4 }
}

#declare city_streets = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    street_texture
  }
  scale <140.000000, 120.000000, 0.200000>
  translate <140.000000, -110.000000, 0.000000>
}

#declare tower1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  no_shadow
  scale <15.000000, 15.000000, 75.000000>
  translate <115.000000, -85.000000, 75.000000>
}

#declare tower2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  no_shadow
  scale <15.000000, 15.000000, 75.000000>
  translate <165.000000, -85.000000, 75.000000>
}

#declare tower3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  no_shadow
  scale <15.000000, 15.000000, 75.000000>
  translate <115.000000, -135.000000, 75.000000>
}

#declare tower4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rusty_Iron
  }
  no_shadow
  scale <15.000000, 15.000000, 75.000000>
  translate <165.000000, -135.000000, 75.000000>
}

#declare towers = union {
  object { tower1 }
  object { tower2 }
  object { tower3 }
  object { tower4 }
}

#declare smbldg3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, 5.000000, 10.000000>
}

#declare smbldg4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, 5.000000, 10.000000>
}

#declare smbldg5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, 5.000000, 10.000000>
}

#declare smbldg6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, 5.000000, 10.000000>
}

#declare smbldg7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, 5.000000, 10.000000>
}

#declare smbldg10 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -15.000000, 10.000000>
}

#declare smbldg11 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -15.000000, 10.000000>
}

#declare smbldg12 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -15.000000, 10.000000>
}

#declare smbldg13 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -15.000000, 10.000000>
}

#declare smbldg14 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -15.000000, 10.000000>
}

#declare smbldg15 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -35.000000, 10.000000>
}

#declare smbldg16 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -35.000000, 10.000000>
}

#declare smbldg17 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -35.000000, 10.000000>
}

#declare smbldg18 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -35.000000, 10.000000>
}

#declare smbldg19 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -35.000000, 10.000000>
}

#declare smbldg20 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -35.000000, 10.000000>
}

#declare smbldg21 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -35.000000, 10.000000>
}

#declare smbldg22 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -55.000000, 10.000000>
}

#declare smbldg23 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -55.000000, 10.000000>
}

#declare smbldg24 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -55.000000, 10.000000>
}

#declare smbldg25 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -55.000000, 10.000000>
}

#declare smbldg29 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -75.000000, 10.000000>
}

#declare smbldg30 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -75.000000, 10.000000>
}

#declare smbldg31 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -75.000000, 10.000000>
}

#declare smbldg32 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -75.000000, 10.000000>
}

#declare smbldg36 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -95.000000, 10.000000>
}

#declare smbldg37 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -95.000000, 10.000000>
}

#declare smbldg38 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -95.000000, 10.000000>
}

#declare smbldg39 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -95.000000, 10.000000>
}

#declare tleft_quad_bldg = union {
  object { smbldg3 }
  object { smbldg4 }
  object { smbldg5 }
  object { smbldg6 }
  object { smbldg7 }
  object { smbldg10 }
  object { smbldg11 }
  object { smbldg12 }
  object { smbldg13 }
  object { smbldg14 }
  object { smbldg15 }
  object { smbldg16 }
  object { smbldg17 }
  object { smbldg18 }
  object { smbldg19 }
  object { smbldg20 }
  object { smbldg21 }
  object { smbldg22 }
  object { smbldg23 }
  object { smbldg24 }
  object { smbldg25 }
  object { smbldg29 }
  object { smbldg30 }
  object { smbldg31 }
  object { smbldg32 }
  object { smbldg36 }
  object { smbldg37 }
  object { smbldg38 }
  object { smbldg39 }
}

#declare smbldg43 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, 5.000000, 10.000000>
}

#declare smbldg44 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, 5.000000, 10.000000>
}

#declare smbldg45 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, 5.000000, 10.000000>
}

#declare smbldg46 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, 5.000000, 10.000000>
}

#declare smbldg47 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, 5.000000, 10.000000>
}

#declare smbldg50 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -15.000000, 10.000000>
}

#declare smbldg51 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -15.000000, 10.000000>
}

#declare smbldg52 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -15.000000, 10.000000>
}

#declare smbldg53 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -15.000000, 10.000000>
}

#declare smbldg54 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -15.000000, 10.000000>
}

#declare smbldg57 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -35.000000, 10.000000>
}

#declare smbldg58 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -35.000000, 10.000000>
}

#declare smbldg59 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -35.000000, 10.000000>
}

#declare smbldg60 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -35.000000, 10.000000>
}

#declare smbldg61 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -35.000000, 10.000000>
}

#declare smbldg62 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -35.000000, 10.000000>
}

#declare smbldg63 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -35.000000, 10.000000>
}

#declare smbldg67 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -55.000000, 10.000000>
}

#declare smbldg68 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -55.000000, 10.000000>
}

#declare smbldg69 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -55.000000, 10.000000>
}

#declare smbldg70 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -55.000000, 10.000000>
}

#declare smbldg74 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -75.000000, 10.000000>
}

#declare smbldg75 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -75.000000, 10.000000>
}

#declare smbldg76 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -75.000000, 10.000000>
}

#declare smbldg77 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -75.000000, 10.000000>
}

#declare smbldg81 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -95.000000, 10.000000>
}

#declare smbldg82 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -95.000000, 10.000000>
}

#declare smbldg83 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -95.000000, 10.000000>
}

#declare smbldg84 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -95.000000, 10.000000>
}

#declare trght_quad_bldg = union {
  object { smbldg43 }
  object { smbldg44 }
  object { smbldg45 }
  object { smbldg46 }
  object { smbldg47 }
  object { smbldg50 }
  object { smbldg51 }
  object { smbldg52 }
  object { smbldg53 }
  object { smbldg54 }
  object { smbldg57 }
  object { smbldg58 }
  object { smbldg59 }
  object { smbldg60 }
  object { smbldg61 }
  object { smbldg62 }
  object { smbldg63 }
  object { smbldg67 }
  object { smbldg68 }
  object { smbldg69 }
  object { smbldg70 }
  object { smbldg74 }
  object { smbldg75 }
  object { smbldg76 }
  object { smbldg77 }
  object { smbldg81 }
  object { smbldg82 }
  object { smbldg83 }
  object { smbldg84 }
  translate <150.000000, 0.000000, 0.000000>
}

#declare smbldg85 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, 5.000000, 10.000000>
}

#declare smbldg86 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, 5.000000, 10.000000>
}

#declare smbldg87 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, 5.000000, 10.000000>
}

#declare smbldg88 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, 5.000000, 10.000000>
}

#declare smbldg92 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -15.000000, 10.000000>
}

#declare smbldg93 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -15.000000, 10.000000>
}

#declare smbldg94 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -15.000000, 10.000000>
}

#declare smbldg95 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -15.000000, 10.000000>
}

#declare smbldg99 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -35.000000, 10.000000>
}

#declare smbldg100 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -35.000000, 10.000000>
}

#declare smbldg101 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -35.000000, 10.000000>
}

#declare smbldg102 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -35.000000, 10.000000>
}

#declare smbldg106 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -55.000000, 10.000000>
}

#declare smbldg107 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -55.000000, 10.000000>
}

#declare smbldg108 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -55.000000, 10.000000>
}

#declare smbldg109 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -55.000000, 10.000000>
}

#declare smbldg110 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -55.000000, 10.000000>
}

#declare smbldg111 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -55.000000, 10.000000>
}

#declare smbldg112 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -55.000000, 10.000000>
}

#declare smbldg113 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -75.000000, 10.000000>
}

#declare smbldg114 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -75.000000, 10.000000>
}

#declare smbldg115 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -75.000000, 10.000000>
}

#declare smbldg116 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -75.000000, 10.000000>
}

#declare smbldg117 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -75.000000, 10.000000>
}

#declare smbldg118 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -95.000000, 10.000000>
}

#declare smbldg119 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -95.000000, 10.000000>
}

#declare smbldg120 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -95.000000, 10.000000>
}

#declare smbldg121 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -95.000000, 10.000000>
}

#declare smbldg122 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -95.000000, 10.000000>
}

#declare bleft_quad_bldg = union {
  object { smbldg85 }
  object { smbldg86 }
  object { smbldg87 }
  object { smbldg88 }
  object { smbldg92 }
  object { smbldg93 }
  object { smbldg94 }
  object { smbldg95 }
  object { smbldg99 }
  object { smbldg100 }
  object { smbldg101 }
  object { smbldg102 }
  object { smbldg106 }
  object { smbldg107 }
  object { smbldg108 }
  object { smbldg109 }
  object { smbldg110 }
  object { smbldg111 }
  object { smbldg112 }
  object { smbldg113 }
  object { smbldg114 }
  object { smbldg115 }
  object { smbldg116 }
  object { smbldg117 }
  object { smbldg118 }
  object { smbldg119 }
  object { smbldg120 }
  object { smbldg121 }
  object { smbldg122 }
  translate <0.000000, -130.000000, 0.000000>
}

#declare smbldg126 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, 5.000000, 10.000000>
}

#declare smbldg127 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, 5.000000, 10.000000>
}

#declare smbldg128 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, 5.000000, 10.000000>
}

#declare smbldg129 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, 5.000000, 10.000000>
}

#declare smbldg133 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -15.000000, 10.000000>
}

#declare smbldg134 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -15.000000, 10.000000>
}

#declare smbldg135 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -15.000000, 10.000000>
}

#declare smbldg136 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -15.000000, 10.000000>
}

#declare smbldg140 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -35.000000, 10.000000>
}

#declare smbldg141 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -35.000000, 10.000000>
}

#declare smbldg142 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -35.000000, 10.000000>
}

#declare smbldg143 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -35.000000, 10.000000>
}

#declare smbldg144 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -55.000000, 10.000000>
}

#declare smbldg145 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -55.000000, 10.000000>
}

#declare smbldg146 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -55.000000, 10.000000>
}

#declare smbldg147 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -55.000000, 10.000000>
}

#declare smbldg148 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -55.000000, 10.000000>
}

#declare smbldg149 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <105.000000, -55.000000, 10.000000>
}

#declare smbldg150 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <125.000000, -55.000000, 10.000000>
}

#declare smbldg151 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -75.000000, 10.000000>
}

#declare smbldg152 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -75.000000, 10.000000>
}

#declare smbldg153 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -75.000000, 10.000000>
}

#declare smbldg154 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -75.000000, 10.000000>
}

#declare smbldg155 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -75.000000, 10.000000>
}

#declare smbldg156 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <5.000000, -95.000000, 10.000000>
}

#declare smbldg157 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <25.000000, -95.000000, 10.000000>
}

#declare smbldg158 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <45.000000, -95.000000, 10.000000>
}

#declare smbldg159 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <65.000000, -95.000000, 10.000000>
}

#declare smbldg160 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 5.000000, 10.000000>
  translate <85.000000, -95.000000, 10.000000>
}

#declare brght_quad_bldg = union {
  object { smbldg126 }
  object { smbldg127 }
  object { smbldg128 }
  object { smbldg129 }
  object { smbldg133 }
  object { smbldg134 }
  object { smbldg135 }
  object { smbldg136 }
  object { smbldg140 }
  object { smbldg141 }
  object { smbldg142 }
  object { smbldg143 }
  object { smbldg144 }
  object { smbldg145 }
  object { smbldg146 }
  object { smbldg147 }
  object { smbldg148 }
  object { smbldg149 }
  object { smbldg150 }
  object { smbldg151 }
  object { smbldg152 }
  object { smbldg153 }
  object { smbldg154 }
  object { smbldg155 }
  object { smbldg156 }
  object { smbldg157 }
  object { smbldg158 }
  object { smbldg159 }
  object { smbldg160 }
  translate <150.000000, -130.000000, 0.000000>
}

#declare total_smbldgs = union {
  object { tleft_quad_bldg }
  object { trght_quad_bldg }
  object { bleft_quad_bldg }
  object { brght_quad_bldg }
  texture {
    Rusty_Iron
  }
}

union {
  object { head_offices }
  object { city_streets }
  object { towers }
  object { total_smbldgs }
}

#declare cannon_base = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Copper_Texture
  }
  scale <5.000000, 5.000000, 5.000000>
  translate <0.000000, 0.000000, 5.000000>
}

#declare base_extension = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Copper_Texture
  }
  scale <2.000000, 2.000000, 2.000000>
  translate <0.000000, 0.000000, 12.000000>
}

#declare base = union {
  object { cannon_base }
  object { base_extension }
  rotate <-0.000000, -0.000000, -65.000000>
}

#declare turret = object { 
  sphere {<0,0,0>,1}
  texture {
    New_Brass
  }
  scale <4.000000, 4.000000, 4.000000>
  translate <-0.000000, 0.000000, 17.500000>
}

#declare barrel = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Texture
  }
  scale <1.000000, 1.000000, 15.000000>
  rotate <-70.000000, -0.000000, -0.000000>
  translate <0.000000, -0.372230, 17.122568>
}

#declare cannon = union {
  object { base }
  object { turret }
  object { barrel }
  scale <2.500000, 2.500000, 2.500000>
  rotate <-0.000000, -0.000000, 150.000000>
  translate <150.215707, -346.002471, 0.000000>
}

#declare inner_laser = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    innerlaser_textu
  }
  scale <0.700000, 0.700000, 1200.000000>
  rotate <-70.000000, -0.000000, 150.000000>
  translate <132.000000, -377.000000, 56.500000>
}

#declare outer_laser = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    outerlaser_tex1
  }
  scale <1.000000, 1.000000, 1200.000000>
  rotate <-70.000000, -0.000000, 150.000000>
  translate <132.000000, -377.000000, 56.500000>
}

#declare outer_laser1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    outerlaser_tex2
  }
  scale <1.250000, 1.250000, 1200.000000>
  rotate <-70.000000, -0.000000, 150.000000>
  translate <132.000000, -377.000000, 56.500000>
}

#declare laser = union {
  object { inner_laser }
  object { outer_laser }
  object { outer_laser1 }
  rotate <-1.000000, -0.000000, -0.000000>
  translate <-1.591262, -4.366744, -5.461629>
}

union {
  object { cannon }
  object { laser }
  rotate <-0.000000, -0.000000, 8.000000>
  translate <-62.110730, -49.034787, 0.000000>
}

#declare city_shield = object { 
  sphere {<0,0,0>,1}
  texture {
    clear
  }
  no_shadow
  scale <200.000000, 200.000000, 200.000000>
  translate <135.000000, -113.000000, 0.000000>
}

#declare city_ground = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    city_grnd_textur
  }
  scale <200.000000, 200.000000, 0.150000>
  translate <135.000000, -113.000000, 0.000000>
}

union {
  object { city_shield }
  object { city_ground }
}

#declare plant_shield = object { 
  sphere {<0,0,0>,1}
  texture {
    clear
  }
  no_shadow
  scale <150.000000, 150.000000, 150.000000>
  translate <-202.000000, 158.000000, 0.000000>
}

#declare plant_ground = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    city_grnd_textur
  }
  scale <150.000000, 150.000000, 0.150000>
  translate <-202.000000, 158.000000, 0.000000>
}

union {
  object { plant_shield }
  object { plant_ground }
}

