/*Title: Past and Present
* Author: Bob Belas
* Contribution to the August '95 Raytracing Competition
* "Alien Worlds" Theme
* All Rights Reserved
*/


#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"

// ********  T E X T U R E S  *******
#include "PNP.INC"


// ****************FOG****************************

fog {color red 1.00 green 0.90 blue 0.85 distance 475}



//	the floor

plane {
  <0.0, 0.0, 1.0>, -0.01
  texture {
     Soil_Texture
  }
}

plane {
  <0.0, 0.0, 1.0>, 1.5
  texture {
     Groundfog_Texture1
  }
}

plane {
  <0.0, 0.0, 1.0>, 2.5
  texture {
     Groundfog_Texture2
  }
}



camera {  //  Camera StdCam
  location  <-57.071, -88.189, 13.802>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <26.000, -0.000, 4.381>
}


// *******  L I G H T S *******

// Yellow Sun
light_source {
	<0, 0, 0> color White
	looks_like{
		sphere {<0, 0, 0>, 1
			pigment {color Yellow filter 0.85}		
			finish {ambient 1.0 diffuse 0.0}
		}
	}
	scale <20, 20, 20>
	translate <488.832552, 615.956176, 75.401690>
}


//Light in red sphere between cones
light_source {
	<0, 0, 0> color White
	looks_like{
		sphere {<0, 0, 0>, 1
			pigment {color red 1.00 green 0.20 blue 0.31 filter 0.85}
			finish {ambient 1.0 diffuse 0.0}
		}
	}
  scale <0.447006, 0.428230, 0.419626>
  translate <28.199280, -0.011995, 2.514990>
}


//Spotlight in temple

object {   // Light source SpotL001
  light_source {
    <0.053, -0.023, 16.244>
    color  red 1.000 green 1.000 blue 1.000
    spotlight
      point_at  <0.053, -0.023, 15.244>
      falloff   37.7  // outer radius (in deg)
      radius    19.2  // inner radius
      tightness 21  // 1=smooth, 100=tight
  }
}



// ********  O B J E C T S *******
box {   //1st Step of Temple Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex1
    turbulence <0.9, 0.7, 0.1> lambda 1.5 omega 0.75 octaves 8
  }
  scale <12.750000, 11.250000, 0.750000>
  translate <0.250000, 0.000000, 0.750000>
}

box {   // 2nd Step of Temple Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex1
    turbulence <0.5, 0.5, 0.5> lambda 2.5 omega 0.85 octaves 6    
  }
  scale <9.562500, 8.437500, 0.750000>
  translate <0.250000, 0.000000, 2.250000>
}

box {   // Third step of Temple Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex1
    turbulence <0.1, 0.7, 0.9> lambda 2.7 omega 0.95 octaves 4    
  }
  scale <7.171875, 6.328125, 0.750000>
  translate <0.250000, 0.000000, 3.750000>
}


box {   // Pillar Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex2
  }
  translate <5.939338, -4.473195, 5.509403>
}

box {   //  Pillar Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex2
  }
  translate <5.971394, 4.706409, 5.509403>
}

box {   //  Pillar Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex2
  }
  translate <-5.182579, -4.473195, 5.509403>
}

box {   //  Pillar Base
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Temple_Tex2
  }
  translate <-5.173698, 4.649276, 5.476013>
}

cylinder {   // Temple Pillars
  <0,0,1>, <0,0,0>, 1
  texture {
    Temple_Tex2
  }
  scale <0.750000, 0.750000, 10.000000>
  translate <5.859535, -4.547818, 6.500000>
}

cylinder {   //  Temple Pillars
  <0,0,1>, <0,0,0>, 1
  texture {
    Temple_Tex2
  }
  scale <0.750000, 0.750000, 10.000000>
  translate <-5.116945, -4.547818, 6.500000>
}

cylinder {   //  Temple Pillars
  <0,0,1>, <0,0,0>, 1
  texture {
    Temple_Tex2
  }
  scale <0.750000, 0.750000, 10.000000>
  translate <-5.116945, 4.692827, 6.500000>
}

cylinder {   //  Temple Pillars
  <0,0,1>, <0,0,0>, 1
  texture {
    Temple_Tex2
  }
  scale <0.750000, 0.750000, 10.000000>
  translate <6.010132, 4.641632, 6.500000>
}

box {   // Temple Roof
  <-1, -1, -1>, <1, 1, 1>
  texture {
    TempleRoof_Tex
  }
  scale <8.750010, 7.500000, 0.250000>
  translate <0.206578, 0.000000, 16.803138>
}


cylinder {   // Temple Arena
  <0,0,1>, <0,0,0>, 1
  texture {
    Texture_Arena
  }
  scale <25.179745, 25.115353, 0.299869>
  translate <18.998147, -0.593692, 0.000000>
}


cone {   // Lower Part of Arena Sculpture
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Texture05
  }
  scale <3.089109, 2.749489, 2.131981>
  translate <28.200375, -0.000000, 0.000000>
}

cone {   // Upper part of Arena Sculpture
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Texture05
  }
  scale <3.089109, 2.749489, 2.131981>
  rotate <-0.000000, -179.777710, -0.000000>
  translate <28.200375, -0.000000, 5.000000>
}

#declare Torus001 = quartic { 
           // Torus MinRadius=   0.250   MajRadius=   1.750 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -6.250,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -6.250,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  6.000, 0.000,  9.000 >
  texture {
   TextureTorus
  }
  translate <0.000000, 0.000000, 7.000000>
}

#declare Torus2 = quartic { 
           // Torus MinRadius=   0.250   MajRadius=   1.750 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -6.250,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -6.250,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  6.000, 0.000,  9.000 >
  texture {
   TextureTorus
  }
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.000000, 0.007641, 7.000000>
}

union {   // GrpObj001
  object { Torus001 }
  object { Torus2 }
  rotate <-0.000000, -45.000000, -0.000000>
  translate <5.000000, 0.000000, 2.500000>
}


//The City
cylinder {   // Cylndr003
  <0,0,1>, <0,0,0>, 1
  texture {
    Building_Tex
  }
  scale <10.314821, 9.588961, 77.644859>
  translate <782.546691, 463.296301, 0.000000>
}

cone {   // Cone002
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Building_Tex2
  }
  scale <22.574165, 23.446945, 82.249687>
  rotate <-0.000000, -180.000000, -0.000000>
  translate <533.462110, 481.016703, 80.290818>
}

box {   // Cube004
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <24.427828, 24.427828, 24.427828>
  translate <684.975249, 493.408175, 23.684915>
}

box {   // Cube7
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <736.894661, 435.310190, 9.473966>
}

box {   // Cube8
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <762.236649, 507.227317, 9.473966>
}

box {   // Cube9
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <511.234704, 537.885347, 9.473966>
}

box {   // Cube10
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <752.812635, 371.002355, 9.473966>
}

box {   // Cube11
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <588.699741, 387.775475, 9.473966>
}

box {   // Cube12
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Building_Tex
  }
  scale <10.337753, 10.337753, 10.337753>
  translate <547.854836, 424.746920, 9.473966>
}

cone {   // Cone3
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Building_Tex
  }
  scale <11.287083, 11.723473, 41.124844>
  rotate <-0.000000, -180.000000, -0.000000>
  translate <720.044195, 512.180791, 39.474858>
}

cone {   // Cone4
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Building_Tex2
  }
  scale <5.643541, 5.861736, 20.562422>
  rotate <-0.000000, -180.000000, -0.000000>
  translate <542.562378, 385.127201, 21.868027>
}

cone {   // Cone5
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    Building_Tex2
  }
  scale <22.574165, 23.446945, 82.249687>
  rotate <-0.000000, -180.000000, -0.000000>
  translate <634.968187, 526.564216, 80.290818>
}

cylinder {   // Cylndr5
  <0,0,1>, <0,0,0>, 1
  texture {
    Building_Tex
  }
  scale <7.736116, 7.191720, 58.233643>
  translate <518.474040, 439.323926, 0.000000>
}

cylinder {   // Cylndr6
  <0,0,1>, <0,0,0>, 1
  texture {
    Building_Tex
  }
  scale <5.802087, 5.393790, 43.675232>
  translate <488.132052, 470.488014, 0.000000>
}

cylinder {   // Cylndr7
  <0,0,1>, <0,0,0>, 1
  texture {
    Building_Tex
  }
  scale <4.351565, 4.045342, 32.756424>
  translate <661.555255, 408.159838, -0.525782>
}



object {   // Translucent Sphere Covering City
  sphere {<0,0,0>,1}
  texture {
    TextureCitySphere
  }
  scale <209.083282, 190.398743, 134.345139>
  translate <642.785795, 446.743142, 0.000000>
}


