#include "colors.inc"
#include "textures.inc"
#include "robxf.inc"
#include "jar.inc"

camera {
  location <0,1,-10>
  look_at <0,0,0>
}

light_source {
  <50,100,-300>
  color White
}

#declare Ground=
pigment {
  wood
  turbulence 0.8
  octaves 4
  color_map {
    [0.0, 0.4 color VeryDarkBrown color DarkBrown]
    [0.4, 0.6 color DarkBrown color DarkTan]
    [0.6, 0.8 color DarkTan color DarkTan]
    [0.8, 1.0 color DarkTan color SemiSweetChoc]
  }
}

box {
  <0,0,0>,<1,1,1>
  pigment {image_map {tga "firesky.tga" map_type 0 interpolate 2}}
  finish {Luminous}
  translate <-0.5,-0.5,0>
  scale <88,31.1166,1> 
  translate <0,8.5,50>
}

object {jar scale <1.2,2,1.2> rotate <0,10,0> translate <6,-2.6,12>}

object {jar scale <0.72,1.2,0.72> rotate <0,10,0> translate <3,-3.6,22>}

object {jar scale <0.432,0.72,0.432> rotate <0,10,0> translate <0.6,-4,32>}

object {jar scale <0.2592,0.432,0.2592> rotate <0,10,0> translate <-1.2,-5.5,42>}

object {
         height_field {tga "ground.tga" water_level .01 }
         translate <-0.5,0,-0.5>
         scale <70,3.3,70>
         translate <-1,-5,0>
         translate <-5,0,-2>
         texture {Ground}       
}

object {robxf scale 0.17 rotate <0,180,0> translate <-6.7,-0.5,2>} 










