//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 08/20/1995    (20.08.1995)
//

#max_intersections 200
#max_trace_level 10

#include "shapes.inc"

camera {  //  Camera Camera
  location  <3.608, -29.000, 9.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-4.848, 55.746, 9.000>
}

// *******  L I G H T S *******

light_source {   // Spotlight lampenlicht
  <7.104, 22.574, 4.115>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <6.951, 21.965, 4.612>
    falloff   3.0  // outer radius (in deg)
      radius    2.0  // inner radius
}

light_source {   // Light3
  <-20.000, -20.000, 10.000>
  color rgb <0.800, 0.800, 0.800>
}

light_source {   // Light2
  <3496.000, -151.000, 304.000>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light1
  <3384.000, -155.000, 302.000>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  T E X T U R E S  *******
//

#declare Nebel_t = texture {
  pigment { 
    gradient z
    turbulence 0.3
    color_map {
      [ 0.0 color rgbf < 0.776,  0.580,  0.220,  0.490> ]
      [ 0.1 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 0.12 color rgbf < 0.5, 0.5, 1.0, 0.5 > ]
      [ 0.13 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 0.14 color rgbf < 0.5, 0.5, 1.0, 0.5 > ]
      [ 0.15 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 0.16 color rgbf < 0.5, 0.5, 1.0, 0.5 > ]
      [ 0.17 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
      [ 1.01 color rgbf < 1.0, 1.0, 1.0, 1.0 > ]
    }
  quick_color rgbf <1.0, 1.0, 1.0, 1.0>
  }
  finish {
    ambient   1.00
    diffuse   0.00
    brilliance   1.00
    specular  0.0000
    roughness  0.0000
  }
}

#declare Bodenfarbe =  texture {
  material_map {
    gif "TILE.GIF" map_type 0 interpolate 4 

    texture {
      pigment {
        granite
        turbulence 0.6
        color_map {
          [0.0, 0.4  color rgb < 0.200,  0.100,  0.050>
                     color rgb < 0.784,  0.518,  0.220>]
          [0.2, 0.4  color rgb < 0.784,  0.518,  0.220>
                     color rgb < 0.500,  0.200,  0.100>]
          [0.4, 0.5  color rgb < 0.784,  0.518,  0.220>
                     color rgb < 0.500,  0.200,  0.100>]
          [0.5, 0.6  color rgb < 0.500,  0.200,  0.100>
                     color rgb < 0.784,  0.518,  0.220>]
          [0.6, 0.8  color rgb < 0.784,  0.518,  0.220>
                     color rgb < 1.000,  0.700,  0.400>]
          [0.8, 1.01 color rgb < 1.000,  0.700,  0.400>
                     color rgb < 0.784,  0.518,  0.220>]
        }
      quick_color rgbf <0.3, 0.3, 0.0, 0.0>
      }
      finish {
        ambient 0.3
        diffuse 0.7
      }
    scale 50.0
    }

    texture {
      pigment { color rgbf <1.0, 1.0, 1.0, 1.0> }
      finish {
        ambient 0.0
        diffuse 0.0
        refraction 1.0
      }
    }

  }
  scale 0.02
}

#declare Ringtext = texture {
  finish {
    ambient   0.30
    diffuse   0.70
    refraction 1
    brilliance   1.00
    specular  0.5000
    roughness  0.0001
  }
  pigment {
    wood
    turbulence 0.000
    color_map {
      [ 0.000 colour rgbf < 1.000, 1.000, 1.000, 1.000  > ]
      [ 0.580 colour rgbf < 1.000, 1.000, 1.000, 1.000  > ]
      [ 0.627 colour rgbf < 0.608, 0.333, 0.000, 0.500  > ]
      [ 0.688 colour rgbf < 0.553, 0.808, 0.000, 0.500  > ]
      [ 0.700 colour rgbf < 0.208, 0.463, 0.831, 0.500  > ]
      [ 0.750 colour rgbf < 0.914, 0.875, 0.000, 0.500  > ]
      [ 0.786 colour rgbf < 1.000, 1.000, 1.000, 1.000  > ]
      [ 0.804 colour rgbf < 0.300, 0.500, 0.000, 0.500  > ]
      [ 0.840 colour rgbf < 0.706, 0.000, 0.000, 0.500  > ]
      [ 0.865 colour rgbf < 0.667, 0.596, 0.000, 0.500  > ]
      [ 0.885 colour rgbf < 1.000, 1.000, 1.000, 1.000  > ]
      [ 0.901 colour rgbf < 0.600, 0.200, 0.200, 0.500  > ]
      [ 0.950 colour rgbf < 0.208, 0.400, 0.731, 0.500  > ]
      [ 1.001 colour rgbf < 0.208, 0.400, 0.731, 1.000  > ]
    }
  quick_color rgbf <0.0, 0.0, 1.0, 0.0>
  }
  scale < 2.0, 2.0, 2.0 >
}

#declare Planet_t = texture {
  pigment { 
    gradient z
    turbulence 0.8
    color_map {
      [ 0.0  color rgbf < 0.0, 0.5, 0.0, 0.0 > ]
      [ 0.5  color rgbf < 0.3, 0.3, 0.0, 0.0 > ]
      [ 1.01 color rgbf < 0.0, 0.5, 0.0, 0.0 > ]
    }
  quick_color rgbf <0.0, 1.0, 0.0, 0.0>
  }
  finish {
    ambient   0.30
    diffuse   0.70
    brilliance   1.00
    specular  0.5000
    roughness  0.0001
  }
  scale < 1.0, 1.0, 0.5 >
}

#declare Wolken_t =texture {
  pigment{
    granite
    color_map {
      [ 0.0  color rgbf <1.0, 1.0, 1.0, 1.0> ]
      [ 0.2  color rgbf <1.0, 1.0, 1.0, 1.0> ]
      [ 0.3  color rgbf <1.0, 1.0, 1.0, 0.5> ]
      [ 0.4  color rgbf <1.0, 1.0, 1.0, 0.5> ]
      [ 0.6  color rgbf <1.0, 1.0, 1.0, 1.0> ]
      [ 0.8  color rgbf <1.0, 1.0, 1.0, 0.5> ]
      [ 1.0  color rgbf <1.0, 1.0, 1.0, 1.0> ]
    }
  quick_color rgbf <1.0, 1.0, 1.0, 1.0>
  }
  finish {
    ambient   0.3
    diffuse   0.7
    refraction 1
  }
  scale <2.0, 2.0, 0.4>
}

#declare Schwarz = texture {
  pigment { color rgb < 0.000,  0.000,  0.000> }
  finish {
    ambient   0.30
    diffuse   0.70
    brilliance   1.00
    phong   0.50
    phong_size  1.00
  }
}

#declare Chrome_Metal = texture {
  pigment { colour red 0.90 green 0.91 blue 0.98 }
  finish { 
    ambient 0.2
    diffuse 0.7
    reflection 0.15
    brilliance 1.0
    specular 0.8
    roughness 0.0001
    metallic
  }
}

#declare Gold_Metal = texture {
  pigment { colour red 1.00 green 0.91 blue 0.0 }
  finish { 
    ambient 0.2
    diffuse 0.7
    reflection 0.15
    brilliance 1.0
    specular 0.8
    roughness 0.0001
    metallic
  }
}

#declare Sterne = texture {
  pigment {
    granite
    color_map {
      [ 0.00 colour rgb < 0.0, 0.0, 0.0 > ]
      [ 0.80 colour rgb < 0.0, 0.0, 0.0 > ]
      [ 0.87 colour rgb < 0.2, 0.2, 0.2 > ]
      [ 0.88 colour rgb < 0.4, 0.4, 0.4 > ]
      [ 0.89 colour rgb < 0.6, 0.6, 0.6 > ]
      [ 0.90 colour rgb < 0.8, 0.8, 0.8 > ]
      [ 0.91 colour rgb < 0.95, 0.95, 0.95 > ]
      [ 0.915 colour rgb < 1.0, 1.0, 1.0 > ]
      [ 0.92 colour rgb < 0.0, 0.0, 0.0 > ]
      [ 1.0  colour rgb < 0.0, 0.0, 0.0 > ]
    }
  quick_color rgbf <0.0, 0.0, 0.0, 0.0>
  }
  finish {
    ambient 1.0
    diffuse 0.0
  }
  scale 0.025
}
texture {
  pigment {
    marble
    turbulence 0.6
    color_map {
      [ 0.0 colour rgbf < 0.0, 0.0, 0.0, 1.0 > ]
      [ 0.2 colour rgbf < 0.0, 0.0, 0.0, 0.5 > ]
      [ 0.4 colour rgbf < 0.0, 0.0, 0.0, 0.0 > ]
      [ 0.6 colour rgbf < 0.0, 0.0, 0.0, 0.5 > ]
      [ 0.8 colour rgbf < 0.0, 0.0, 0.0, 1.0 > ]
      [ 1.0 colour rgbf < 0.0, 0.0, 0.0, 1.0 > ]
    }
  quick_color rgbf <0.0, 0.0, 0.0, 0.0>
  }
  finish {
    ambient 1.0
    diffuse 0.0
  }
  scale 0.5
  translate < 0.0, 0.0, 0.4 >
}

#declare gummi = texture {
  pigment { color rgb < 0.050,  0.050,  0.050> }
  finish {
    ambient   0.30
    diffuse   0.70
    brilliance   1.00
    specular  0.5000
    roughness  0.0100
  }
}

#declare blau = texture {
  pigment { 
    granite
    color_map {
      [ 0.000 color rgb < 0.282, 0.557, 0.851 > ]
      [ 0.500 color rgb < 0.282, 0.557, 0.851 > ]
      [ 0.750 color rgb < 0.518, 0.255, 0.078 > ]
      [ 0.950 color rgb < 0.282, 0.557, 0.851 > ]
      [ 1.000 color rgb < 0.282, 0.557, 0.851 > ]
    }
  }      
  finish {
    ambient   0.30
    diffuse   0.70
    brilliance   1.00
    phong   0.60
    phong_size  20.00
    specular  1.0000
    roughness  0.0010
    metallic
  }
  scale < 8.0, 8.0, 1.0 >
}

#declare orange = texture {
  pigment { color rgb < 1.0,  0.5,  0.000> }
  finish {
    ambient   0.50
    diffuse   0.70
    brilliance   1.00
    specular  0.3000
    roughness  0.0001
    reflection  0.200
  }
}

#declare lichtschein = texture {
  pigment { 
    radial
    color_map {
      [ 0.000 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 0.492 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 0.496 color rgbf < 1.000,  1.000,  1.000,  0.900> ]
      [ 0.504 color rgbf < 1.000,  1.000,  1.000,  0.900> ]
      [ 0.508 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 1.000 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
    }
  }
  finish {
    ambient   1.00
    diffuse   0.00
    refraction 1.0
    ior 1.0
  }
  rotate < 90.0, 0.0, -90.0 >
}

#declare lichtschein2 = texture {
  pigment { 
    radial
    color_map {
      [ 0.000 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 0.494 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 0.498 color rgbf < 1.000,  1.000,  1.000,  0.900> ]
      [ 0.502 color rgbf < 1.000,  1.000,  1.000,  0.900> ]
      [ 0.506 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
      [ 1.000 color rgbf < 1.000,  1.000,  1.000,  1.000> ]
    }
  }
  finish {
    ambient   1.00
    diffuse   0.00
    refraction 1.0
    ior 1.0
  }
  rotate < 90.0, 0.0, -90.0 >
}

#declare unterboden = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.0, 0.4  color rgb < 0.200,  0.100,  0.050>
                 color rgb < 0.784,  0.518,  0.220>]
      [0.2, 0.4  color rgb < 0.784,  0.518,  0.220>
                 color rgb < 0.500,  0.200,  0.100>]
      [0.4, 0.5  color rgb < 0.784,  0.518,  0.220>
                 color rgb < 0.500,  0.200,  0.100>]
      [0.5, 0.6  color rgb < 0.500,  0.200,  0.100>
                 color rgb < 0.784,  0.518,  0.220>]
      [0.6, 0.8  color rgb < 0.784,  0.518,  0.220>
                 color rgb < 1.000,  0.700,  0.400>]
      [0.8, 1.01 color rgb < 1.000,  0.700,  0.400>
                 color rgb < 0.784,  0.518,  0.220>]
    }
  quick_color rgbf <0.3, 0.3, 0.0, 0.0>
  }
  finish {
    ambient 0.3
    diffuse 0.7
  }
}

#declare Gleiter_Texture= texture {
  pigment {
    gradient z
    color_map {
      [ 0.0 color rgb < 1.0, 0.0, 0.0 > ]
      [ 1.0 color rgb < 1.0, 0.9, 0.0 > ]
    }
    scale 8.0
    translate <0.0, 0.0, 3.5>
  }
  finish {
    ambient  0.30
    diffuse  0.70
    reflection 0.1
    brilliance  1.00
    phong 0.70
    phong_size 20.00
  }
}

#declare Chip_Text= texture {
  pigment {
    image_map
    { gif "chip.gif"
      once
    }
    scale <7.0, 4.0, 1.0>
    translate <-3.3, -2.0, 0.0>
    rotate <-90.0, -90.0, 0.0>
  }
  finish {
    ambient   0.50
    diffuse   0.70
    brilliance   1.00
    phong  0.9
    phong_size  20.00
  }
}

#declare sig_texture = texture {
  pigment {
    image_map {
      gif "signet.GIF" map_type 0 interpolate 4 
      filter 0,1
    }
  }
  finish {
    ambient   0.60
    diffuse   0.80
    refraction 1.0
    brilliance   1.00
    specular  1.0000
    roughness  0.020
  }
  normal {
    bump_map {
      gif "signetbw.GIF" map_type 0 interpolate 4
      bump_size 4
    }
  }
}

// ********  O B J E C T S *******

#declare gleiter_bound = object {
  UnitBox
  scale <5.2, 1.2, 4.4>
  translate <0.0, -0.6, -0.4>
}

#declare Segel = object {
  union {
    triangle { <0.50000, -3.00000, 1.0>  <0.31296, -2.76770, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.31296, -2.76770, 1.0>  <0.14669, -2.54138, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.14669, -2.54138, 1.0>  <0.00120, -2.32103, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.00120, -2.32103, 1.0>  <-0.12352, -2.10666, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.12352, -2.10666, 1.0>  <-0.22748, -1.89825, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.22748, -1.89825, 1.0>  <-0.31065, -1.69582, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.31065, -1.69582, 1.0>  <-0.37306, -1.49936, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.37306, -1.49936, 1.0>  <-0.41470, -1.30887, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.41470, -1.30887, 1.0>  <-0.43556, -1.12436, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.43556, -1.12436, 1.0>  <-0.43565, -0.94582, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.43565, -0.94582, 1.0>  <-0.41498, -0.77325, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.41498, -0.77325, 1.0>  <-0.37352, -0.60666, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.37352, -0.60666, 1.0>  <-0.31130, -0.44603, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.31130, -0.44603, 1.0>  <-0.22831, -0.29138, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.22831, -0.29138, 1.0>  <-0.12454, -0.14270, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.12454, -0.14270, 1.0>  <0.00000, 0.00000, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.00000, 0.00000, 1.0>  <-0.12863, 0.13782, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.12863, 0.13782, 1.0>  <-0.23595, 0.28227, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.23595, 0.28227, 1.0>  <-0.32195, 0.43334, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.32195, 0.43334, 1.0>  <-0.38663, 0.59104, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.38663, 0.59104, 1.0>  <-0.42999, 0.75536, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.42999, 0.75536, 1.0>  <-0.45203, 0.92630, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.45203, 0.92630, 1.0>  <-0.45276, 1.10386, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.45276, 1.10386, 1.0>  <-0.43217, 1.28805, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.43217, 1.28805, 1.0>  <-0.39026, 1.47886, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.39026, 1.47886, 1.0>  <-0.32703, 1.67630, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.32703, 1.67630, 1.0>  <-0.24249, 1.88036, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.24249, 1.88036, 1.0>  <-0.13663, 2.09104, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.13663, 2.09104, 1.0>  <-0.00945, 2.30834, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <-0.00945, 2.30834, 1.0>  <0.13905, 2.53227, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.13905, 2.53227, 1.0>  <0.30887, 2.76282, 1.0>  <0.0, 0.0, 0.0> }
    triangle { <0.30887, 2.76282, 1.0>  <0.50000, 3.00000, 1.0>  <0.0, 0.0, 0.0> }
  }
  bounded_by { box { <-0.45321, -3.00300, -0.001> <3.29269, 3.003000, 1.001> } }
  scale <1.0, 1.668151, 8.293987>
  rotate <0.0, 0.0, -90.0>
  translate <0.0, 0.0, -4.479241>
  texture { Gleiter_Texture }
}

#declare chip_bound= object {
  UnitBox
  scale <1.7, 0.6, 2.8>
  translate <0.0, -0.222606, 0.0> 
}

#declare geh_bound= object {
  UnitBox
  scale <1.2, 0.4, 2.7> 
}

#declare gehaeuse_a= object {
  UnitBox
  scale <1.000000, 0.300000, 2.500000>
}

#declare gehaeuse_b= object {
  UnitBox
  scale <1.100000, 0.200000, 2.500000>
}

#declare gehaeuse_c= object {
  UnitBox
  scale <1.000000, 0.200000, 2.600000>
}

#declare gehaeuse_d= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.100000, 0.100000, 5.000000>
}  

#declare gehaeuse_e= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.100437, 0.100000, 2.000000>
  rotate <-0.000000, -90.000000, -0.000000>
}

#declare gehaeuse_f= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.1, 0.1, 0.4>
  rotate <-270.0, -0.0, -0.0>
}  
   
#declare gehaeuse_g= object
{ sphere {<0.0, 0.0, 0.0>, 0.1} }
  
#declare gehaeuse= union {
  object { gehaeuse_a }
  object { gehaeuse_b }
  object { gehaeuse_c }
  object { gehaeuse_d translate < 1.0, -0.2, -2.5>}
  object { gehaeuse_d translate <-1.0, -0.2, -2.5>}
  object { gehaeuse_d translate < 1.0 , 0.2, -2.5>}
  object { gehaeuse_d translate <-1.0 , 0.2, -2.5>}
  object { gehaeuse_e translate < 1.0 , 0.2,  2.5>}
  object { gehaeuse_e translate < 1.0 , 0.2, -2.5>}
  object { gehaeuse_e translate < 1.0, -0.2,  2.5>}
  object { gehaeuse_e translate < 1.0, -0.2, -2.5>}
  object { gehaeuse_f translate < 1.0 , 0.2,  2.5>}
  object { gehaeuse_f translate <-1.0 , 0.2,  2.5>}
  object { gehaeuse_f translate < 1.0 , 0.2, -2.5>}
  object { gehaeuse_f translate <-1.0 , 0.2, -2.5>}
  object { gehaeuse_g translate < 1.0 , 0.2,  2.5>}
  object { gehaeuse_g translate <-1.0 , 0.2,  2.5>}
  object { gehaeuse_g translate < 1.0, -0.2,  2.5>}
  object { gehaeuse_g translate <-1.0, -0.2,  2.5>}
  object { gehaeuse_g translate < 1.0 , 0.2, -2.5>}
  object { gehaeuse_g translate <-1.0 , 0.2, -2.5>}
  object { gehaeuse_g translate < 1.0, -0.2, -2.5>}
  object { gehaeuse_g translate <-1.0, -0.2, -2.5>}
  texture {Chip_Text}
  bounded_by { object { geh_bound } }
}

#declare pinbound_rechts= object {
  UnitBox 
  scale <0.262198, 0.421225, 2.473713>
  translate <1.324505, -0.311648, 0.0>
}

#declare pin_a= object {
  UnitBox
  scale <0.2, 0.05, 0.1>
}

#declare pin_b= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 0.2>
  translate <0.2, 0.0, -0.1>
}

#declare pin_c= object {
  UnitBox
  scale <0.05, 0.15, 0.1>
  translate <0.2, -0.15, 0.0>
}

#declare pin_d= object {
  UnitBox
  scale <0.03, 0.2, 0.05>
  translate <0.2, -0.5, 0.0>
}

#declare pin1= union 
{ object { pin_a }
  object { pin_b }
  object { pin_c }
  object { pin_d }
}

#declare pins_rechts= union {
  object { pin1 translate <1.3, 0.0, -2.25> }
  object { pin1 translate <1.3, 0.0, -1.75> }
  object { pin1 translate <1.3, 0.0, -1.25> }
  object { pin1 translate <1.3, 0.0, -0.75> }
  object { pin1 translate <1.3, 0.0, -0.25> }
  object { pin1 translate <1.3, 0.0,  0.25> }
  object { pin1 translate <1.3, 0.0,  0.75> }
  object { pin1 translate <1.3, 0.0,  1.25> }
  object { pin1 translate <1.3, 0.0,  1.75> }
  object { pin1 translate <1.3, 0.0,  2.25> }
  texture { Chrome_Metal }
  bounded_by { object { pinbound_rechts } }
}

#declare pinbound_links = object {
  UnitBox 
  scale <0.262198, 0.421225, 2.473713>
  translate <-1.324505, -0.322779, 0.0>
}

#declare pin2 = union {
  object { pin_a }
  object { pin_b }
  object { pin_c }
  object { pin_d }
  rotate <-0.0, -180.0, -0.0>
}

#declare pins_links= union {
  object { pin2 translate <-1.3, 0.0, -2.25> }
  object { pin2 translate <-1.3, 0.0, -1.75> }
  object { pin2 translate <-1.3, 0.0, -1.25> }
  object { pin2 translate <-1.3, 0.0, -0.75> }
  object { pin2 translate <-1.3, 0.0, -0.25> }
  object { pin2 translate <-1.3, 0.0,  0.25> }
  object { pin2 translate <-1.3, 0.0,  0.75> }
  object { pin2 translate <-1.3, 0.0,  1.25> }
  object { pin2 translate <-1.3, 0.0,  1.75> }
  object { pin2 translate <-1.3, 0.0,  2.25> }
  texture { Chrome_Metal }
  bounded_by { object { pinbound_links } }
}

#declare Chip= union 
{ object { gehaeuse }
  object { pins_rechts }
  object { pins_links }
  bounded_by { object { chip_bound } }
  rotate <5.0, -0.0, -180.0>
  translate <0.0, -0.6, 0.9>
}

#declare stange_1= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 9.7>
  rotate <21.278000, 23.624001, 38.290001>
  translate <0.0, 0.0, -4.497196>
}

#declare stange_2= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 9.7>
  rotate <-21.278000, -23.624001, 49.423149>
  translate <0.0, 0.0, -4.497196>
}

#declare stange_3= object 
{ sphere { <0.0, 0.0, -4.49802>, 0.05 } }

#declare stange_4= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 1.72>
  rotate <-0.0, 90.0, 14.366468>
  translate <0.0, -0.592631, -1.752729>
}

#declare stange_5= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 1.72>
  rotate <-0.0, 90.0, 165.199997>
  translate <0.0, -0.592631, -1.752729>
}

#declare stange_6= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 8.3>
  translate <0.0, 0.0, -4.497000>
}

#declare stange_7= intersection 
{ object { Cylinder_Z }
  plane { <0, 0, -1>, 0 }
  plane { <0, 0, +1>, 1 }
  scale <0.05, 0.05, 0.59>
  rotate <-270.0, -0.0, -0.0>
  translate <0.0, 0.0, -1.75>
}

#declare stange_8= object 
{ sphere { <0.0, -0.595, -1.75>, 0.05 } } 

#declare gestaenge= union {
  object { stange_1 }
  object { stange_2 }
  object { stange_3 }
  object { stange_4 }
  object { stange_5 }
  object { stange_6 }
  object { stange_7 }
  object { stange_8 }
  texture { Gold_Metal }
}

#declare Gleiter= union 
{ object { Segel }
  object { Chip }
  object { gestaenge }
bounded_by { object { gleiter_bound } }
}

#declare koerperbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <7.000000, 13.000000, 6.000000>
}

#declare ecke17 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, 1.000000, 4.000000>
}

#declare ecke18 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, 1.000000, 4.000000>
}

#declare ecke19 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, -1.000000, 4.000000>
}

#declare ecke20 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, -1.000000, 4.000000>
}

#declare ecke21 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, 1.000000, -4.000000>
}

#declare ecke22 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, 1.000000, -4.000000>
}

#declare ecke23 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, -1.000000, -4.000000>
}

#declare ecke24 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, -1.000000, -4.000000>
}

#declare kante25 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <-5.000000, 1.000000, -4.000000>
}

#declare kante26 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <5.000000, 1.000000, -4.000000>
}

#declare kante27 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <-5.000000, -1.000000, -4.000000>
}

#declare kante28 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <5.000000, -1.000000, -4.000000>
}

#declare kante29 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, -1.000000, -4.000000>
}

#declare kante30 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, -1.000000, -4.000000>
}

#declare kante31 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, -1.000000, 4.000000>
}

#declare kante32 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, -1.000000, 4.000000>
}

#declare kante33 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, -1.000000, -4.000000>
}

#declare kante34 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 1.000000, -4.000000>
}

#declare kante35 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, -1.000000, 4.000000>
}

#declare kante36 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 1.000000, 4.000000>
}

#declare fuellung7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <6.000000, 1.000000, 4.000000>
}

#declare fuellung8 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 2.000000, 4.000000>
}

#declare fuellung9 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 1.000000, 5.000000>
}

#declare segment3 = union {
  object { ecke17 }
  object { ecke18 }
  object { ecke19 }
  object { ecke20 }
  object { ecke21 }
  object { ecke22 }
  object { ecke23 }
  object { ecke24 }
  object { kante25 }
  object { kante26 }
  object { kante27 }
  object { kante28 }
  object { kante29 }
  object { kante30 }
  object { kante31 }
  object { kante32 }
  object { kante33 }
  object { kante34 }
  object { kante35 }
  object { kante36 }
  object { fuellung7 }
  object { fuellung8 }
  object { fuellung9 }
  texture {
    blau
  }
}

#declare kante41 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 6.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, -3.000000, -4.000000>
}

#declare kante42 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 6.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, -3.000000, -4.000000>
}

#declare kante43 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 6.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, -3.000000, 4.000000>
}

#declare kante44 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 6.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, -3.000000, 4.000000>
}

#declare fuellung10 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <6.000000, 3.000000, 4.000000>
}

#declare fuellung12 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 3.000000, 5.000000>
}

#declare segment4 = union {
  object { kante41 }
  object { kante42 }
  object { kante43 }
  object { kante44 }
  object { fuellung10 }
  object { fuellung12 }
  texture {
    orange
  }
}

#declare ecke1 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, 3.000000, 4.000000>
}

#declare ecke2 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, 3.000000, 4.000000>
}

#declare ecke5 = object { 
  sphere {<0,0,0>,1}
  translate <-5.000000, 3.000000, -4.000000>
}

#declare ecke6 = object { 
  sphere {<0,0,0>,1}
  translate <5.000000, 3.000000, -4.000000>
}

#declare kante1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <-5.000000, 3.000000, -4.000000>
}

#declare kante2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 8.000000>
  translate <5.000000, 3.000000, -4.000000>
}

#declare kante3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 3.000000>
  translate <-5.000000, -3.000000, -1.000000>
}

#declare kante4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 3.000000>
  translate <5.000000, -3.000000, -1.000000>
}

#declare kante5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 3.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, 0.000000, 4.000000>
}

#declare kante6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 3.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, 0.000000, -4.000000>
}

#declare kante7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 4.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-5.000000, -1.000000, 4.000000>
}

#declare kante8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 4.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, -1.000000, 4.000000>
}

#declare kante9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <4.000000, 4.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 0.000000, -1.000000>
}

#declare kante10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 3.000000, -4.000000>
}

#declare kante11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <3.000000, 3.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, -1.000000, 2.000000>
}

#declare kante12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 10.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 3.000000, 4.000000>
}

#declare kante13 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 3.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.000000, 0.000000, -4.000000>
}

#declare rundecke1 = torus { 
  2.000, 1.000  // Major, minor radius
  rotate -x*90
  rotate <-90.000000, 0.000000, -90.000000>
  translate <5.000000, -1.000000, 2.000000>
}

#declare rundecke2 = torus { 
  3.000, 1.000  // Major, minor radius
  rotate -x*90
  rotate <-90.000000, 0.000000, -90.000000>
  translate <5.000000, 0.000000, -1.000000>
}

#declare rundecke3 = torus { 
  2.000, 1.000  // Major, minor radius
  rotate -x*90
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, -1.000000, 2.000000>
}

#declare rundecke4 = torus { 
  3.000, 1.000  // Major, minor radius
  rotate -x*90
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-5.000000, 0.000000, -1.000000>
}

#declare kante37 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <3.000000, 3.000000, 12.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-6.000000, 0.000000, -1.000000>
}

#declare kante38 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <2.000000, 2.000000, 12.000000>
  rotate <-90.000000, 0.000000, -90.000000>
  translate <-6.000000, -1.000000, 2.000000>
}

#declare fuellung1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 1.500000, 1.500000>
  translate <0.000000, -2.500000, 0.500000>
}

#declare fuellung2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 2.000000, 1.500000>
  translate <0.000000, 1.000000, 3.500000>
}

#declare fuellung3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 1.500000, 1.500000>
  translate <0.000000, 1.500000, -3.500000>
}

#declare fuellung14 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <6.000000, 1.500000, 1.500000>
  translate <0.000000, -1.500000, 0.500000>
}

#declare fuellung15 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <6.000000, 1.500000, 4.000000>
  translate <0.000000, 1.500000, 0.000000>
}

#declare fuellung16 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <6.000000, 0.500000, 1.500000>
  translate <0.000000, -0.500000, 2.500000>
}

#declare segment1 = union {
  object { ecke1 }
  object { ecke2 }
  object { ecke5 }
  object { ecke6 }
  object { kante1 }
  object { kante2 }
  object { kante3 }
  object { kante4 }
  object { kante5 }
  object { kante6 }
  object { kante7 }
  object { kante8 }
  object { kante9 }
  object { kante10 }
  object { kante11 }
  object { kante12 }
  object { kante13 }
  object { rundecke1 }
  object { rundecke2 }
  object { rundecke3 }
  object { rundecke4 }
  object { kante37 }
  object { kante38 }
  object { fuellung1 }
  object { fuellung2 }
  object { fuellung3 }
  object { fuellung14 }
  object { fuellung15 }
  object { fuellung16 }
  texture {
    blau
  }
}

#declare koerper = union {
  object { segment3 }
  object { segment4
    scale <0.800000, 0.800000, 0.800000>
    translate <0.000000, -3.000000, 0.000000>
  }
  object { segment4
    scale <0.800000, 0.800000, 0.800000>
    translate <0.000000, 3.000000, 0.000000>
  }
  object { segment1
    translate <0.000000, -8.000000, 0.000000>
  }
  object { segment1
    rotate <-180.000000, 0.000000, 0.000000>
    translate <0.000000, 8.000000, 0.000000>
  }
  bounded_by { koerperbound }
  translate <0.000000, 0.000000, 8.500000>
}

#declare beinbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <7.000000, 4.000000, 9.000000>
  translate <-3.000000, 0.000000, 8.000000>
}

#declare rohr1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    blau
  }
  scale <1.100000, 1.100000, 8.000000>
}

#declare ring7 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.000000, 1.000000, 0.800000>
  translate <1.250000, 0.000000, 0.000000>
}

#declare ring8 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.100000, 1.100000, 0.800000>
  rotate <0.000000, -4.000000, 0.000000>
  translate <1.246115, 0.000000, 0.263056>
}

#declare ring9 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.300000, 1.300000, 0.800000>
  rotate <0.000000, -8.000000, 0.000000>
  translate <1.274529, 0.000000, 0.559866>
}

#declare dichtung2 = union {
  object { ring7 }
  object { ring8 }
  object { ring9 }
  texture {
    gummi
  }
  translate <-1.250000, 0.000000, 0.000000>
}

#declare fuss1 = torus { 
  2.600, 0.400  // Major, minor radius
  rotate -x*90
}

#declare fuss2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <2.600000, 2.600000, 0.800000>
  translate <0.000000, 0.000000, -0.400000>
}

#declare fuss_zw = union {
  object { fuss1 }
  object { fuss2 }
  texture {
    blau
  }
  rotate <0.000000, -8.000000, 0.000000>
  translate <-0.055415, 0.000000, 1.015951>
}

#declare fuss_ges = union {
  object { dichtung2 }
  object { fuss_zw }
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.042462, 0.000000, 7.977614>
}
#declare unterschenkel = union {
  object { rohr1 }
  object { fuss_ges }
  rotate <0.000000, -80.000000, 0.000000>
  translate <-1.289910, 0.000000, 9.558179>
}
#declare ring1 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  translate <1.250000, 0.000000, 0.000000>
}

#declare ring2 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -40.000000, 0.000000>
  translate <0.948296, 0.000000, 0.794236>
}

#declare ring3 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -50.000000, 0.000000>
  translate <0.806532, 0.000000, 0.954433>
}

#declare ring4 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -60.000000, 0.000000>
  translate <0.615488, 0.000000, 1.080520>
}

#declare ring5 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -70.000000, 0.000000>
  translate <0.424445, 0.000000, 1.179992>
}

#declare ring6 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -80.000000, 0.000000>
  translate <0.215089, 0.000000, 1.228661>
}

#declare ring10 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -30.000000, 0.000000>
  translate <1.073694, 0.000000, 0.621814>
}

#declare ring11 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -20.000000, 0.000000>
  translate <1.167742, 0.000000, 0.418043>
}

#declare ring12 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.230441, 0.000000, 0.214272>
}

#declare dichtung1 = union {
  object { ring1 }
  object { ring2 }
  object { ring3 }
  object { ring4 }
  object { ring5 }
  object { ring6 }
  object { ring10 }
  object { ring11 }
  object { ring12 }
  texture {
    gummi
  }
  translate <-1.250000, 0.000000, 8.250000>
}

#declare rohr2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    blau
  }
  scale <1.100000, 1.100000, 8.000000>
}

#declare oberschenkel = union {
  object { unterschenkel }
  object { dichtung1 }
  object { rohr2 }
  rotate <0.000000, 8.000000, 0.000000>
  translate <0.100199, 0.000000, 0.626247>
}

#declare oberschenkel1 = union {
  object { unterschenkel }
  object { dichtung1 }
  object { rohr2 }
  rotate <0.000000, -5.000000, 0.000000>
  translate <0.100199, 0.000000, 0.626247>
}

#declare ring13 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.000000, 1.000000, 0.800000>
  rotate <0.000000, 8.000000, 0.000000>
  translate <1.296923, 0.000000, 0.431695>
}

#declare ring14 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.150000, 1.150000, 0.800000>
  rotate <0.000000, 4.000000, 0.000000>
  translate <1.217961, 0.000000, 0.225518>
}

#declare ring15 = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  scale <1.300000, 1.300000, 0.800000>
  translate <1.250000, 0.000000, 0.000000>
}

#declare dichtung3 = union {
  object { ring13 }
  object { ring14 }
  object { ring15 }
  texture {
    gummi
  }
  translate <-1.250000, 0.000000, 0.000000>
}

#declare bein = union {
  object { oberschenkel }
  object { dichtung3 }
  bounded_by { beinbound }
}

#declare bein1 = union {
  object { oberschenkel1 }
  object { dichtung3 }
  bounded_by { beinbound }
}

#declare hd_c = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    gummi
  }
  translate <0.000000, 0.000000, 1.000000>
}

#declare hr_a = torus { 
  2.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    blau
  }
  translate <0.000000, 0.000000, 0.300000>
}

#declare hr_b = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    blau
  }
  scale <2.500000, 2.500000, 1.000000>
  translate <0.000000, 0.000000, -0.200000>
}

#declare ht_a = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <2.000000, 2.000000, 1.400000>
  translate <0.000000, 0.000000, 0.900000>
}

#declare ht_b = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  translate <0.000000, 0.000000, 2.300000>
}

#declare ht_c = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  translate <0.000000, 0.000000, 0.900000>
}

#declare ht_ges = union {
  object { ht_a }
  object { ht_b }
  object { ht_c }
  texture {
    blau
  }
}

#declare hd_a = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    gummi
  }
  translate <0.000000, 0.000000, 2.800000>
}

#declare hd_b = torus { 
  1.250, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    gummi
  }
  translate <0.000000, 0.000000, 0.200000>
}

#declare lampenbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 5.000000, 17.000000>
  translate <0.000000, 0.000000, 16.000000>
}

#declare lampe_a = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 1.000000, 2.000000>
}

#declare lampe_b = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <1.000000, 1.000000, 2.000000>
  translate <0.000000, 0.000000, 0.419652>
}

#declare lampe_ab = difference {
  object { lampe_a }
  object { lampe_b }
}

#declare lampe_c = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.100000, 1.100000, 0.700000>
  translate <0.000000, 0.000000, 1.300000>
}

#declare lampe_zw = intersection {
  object { lampe_ab }
  object { lampe_c }
}

#declare lrund_a = torus { 
  0.900, 0.100  // Major, minor radius
  rotate -x*90
  translate <0.000000, 0.000000, 2.000000>
}

#declare lrund_b = torus { 
  0.200, 0.100  // Major, minor radius
  rotate -x*90
  translate <0.000000, 0.000000, 0.600000>
}

#declare lmpe_ges = union {
  object { lampe_zw }
  object { lrund_a }
  object { lrund_b }
  texture {
    blau
  }
  scale <0.500000, 0.500000, 1.000000>
}

#declare strahl_a = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 13.000000, 0.001000>
  translate <0.000000, 14.000000, 0.000000>
}

#declare strahl_b = plane {
  z,0
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.000000, 28.000000, 0.000000>
}

#declare strahl = intersection {
  object { strahl_a }
  object { strahl_b }
  texture {
    lichtschein
  }
  no_shadow
  rotate <90.000000, 0.000000, -90.000000>
  translate <0.000000, 0.000000, 0.750000>
}

#declare lampe = union {
  object { lmpe_ges }
  object { strahl }
  bounded_by { lampenbound }
  scale <6.000000, 6.000000, 6.000000>
  rotate <0.000000, 0.000000, -7.500000>
  translate <0.000000, 0.000000, -1.000000>
}

#declare halsteil1 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { lampe }
  rotate <0.000000, -6.000000, 4.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil2 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil1 }
  rotate <0.000000, -7.000000, 3.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil3 = union {
  object { ht_ges }
  object { hd_a }
  object { halsteil2 }
  rotate <0.000000, -7.000000, 4.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil4 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil3 }
  rotate <0.000000, -7.000000, 4.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil5 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil4 }
  rotate <0.000000, -7.000000, 4.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil6 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil5 }
  rotate <0.000000, -7.000000, 4.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil7 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil6 }
  rotate <0.000000, -6.000000, 2.000000>
}

#declare halsteil8 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil7 }
  rotate <0.000000, -5.000000, 3.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil10 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil8 }
  rotate <-2.000000, 0.000000, 2.000000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare hals = union {
  object { hd_c }
  object { hr_a }
  object { hr_b }
  object { halsteil10 }
  rotate <-35.000000, 0.000000, 0.000000>
  translate <0.000000, 9.600000, 12.100000>
}

#declare kr_bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <35.000000, 35.000000, 120.000000>
  rotate <0.000000, -45.000000, -15.000000>
  translate <-60.000000, 27.000000, 75.000000>
}

#declare lampenbound1 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.000000, 7.000000, 65.000000>
  translate <0.000000, 0.000000, 64.000000>
}

#declare strahl_a1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <5.000000, 64.000000, 0.001000>
  translate <0.000000, 63.000000, 0.000000>
}

#declare strahl_b1 = plane {
  z,0
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.000000, 127.000000, 0.000000>
}

#declare strahl1 = intersection {
  object { strahl_a1 }
  object { strahl_b1 }
  texture {
    lichtschein2
  }
  no_shadow
  rotate <90.000000, 0.000000, -90.000000>
  translate <0.000000, 0.000000, 0.750000>
}

#declare lampe1 = union {
  object { lmpe_ges }
  object { strahl1 }
  bounded_by { lampenbound1 }
  scale <6.000000, 6.000000, 6.000000>
  rotate <0.000000, 0.000000, -38.000000>
  translate <0.000000, 0.000000, -1.000000>
}

#declare halsteil9 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { lampe1 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil11 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil9 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil12 = union {
  object { ht_ges }
  object { hd_a }
  object { halsteil11 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil13 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil12 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil14 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil13 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil15 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil14 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil16 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil15 }
  rotate <-2.000000, 0.000000, 0.000000>
}

#declare halsteil17 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil16 }
  rotate <-2.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil18 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil17 }
  rotate <-1.000000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare hals1 = union {
  object { hd_c }
  object { hr_a }
  object { hr_b }
  object { halsteil18 }
  rotate <-35.000000, 0.000000, 0.000000>
  translate <0.000000, 9.600000, 12.100000>
}

#declare lampe2 = union {
  object { lmpe_ges }
  object { strahl1 }
  bounded_by { lampenbound1 }
  scale <6.000000, 6.000000, 6.000000>
  rotate <0.000000, 0.000000, -70.000000>
  translate <0.000000, 0.000000, -1.000000>
}

#declare halsteil19 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { lampe2 }
  rotate <-2.000000, -2.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil20 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil19 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil21 = union {
  object { ht_ges }
  object { hd_a }
  object { halsteil20 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil22 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil21 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil23 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil22 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil24 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil23 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil25 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil24 }
  rotate <-2.000000, -3.000000, 0.000000>
}

#declare halsteil26 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil25 }
  rotate <-2.000000, -3.000000, 0.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare halsteil27 = union {
  object { ht_ges }
  object { hd_a }
  object { hd_b }
  object { halsteil26 }
  rotate <-1.000000, -2.000000, 0.000000>
  translate <0.000000, 0.000000, 1.100000>
}

#declare hals2 = union {
  object { hd_c }
  object { hr_a }
  object { hr_b }
  object { halsteil27 }
  rotate <-35.000000, 0.000000, 0.000000>
  translate <0.000000, 9.600000, 12.100000>
}

#declare kr_bound1 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <30.000000, 30.000000, 450.000000>
  rotate <-52.000000, 0.000000, 0.000000>
  translate <0.000000, 320.000000, 260.000000>
}

#declare kr_bound2 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <40.000000, 40.000000, 420.000000>
  rotate <-55.742172, 0.000000, 29.424055>
  translate <-163.089420, 291.472375, 222.930474>
}

box {   // signet
  <-1, -1, -1>, <1, 1, 1>
  texture {
    sig_texture
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <0.550000, 0.180000, 0.001000>
  rotate <90.000000, 0.000000, 5.000000>
  translate <-0.909668, -14.848505, 6.399672>
}

#declare Bodenbound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <315.769989, 315.769989, 6.000000>
  translate <-7.500000, 272.500000, -0.250000>
}

#declare Boden = object { 
  height_field {
    gif "plboden.gif" 
    water_level 0.000000
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Bodenfarbe
  }
  scale <300.000000, 300.000000, 5.000000>
  translate <0.000000, 280.000000, 0.000000>
}

#declare Boden1 = object { 
  height_field {
    gif "plboden.gif" 
    water_level 0.000000
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    unterboden
  }
  scale <300.000000, 300.000000, 5.000000>
  translate <0.000000, 280.000000, -0.100000>
}

union {   // Boden_gesamt
  object { 
    height_field {
      gif "plboden.gif"
      water_level 0.000000
      smooth
    }
    rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
    scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
    translate < -1,-1,-1> // Center around origin
    texture {
      Bodenfarbe
    }
    scale <300.000000, 300.000000, 5.000000>
    translate <0.000000, 280.000000, 0.000000>
  }
  object { Boden1 }
  bounded_by { Bodenbound }
}

object {   // Horizont
  sphere {<0,0,0>,1}
  texture {
    Nebel_t
  }
  scale <1000.000000, 1000.000000, 1000.000000>
}

#declare Planet = object { 
  sphere {<0,0,0>,1}
  texture {
    Planet_t
  }
}

#declare Ring = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    Ringtext
  }
  scale <2.000000, 2.000000, 1.000000>
}

#declare Wolken = object { 
  sphere {<0,0,0>,1}
  texture {
    Wolken_t
  }
  scale <1.010000, 1.010000, 1.010000>
}

union {   // Planet_ges
  object { Planet }
  object { Ring }
  object { Wolken }
  scale <100.000000, 100.000000, 100.000000>
  rotate <56.990593, 0.000000, 52.011471>
  translate <-235.452337, 1335.804413, 104.111079>
}

object {   // Himmel
  sphere {<0,0,0>,1}
  texture {
    Sterne
  }
  scale <4000.000000, 4000.000000, 4000.000000>
}

object { 
  Gleiter
  rotate <95.000000, 0.000000, -165.000000>
  translate <4.059080, 9.883464, 14.959632>
}

object { 
  Gleiter
  rotate <100.000000, 25.260548, -182.819122>
  translate <-18.038105, 40.321468, 15.000000>
}

object { 
  Gleiter
  rotate <95.000000, 70.000000, -151.493378>
  translate <19.279856, 119.017595, 15.000000>
}

object { 
  Gleiter
  rotate <95.000000, 15.000000, -192.891586>
  translate <-14.325539, 128.215504, 13.114736>
}

union {   // kriecher1
  object { koerper }
  object { bein
    rotate <0.000000, -90.000000, 0.000000>
    translate <-6.062046, 0.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -20.000000>
    translate <-6.062046, 7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, 22.000000>
    translate <-6.062046, -7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -200.000000>
    translate <5.937954, -7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -180.000000>
    translate <5.937954, 0.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -163.000000>
    translate <5.937954, 7.000000, 8.925000>
  }
  object { hals1 }
  bounded_by { kr_bound1 }
  scale <0.100000, 0.100000, 0.100000>
  rotate <6.500000, 4.000000, -15.000000>
  translate <-19.000000, 52.000000, -3.450000>
}

union {   // kriecher2
  object { koerper }
  object { bein1
    rotate <0.000000, -92.000000, 0.000000>
    translate <-6.000000, 0.000000, 8.925000>
  }
  object { bein1
    rotate <-5.000000, -87.000000, -20.000000>
    translate <-6.000000, 7.000000, 8.925000>
  }
  object { bein1
    rotate <0.000000, -90.000000, 22.000000>
    translate <-6.000000, -7.000000, 8.925000>
  }
  object { bein1
    rotate <0.000000, -90.000000, -200.000000>
    translate <6.000000, -7.000000, 8.925000>
  }
  object { bein1
    rotate <0.000000, -82.000000, -180.000000>
    translate <6.000000, 0.000000, 8.925000>
  }
  object { bein1
    rotate <0.000000, -80.000000, -163.000000>
    translate <6.000000, 7.000000, 8.925000>
  }
  object { hals2 }
  bounded_by { kr_bound2 }
  scale <0.100000, 0.100000, 0.100000>
  rotate <20.000000, 4.000000, -2.000000>
  translate <-1.228983, 14.771017, 0.800000>
}

union {   // kriecher
  object { koerper }
  object { bein
    rotate <0.000000, -90.000000, 0.000000>
    translate <-6.062046, 0.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -20.000000>
    translate <-6.062046, 7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, 22.000000>
    translate <-6.062046, -7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -200.000000>
    translate <5.937954, -7.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -180.000000>
    translate <5.937954, 0.000000, 8.925000>
  }
  object { bein
    rotate <0.000000, -90.000000, -163.000000>
    translate <5.937954, 7.000000, 8.925000>
  }
  object { hals }
  bounded_by { kr_bound }
  scale <0.100000, 0.100000, 0.100000>
  rotate <42.000000, 1.000000, 53.000000>
  translate <7.325000, 23.609333, 0.380000>
}

