/* File...........TEMPLE.INC
   Author.........Carlos Javier M. Garate
   Internet.......cgarate@spin.com.mx
                  cjmtz@mail.internet.com.mx
                  http://www.spin.com.mx/Usuarios/cgarate/cgaratei.html
   Date...........August / 21 / 1995
   Program........POV-Ray 2.2
   Computer.......DEC PC LPx+ 450d2
                  486DX2 50 Mhz, 8 MB RAM, VESA 1MB.
   Related Files.."MOON.GIF", "MOON2.GIF", "HEIGHT.GIF", "STARS.GIF". */

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"

/*-------------------------Begin Union, object: Treasure--------------------*/
#declare Treasure =
union {
       object { Pyramid2
       texture {Glass3}
       bounded_by {sphere{<0, 0, 0>, 5}}
       scale 5
               }

sphere {<0,1,0> 1
        texture {Chrome_Texture}
        pigment {Red}
        finish {reflection .3}
        }

// Light Source
light_source {<0, 10, 0> color White
              spotlight
              point_at <0,1,0>
              radius 11
              falloff  25
              }
       }
/*-------------------------End Union, object: Treasure----------------------*/

/*-------------------------Begin Union, object: Rocks-----------------------*/
#declare Rocks =
union {
// Light Source
light_source {<1, 20, 0> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<3, 20, 1> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<5, 20, 0> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<7, 20, 2> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<6, 20, 1> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<8, 20, 2> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// Light Source
light_source {<8, 20, 0> color Gray15
        spotlight
        point_at <0,1,0>
        radius 11
        falloff  25
        }

// height_field
height_field { gif "c:\photo\height.gif"  water_level 0
texture {Glass3}
rotate <0,90,0>
scale <20,30,30>}

sphere {<1, 1, .5>, .4
texture {Chrome_Texture}
pigment {Red}
finish {reflection .7}
}
sphere {<3, 1, 0>, .4
texture {Chrome_Texture}
pigment {Yellow}
finish {reflection .7}
}
sphere {<5, 1, .6>, .4
texture {Chrome_Texture}
finish {reflection .7}
}
sphere {<7, 1, .5>, .4
texture {Chrome_Texture}
pigment {Green}
finish {reflection .7}
}
sphere {<6, 1, 0>, .4
texture {Chrome_Texture}
pigment {Coral}
finish {reflection .7}
}
sphere {<4, 1, .5>, .4
texture {Chrome_Texture}
pigment {Blue}
finish {reflection .7}
}
sphere {<2, 1, .5>, .4
texture {Chrome_Texture}
pigment {DarkOliveGreen}
finish {reflection .7}
}
sphere {<11, 1, .5>, .4
texture {Chrome_Texture}
pigment {Gold}
finish {reflection .7}
}
sphere {<9, 1, 1>, .4
texture {Chrome_Texture}
pigment {MediumVioletRed}
finish {reflection .7}
}
sphere {<5, 1, .5>, .4
texture {Chrome_Texture}
pigment {Salmon}
finish {reflection .7}
}
}
/*-------------------------End Union, object: Rocks-------------------------*/

/*-------------------------Begin Union, object: Sea-------------------------*/
#declare Sea =
union {
// Light Source
light_source {<-1, 20, 20> color White
        spotlight
        point_at <0,1,0>
        radius 10
        falloff  20
        }

// Light Source
light_source {<11, 10, 20> color White
        spotlight
        point_at <0,1,0>
        radius 10
        falloff  20
        }

// Plane 
plane {<0, 1, 0>, 0
texture {Water}
finish {Luminous}
}
}
/*-------------------------End union, object: Sea---------------------------*/

/*-------------------------Begin union, object: Sky-------------------------*/
#declare Sky =
plane {<0, 0, 1>, 30
pigment {image_map {gif "c:\photo\stars.gif"
                    interpolate 2
                    }
                    scale 20
                 }
}
/*-------------------------End union, object: Sky---------------------------*/

/*-------------------------Begin object: Moon1------------------------------*/
#declare Moon1 =
// Light Source
light_source {<-2, 5, 10> color White
              looks_like {sphere {<0, 0, 0>, 1
                          pigment {image_map {gif "c:\photo\moon.gif"
                                   interpolate 2
                                   map_type 1}}
                          finish {Luminous}
                                 }
                         } 
              }
/*-------------------------End object: Moon1--------------------------------*/

/*-------------------------Begin object: Moon2------------------------------*/
#declare Moon2  =
// Light Source
light_source {<10, 4, 16> color White
looks_like {
sphere {<0, 0, 0>, 1
        pigment {image_map {gif "c:\photo\moon.gif"
         map_type 1
         interpolate 2}}
       finish {Luminous}
       }
           }
              }
/*-------------------------End object: Moon2--------------------------------*/

/*-------------------------Begin object: Moon3------------------------------*/
#declare Moon3 =
sphere {<-1.7, 7, 15>, .2
        pigment {image_map {gif "c:\photo\moon2.gif"
         map_type 1
         interpolate 2}}
       }
/*-------------------------End object: Moon3--------------------------------*/


