// Persistence of Vision Raytracer 2.x
// Image by Peter McArdle
// Rubic's Cube
// Units in inches

// The gif for the cover of book is upside down
// I had used a tga file but tga2gif doesn't recognize the filped bit
// and the resulting gif is upside down
// I don't have any programs that let me modify gifs so you need to 
// flip it before you render

#include "colors.inc"    // pre-defined colors
//#include "shapes.inc"    // pre-defined scene elements
//#include "textures.inc"  // pre-defined surface textures


//background { color rgb <.9, .9, .8> }
default { finish { ambient 0.15 } }

#declare Camera1 =
camera {
  location  <1, 5.5, -8.0>
  direction <0.0,  0.0,  1.5>
  up        <0.0,  1.0,  0.0>
  right     <4/3,  0.0,  0.0>
  look_at   <0.0,  2.0,  -1.0>
  sky       <0.0,  1.0,  0.0>
 }

#declare Camera2 =
camera {
  location  <0, 5.5, -8.0>
  direction <0.0,  0.0,  1.5>
  up        <0.0,  1.0,  0.0>
  right     <4/3,  0.0,  0.0>
  look_at   <0.0,  0.0,  -2.0>
  sky       <0.0,  1.0,  0.0>
 }

camera { Camera1 }

//Light source
light_source { <0, 5.5, -8> color Gray50 }     //at Camera1

//light_source { <0, 10, 0> color Gray50 }

#declare Spot1 =
object {
  light_source {
    <0, 10.0, 0>
    color Gray50
    area_light <1, 0, 0> <0, 0, 1> 3, 3
    spotlight
    point_at <0, 0, 0>
    radius 0
    tightness 1  
    falloff 45
   }
 }

object { 
  Spot1 
  translate 2*y
  rotate 30*x
  rotate 30*z
  translate <-2, -2.5, 4>
}

//Spot Light
light_source {
  <0.0, 30.0, -4> 
  color Gray50
  //area_light <3, 0, 0> <0, 0, 3> 5, 5
  //jitter
  spotlight
  point_at <0, 0, 2>
  radius 2.5 
  //tightness 50 
  falloff 10 
}

#include "cube.inc"

//object { Cube } 

#declare Book_Cover =
object { 
  box { <0.0, 0.0, 0.0> <1.0, 1.0, 0.001> }
  texture {
    pigment { 
      image_map {
        gif "cover.gif"  //this was a tga file and needs to be flipped
        map_type 0
        interpolate 2
      }
    }
  }
  scale <4, 7, 1>
}


#declare Book_Body =
object { 
  difference {
    box { <0.0, 0.01, 0.0> <4.0 6.99, 1.0> }
    cylinder { <4.0*8, -0.01, 0.5> <4.0*8, 7.01, 0.5> 0.5 scale <0.125, 1, 1> }
  }
  texture {
    pigment {
      gradient 1*z
      color_map {
        [ 0.0 color rgb <0.9, 0.9, 0.9> ]
        [ 0.5 color rgb <0.9, 0.9, 0.9> ]     
        [ 0.50001 color rgb <0.8, 0.8, 0.8> ]
        [ 1.0 color rgb <0.8, 0.8, 0.8> ]            
      }
      scale <1, 1, 1/100>
    }
  }
}

#declare Spine =
object {
  cylinder { <0.0, 0.001, 0.0> <0.0, 6.999 0.0> 0.499 }
  texture {
    pigment { color rgb <0.9, 0.9, 0.8> }
  }
  scale <0.125, 1, 1>
}


//the book
object { 
  union {
    object { Book_Cover translate -0.001*z rotate 90*x rotate 0.5*z }
    object { Book_Body rotate 90*x }
    object { Spine translate 0.5*z rotate 90*x }
    translate 1.001*y
    translate -4*x
    rotate 0.5*z
  }
}

object { 
  Book_Cover 
  texture { 
    pigment { color rgb <0.9, 0.9, 0.8> } 
  } 
  translate -0.001*z
  rotate 90*x
  translate -4*x
}

//The cube
object { 
  Cube1 
  rotate 35*y
  translate 2*x
}

//the two missing cubes
#declare Missing_1 =
//difference {
  object { T_R_E_Sect //} 
  //sphere { <0.0, 1.125, 0.0> 0.75 }
  translate <-0.75, -1.5, 0.0>
}

object { 
  Missing_1 
  translate <0, 0, 0.35> 
  rotate -90*x
  translate <0, 0, 0.35>
  rotate 45*y
  translate -1*z
  translate -2*x
}

#declare Missing_2 =
object { 
  T_F_R_C_Sect 
  translate <-0.75, -1.5, 0.75>
}

object { 
  Missing_2 
  translate -0.35*x
  rotate -15*z
  translate 0.35*x
  rotate 25*y
  translate -1.5*z
  translate -1*x
}


#include "hallway.inc"
object { the_floor }

/*
//checkered floor for positioning
object {
  plane { < 0.0, 1.0, 0.0> 0.0 }
  texture {
    pigment { checker color White color Gray90 }
    scale 2
  }
}
*/

//back wall
object {
  box { <-15, 0.0 10> <15, 25, 11> }
  texture {
    wt rotate 90*z
  }
}

object { 
  cylinder { <-15, 0.0, 10> <15, 0.0, 10> 1.0 }
  scale <1, .5, 1>
  texture {
    wt rotate -90*z translate -10*x
  }
}
