#declare Radius_Bull     = 0.5
#declare Radius_Outer    = 1.0
#declare Radius_Treble   = 6.0
#declare Radius_Double   = 9.5
#declare Radius_Board    = 12.0
#declare Radius_DT_Delta = 0.5
#declare Radius_Wire     = 0.06

#declare YBoard = texture  { pigment { color Yellow }      finish { crand 0.05 ambient 0.3 } }
#declare YGBoard = texture { pigment { color YellowGreen } finish { crand 0.05 ambient 0.3 } }
#declare RBoard = texture  { pigment { color Red }         finish { crand 0.05 ambient 0.15 } }
#declare BBoard = texture  { pigment { color Gray30 }      finish { crand 0.05 ambient 0.3 } }

#declare Border = object {
    cylinder { <0, 0, 0>, <0, 0, -2+DELTA>, Radius_Board
        texture { BBoard }
    }
}

#declare Numbers = object {
    union {
// Single numbers , 5
        box { <0,0,0>, <1,1,1> pigment { image_map { gif "5.gif" filter 0,1 } } scale <1,1.2,DELTA> translate <-0.5,Radius_Board-1.8,-2-2*DELTA> rotate z*18 }
// Double Numbers, 20, 12
        object {  //20
            union {
                box { <0,0,0>, <1,1,1> pigment { image_map { gif "2.gif" filter 0,1 } } scale <1,1.2,DELTA> translate <-0.5,Radius_Board-1.8,-2-2*DELTA> }
                box { <0,0,0>, <1,1,1> pigment { image_map { gif "0.gif" filter 0,1 } } scale <1,1.2,DELTA> translate <-0.5,Radius_Board-1.8,-2-2*DELTA> }
            }
        }
        object {  //12
            union {
                box { <0,0,0>, <1,1,1> pigment { image_map { gif "1.gif" filter 0,1 } } scale <1,1.2,DELTA> translate <-1,Radius_Board-1.8,-2-2*DELTA> }
                box { <0,0,0>, <1,1,1> pigment { image_map { gif "2.gif" filter 0,1 } } scale <1,1.2,DELTA> translate <0, Radius_Board-1.8,-2-2*DELTA> }
            }
            rotate z*36
        }
    }
}

#declare Bull = object {
    cylinder { <0, 0, 0>, <0, 0, -2>, Radius_Bull
        texture { RBoard }
    }
}

#declare Outer = object {
    difference {
        cylinder { <0, 0, 0>, <0, 0, -2>, Radius_Outer }
        cylinder { <0, 0, 0+DELTA>, <0, 0, -2-DELTA>, Radius_Bull }
    }
    texture { YBoard }
}


#declare O_D_Slice = object {    
    difference {
        cylinder { <0, 0, 0>, <0, 0, -2>, Radius_Double }
        cylinder { <0, 0, 0+DELTA>, <0, 0, -2-DELTA>, Radius_Outer }
    }
    clipped_by { plane{x,0}}
    clipped_by { object { plane { -x, 0 } rotate <0,0,18> } }
}

#declare Treble_Slice = object {    
    difference {
        cylinder { <0, 0, 0>, <0, 0, -2-DELTA>, Radius_Treble+Radius_DT_Delta }
        cylinder { <0, 0, 0+DELTA>, <0, 0, -2-(2*DELTA)>, Radius_Treble }
    }
    clipped_by { plane{x,0}}
    clipped_by { object { plane { -x, 0 } rotate <0,0,18> } }
}

#declare Double_Slice = object {    
    difference {
        cylinder { <0, 0, 0>, <0, 0, -2-DELTA>, Radius_Double+Radius_DT_Delta }
        cylinder { <0, 0, 0+DELTA>, <0, 0, -2-(2*DELTA)>, Radius_Double }
    }
    clipped_by { plane{x,0}}
    clipped_by { object { plane { -x, 0 } rotate <0,0,18> } }
}

#declare OuterToDouble = object {
    union {
        object { O_D_Slice  rotate <0,0,  9>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0, 27>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0, 45>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0, 63>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0, 81>  texture { YGBoard } }
/*
        object { O_D_Slice  rotate <0,0, 99>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,117>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,135>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,153>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,171>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,189>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,207>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,225>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,243>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,261>  texture { YGBoard } }
*/
        object { O_D_Slice  rotate <0,0,279>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,297>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,315>  texture { BBoard } }
        object { O_D_Slice  rotate <0,0,333>  texture { YGBoard } }
        object { O_D_Slice  rotate <0,0,351>  texture { BBoard } }
    }
    bounded_by { cylinder { <0, 0, 0+DELTA>, <0, 0, -2-DELTA>, Radius_Double } }
}

#declare Trebles = object {
    union {
        object { Treble_Slice  rotate <0,0,  9>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0, 27>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0, 45>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0, 63>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0, 81>  texture { BBoard } }
/*
        object { Treble_Slice  rotate <0,0, 99>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,117>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,135>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,153>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,171>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,189>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,207>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,225>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,243>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,261>  texture { BBoard } }
*/
        object { Treble_Slice  rotate <0,0,279>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,297>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,315>  texture { RBoard } }
        object { Treble_Slice  rotate <0,0,333>  texture { BBoard } }
        object { Treble_Slice  rotate <0,0,351>  texture { RBoard } }
    }
    bounded_by { cylinder { <0, 0, 0+DELTA>, <0, 0, -2-(DELTA*2)>, Radius_Treble+Radius_DT_Delta+DELTA } }
}

#declare Doubles = object {
    union {
        object { Double_Slice  rotate <0,0,  9>  texture { BBoard } }
        object { Double_Slice  rotate <0,0, 27>  texture { RBoard } }
        object { Double_Slice  rotate <0,0, 45>  texture { BBoard } }
        object { Double_Slice  rotate <0,0, 63>  texture { RBoard } }
        object { Double_Slice  rotate <0,0, 81>  texture { BBoard } }
/*
        object { Double_Slice  rotate <0,0, 99>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,117>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,135>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,153>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,171>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,189>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,207>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,225>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,243>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,261>  texture { BBoard } }
*/
        object { Double_Slice  rotate <0,0,279>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,297>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,315>  texture { RBoard } }
        object { Double_Slice  rotate <0,0,333>  texture { BBoard } }
        object { Double_Slice  rotate <0,0,351>  texture { RBoard } }
    }
    bounded_by { cylinder { <0, 0, 0+DELTA>, <0, 0, -2-(DELTA*2)>, Radius_Double+Radius_DT_Delta+DELTA } }
}

#declare BoardBack = object {
    union {
        object { Bull }
        object { Outer }
        object { OuterToDouble }
        object { Trebles }
        object { Doubles }
        object { Border }
        object { Numbers }
    }
}

#declare wireTexture = texture { Silver3 }

#declare WireEdging = object {
    torus { Radius_Board-0.5, Radius_Wire  
        texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
    }
}

#declare WireDoubles = object {
    union {
        torus { Radius_Double+Radius_DT_Delta, Radius_Wire  
            texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
        torus { Radius_Double, Radius_Wire  
            texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
    }
}


#declare WireTrebles = object {
    union {
        torus { Radius_Treble+Radius_DT_Delta, Radius_Wire  
            texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
        torus { Radius_Treble, Radius_Wire  
            texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
    }
}


#declare WireBull = object {
    union {
        torus { Radius_Outer, Radius_Wire  
            texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
        torus { Radius_Bull, Radius_Wire  
                texture { wireTexture } rotate <90, 0, 0> translate <0, 0, -2>
        }
    }
}

#declare WireRadials = object {
    union {
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*  9 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z* 27 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z* 45 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z* 63 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z* 81 }
/*
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z* 99 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*117 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*135 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*153 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*171 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*189 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*207 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*225 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*243 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*261 }
*/
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*279 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*297 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*315 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*333 }
        cylinder { <0,Radius_Outer,-2>, <0,Radius_Double+Radius_DT_Delta,-2>, Radius_Wire texture { wireTexture } rotate z*351 }
    }
}

#declare Wire = object {
    union {
        object { WireEdging }
        object { WireDoubles }
        object { WireTrebles }
        object { WireBull }
        object { WireRadials }
    }
}

#declare Board = object {
    union {
        object { BoardBack }
        object { Wire }
    }
}
