/*
Title           Dragon Room
Filename        DrgnRmPv.PoV
Author          Jamie McCarter
Description	A rectangular room with a three headed dragon (Hydra) in the
		centre of it.
*/
#declare BezierResolution = 2

#include "DrgnRmPv.Include"
#include "Wall.Include"
#include "Arch.Include"
//#include "Bone.Include"
//#include "RibCage.Include"
#include "Dragon.Include"
#include "MainRoom.Include
#include "Lighting.Include"

camera {
	location <8, -58, 6>
	right <-4/3, 0, 0>
	direction <0, 0, 0.75>
	up <0, 0, 1>
	sky <0, 0, 1>
	look_at <20, -30, 15>
	}
/*
plane { // The starry sky
	<0, 0, 1>, 50
	texture { StarTexture scale 50 }
	}
*/
box {	/*
	The horse head/dragon head nebula
	Found on some NASA archive.  I use this image rather than the Fractint
	starfield because, well, it looks much better.  I find the nebula has
	both red and blue in it which play well off of the red of the dragon
	and the blue of the room.
	*/
	<-20, 0, 0>, <80, 0.01, 100>
	texture {
		pigment {
			image_map {
				tga "HorsHead.Tga"
				interpolate 2.0
				once
				}
			turbulence 0.15 // Slight turbulence because I need to fake a high resolution image 
			rotate x*90
			}
		finish {
			ambient 1.0
			diffuse 0.0
			}
		scale <89.4375, 1, 66.1875>
		translate <-5, 0, 10>
		}
	rotate <15, 0, -25>
	translate <0, 20, 0>
	}
/*
Excluded from the render because of the camera angle.  Provided I ever have
enough time for a animation these would be back in in a jiffy.
union { // 'Da Bones
	object { Fimur rotate z*15 translate <35, -50, 0.100> }
	object { Fimur translate <-2, 0, 0> rotate z*45 translate <24, -53, 0.100> }
	object { Fimur translate <-2, 0, 0> rotate z*(45+70) translate <24, -53, 0.150> }
	object { RibCage scale 0.5 rotate y*15 rotate z*250 translate <34, -54, 0.0> }
	object { RibCage scale 0.75 rotate -y*15 rotate -z*50 translate <6, -50, 0.0> }
	object { Fimur rotate z*150 translate <15, -52, 0.0> }
	object { Fimur rotate z*231 translate <10, -56, 0.0> }
	}
*/
union { // The entire Room
	object { BothEndWalls }
	object { BothSideWalls }
	object { Arch }
	object { GroundFloor }
	object { GroundFog }
	object { FlatRoof }
	object { DragonPlatform }
	}
// End of DrgnRmPv.PoV File
