// Persistence Of Vision Raytracer version 2.0
// Samuel Goldstein
// Cathedral Things

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stonemod.inc"

#declare straight_in_view2 =
camera {
   location  <-15, 100, -275>
   direction <0, 0,  1>
   look_at   <0, 95,   0>
}


#declare SkyCam =
camera {
   location  <1, 300, 1>
   direction <0, -1,  0>
   look_at   <0, 100,   0>
}


camera { straight_in_view2 } //camera1

#declare FlameRed = color red 1.0 green 0.6 blue 0.1
#declare HotRed = color red 1.0 green 0.3 blue 0.3
#declare MurkyGothic= color red 0.88 green 0.91 blue 1.0
#declare HyperMurkyGothic = color red 1.76 green 1.82 blue 2




#declare OldMetal = texture {
 finish
  {metallic
   ambient 0.5
   diffuse 0.7
   brilliance 6
   reflection 0.15
   phong 0.75
   phong_size 80
  }
 pigment {
  Brass
 }
}

#declare OldGlass = texture {
    pigment {
      bozo
      turbulence 0.15
      color_map 
       {[0.0, 0.5   color red 1 green 1 blue 1 filter 0.95
                 color red 1 green 1 blue 1 filter 0.9]
        [0.5, 1.001 color red 1  green 1  blue 1 filter 0.9
                 color red .9  green .9  blue .9 filter 1]
       }
    }
    finish 
     {ambient 0
      diffuse 0
      reflection 0.5
      refraction 0.85
      ior 1.5
      phong 0.3
      phong_size 60
     }
}

#declare stonewall = texture {
                tiles {
                        texture { Stone16_mod scale <2,4,3> }
                tile2
                        texture { Stone13_mod scale <2,4,3> }
                      }
                scale <10,4,10>
                }

#declare gothcapitol3=
   union {
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <2,0,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-2,0,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,0,-2>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,0,2>}

        cylinder { <0,0,0>,<0,5,0>,1.5 translate <2,0,0> }
        cylinder { <0,0,0>,<0,5,0>,1.5 translate <-2,0,0> }
        cylinder { <0,0,0>,<0,5,0>,1.5 translate <0,0,-2> }
        cylinder { <0,0,0>,<0,5,0>,1.5 translate <0,0,2> }
        cylinder { <0,0,0>,<0,5,0>,0.5 translate <3.5,0,0> }
        cylinder { <0,0,0>,<0,5,0>,0.5 translate <-3.5,0,0> }
        cylinder { <0,0,0>,<0,5,0>,0.5 translate <0,0,-3.5> }
        cylinder { <0,0,0>,<0,5,0>,0.5 translate <0,0,3.5> }

        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <2,5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-2,5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,5,-2>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,5,2>}

        sphere {<0,0,0>,1 scale <2,1,2> translate <2.5,1.5,0>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <-2.5,1.5,0>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <0,1.5,-2.5>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <0,1.5,2.5>}

        sphere {<0,0,0>,1 scale <2,1,2> translate <2.5,3.5,0>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <-2.5,3.5,0>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <0,3.5,-2.5>}
        sphere {<0,0,0>,1 scale <2,1,2> translate <0,3.5,2.5>}
        }

#declare tinycolumn=
   union {
        cylinder { <0,0,0>,<0,35,0>,1 translate <0,0,0> }
        cylinder { <0,0,0>,<0,35,0>,0.125 translate <0,0,-1> }
        cylinder { <0,0,0>,<0,35,0>,0.125 translate <0,0,1> }
        cylinder { <0,0,0>,<0,35,0>,0.125 translate <1,0,0> }
        cylinder { <0,0,0>,<0,35,0>,0.125 translate <-1,0,0> }

        sphere {<0,0,0>,1.3 scale <1,0.5,1> translate <0,35,0>}
        sphere {<0,0,0>,1.3 scale <1,0.5,1> translate <0,0,0>}
	texture { Stone21_mod scale <2,6,3>}
        }

#declare column=
   union {
        // bottom capitol
        object {gothcapitol3 scale <1.1 1 1.1>}
        // Stalk
        cylinder { <0,4,0>,<0,35,0>,2 }
        cylinder { <0,4,0>,<0,35,0>,1 translate <2, 0, 0>}
        cylinder { <0,4,0>,<0,35,0>,1 translate <-2, 0, 0> }
        cylinder { <0,4,0>,<0,35,0>,1 translate <0,0,-2> }
        cylinder { <0,4,0>,<0,35,0>,0.5 translate <3.5,0,0> }
        cylinder { <0,4,0>,<0,35,0>,0.5 translate <-3.5,0,0> }
        cylinder { <0,4,0>,<0,35,0>,0.5 translate <0,0,-3.5> }
        // top capitol
        object {gothcapitol3 translate <0,35,0>}
        texture { Stone21_mod
                scale <2,6,3> }
}


#declare tallcolumn2=
   union {
        // bottom capitol
        object {gothcapitol3 scale <1.1 1 1.1>}
        // Stalk
        cylinder { <0,4,0>,<0,55,0>,2 }
        cylinder { <0,4,0>,<0,55,0>,1 translate <2, 0, 0>}
        cylinder { <0,4,0>,<0,55,0>,1 translate <-2, 0, 0> }
        cylinder { <0,4,0>,<0,55,0>,1 translate <0,0,-2> }
        cylinder { <0,4,0>,<0,55,0>,1 translate <0,0,2> }
        cylinder { <0,4,0>,<0,55,0>,0.5 translate <3.5,0,0> }
        cylinder { <0,4,0>,<0,55,0>,0.5 translate <-3.5,0,0> }
        cylinder { <0,4,0>,<0,55,0>,0.5 translate <0,0,-3.5> }
        cylinder { <0,4,0>,<0,55,0>,0.5 translate <0,0,3.5> }
        // top capitol
        object {gothcapitol3 translate <0,55,0>}
        texture { Stone21_mod
                scale <2,6,3> }
}

#declare arch=
         union {
            intersection {
                torus {28,1}
                box {<10,-1,0>,<31,1,30>}
                translate <-10,0,0>
                rotate <-90,0,0>
                }
            intersection {
                torus {27,0.5}
                box {<10,-1,0>,<31,1,30>}
                translate <-10,0,0>
                rotate <-90,0,0>
                }
            intersection {
                torus {28,1}
                box {<-31,-1,0>,<-10,1,30>}
                translate <10,0,0>
                rotate <-90,0,0>
                }
            intersection {
                torus {27,0.5}
                box {<-31,-1,0>,<-10,1,30>}
                translate <10,0,0>
                rotate <-90,0,0>
                }
           texture { Stone21_mod scale <2,4,3> }
           }

#declare minorarch=
         union {
            intersection {
                torus {6.187,0.75}
                box {<2.06,-1,0>,<8,1,8>}
                translate <-2.06,0,0>
                rotate <-90,0,0>
                }
            intersection {
                torus {6.187,0.75}
                box {<-8,-1,0>,<-2.06,1,8>}
                translate <2.06,0,0>
                rotate <-90,0,0>
                }
           texture { Stone21_mod scale <2,4,3> }
           }

#declare ringwindow=
        // Remember, we're workin' in the XZ Plane here, then rotating
        object {
        difference {
           merge {
              torus {3,0.35 sturm translate <4,0,0>}
              torus {3,0.35 sturm translate <-4,0,0>}
              torus {3,0.35 sturm translate <0,0,-4>}
              torus {3,0.35 sturm translate <0,0,4>}
              torus {7.4,0.6 sturm}
                 }
           cylinder {<0,-1,0>,<0,1,0>,3.5}
           }
         rotate <90,0,0>
         texture { Stone21_mod scale <2,4,3> }
         }
         


#declare archway=
         intersection {
                cylinder {<10,0,-0.1>,<10,0,5>,29}
                cylinder {<-10,0,-0.1>,<-10,0,5>,29}
                }
#declare window_glass =
    merge {
        intersection {
           object {archway scale <0.45,0.45,2> translate <0,60,0>}
	   box {<-8,60,0>,<8,77,0.2>}
           }
        box {<-8,0,0>,<8,60,0.2>}
        texture {OldGlass}
        }


#declare upperarches = union {
        cylinder {<0,85,0.5>,<0,130,0.5>,1 scale <0.5,1,1>}
        cylinder {<-20,80,0.5>,<-20,130,0.5>,1 scale <0.5,1,1>}
        cylinder {<20,80,0.5>,<20,130,0.5>,1 scale <0.5,1,1>}
        cylinder {<-40,60,0.5>,<-40,130,0.5>,1 scale <0.5,1,1>}

        cylinder {<-20,190,0>,<20,190,0>,1 scale <1,0.5,1>}
        cylinder {<-20,215,0>,<20,215,0>,1 scale <1,0.5,1>}
        cylinder {<-20,240,0>,<20,240,0>,1 scale <1,0.5,1>}

        object {arch scale <0.25,0.25,1> translate <-15,88,0>}
        object {arch scale <0.25,0.25,1> translate <-5,88,0>}
        object {arch scale <0.25,0.25,1> translate <5,88,0>}
        object {arch scale <0.25,0.25,1> translate <15,88,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-20,88,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-10,88,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,88,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <10,88,0>}
        object {arch scale <0.25,0.25,1> translate <-15,100.5,0>}
        object {arch scale <0.25,0.25,1> translate <-5,100.5,0>}
        object {arch scale <0.25,0.25,1> translate <5,100.5,0>}
        object {arch scale <0.25,0.25,1> translate <15,100.5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-20,100.5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-10,100.5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,100.5,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <10,100.5,0>}
        object {arch scale <0.25,0.25,1> translate <-15,113,0>}
        object {arch scale <0.25,0.25,1> translate <-5,113,0>}
        object {arch scale <0.25,0.25,1> translate <5,113,0>}
        object {arch scale <0.25,0.25,1> translate <15,113,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-20,113,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <-10,113,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <0,113,0>}
        sphere {<0,0,0>,1 scale <1.5,0.5,1.5> translate <10,113,0>}
        texture { Stone21_mod scale <2,4,3> }
}

#declare window_lead =
        union {
		cylinder {<0,0,0>,<8,10,0>,0.15 }
		cylinder {<0,0,0>,<-8,10,0>,0.15 }

		cylinder {<-8,0,0>,<8,20,0>,0.15 }
		cylinder {<8,0,0>,<-8,20,0>,0.15 }

		cylinder {<-8,10,0>,<8,30,0>,0.15 }
		cylinder {<8,10,0>,<-8,30,0>,0.15 }

		cylinder {<-8,20,0>,<8,40,0>,0.15 }
		cylinder {<8,20,0>,<-8,40,0>,0.15 }

		cylinder {<-8,30,0>,<8,50,0>,0.15 }
		cylinder {<8,30,0>,<-8,50,0>,0.15 }

		cylinder {<-8,40,0>,<8,60,0>,0.15 }
		cylinder {<8,40,0>,<-8,60,0>,0.15 }

		cylinder {<-8,50,0>,<0,60,0>,0.15 }
		cylinder {<8,50,0>,<0,60,0>,0.15 }

		cylinder {<-8,20,0>,<8,20,0>,0.15 }
		cylinder {<-8,40,0>,<8,40,0>,0.15 }
		cylinder {<-8,60,0>,<8,60,0>,0.15 }
		texture {
		  pigment {Silver}
		  finish
  			{metallic
   			ambient 0.2
   			diffuse 0.7
   			phong 0.75
   			phong_size 80
		        }
              }      
}

#declare spire = union {
	box {<-3,0,-3>,<3,1,3>}
	box {<-2.5,1,-2.5>,<2.5,3,2.5>}
	box {<-3,3,-3>,<3,3.75,3>}
	box {<-2,3.75,-2>,<2,5.25,2>}
	box {<-2.5,5.25,-2.5>,<2.5,5.81,2.5>}
	box {<-1.5,5.81,-1.5>,<1.5,6.93,1.5>}
	box {<-2,6.93,-2>,<2,7.35,2>}
	box {<-1,7.35,-1>,<1,8.19,1>}
	box {<-1.5,8.19,-1.5>,<1.5,8.51,1.5>}
	box {<-.5,8.51,-.5>,<.5,9.14,.5>}
	box {<-1,9.14,-1>,<1,9.38,1>}
	box {<-.25,9.38,-.25>,<.25,9.85,.25>}
	texture {stonewall}
	scale <.5,1.5,.5>
}

#declare outerbuttress= union {
	box {<-3,0,-7>,<3,120,0>}
	   intersection {
		   box {<-3,0,-9>,<3,120,0> }
	           plane {-z,0 rotate <0,30,0> translate <0,0,-8.5>}
		   plane {-z,0 rotate <0,-30,0> translate <0,0,-8.5>}
	           plane {y,0 rotate <-60,0,0> translate <0,120,-7>}
	}
	   intersection {
		   box {<-4,0,-10>,<4,85,0>}
	           plane {y,0 rotate <0,0,60> translate <0,85,0>}
		   plane {y,0 rotate <0,0,-60> translate <0,85,0>}
	}
	   intersection {
		   box {<-4,0,-12>,<4,85,0> }
	           plane {-z,0 rotate <0,30,0> translate <0,0,-11.75>}
		   plane {-z,0 rotate <0,-30,0> translate <0,0,-11.75>}
	           plane {y,0 rotate <0,0,60> translate <0,85,0>}
		   plane {y,0 rotate <0,0,-60> translate <0,85,0>}
		   plane {y,0 rotate <-60,0,0> translate <0,85,-8.5>}
	}
	box {<-10,0,-12>,<0,0.5,1> rotate <0,0,60> translate <0,85,0>}
	box {<0,0,-12>,<10,0.5,1> rotate <0,0,-60> translate <0,85,0>}

	object {spire translate <0,120,-3.5>}
	texture {stonewall}
		}

#declare innerbuttress= union {
	box {<-3,0,-7>,<3,175,0>}
	   intersection {
		   box {<-4,0,-10>,<4,130,0>}
	           plane {y,0 rotate <0,0,60> translate <0,130,0>}
		   plane {y,0 rotate <0,0,-60> translate <0,130,0>}
	}
	box {<-10,0,-11>,<0,0.5,1> rotate <0,0,60> translate <0,130,0>}
	box {<0,0,-11>,<10,0.5,1> rotate <0,0,-60> translate <0,130,0>}
	object{spire translate <0,175,-3.5>}
	texture {stonewall}
	}

#declare flightbar = union {
	box {<-2.5,0,0>,<2.5,4,89> rotate <-45,0,0>}
	box {<-2,0,0>,<2,4.5,89> rotate <-45,0,0>}
	texture {stonewall}
	}

#declare flyingbuttress = union {
	object{innerbuttress}
	object {outerbuttress translate <0,0,-60>}
	object {flightbar translate <0,112,-60>}
	}

#declare vaunt = difference {
	union {
		intersection {
			cylinder {<13.4,60,-27>,<13.4,60,27>,41.5}
			cylinder {<-13.4,60,-27>,<-13.4,60,27>,41.5}
		}
		intersection {
			cylinder {<-27,60,13.4>,<27,60,13.4>,41.5}
			cylinder {<-27,60,-13.4>,<27.5,60,-13.4>,41.5}
		}
	}

	intersection {
		cylinder {<13.5,60,-28>,<13.5,60,28>,40.5}
		cylinder {<-13.5,60,-28>,<-13.5,60,28>,40.5}
	}
	intersection {
		cylinder {<-28,60,13.5>,<28,60,13.5>,40.5}
		cylinder {<-28,60,-13.5>,<28,60,-13.5>,40.5}
	}
	box {<-29,0,-29>,<29,63,29>}
	texture {stonewall}

}

#declare vaunt_arch = 
         union {
            intersection {
                torus {40.5,1}
                box {<13.5,-1,0>,<41,1,41>}
                translate <-13.5,0,0>
                rotate <-90,0,0>
                }
            intersection {
                torus {40.5,1}
                box {<-41,-1,0>,<-13.5,1,41>}
                translate <13.5,0,0>
                rotate <-90,0,0>
                }
           texture { Stone21_mod scale <2,4,3> }
           }

#declare vauntcap = union {
	object {vaunt}
	object {vaunt_arch rotate <0,90,0> translate <-27,60,0>}
	object {vaunt_arch rotate <0,90,0> translate <27,60,0>}
	object {vaunt_arch translate <0,60,27>}
	object {vaunt_arch translate <0,60,-27>}
	}

#declare vauntway = object {vauntcap scale <0.89,1,1.13>}

#declare vauntint = union {
	object {vaunt}
	object {vaunt_arch rotate <0,90,0> translate <-27,60,0>}
	object {vaunt_arch rotate <0,90,0> translate <27,60,0>}
	scale <0.89,1,1.13>
	}

#declare small_arches = union {
        object {arch scale <0.45,0.45,1> translate <-9,60,0>}
        object {arch scale <0.45,0.45,1> translate <9,60,0>}
        object {tallcolumn2 scale <0.5, 1, 0.5>}
}

#declare external_small_arches = union {
        object {arch scale <0.45,0.45,1> translate <-9,60,0>}
        object {arch scale <0.45,0.45,1> translate <9,60,0>}
        object {tallcolumn2 scale <0.45, 1, 0.45>}
	object {tallcolumn2 scale <0.5, 1, 0.5> translate <-18.5,0,0>}
	object {tallcolumn2 scale <0.5, 1, 0.5> translate <18.5,0,0>}
}

#declare eng_s_wall_frame =
   union {
    difference {
         box {<-27,0,0>,<27,110,1>}
         object {archway scale <0.45,0.45,1> translate <-9,60,0>}
         object {archway scale <0.45,0.45,1> translate <9,60,0>}
         box {<-17.5,1,-1>,<-1,60,2>}
         box {<1,1,-1>,<17.5,60,2>}
         cylinder {<0,76,-1>,<0,76,2>,7}
	}
       box {<-27,110,-1>,<27,112,1>}
       box {<-27,98,-.6>,<27,98.5,1>}
       box {<-27,108,-.6>,<27,108.5,1>}

       box {<-20,112,-.8>,<-10,115,1>}
       box {<-5,112,-.8>,<5,115,1>}
       box {<10,112,-.8>,<20,115,1>}
            texture {stonewall}
         }

#declare eng_l_wall_frame =
   union {
    difference {
         box {<-27,0,0>,<27,170,1>}
         object {archway scale <0.45,0.45,1> translate <-9,60,0>}
         object {archway scale <0.45,0.45,1> translate <9,60,0>}
         box {<-17.5,1,-1>,<-1,60,2>}
         box {<1,1,-1>,<17.5,60,2>}
         cylinder {<0,76,-1>,<0,76,2>,7}
	 object {archway scale <0.225,0.225,1> translate <-15,160,0>}
	 object {archway scale <0.225,0.225,1> translate <0,160,0>}
	 object {archway scale <0.225,0.225,1> translate <15,160,0>}
	 box {<-19.125,125,-1>,<-10.875,160,2>}
	 box {<-4.125,125,-1>,<4.125,160,2>}
	 box {<10.875,125,-1>,<19.125,160,2>}
	}
       box {<-27,170,-1>,<27,172,1>}
       box {<-27,112,-.6>,<27,112.5,1>}
       box {<-27,120,-.6>,<27,120.5,1>}
       box {<-27,168,-.6>,<27,168.5,1>}

       box {<-20,172,-.8>,<-10,175,1>}
       box {<-5,172,-.8>,<5,175,1>}
       box {<10,172,-.8>,<20,175,1>}

	box {<-19.123,125,-1>,<-10.875,125,1>}
	box {<-4.123,125,-1>,<4.125,125,1>}
	box {<10.875,123,-1>,<19.125,125,1>}
            texture {stonewall}
         }

//			Filled	Upper			Ring	Left
// NAME			Upper	Arches	Mesh	Glass	rotate	column
// --------------------------------------------------------------------------
// eng_outer		Y	N	Y	Y	0	N
// eng_inner		Y	*	N	N	0	N


#declare eng_outer =
        union {
             object {eng_s_wall_frame}
             object {arch translate <0,60,0>}
             object {external_small_arches}
             object {ringwindow translate <0,76,0>}
	     object {window_lead translate <-9,0,0>}
	     object {window_lead translate <9,0,0>}
//	     object {window_glass translate <-9,0,0>}
//	     object {window_glass translate <9,0,0>}

             }
#declare eng_inner =
        union {
             object {eng_l_wall_frame}
             object {arch translate <0,60,0>}
	     object {minorarch  translate <-15,160,0>}
	     object {minorarch  translate <0,160,0>}
	     object {minorarch  translate <15,160,0>}
	     object {tinycolumn translate <-19.125,125,0> }
	     object {tinycolumn translate <-10.875,125,0> }
	     object {tinycolumn translate <-4.125,125,0> }
	     object {tinycolumn translate <4.125,125,0> }
	     object {tinycolumn translate <10.875,125,0> }
	     object {tinycolumn translate <19.125,125,0> }
             object {external_small_arches}
             object {ringwindow translate <0,76,0>}
             }

#declare cathbase = union {
	box {<-35,0,-100>,<35,0.5,100>}
	box {<-100,0,-35>,<100,0.5,35>}
	box {<-34,0.5,-99>,<34,1,99>}
	box {<-99,0.5,-34>,<99,1,34>}
	box {<-33,1,-98>,<33,1.5,98>}
	box {<-98,1,-33>,<98,1.5,33>}
	box {<-32,1.5,-97>,<32,2,97>}
	box {<-97,1.5,-32>,<97,2,32>}
	texture {stonewall}
}

#declare cathlet = union {

object {eng_inner rotate <0,0,0> translate <0,0,0>}
object {eng_inner rotate <0,90,0> translate <-27,0,27>}
object {eng_inner rotate <0,-90,0> translate <27,0,27>}
object {eng_inner rotate <0,180,0> translate <0,0,54>}

object {eng_outer rotate <0,0,0> translate <0,0,-61>}
object {eng_outer rotate <0,90,0> translate <-88,0,27>}
object {eng_outer rotate <0,-90,0> translate <88,0,27>}
object {eng_outer rotate <0,180,0> translate <0,0,115>}

object {vauntint translate <0,0,-30.5>}
object {vauntint rotate <0,90,0> translate <-57.5,0,27>}
object {vauntint rotate <0,90,0> translate <57.5,0,27>}
object {vauntint translate <0,0,84.5>}

object {vauntcap translate <0,105,27>}

object {flyingbuttress rotate <0,0,0> translate <-27,0,0>}
object {flyingbuttress rotate <0,0,0> translate <27,0,0>}
object {flyingbuttress rotate <0,90,0> translate <-27,0,0>}
object {flyingbuttress rotate <0,90,0> translate <-27,0,54>}
object {flyingbuttress rotate <0,-90,0> translate <27,0,0>}
object {flyingbuttress rotate <0,-90,0> translate <27,0,54>}
object {flyingbuttress rotate <0,180,0> translate <-27,0,54>}
object {flyingbuttress rotate <0,180,0> translate <27,0,54>}

}

#declare cathskel = union {

object {vauntway translate <0,0,-30.5>}
object {vauntway rotate <0,90,0> translate <-57.5,0,27>}
object {vauntway rotate <0,90,0> translate <57.5,0,27>}
object {vauntway translate <0,0,84.5>}

object {vauntcap translate <0,15,27>}
object {vauntcap translate <0,105,27>}

object {flyingbuttress rotate <0,0,0> translate <-27,0,0>}
object {flyingbuttress rotate <0,0,0> translate <27,0,0>}
object {flyingbuttress rotate <0,90,0> translate <-27,0,0>}
object {flyingbuttress rotate <0,90,0> translate <-27,0,54>}
object {flyingbuttress rotate <0,-90,0> translate <27,0,0>}
object {flyingbuttress rotate <0,-90,0> translate <27,0,54>}
object {flyingbuttress rotate <0,180,0> translate <-27,0,54>}
object {flyingbuttress rotate <0,180,0> translate <27,0,54>}

}

#declare triang = difference {
	   box {<-5,0,-0.5>,<5,9,0.5>}
	   plane {x,0 rotate <0,0,-30> translate <-5,0,0>}
	   plane {-x,0 rotate <0,0,30> translate <5,0,0>}
	   translate <0,-4.330127,0>
	}

#declare spire_jewish = union {
		difference {
			object {triang}
			object {triang scale <0.7,0.7,2> translate <0,-0.5,0>}
			}
		difference {
			object {triang rotate <0,0,180>}
			object {triang scale <0.7,0.7,2> rotate <0,0,180>
				translate <0,0.5,0> }
			translate <0,-3,0>
			}
		cylinder {<0,-10,0>,<0,-5.9,0>,0.5}
	translate <0,10,0>
	scale <2,2,2>
	texture {Silver2}
}


#declare spire_islamic = union {
		difference {
			cylinder {<0,0,-.5>,<0,0,0.5>,4.8}
			cylinder {<0,0.9,-1>,<0,0.9,1>,4.08}
			rotate <0,0,60>
			}
	cone {<0,4.7,0>,0.25,<0,12,0>,0.1}
	sphere {<0,8,0>,0.5}
	cylinder {<0,-10,0>,<0,-4.7,0>,0.5}
	translate <0,10,0>
	scale <2,2,2>
	texture {Silver2}

}


#declare spire_christian = union {
	cylinder {<0,0,0>,<0,20,0>,0.75}
	cylinder {<-5,15,0>,<5,15,0>,0.75}
	sphere {<0,20,0>,1.1}
	sphere {<0,5,0>,1.1}
	sphere {<-5,15,0>,1.1}
	sphere {<5,15,0>,1.1}
	scale <2,2,2>
	texture {Silver2}

}

// Sky
sphere {<0,0,0>,2000 inverse
	texture {
		finish {ambient 1
			diffuse 0
			}
		pigment { color red 0 green 0 blue 0}
		}
}

// Moon
cylinder {<0,0,0>,<0,0,0.025>,125 translate <-400,700,1700>
	texture {
		finish {ambient 1}
		pigment {color red 1 green 1 blue 0.9}
		}
	}
// Moonlight
light_source { <-184, 323, 800> color HyperMurkyGothic}

// Funny non-moon highlight
light_source {<0,100,27>
              color Blue
              spotlight
              point_at <0,0,27>
              radius 80
              falloff 89
              tightness 1 }




// Cloud-sphere
sphere {<0,0,0>,1600 inverse
        texture {
	   finish {
		ambient 1.0
		diffuse 0.0
	   }
           pigment{
               agate
               color_map {
                    [ 0, .7  color Clear
			     color red 0.4 green 0.1 blue 0.42 filter 0.75]
                    [.7,  .8  color red 0.4 green 0.1 blue 0.42 filter 0.75
			      color red 0.5 green 0.4 blue 0.54 filter 0.5]
		    [.8,  .95  color red 0.5 green 0.4 blue 0.54 filter 0.5
			      color red 0.5 green 0.5 blue 0.54 filter 0.2]
		    [.95,1.001 color red 0.5 green 0.5 blue 0.54 filter 0.2
				 color red 0.5 green 0.5 blue 0.5 filter 0.1]
                    }
               scale .75
               }
           scale <1500,200,1500>
           }
}

// Cirrus Layer 1
plane {y,250 no_shadow
	texture {
	   finish {
		ambient 0.55
		}
           pigment{
               bozo
		turbulence 0.9
               color_map {
                    [ 0, .7 color Clear
			     color Clear]
                    [.7,  1.001  color Clear
			      color red 1 ]
                    }
               }
           scale <500,20,19>
           }
	rotate <0,-10,0>

}


// Jewish
object {cathskel translate <0,2,300>}
object {cathbase translate <0,0,327>}
object {spire_jewish translate <0,206,300>}
light_source {<0,200,300>
              color Blue
              spotlight
              point_at <0,220,327>
              radius 20
              falloff 29
              tightness 1 }

light_source {<0,200,327>
              color Blue
              spotlight
              point_at <0,90,327>
              radius 80
              falloff 89
              tightness 1 }


// Islamic
object {cathskel translate <-400,2,450>}
object {cathbase translate <-400,0,477>}
object {spire_islamic rotate <0,-30,0> translate <-400,206,477>}
light_source {<-375,200,450>
              color Gold
              spotlight
              point_at <-400,215,477>
              radius 20
              falloff 30
              tightness 1 }


// Christian
object {cathlet translate <400,2,450>}
object {cathbase translate <400,0,477>}
object {spire_christian translate <400,206,477>}


height_field { tga "maze4.tga"
   translate <-0.5, 0, -0.5>
   scale <1000,50,1000>
   translate <0,-50,250>
		
   texture {Stone4_mod scale <19,19,2>}

}

height_field {tga "mountain.tga"
   translate <-0.5,0,0>
   scale <2000,280,100>
   translate <0,-30,750>
   texture {Stone4_mod scale <10,10,10>}

}


