#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "fov.inc"
#include "medal.inc"
#include "fita.inc"


/* Camera: Camera01 */
/* camera {
   location <0.0000, 40.0000, 0.0000>
   direction <0, 0.8, 0>
   up <0, 0, 1>   /* right-handed coordinates */
   sky  <0, 0, 1>
   right <1.333, 0, 0>
   look_at <0.0000, 0.0000, 0.0000>
}
*/

/* Camera: Camera01 */
camera {
   location <0.0000, 100.0000, -5.0000>
   direction <0, 1.5, 0>
   up <0, 0, 1>
   sky  <0, 0, 1>
   right <1.333, 0, 0>
   look_at <0.0000, 0.3893, 5.5669>
}


/*
light_source {
    <-30.0000, 15.0000, 15.0000> color rgb <0.71, 0.71, 0.71>
    spotlight
    point_at <0.0000, 0.0000, 0.0000>
    tightness 0
    radius 22.00
    falloff 60.00
}
*/

light_source {
    <-30.0000, 15.0000, 30.0000> color rgb <0.71, 0.71, 0.71>
    spotlight
    point_at <0.0000, 0.0000, 0.0000>
    tightness 0
    radius 22.00
    falloff 90.00
}

#declare medal=
union { 
 union {
   difference {
        cylinder { <0,-1,0>, <0,1,0>, 11 open }
        cylinder { <0,-5,0>, <0,5,0>, 10 open }
        }
   cylinder { <0,-0.8,0>, <0,0.8,0>, 10 }
  } 
 disc { <0,-1,0>, <0,1,0>, 11 }
 bounded_by { sphere { <0,0,0> 11.1 } }
}

// Little ring
declare ring =
object { 
   torus { 0.7, 0.3 }
   translate <0,0,12>
   bounded_by { sphere { <0,0,12>, 1.1 } }
}


// Podium
declare podium=
union {
   box { <-11,-4,-11>, <11,7,-19> }
   box { <-28,-4,-19>, <28,7,-27> }
}




// Gold Medal
object 
{ medal
texture { GOLD_MEDAL }
}

object
{ ring
   texture { MY_GOLD }
}

object 
{
fita
}

//Silver Medal
union {
 union {  
   object { medal texture {SILVER_MEDAL} }
   object { ring texture {MY_SILVER} }
   }
 object { fita }

translate <22,0,-8>
}


//Cooper Medal
union {
 union {  
   object { medal texture {COOPER_MEDAL} }
   object { ring texture {MY_COOPER} }
   }
 object { fita }

translate <-22,0,-8>
}



object {
  plane { y, -2 }
  texture { PLANE_TEX }
  rotate 180*y
}


object {
   podium
   texture { Stone13 
             rotate 60*y   }
}



