//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 4 lights, 25 textures and 650 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 12/31/1994    (31.12.1994)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
//#include "enviro.inc"

camera {  //  Camera StdCam
  location  <-35.768, -133.597, 117.591>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-23.694, -5.128, 90.695>
}

// *******  L I G H T S *******
light_source {   // Light1
  <286.984, -68.670, 178.295>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // lampbulb
  <-72.127, 17.172, 138.365>
  color rgb <1.000, 1.000, 1.000>
}

//light_source {   // Light2
//  <277.413, -244.214, 95.471>
//  color rgb <0.404, 0.404, 0.404>
//}

//light_source {   // Light3
//  <112.075, -240.132, 95.471>
//  color rgb <0.412, 0.412, 0.412>
//}


//
// ********  T E X T U R E S  *******
//

#include "GAME4.INC"

// ********  O B J E C T S *******
#declare Cylndr001 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    EMBWood1
  }
  scale <5.000000, 5.000000, 1.500000>
}

#declare Torus001 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    EMBWood1
  }
  scale <2.500000, 2.500000, 1.000000>
  translate <0.000000, 0.000000, 1.500000>
}

#declare CSG001 = union {
  object { Cylndr001 }
  object { Torus001 }
}

#declare Cylndr2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    EMBWood1
  }
  scale <4.500000, 4.500000, 0.500000>
  translate <0.000000, 0.000000, 1.251000>
}

#declare CSG002 = difference {
  object { CSG001 }
  object { Cylndr2 }
}

#declare corkpad = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    Cork
  }
  scale <4.450000, 4.450000, 1.000000>
  translate <0.000000, 0.000000, 1.300000>
}

#declare coaster = union {
  object { CSG002 }
  object { corkpad }
}
#declare Cube001 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  scale <2.500000, 1.033000, 1.250000>
}

#declare Cube2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  scale <2.500000, 1.033000, 1.250000>
  rotate <0.000000, 0.000000, -90.000000>
}

#declare Cube3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  scale <2.500000, 1.033000, 1.250000>
  rotate <0.000000, 0.000000, -45.000000>
}

#declare Cube4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glass2
  }
  scale <2.500000, 1.033000, 1.250000>
  rotate <0.000000, 0.000000, -135.000000>
}

#declare glassbase = union {
  object { Cube001 }
  object { Cube2 }
  object { Cube3 }
  object { Cube4 }
  translate <0.000000, 0.000000, 2.747950>
}

#declare Cylndr002 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Glass2
  }
  scale <2.700000, 2.700000, 10.000000>
  translate <0.000000, 0.000000, 3.924369>
}

#declare Sphere001 = object { 
  sphere {<0,0,0>,1}
  texture {
    Glass2
  }
  scale <2.700000, 2.700000, 1.000000>
  translate <0.000000, 0.000000, 3.922407>
}

#declare outside = union {
  object { Cylndr002 }
  object { Sphere001 }
}

#declare glassoutside = union {
  object { glassbase }
  object { outside }
}

#declare Cylndr3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Transparent
  }
  scale <2.700000, 2.700000, 10.000000>
  translate <0.000000, 0.000000, 3.924369>
}

#declare Sphere2 = object { 
  sphere {<0,0,0>,1}
  texture {
    Transparent
  }
  scale <2.700000, 2.700000, 1.000000>
  translate <0.000000, 0.000000, 3.922407>
}

#declare inside = union {
  object { Cylndr3 }
  object { Sphere2 }
  scale <0.950000, 0.950000, 1.050000>
}

#declare drinkingglass = difference {
  object { glassoutside }
  object { inside }
  scale <1.250000, 1.250000, 1.250000>
  translate <0.000000, 0.000000, -0.341443>
}

union {   // drinkcoaster
  object { coaster }
  object { drinkingglass }
  translate <-46.289213, -24.591144, 76.300000>
}
#declare side = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gcside
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.200000, 10.000000, 11.250000>
}

#declare top = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gctop
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.200000, 10.000000, 11.250000>
  translate <0.000000, 0.010000, 0.010000>
}

#declare front = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gcfront
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.200000, 10.000000, 11.250000>
  translate <0.010000, 0.010000, 0.000000>
}

#declare gcbox = union {
  object { side }
  object { top }
  object { front }
  rotate <30.000000, -90.000000, 0.000000>
  translate <4.331532, -3.632897, 15.800000>
}

#declare side1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    os2side
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <4.000000, 10.300000, 12.200000>
}

#declare top1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    os2top
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <4.000000, 10.300000, 12.200000>
  translate <0.000000, 0.010000, 0.010000>
}

#declare front1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    os2front
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <4.000000, 10.300000, 12.200000>
  translate <0.010000, 0.010000, 0.000000>
}

#declare os2box = union {
  object { side1 }
  object { top1 }
  object { front1 }
  rotate <0.000000, -90.000000, 0.000000>
  translate <-0.200000, 0.000000, 4.000000>
}

#declare side2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    mesaside
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.800000, 10.900000, 12.400000>
}

#declare top2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    mesatop
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.800000, 10.900000, 12.400000>
  translate <0.000000, 0.010000, 0.010000>
}

#declare front2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    mesafnt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.800000, 10.900000, 12.400000>
  translate <0.010000, 0.010000, 0.000000>
}

#declare mesabox = union {
  object { side2 }
  object { top2 }
  object { front2 }
  rotate <0.000000, -90.000000, 0.000000>
  translate <0.000000, 0.000000, 10.800000>
}

union {
  object { gcbox }
  object { os2box }
  object { mesabox }
  translate <11.576260, 20.000000, 76.300000>
}

#declare Cube5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <18.000000, 7.500000, 13.750000>
}

#declare Cylndr4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  no_shadow
  scale <220.000000, 220.000000, 100.000000>
  translate <0.000000, 212.500000, -50.000000>
}

#declare front_plastic = intersection {
  object { Cube5 }
  object { Cylndr4 }
}

#declare Cylndr5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Transparent
  }
  scale <220.000000, 220.000000, 100.000000>
  translate <0.000000, 212.500000, -50.000000>
}

#declare Cylndr6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    galciv
  }
  scale <220.000000, 220.000000, 100.000000>
  translate <0.000000, 213.500000, -50.000000>
}

#declare picturetube1 = difference {
  object { Cylndr5 }
  object { Cylndr6 }
}

#declare Cube002 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Transparent
  }
  scale <14.000000, 3.000000, 10.625000>
  translate <0.000000, -5.000000, 0.000000>
}

#declare picturetube = intersection {
  object { picturetube1 }
  object { Cube002 }
  translate <0.000000, -0.100000, 0.000000>
}

#declare front_monitor = difference {
  object { front_plastic }
  object { picturetube }
}

#declare sony_label = object { 
  height_field {
    gif "sony.gif" 
    water_level 0.192157
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    sony
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.500000, 0.500000, 0.200000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <0.000000, -7.329948, -12.122862>
}

#declare Cube003 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <12.000000, 13.000000, 11.000000>
  translate <0.000000, 20.000000, -1.000000>
}

#declare upperleft = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 26.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-12.000000, 7.000000, 9.000000>
}

#declare upperright = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 26.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <12.000000, 7.000000, 9.000000>
}

#declare lowerleft = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 26.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-12.000000, 7.000000, -11.000000>
}

#declare lowerright = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 26.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <12.000000, 7.000000, -11.000000>
}

#declare Cube6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <13.000000, 13.000000, 10.000000>
  translate <0.000000, 20.000000, -1.000000>
}

#declare monotorrear = union {
  object { Cube003 }
  object { upperleft }
  object { upperright }
  object { lowerleft }
  object { lowerright }
  object { Cube6 }
}

#declare Cube004 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <11.875000, 18.750000, 2.500000>
  translate <0.000000, 12.717713, -14.512915>
}

#declare Cube005 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <12.000000, 1.000000, 2.000000>
  rotate <45.000000, 0.000000, 0.000000>
}

#declare Cube006 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <12.000000, 1.000000, 1.000000>
  translate <0.000000, -1.705158, 1.118747>
}

#declare basecutaway = union {
  object { Cube005 }
  object { Cube006 }
  translate <0.000000, -3.347123, -17.468963>
}

#declare monitorbase1 = difference {
  object { Cube004 }
  object { basecutaway }
}

#declare Cylndr7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 2.000000>
  rotate <90.000000, 0.000000, 0.000000>
  translate <-5.000000, -3.000000, -15.000000>
}

#declare Cylndr003 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-8.500000, -5.000000, -15.000000>
}

#declare on_off = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.500000>
  translate <9.000000, -5.500000, -14.700000>
}

#declare power_led = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    green_led
  }
  scale <0.200000, 0.200000, 0.100000>
  translate <7.000000, -5.900000, -15.000000>
}

#declare monitorbase = union {
  object { monitorbase1 }
  object { Cylndr7 }
  object { Cylndr003 }
  object { on_off }
  object { power_led }
}

#declare Cube007 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <12.000000, 12.000000, 0.500000>
  translate <0.000000, 9.000000, -21.000000>
}

#declare Sphere3 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 7.000000, -11.500000>
}

#declare monitorstand = union {
  object { Cube007 }
  object { Sphere3 }
}

union {
  object { front_monitor }
  object { sony_label }
  object { monotorrear }
  object { monitorbase }
  object { monitorstand }
  rotate <0.000000, 0.000000, 30.000000>
  translate <-29.343896, -5.887739, 97.520000>
}

#declare desktop = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <60.000000, 31.250000, 1.000000>
  translate <0.000000, 0.000000, 75.000000>
}

#declare deskrtside = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <1.000000, 31.250000, 37.500000>
  translate <-59.000000, 0.000000, 37.500000>
}

#declare desklfside = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <1.000000, 31.250000, 37.500000>
  translate <-16.750000, 0.000000, 37.500000>
}

#declare drawframe = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <21.000000, 1.000000, 37.500000>
  translate <-37.500000, -28.500000, 37.500000>
}

#declare topdrawer = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <18.250000, 1.000000, 5.000000>
  translate <-38.000000, -30.750000, 67.000000>
}

#declare middledrawer = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <18.250000, 1.000000, 10.500000>
  translate <-38.000000, -30.750000, 49.500000>
}

#declare bottomdrawer = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <18.250000, 1.000000, 17.000000>
  translate <-38.000000, -30.750000, 20.000000>
}

#declare deskftrtleg = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <2.250000, 3.000000, 37.500000>
  translate <54.000000, -24.000000, 37.500000>
}

#declare deskrearrtleg = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <2.250000, 3.000000, 37.500000>
  translate <54.000000, 24.000000, 37.500000>
}

#declare desklegbase = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pine_Wood
  }
  scale <2.250000, 21.000000, 3.000000>
  translate <54.000000, 0.000000, 3.000000>
}

union {
  object { desktop }
  object { deskrtside }
  object { desklfside }
  object { drawframe }
  object { topdrawer }
  object { middledrawer }
  object { bottomdrawer }
  object { deskftrtleg }
  object { deskrearrtleg }
  object { desklegbase }
}

plane {   // wall
  z,0
  texture {
    wallpaint
  }
  rotate <90.000000, 0.000000, 0.000000>
  translate <0.000000, 32.000000, 0.000000>
}

plane {   // wall2
  z,0
  texture {
    wallpaint
  }
  rotate <0.000000, 90.000000, 0.000000>
  translate <-200.000000, 0.000000, 0.000000>
}

cylinder {   // lightpole
  <0,0,1>, <0,0,0>, 1
  texture {
    Brass_Texture
  }
  scale <1.875000, 1.875000, 130.000000>
  translate <-72.116730, 17.245305, 0.000000>
}

#declare Cone001 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    lampshadetxt
  }
  scale <15.000000, 15.000000, 20.000000>
  rotate <-180.000000, 0.000000, 0.000000>
}

#declare lampshadecut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Transparent
  }
  scale <8.000000, 8.000000, 5.000000>
  translate <0.000000, -0.137788, -3.444712>
}

#declare Cylndr004 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Transparent
  }
  scale <16.000000, 16.000000, 1.000000>
  translate <0.000000, 0.000000, -20.500000>
}

difference {
  object { Cone001 }
  object { lampshadecut }
  object { Cylndr004 }
  translate <-72.136810, 17.246768, 148.398202>
}

#declare Cube008 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 4.200000, 6.250000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare Cube9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 4.200000, 5.750000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare Cube10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 4.700000, 5.750000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare CSG2 = union {
  object { Cube008 }
  object { Cube9 }
  object { Cube10 }
}

#declare Cylndr005 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <3.874799, 4.200000, 0.500000>
}

#declare Cylndr8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <-3.875064, 4.200000, 0.500000>
}

#declare Cylndr9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <-3.875064, -4.200000, 0.500000>
}

#declare Cylndr10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <3.875000, -4.200000, 0.500000>
}

#declare Cylndr11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, 4.200000, 0.500000>
}

#declare Cylndr12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, 4.200000, 12.000000>
}

#declare Cylndr13 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Cylndr14 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Cylndr15 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <-3.880000, -4.200000, 12.000000>
}

#declare Cylndr16 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 9.544000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <-3.880000, -5.344000, 0.500000>
}

#declare Cylndr17 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 0.500000>
}

#declare Sphere4 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, -4.200000, 12.000000>
}

#declare Sphere002 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, 4.200000, 0.500000>
}

#declare Sphere5 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, 4.200000, 0.500000>
}

#declare Sphere6 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Sphere7 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, 4.200000, 12.000000>
}

#declare Sphere8 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, 4.200000, 12.000000>
}

#declare mesh = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    steelscreen
  }
  scale <3.800000, 0.100000, 3.400000>
  translate <0.000000, -4.686930, 8.500000>
}

#declare speaker_main = union {
  object { CSG2 }
  object { Cylndr005 }
  object { Cylndr8 }
  object { Cylndr9 }
  object { Cylndr10 }
  object { Cylndr11 }
  object { Cylndr12 }
  object { Cylndr13 }
  object { Cylndr14 }
  object { Cylndr15 }
  object { Cylndr16 }
  object { Cylndr17 }
  object { Sphere4 }
  object { Sphere002 }
  object { Sphere5 }
  object { Sphere6 }
  object { Sphere7 }
  object { Sphere8 }
  object { mesh }
  texture {
    compuplastictan
  }
}

#declare controlS_edge = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 4.500000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <-3.880000, -5.310564, 0.550454>
}

#declare controlS_edg1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 4.500000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <3.880000, -5.310564, 0.550454>
}

#declare front_lower_edg = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.750000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.875000, -5.313000, 0.498288>
}

#declare cs_sphere1 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, -5.340000, 0.500000>
}

#declare controlsurfside = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.800000, 0.500000>
  translate <0.000000, -4.200000, 1.000000>
}

#declare cs_sphere2 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, -5.340000, 0.500000>
}

#declare controlsurfa1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.200000, 2.000000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <0.000000, -4.598618, 2.435233>
}

#declare controlsurfs1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.400000, 0.500000>
  translate <0.000000, -4.212564, 1.929742>
}

#declare controlsurface = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 0.800000, 2.240000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <0.000000, -4.440440, 2.640829>
}

#declare volumehole = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <1.000000, 1.000000, 0.250000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <1.369402, -4.796961, 2.341134>
}

#declare on_off_hole = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <0.600000, 1.000000, 0.250000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <2.172155, -4.418777, 3.196188>
}

#declare controlsurf = difference {
  object { controlsurface }
  object { volumehole }
  object { on_off_hole }
}

#declare led = object { 
  sphere {<0,0,0>,1}
  texture {
    led_red
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <2.927688, -4.941760, 3.978669>
}

#declare controls = union {
  object { controlS_edge }
  object { controlS_edg1 }
  object { front_lower_edg }
  object { cs_sphere1 }
  object { controlsurfside }
  object { cs_sphere2 }
  object { controlsurfa1 }
  object { controlsurfs1 }
  object { controlsurf }
  object { led }
}

union {
  object { speaker_main }
  object { controls }
  rotate <0.000000, 0.000000, 45.000000>
  translate <-52.707710, -13.568090, 76.339516>
}

#declare Cube11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 4.200000, 6.250000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare Cube12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 4.200000, 5.750000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare Cube13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 4.700000, 5.750000>
  translate <0.000000, 0.000000, 6.250000>
}

#declare CSG3 = union {
  object { Cube11 }
  object { Cube12 }
  object { Cube13 }
}

#declare Cylndr18 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <3.874799, 4.200000, 0.500000>
}

#declare Cylndr19 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <-3.875064, 4.200000, 0.500000>
}

#declare Cylndr20 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <-3.875064, -4.200000, 0.500000>
}

#declare Cylndr21 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 11.500000>
  translate <3.875000, -4.200000, 0.500000>
}

#declare Cylndr22 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, 4.200000, 0.500000>
}

#declare Cylndr23 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, 4.200000, 12.000000>
}

#declare Cylndr24 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.760000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Cylndr25 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Cylndr26 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <-3.880000, -4.200000, 12.000000>
}

#declare Cylndr27 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 9.544000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <-3.880000, -5.344000, 0.500000>
}

#declare Cylndr28 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 8.400000>
  rotate <-90.000000, -90.000000, 0.000000>
  translate <3.880000, -4.200000, 0.500000>
}

#declare Sphere9 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, -4.200000, 12.000000>
}

#declare Sphere10 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, 4.200000, 0.500000>
}

#declare Sphere11 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, 4.200000, 0.500000>
}

#declare Sphere12 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, -4.200000, 12.000000>
}

#declare Sphere13 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, 4.200000, 12.000000>
}

#declare Sphere14 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, 4.200000, 12.000000>
}

#declare mesh1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    steelscreen
  }
  scale <3.800000, 0.100000, 3.400000>
  translate <0.000000, -4.686930, 8.500000>
}

#declare speaker_main1 = union {
  object { CSG3 }
  object { Cylndr18 }
  object { Cylndr19 }
  object { Cylndr20 }
  object { Cylndr21 }
  object { Cylndr22 }
  object { Cylndr23 }
  object { Cylndr24 }
  object { Cylndr25 }
  object { Cylndr26 }
  object { Cylndr27 }
  object { Cylndr28 }
  object { Sphere9 }
  object { Sphere10 }
  object { Sphere11 }
  object { Sphere12 }
  object { Sphere13 }
  object { Sphere14 }
  object { mesh1 }
  texture {
    compuplastictan
  }
}

#declare controlS_edge1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 4.500000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <-3.880000, -5.310564, 0.550454>
}

#declare controlS_edg2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 4.500000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <3.880000, -5.310564, 0.550454>
}

#declare front_lower_e1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 7.750000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <3.875000, -5.313000, 0.498288>
}

#declare cs_sphere3 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <-3.880000, -5.340000, 0.500000>
}

#declare controlsurfsi1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.800000, 0.500000>
  translate <0.000000, -4.200000, 1.000000>
}

#declare cs_sphere4 = object { 
  sphere {<0,0,0>,1}
  texture {
    compuplastictan
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <3.880000, -5.340000, 0.500000>
}

#declare controlsurfa2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.200000, 2.000000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <0.000000, -4.598618, 2.435233>
}

#declare controlsurfs2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.380000, 0.400000, 0.500000>
  translate <0.000000, -4.212564, 1.929742>
}

#declare controlsurfac1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <3.880000, 0.800000, 2.240000>
  rotate <-15.000000, 0.000000, 0.000000>
  translate <0.000000, -4.440440, 2.640829>
}

#declare volumehole1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <1.000000, 1.000000, 0.250000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <1.369402, -4.796961, 2.341134>
}

#declare on_off_hole1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <0.600000, 1.000000, 0.250000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <2.172155, -4.418777, 3.196188>
}

#declare controlsurf1 = difference {
  object { controlsurfac1 }
  object { volumehole1 }
  object { on_off_hole1 }
}

#declare led1 = object { 
  sphere {<0,0,0>,1}
  texture {
    led_red
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <2.927688, -4.941760, 3.978669>
}

#declare controls1 = union {
  object { controlS_edge1 }
  object { controlS_edg2 }
  object { front_lower_e1 }
  object { cs_sphere3 }
  object { controlsurfsi1 }
  object { cs_sphere4 }
  object { controlsurfa2 }
  object { controlsurfs2 }
  object { controlsurf1 }
  object { led1 }
}

union {
  object { speaker_main1 }
  object { controls1 }
  translate <-5.920748, 6.725966, 76.339516>
}

#declare Cube7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <23.000000, 9.000000, 2.000000>
}

#declare maincutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <13.750000, 4.900000, 1.500000>
  translate <-8.500000, -2.800000, 0.600000>
}

#declare escapecutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <1.250000, 0.950000, 1.500000>
  translate <-21.000000, 5.000000, 0.600000>
}

#declare fk1cutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <3.750000, 0.950000, 1.500000>
  translate <-14.500000, 5.000000, 0.600000>
}

#declare fk5cutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <3.750000, 0.950000, 1.500000>
  translate <-6.500000, 5.000000, 0.600000>
}

#declare fk9cutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <3.750000, 0.950000, 1.500000>
  translate <1.500000, 5.000000, 0.600000>
}

#declare prtscrcutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <2.800000, 0.950000, 1.500000>
  translate <9.000000, 5.000000, 0.600000>
}

#declare insertcutaray = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <2.800000, 2.100000, 1.500000>
  translate <9.000000, 0.050000, 0.600000>
}

#declare uparrowcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <0.950000, 0.950000, 1.500000>
  translate <9.000000, -4.850000, 0.600000>
}

#declare leftarrowcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <2.800000, 0.950000, 1.500000>
  translate <9.000000, -6.750000, 0.600000>
}

#declare umberpadcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    MattBlack
  }
  scale <3.750000, 4.900000, 1.500000>
  translate <17.500000, -2.800000, 0.600000>
}

#declare topcutaway = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <23.500000, 10.000000, 2.000000>
  rotate <7.500000, 0.000000, 0.000000>
  translate <0.000000, 0.000000, 2.700000>
}

#declare frame = difference {
  object { Cube7 }
  object { maincutaway }
  object { escapecutaway }
  object { fk1cutaway }
  object { fk5cutaway }
  object { fk9cutaway }
  object { prtscrcutaway }
  object { insertcutaray }
  object { uparrowcut }
  object { leftarrowcut }
  object { umberpadcut }
  object { topcutaway }
}

#declare Cube40 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.350000, 1.000000, 0.625000>
}

#declare Cube41 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.360000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube42 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-4.350000, 0.000000, 0.019957>
}

#declare Cube43 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <4.360000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube44 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <4.350000, 0.000000, 0.108636>
}

#declare spacebar = difference {
  object { Cube40 }
  object { Cube41 }
  object { Cube42 }
  object { Cube43 }
  object { Cube44 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-8.510000, -6.500000, 0.200000>
}

#declare Cube35 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube36 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube37 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube38 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube39 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare backslashkey = difference {
  object { Cube35 }
  object { Cube36 }
  object { Cube37 }
  object { Cube38 }
  object { Cube39 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <4.230000, -6.500000, 0.200000>
}

#declare Cube30 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube31 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube32 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.900000, 0.000000, 0.019957>
}

#declare Cube33 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube34 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare rightcntlkey = difference {
  object { Cube30 }
  object { Cube31 }
  object { Cube32 }
  object { Cube33 }
  object { Cube34 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <1.500000, -6.500000, 0.200000>
}

#declare Cube25 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube26 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube27 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.900000, 0.000000, 0.019957>
}

#declare Cube28 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube29 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare rightaltkey = difference {
  object { Cube25 }
  object { Cube26 }
  object { Cube27 }
  object { Cube28 }
  object { Cube29 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-2.140000, -6.500000, 0.200000>
}

#declare Cube20 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube21 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube22 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.900000, 0.000000, 0.019957>
}

#declare Cube23 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube24 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare leftaltkey = difference {
  object { Cube20 }
  object { Cube21 }
  object { Cube22 }
  object { Cube23 }
  object { Cube24 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-14.880000, -6.500000, 0.200000>
}

#declare Cube15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube16 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube17 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.900000, 0.000000, 0.019957>
}

#declare Cube18 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.910000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube19 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare leftcntlkey = difference {
  object { Cube15 }
  object { Cube16 }
  object { Cube17 }
  object { Cube18 }
  object { Cube19 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-18.520000, -6.500000, 0.200000>
}

#declare Cube8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube45 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube46 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube47 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare macrokey = difference {
  object { Cube8 }
  object { Cube14 }
  object { Cube45 }
  object { Cube46 }
  object { Cube47 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-21.250000, -6.500000, 0.200000>
}

#declare spacebar_row = union {
  object { spacebar }
  object { backslashkey }
  object { rightcntlkey }
  object { rightaltkey }
  object { leftaltkey }
  object { leftcntlkey }
  object { macrokey }
}

#declare Cube95 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.600000, 1.000000, 0.625000>
}

#declare Cube96 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.600000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube97 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-2.550000, 0.000000, 0.019957>
}

#declare Cube98 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.600000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube99 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <2.550000, 0.000000, 0.108636>
}

#declare rtshift_key = difference {
  object { Cube95 }
  object { Cube96 }
  object { Cube97 }
  object { Cube98 }
  object { Cube99 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <2.600000, -4.700000, 0.600000>
}

#declare ls1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.200000, 1.000000, 0.625000>
}

#declare ls2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.200000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare ls3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-2.150000, 0.000000, 0.019957>
}

#declare ls4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.200000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare ls5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <2.150000, 0.000000, 0.108636>
}

#declare leftshift_key = difference {
  object { ls1 }
  object { ls2 }
  object { ls3 }
  object { ls4 }
  object { ls5 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-20.000000, -4.700000, 0.600000>
}

#declare Cube90 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube91 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube92 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube93 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube94 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key9 = difference {
  object { Cube90 }
  object { Cube91 }
  object { Cube92 }
  object { Cube93 }
  object { Cube94 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-0.800000, -4.700000, 0.600000>
}

#declare Cube85 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube86 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube87 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube88 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube89 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key8 = difference {
  object { Cube85 }
  object { Cube86 }
  object { Cube87 }
  object { Cube88 }
  object { Cube89 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-2.600000, -4.700000, 0.600000>
}

#declare Cube80 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube81 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube82 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube83 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube84 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key7 = difference {
  object { Cube80 }
  object { Cube81 }
  object { Cube82 }
  object { Cube83 }
  object { Cube84 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-4.400000, -4.700000, 0.600000>
}

#declare Cube75 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube76 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube77 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube78 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube79 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key6 = difference {
  object { Cube75 }
  object { Cube76 }
  object { Cube77 }
  object { Cube78 }
  object { Cube79 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-6.200000, -4.700000, 0.600000>
}

#declare Cube70 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube71 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube72 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube73 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube74 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key5 = difference {
  object { Cube70 }
  object { Cube71 }
  object { Cube72 }
  object { Cube73 }
  object { Cube74 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-8.000000, -4.700000, 0.600000>
}

#declare Cube65 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube66 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube67 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube68 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube69 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key4 = difference {
  object { Cube65 }
  object { Cube66 }
  object { Cube67 }
  object { Cube68 }
  object { Cube69 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-9.800000, -4.700000, 0.600000>
}

#declare Cube60 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube61 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube62 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube63 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube64 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key3 = difference {
  object { Cube60 }
  object { Cube61 }
  object { Cube62 }
  object { Cube63 }
  object { Cube64 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-11.600000, -4.700000, 0.600000>
}

#declare Cube55 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube56 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube57 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube58 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube59 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key2 = difference {
  object { Cube55 }
  object { Cube56 }
  object { Cube57 }
  object { Cube58 }
  object { Cube59 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-13.400000, -4.700000, 0.600000>
}

#declare Cube50 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube51 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube52 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube53 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube54 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key1 = difference {
  object { Cube50 }
  object { Cube51 }
  object { Cube52 }
  object { Cube53 }
  object { Cube54 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-15.200000, -4.700000, 0.600000>
}

#declare Cube48 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube49 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube100 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube101 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube102 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare z_key = difference {
  object { Cube48 }
  object { Cube49 }
  object { Cube100 }
  object { Cube101 }
  object { Cube102 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-17.000000, -4.700000, 0.600000>
}

#declare z_row = union {
  object { rtshift_key }
  object { leftshift_key }
  object { z_key9 }
  object { z_key8 }
  object { z_key7 }
  object { z_key6 }
  object { z_key5 }
  object { z_key4 }
  object { z_key3 }
  object { z_key2 }
  object { z_key1 }
  object { z_key }
  translate <0.000000, 0.000000, -0.150000>
}

#declare Cube103 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.200000, 1.000000, 0.625000>
}

#declare Cube104 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.250000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube105 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.100000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.250000, 0.000000, 0.019957>
}

#declare Cube106 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.240000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube107 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.100000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.200000, 0.000000, 0.108636>
}

#declare escapekey = difference {
  object { Cube103 }
  object { Cube104 }
  object { Cube105 }
  object { Cube106 }
  object { Cube107 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-21.000000, 5.000000, 1.750000>
}

#declare Cube108 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube109 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube110 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube111 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube112 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key = difference {
  object { Cube108 }
  object { Cube109 }
  object { Cube110 }
  object { Cube111 }
  object { Cube112 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-17.250000, 5.008942, 1.734853>
}

#declare Cube113 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube114 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube115 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube116 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube117 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key1 = difference {
  object { Cube113 }
  object { Cube114 }
  object { Cube115 }
  object { Cube116 }
  object { Cube117 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-15.450000, 5.008942, 1.734853>
}

#declare Cube118 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube119 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube120 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube121 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube122 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key2 = difference {
  object { Cube118 }
  object { Cube119 }
  object { Cube120 }
  object { Cube121 }
  object { Cube122 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-13.650000, 5.008942, 1.734853>
}

#declare Cube123 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube124 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube125 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube126 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube127 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key3 = difference {
  object { Cube123 }
  object { Cube124 }
  object { Cube125 }
  object { Cube126 }
  object { Cube127 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-11.850000, 5.008942, 1.734853>
}

#declare Cube128 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube129 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube130 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube131 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube132 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key4 = difference {
  object { Cube128 }
  object { Cube129 }
  object { Cube130 }
  object { Cube131 }
  object { Cube132 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-9.251875, 5.009132, 1.734853>
}

#declare Cube133 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube134 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube135 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube136 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube137 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key5 = difference {
  object { Cube133 }
  object { Cube134 }
  object { Cube135 }
  object { Cube136 }
  object { Cube137 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-7.451875, 5.009132, 1.734853>
}

#declare Cube138 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube139 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube140 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube141 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube142 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key6 = difference {
  object { Cube138 }
  object { Cube139 }
  object { Cube140 }
  object { Cube141 }
  object { Cube142 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-5.651875, 5.009132, 1.734853>
}

#declare Cube143 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube144 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube145 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube146 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube147 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key7 = difference {
  object { Cube143 }
  object { Cube144 }
  object { Cube145 }
  object { Cube146 }
  object { Cube147 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-3.851875, 5.009132, 1.734853>
}

#declare Cube148 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube149 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube150 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube151 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube152 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key8 = difference {
  object { Cube148 }
  object { Cube149 }
  object { Cube150 }
  object { Cube151 }
  object { Cube152 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-1.234342, 5.009132, 1.734853>
}

#declare Cube153 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube154 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube155 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube156 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube157 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key9 = difference {
  object { Cube153 }
  object { Cube154 }
  object { Cube155 }
  object { Cube156 }
  object { Cube157 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <0.565658, 5.009132, 1.734853>
}

#declare Cube158 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube159 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube160 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube161 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube162 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key10 = difference {
  object { Cube158 }
  object { Cube159 }
  object { Cube160 }
  object { Cube161 }
  object { Cube162 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <2.365658, 5.009132, 1.734853>
}

#declare Cube163 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube164 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube165 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube166 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube167 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key11 = difference {
  object { Cube163 }
  object { Cube164 }
  object { Cube165 }
  object { Cube166 }
  object { Cube167 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <4.165658, 5.009132, 1.734853>
}

#declare Cube168 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube169 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube170 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube171 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube172 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key12 = difference {
  object { Cube168 }
  object { Cube169 }
  object { Cube170 }
  object { Cube171 }
  object { Cube172 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <7.242000, 5.009132, 1.734853>
}

#declare Cube173 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube174 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube175 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube176 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube177 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key13 = difference {
  object { Cube173 }
  object { Cube174 }
  object { Cube175 }
  object { Cube176 }
  object { Cube177 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <9.041741, 5.009132, 1.734853>
}

#declare Cube178 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube179 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube180 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube181 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube182 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare f1_key14 = difference {
  object { Cube178 }
  object { Cube179 }
  object { Cube180 }
  object { Cube181 }
  object { Cube182 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <10.841741, 5.009132, 1.734853>
}

#declare fkeys = union {
  object { escapekey }
  object { f1_key }
  object { f1_key1 }
  object { f1_key2 }
  object { f1_key3 }
  object { f1_key4 }
  object { f1_key5 }
  object { f1_key6 }
  object { f1_key7 }
  object { f1_key8 }
  object { f1_key9 }
  object { f1_key10 }
  object { f1_key11 }
  object { f1_key12 }
  object { f1_key13 }
  object { f1_key14 }
}

#declare a6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key1 = difference {
  object { a6 }
  object { a7 }
  object { a8 }
  object { a9 }
  object { a10 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-16.200000, -2.800000, 0.700000>
}

#declare a11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key2 = difference {
  object { a11 }
  object { a12 }
  object { a13 }
  object { a14 }
  object { a15 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-14.400000, -2.800000, 0.700000>
}

#declare a1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key = difference {
  object { a1 }
  object { a2 }
  object { a3 }
  object { a4 }
  object { a5 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-18.000000, -2.800000, 0.700000>
}

#declare a16 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a17 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a18 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a19 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a20 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key3 = difference {
  object { a16 }
  object { a17 }
  object { a18 }
  object { a19 }
  object { a20 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-12.600000, -2.800000, 0.700000>
}

#declare a21 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a22 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a23 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a24 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a25 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key4 = difference {
  object { a21 }
  object { a22 }
  object { a23 }
  object { a24 }
  object { a25 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-10.800000, -2.800000, 0.700000>
}

#declare a26 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a27 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a28 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a29 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a30 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key5 = difference {
  object { a26 }
  object { a27 }
  object { a28 }
  object { a29 }
  object { a30 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-9.000000, -2.800000, 0.700000>
}

#declare a31 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a32 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a33 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a34 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a35 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key6 = difference {
  object { a31 }
  object { a32 }
  object { a33 }
  object { a34 }
  object { a35 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-7.200000, -2.800000, 0.700000>
}

#declare a36 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a37 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a38 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a39 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a40 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key7 = difference {
  object { a36 }
  object { a37 }
  object { a38 }
  object { a39 }
  object { a40 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-5.400000, -2.800000, 0.700000>
}

#declare a41 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a42 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a43 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a44 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a45 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key8 = difference {
  object { a41 }
  object { a42 }
  object { a43 }
  object { a44 }
  object { a45 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-3.600000, -2.800000, 0.700000>
}

#declare a46 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a47 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a48 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a49 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a50 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key9 = difference {
  object { a46 }
  object { a47 }
  object { a48 }
  object { a49 }
  object { a50 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-1.800000, -2.800000, 0.700000>
}

#declare a51 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a52 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a53 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a54 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a55 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare a_key10 = difference {
  object { a51 }
  object { a52 }
  object { a53 }
  object { a54 }
  object { a55 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <0.000000, -2.800000, 0.700000>
}

#declare ls6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.700000, 1.000000, 0.625000>
}

#declare ls7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.700000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare ls8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.600000, 0.000000, 0.019957>
}

#declare ls9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.700000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare ls10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.600000, 0.000000, 0.108636>
}

#declare capslock_key = difference {
  object { ls6 }
  object { ls7 }
  object { ls8 }
  object { ls9 }
  object { ls10 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-20.600000, -2.906581, 0.685554>
}

#declare a_key_row = union {
  object { a_key1 }
  object { a_key2 }
  object { a_key }
  object { a_key3 }
  object { a_key4 }
  object { a_key5 }
  object { a_key6 }
  object { a_key7 }
  object { a_key8 }
  object { a_key9 }
  object { a_key10 }
  object { capslock_key }
}

#declare a56 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a57 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a58 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a59 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a60 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key = difference {
  object { a56 }
  object { a57 }
  object { a58 }
  object { a59 }
  object { a60 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-18.600000, -0.945025, 0.974873>
}

#declare a61 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a62 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a63 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a64 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a65 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key1 = difference {
  object { a61 }
  object { a62 }
  object { a63 }
  object { a64 }
  object { a65 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-16.800000, -0.945025, 0.974873>
}

#declare a66 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a67 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a68 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a69 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a70 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key2 = difference {
  object { a66 }
  object { a67 }
  object { a68 }
  object { a69 }
  object { a70 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-15.000000, -0.945025, 0.974873>
}

#declare a71 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a72 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a73 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a74 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a75 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key3 = difference {
  object { a71 }
  object { a72 }
  object { a73 }
  object { a74 }
  object { a75 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-13.200000, -0.945025, 0.974873>
}

#declare a76 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a77 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a78 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a79 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a80 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key4 = difference {
  object { a76 }
  object { a77 }
  object { a78 }
  object { a79 }
  object { a80 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-11.400000, -0.945025, 0.974873>
}

#declare a81 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a82 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a83 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a84 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a85 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key5 = difference {
  object { a81 }
  object { a82 }
  object { a83 }
  object { a84 }
  object { a85 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-9.600000, -0.945025, 0.974873>
}

#declare a86 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a87 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a88 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a89 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a90 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key6 = difference {
  object { a86 }
  object { a87 }
  object { a88 }
  object { a89 }
  object { a90 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-7.800000, -0.945025, 0.974873>
}

#declare a91 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a92 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a93 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a94 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a95 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key7 = difference {
  object { a91 }
  object { a92 }
  object { a93 }
  object { a94 }
  object { a95 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-6.000000, -0.945025, 0.974873>
}

#declare a96 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a97 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a98 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a99 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a100 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key8 = difference {
  object { a96 }
  object { a97 }
  object { a98 }
  object { a99 }
  object { a100 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-4.200000, -0.945025, 0.974873>
}

#declare a101 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a102 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a103 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a104 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a105 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key9 = difference {
  object { a101 }
  object { a102 }
  object { a103 }
  object { a104 }
  object { a105 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-2.400000, -0.945025, 0.974873>
}

#declare a106 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a107 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a108 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a109 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a110 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key10 = difference {
  object { a106 }
  object { a107 }
  object { a108 }
  object { a109 }
  object { a110 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-0.600000, -0.945025, 0.974873>
}

#declare a111 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a112 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a113 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a114 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a115 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key11 = difference {
  object { a111 }
  object { a112 }
  object { a113 }
  object { a114 }
  object { a115 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <1.200000, -0.945025, 0.974873>
}

#declare ls11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.400000, 1.000000, 0.625000>
}

#declare ls12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.400000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare ls13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.450000, 0.000000, 0.019957>
}

#declare ls14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.400000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare ls15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.450000, 0.000000, 0.108636>
}

#declare tab_key = difference {
  object { ls11 }
  object { ls12 }
  object { ls13 }
  object { ls14 }
  object { ls15 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-20.750000, -1.106581, 0.962266>
}

#declare q_key_row = union {
  object { q_key }
  object { q_key1 }
  object { q_key2 }
  object { q_key3 }
  object { q_key4 }
  object { q_key5 }
  object { q_key6 }
  object { q_key7 }
  object { q_key8 }
  object { q_key9 }
  object { q_key10 }
  object { q_key11 }
  object { tab_key }
}

#declare a116 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a117 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a118 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a119 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a120 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare tilde_key = difference {
  object { a116 }
  object { a117 }
  object { a118 }
  object { a119 }
  object { a120 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-21.200000, 0.907712, 1.256140>
}

#declare a121 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a122 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a123 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a124 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a125 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key13 = difference {
  object { a121 }
  object { a122 }
  object { a123 }
  object { a124 }
  object { a125 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-19.400000, 0.907712, 1.256140>
}

#declare a126 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a127 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a128 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a129 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a130 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key14 = difference {
  object { a126 }
  object { a127 }
  object { a128 }
  object { a129 }
  object { a130 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-17.600000, 0.907712, 1.256140>
}

#declare a131 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a132 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a133 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a134 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a135 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key15 = difference {
  object { a131 }
  object { a132 }
  object { a133 }
  object { a134 }
  object { a135 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-15.800000, 0.907712, 1.256140>
}

#declare a136 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a137 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a138 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a139 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a140 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key16 = difference {
  object { a136 }
  object { a137 }
  object { a138 }
  object { a139 }
  object { a140 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-14.000000, 0.907712, 1.256140>
}

#declare a141 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a142 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a143 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a144 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a145 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key17 = difference {
  object { a141 }
  object { a142 }
  object { a143 }
  object { a144 }
  object { a145 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-12.200000, 0.907712, 1.256140>
}

#declare a146 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a147 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a148 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a149 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a150 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key18 = difference {
  object { a146 }
  object { a147 }
  object { a148 }
  object { a149 }
  object { a150 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-10.400000, 0.907712, 1.256140>
}

#declare a151 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a152 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a153 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a154 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a155 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key19 = difference {
  object { a151 }
  object { a152 }
  object { a153 }
  object { a154 }
  object { a155 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-8.600000, 0.907712, 1.256140>
}

#declare a156 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a157 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a158 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a159 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a160 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key20 = difference {
  object { a156 }
  object { a157 }
  object { a158 }
  object { a159 }
  object { a160 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-6.800000, 0.907712, 1.256140>
}

#declare a161 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a162 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a163 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a164 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a165 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key21 = difference {
  object { a161 }
  object { a162 }
  object { a163 }
  object { a164 }
  object { a165 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-5.000000, 0.907712, 1.256140>
}

#declare a166 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a167 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a168 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a169 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a170 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key22 = difference {
  object { a166 }
  object { a167 }
  object { a168 }
  object { a169 }
  object { a170 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-3.200000, 0.907712, 1.256140>
}

#declare a171 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a172 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a173 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a174 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a175 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key23 = difference {
  object { a171 }
  object { a172 }
  object { a173 }
  object { a174 }
  object { a175 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <-1.400000, 0.907712, 1.256140>
}

#declare a176 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare a177 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a178 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare a179 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a180 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare q_key24 = difference {
  object { a176 }
  object { a177 }
  object { a178 }
  object { a179 }
  object { a180 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <0.400000, 0.907712, 1.256140>
}

#declare Cube305 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube306 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube307 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-2.000000, 0.000000, 0.019957>
}

#declare Cube308 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube309 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare backspace = difference {
  object { Cube305 }
  object { Cube306 }
  object { Cube307 }
  object { Cube308 }
  object { Cube309 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <15.661661, -6.517414, 0.214972>
}

#declare number_keys = union {
  object { tilde_key }
  object { q_key13 }
  object { q_key14 }
  object { q_key15 }
  object { q_key16 }
  object { q_key17 }
  object { q_key18 }
  object { q_key19 }
  object { q_key20 }
  object { q_key21 }
  object { q_key22 }
  object { q_key23 }
  object { q_key24 }
  object { backspace }
}

#declare a181 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.100000, 1.000000, 0.625000>
}

#declare a182 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.100000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a183 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-2.050000, 0.000000, 0.019957>
}

#declare a184 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <2.100000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare a185 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <2.050000, 0.000000, 0.108636>
}

#declare enter_bottom = difference {
  object { a181 }
  object { a182 }
  object { a183 }
  object { a184 }
  object { a185 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <3.100000, -2.800000, 0.700000>
}

#declare a186 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.500000, 1.200000, 0.625000>
  translate <0.000000, -0.200000, 0.000000>
}

#declare a187 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.500000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare a188 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.200000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-1.450000, -0.200000, 0.019957>
}

#declare a190 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.200000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.450000, -0.200000, 0.108636>
}

#declare enter_top = difference {
  object { a186 }
  object { a187 }
  object { a188 }
  object { a190 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <3.700000, -0.945025, 0.974873>
}

#declare enter_key = union {
  object { enter_bottom }
  object { enter_top }
}

#declare Cube183 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube184 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube185 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube186 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube187 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key = difference {
  object { Cube183 }
  object { Cube184 }
  object { Cube185 }
  object { Cube186 }
  object { Cube187 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <7.250000, 0.950000, 1.270000>
}

#declare Cube188 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube189 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube190 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube191 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube192 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key3 = difference {
  object { Cube188 }
  object { Cube189 }
  object { Cube190 }
  object { Cube191 }
  object { Cube192 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <7.250000, -0.850000, 1.000000>
}

#declare Cube193 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube194 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube195 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube196 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube197 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key1 = difference {
  object { Cube193 }
  object { Cube194 }
  object { Cube195 }
  object { Cube196 }
  object { Cube197 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <9.050000, 0.950000, 1.270000>
}

#declare Cube198 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube199 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube200 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube201 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube202 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key2 = difference {
  object { Cube198 }
  object { Cube199 }
  object { Cube200 }
  object { Cube201 }
  object { Cube202 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <10.850000, 0.950000, 1.270000>
}

#declare Cube203 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube204 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube205 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube206 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube207 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key4 = difference {
  object { Cube203 }
  object { Cube204 }
  object { Cube205 }
  object { Cube206 }
  object { Cube207 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <9.050000, -0.850000, 1.000000>
}

#declare Cube208 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube209 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube210 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube211 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube212 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare insert_key5 = difference {
  object { Cube208 }
  object { Cube209 }
  object { Cube210 }
  object { Cube211 }
  object { Cube212 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <10.850000, -0.850000, 1.000000>
}

#declare insert_group = union {
  object { insert_key }
  object { insert_key3 }
  object { insert_key1 }
  object { insert_key2 }
  object { insert_key4 }
  object { insert_key5 }
}

#declare Cube213 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube214 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube215 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube216 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube217 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare left_arrow_key = difference {
  object { Cube213 }
  object { Cube214 }
  object { Cube215 }
  object { Cube216 }
  object { Cube217 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <7.250000, -6.500000, 0.200000>
}

#declare Cube218 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube219 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube220 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube221 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube222 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare left_arrow_ke1 = difference {
  object { Cube218 }
  object { Cube219 }
  object { Cube220 }
  object { Cube221 }
  object { Cube222 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <9.050000, -6.500000, 0.200000>
}

#declare Cube223 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube224 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube225 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube226 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube227 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare left_arrow_ke2 = difference {
  object { Cube223 }
  object { Cube224 }
  object { Cube225 }
  object { Cube226 }
  object { Cube227 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <10.850000, -6.500000, 0.200000>
}

#declare Cube228 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube229 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube230 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube231 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube232 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare up_arrow_key = difference {
  object { Cube228 }
  object { Cube229 }
  object { Cube230 }
  object { Cube231 }
  object { Cube232 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <9.050000, -4.700000, 0.450000>
}

#declare arrow_keys = union {
  object { left_arrow_key }
  object { left_arrow_ke1 }
  object { left_arrow_ke2 }
  object { up_arrow_key }
}

#declare Cube233 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube234 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube235 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube236 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube237 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key = difference {
  object { Cube233 }
  object { Cube234 }
  object { Cube235 }
  object { Cube236 }
  object { Cube237 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <14.700000, 0.950000, 1.270000>
}

#declare Cube238 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube239 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube240 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube241 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube242 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key1 = difference {
  object { Cube238 }
  object { Cube239 }
  object { Cube240 }
  object { Cube241 }
  object { Cube242 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <16.500000, 0.950000, 1.270000>
}

#declare Cube243 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube244 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube245 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube246 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube247 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key2 = difference {
  object { Cube243 }
  object { Cube244 }
  object { Cube245 }
  object { Cube246 }
  object { Cube247 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <18.300000, 0.950000, 1.270000>
}

#declare Cube248 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube249 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube250 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube251 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube252 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key3 = difference {
  object { Cube248 }
  object { Cube249 }
  object { Cube250 }
  object { Cube251 }
  object { Cube252 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <20.100000, 0.950000, 1.270000>
}

#declare Cube253 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube254 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube255 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube256 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube257 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key4 = difference {
  object { Cube253 }
  object { Cube254 }
  object { Cube255 }
  object { Cube256 }
  object { Cube257 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <14.700000, -0.939366, 0.978386>
}

#declare Cube258 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube259 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube260 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube261 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube262 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key5 = difference {
  object { Cube258 }
  object { Cube259 }
  object { Cube260 }
  object { Cube261 }
  object { Cube262 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <14.700000, -2.795807, 0.700882>
}

#declare Cube263 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube264 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube265 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube266 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube267 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key6 = difference {
  object { Cube263 }
  object { Cube264 }
  object { Cube265 }
  object { Cube266 }
  object { Cube267 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <14.700000, -4.708690, 0.451598>
}

#declare Cube268 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube269 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube270 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube271 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube272 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key7 = difference {
  object { Cube268 }
  object { Cube269 }
  object { Cube270 }
  object { Cube271 }
  object { Cube272 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <16.500000, -0.939366, 0.978386>
}

#declare Cube273 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube274 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube275 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube276 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube277 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key8 = difference {
  object { Cube273 }
  object { Cube274 }
  object { Cube275 }
  object { Cube276 }
  object { Cube277 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <16.500000, -2.800511, 0.700882>
}

#declare Cube278 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube279 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube280 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube281 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube282 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key9 = difference {
  object { Cube278 }
  object { Cube279 }
  object { Cube280 }
  object { Cube281 }
  object { Cube282 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <16.500000, -4.699283, 0.451598>
}

#declare Cube283 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube284 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube285 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube286 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube287 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key10 = difference {
  object { Cube283 }
  object { Cube284 }
  object { Cube285 }
  object { Cube286 }
  object { Cube287 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <18.300000, -0.944069, 0.973682>
}

#declare Cube288 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube289 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube290 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube291 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube292 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key11 = difference {
  object { Cube288 }
  object { Cube289 }
  object { Cube290 }
  object { Cube291 }
  object { Cube292 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <18.300000, -2.795807, 0.700882>
}

#declare Cube293 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube294 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube295 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube296 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube297 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare num_lock_key12 = difference {
  object { Cube293 }
  object { Cube294 }
  object { Cube295 }
  object { Cube296 }
  object { Cube297 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <18.300000, -4.703987, 0.451598>
}

#declare Cube298 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 1.000000, 0.625000>
}

#declare Cube299 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube300 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube301 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube302 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare point_key = difference {
  object { Cube298 }
  object { Cube299 }
  object { Cube300 }
  object { Cube301 }
  object { Cube302 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <18.300000, -6.499283, 0.202315>
}

#declare Cube303 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 2.000000, 0.625000>
}

#declare Cube304 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.900000, 0.075924>
}

#declare Cube310 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 2.100000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube311 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -2.000000, 0.120213>
}

#declare Cube312 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 2.100000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare kb_enter_ky = difference {
  object { Cube303 }
  object { Cube304 }
  object { Cube310 }
  object { Cube311 }
  object { Cube312 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <20.100000, -5.600000, 0.341537>
}

#declare Cube313 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 2.000000, 0.625000>
}

#declare Cube314 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.900000, 0.075924>
}

#declare Cube315 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 2.100000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-0.950000, 0.000000, 0.019957>
}

#declare Cube316 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.000000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -2.000000, 0.120213>
}

#declare Cube317 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 2.100000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <0.950000, 0.000000, 0.108636>
}

#declare kb_enter_ky1 = difference {
  object { Cube313 }
  object { Cube314 }
  object { Cube315 }
  object { Cube316 }
  object { Cube317 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <20.100000, -1.912657, 0.835141>
}

#declare Cube318 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 1.000000, 0.625000>
}

#declare Cube319 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 0.200000, 1.000000>
  rotate <10.000000, 0.000000, 0.000000>
  translate <0.000000, 1.005991, 0.075924>
}

#declare Cube320 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, 10.000000, 0.000000>
  translate <-2.000000, 0.000000, 0.019957>
}

#declare Cube321 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <1.900000, 0.200000, 1.000000>
  rotate <-10.000000, 0.000000, 0.000000>
  translate <0.000000, -1.024972, 0.120213>
}

#declare Cube322 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    compuplastictan
  }
  scale <0.200000, 1.000000, 1.000000>
  rotate <0.000000, -10.000000, 0.000000>
  translate <1.900000, 0.000000, 0.108636>
}

#declare kb_zero_key = difference {
  object { Cube318 }
  object { Cube319 }
  object { Cube320 }
  object { Cube321 }
  object { Cube322 }
  rotate <7.500000, 0.000000, 0.000000>
  translate <3.250000, 0.958180, 1.265463>
}

#declare NumericPad = union {
  object { num_lock_key }
  object { num_lock_key1 }
  object { num_lock_key2 }
  object { num_lock_key3 }
  object { num_lock_key4 }
  object { num_lock_key5 }
  object { num_lock_key6 }
  object { num_lock_key7 }
  object { num_lock_key8 }
  object { num_lock_key9 }
  object { num_lock_key10 }
  object { num_lock_key11 }
  object { num_lock_key12 }
  object { point_key }
  object { kb_enter_ky }
  object { kb_enter_ky1 }
  object { kb_zero_key }
}

union {
  object { frame }
  object { spacebar_row }
  object { z_row }
  object { fkeys }
  object { a_key_row }
  object { q_key_row }
  object { number_keys }
  object { enter_key }
  object { insert_group }
  object { arrow_keys }
  object { NumericPad }
  scale <0.900000, 0.800000, 0.900000>
  rotate <0.000000, 0.000000, 25.000000>
  translate <-14.528286, -16.490027, 78.591608>
}

