:- 
   declare('Wedge',
      object([
      intersection([
         plane([vector(0,1,0),float(0),rotate(-12,0,0)]),
         plane([vector(0,-1,0),float(0),rotate(12,0,0)])
      ]),
      texture([pigment([colour(rgb(0.6,0,0))])])
      ])
   ).
:- 
   declare('ArmComp',
      union([
         sphere([centre(0,0,0),radius(3),
            texture([pigment([colour(rgb(0.3,0.8,0.6))])])
         ]),
         union([
            sphere([centre(0,0,0),radius(0.3),scale(1,1,30)]),
            sphere([centre(0,0,0),radius(0.3),scale(1,30,1)]),
            sphere([centre(0,0,0),radius(0.3),scale(30,1,1)]),
            texture([pigment([colour(rgb(0.2,0.2,0.5))])])
         ])
      ])
   ).
monster_arm(XD,YD,ZD,Name) :- 
   %declare('Arm',
   %% generate 8 control points.
   bagof( [X,Y,Z],
      I^(  between(1,8,I),
           X is 10+XD*I-random(20),
           Y is YD*(10-random(20)),
           Z is ZD*(10-random(20))
           %X is 10+I*(5-random(10)),
           %Y is I*(5-random(10)),
           %Z is I*(5-random(10))
      ),
      Cps
   ),
   append([[0,0,0],[0,0,0],[0,0,0]],Cps,CCPs),
   forall( between(1,10,I), (
      J is I+1,
      nmember([X1,Y1,Z1],CCPs,I),
      nmember([X2,Y2,Z2],CCPs,J),
      X is X1+X2,
      Y is Y1+Y2,
      Z is Z1+Z2,
      accumulate([X,Y,Z])
   )),
   get_and_clear_accumulator(CPs),
   %% calculate the bspline points. 300 of them
   spline(b_spline,CPs,300,NPs),
   %% create 200 spheres on the bspline curve. Do it the slow way.
   forall( member(P,NPs), 
      ( [X,Y,Z]=P,
        RA is random(180),
        RB is random(180),
        accumulate(object(['ArmComp',rotate(RA,RB,0),translate(X,Y,Z)]))
      )),
   get_and_clear_accumulator(Spheres),
   declare(Name,
      object([
         union(Spheres)
      ])
   ).
:- 
   declare('MonsterTooth',
      intersection([
         sphere([centre(0,0,0),radius(39),scale(1,2,1) ]),
         cone([
            start(0,2,39),radius1(0),
            end(0,37,39),radius2(11),
            rotate(-10,0,0)
         ]),
         plane([vector(0,-1,0),float(0),rotate(10,0,0)]),
         texture([
            pigment([colour(rgb(0.8,1,0.9))]),
            finish([phong(0.8),phong_size(70),reflection(0.6)])
         ])
      ])
   ).
:- 
   declare('MonsterEye',
      sphere([centre(0,0,40),radius(4),
         texture([
            pigment([colour(rgb(0.6,0.6,0.6))]),
            finish([phong(0.8),phong_size(70),reflection(1.0)])
         ])
      ])
   ).
:- 
   monster_arm(5,2,3,'Arm1'),
   monster_arm(5,-1,0,'Arm2'),
   monster_arm(5,2,0,'Arm3'),
   monster_arm(5,-1,4,'Arm4'),
   declare('Monster',
      union([
         difference([
            union([
               difference([
                  sphere([centre(0,0,0),radius(40)]),
                  sphere([centre(0,0,0),radius(38),texture([pigment([colour(rgb(0.4,0,0))])])]),
                  texture([
                     pigment([
                        marble,
                        turbulence(2.2),
                        colour_map([
                           colour_entry(0,colour(rgb(0.6,0.5,0))),
                           colour_entry(0.8,colour(rgb(0.3,0,0))),
                           colour_entry(0.8,colour(rgb(0.6,0.5,0))),
                           colour_entry(1,colour(rgb(0.3,0,0)))
                        ]),
                        scale(100,75,150),
                        rotate(30,40,50)
                     ]),
                     normal([bumps(0.4)]),
                     finish([phong(0.8),phong_size(20)])
                  ])
               ]),
               object(['MonsterEye',rotate(-40,30,0)]),
               object(['MonsterEye',rotate(-40,-30,0)])
            ]),
            object(['Wedge',rotate(-33,0,0),translate(0,-20,10)]),
            scale(1,2,1.3)
         ]),
         object(['MonsterTooth',translate(0,-20,0)]),
         object(['MonsterTooth',translate(0,-22,0),rotate(0,23,0)]),
         object(['MonsterTooth',translate(0,-26,0),rotate(0,46,0)]),
         object(['MonsterTooth',translate(0,-31,0),rotate(0,69,0)]),
         object(['MonsterTooth',translate(0,-22,0),rotate(0,-23,0)]),
         object(['MonsterTooth',translate(0,-26,0),rotate(0,-46,0)]),
         object(['MonsterTooth',translate(0,-31,0),rotate(0,-69,0)]),
         object(['Arm1',rotate(30,0,0),translate(35,20,0)]),
         object(['Arm2',rotate(30,0,0),translate(35,0,0)]),
         object(['Arm3',rotate(-30,180,0),translate(-35,20,0)]),
         object(['Arm4',rotate(-30,180,0),translate(-35,0,0)])
      ])
   ).

