//
// tile.inc - Hop Scotch
//
// By Robert S. Creager - December 1994
// robc@bigb.stortek.com
//
// For the December 'Games' Internet ray tracing contest.
//
// This image took 16 hours - 00 minutes on a Sparc 5 with +a0.1 at 800x600.
// This image took 40 hours - ?? minutes on a 486-66  with +a0.1 at 800x600.
//
// The anti-aliasing needed to be that low to give me an acceptable look on
//   the buggy top.
//
// There are four include files - buggy.inc, tstone.inc, tile.inc & chars.inc
// There are eight height field gif maps - plasma1-8.gif  I used 8 so that
//   each tile would look different
//
// The base scale is in inches.
//
// This is my first pov scene, so comments/suggestions are more than welcome
//
// Permissions: Distribute as you wish.  Not for commercial use without
//              prior permission from the artist.
// 
// If you use any thing out of here, please mention me, and I would also
//   appreciate a copy of the final image/and/or the pov files :-)

#declare Grnt0a =
texture
   {
   pigment
      {
      granite
      turbulence 0.6
      color_map
         {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                          color rgbf <0.769, 0.686, 0.592, 0.792>]
          [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                          color rgbf <0.843, 0.753, 0.718, 0.396>]
          [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                          color rgbf <0.780, 0.667, 0.561, 0.976>]
          [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                          color rgbf <0.741, 0.659, 0.576, 0.820>]
          [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                          color rgbf <0.729, 0.502, 0.451, 0.306>]
         }
      }
    }

#declare Grnt9a =
texture
   {
   pigment
      {
      granite
      turbulence 0.6
      color_map
         {[0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                          color rgbf <0.745, 0.843, 0.835, 0.847>]
          [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                          color rgbf <0.404, 0.337, 0.337, 0.463>]
          [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                          color rgbf <0.773, 0.729, 0.745, 0.622>]
          [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                          color rgbf <0.914, 0.843, 0.725, 0.651>]
          [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                          color rgbf <0.153, 0.133, 0.208, 0.437>]
          [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                          color rgbf <0.812, 0.812, 0.812, 0.835>]
          [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                          color rgbf <0.812, 0.812, 0.812, 0.835>]
         }
      }
   }

#declare Stone8 =
texture
   {
   pigment { color White }
   finish { ambient 0.4 crand 0.06 diffuse 0.7 }
   }
texture { Grnt0a scale <2, 3, 2> rotate <0, 0, -30> }
texture { Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
          finish { ambient 0.2 diffuse 0.5 }
        }

#declare Tile_Size = 20
#declare Hop_Scotch =
union
   {
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma1.gif" inverse scale <1, .1/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      texture { Stone8 finish { reflection 6/6 specular 6/6 roughness .005 } }
      }
      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma2.gif" inverse scale <1, 3/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate z*Tile_Size
      texture { Stone8  finish { reflection 5/6 specular 5/6 roughness .005 } }
      }
      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma3.gif" inverse scale <1, 4/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate <Tile_Size/2, 0, 2*Tile_Size>
      texture { Stone8 finish { reflection 4/6 specular .04/6 roughness .005 } }
      }
      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma4.gif" inverse scale <1, 4/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate <-Tile_Size/2, 0, 2*Tile_Size>
      texture { Stone8 finish { reflection 4/6 specular 4/6 roughness .005 } }
      }

      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma5.gif" inverse scale <1, 5/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate z*Tile_Size*3
      texture { Stone8 finish { reflection 3/6 specular 3/6 roughness .005 } }
      }

      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma6.gif" inverse scale <1, 6/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate <Tile_Size/2, 0, 4*Tile_Size>
      texture { Stone8 finish { reflection 2/6 specular 2/6 roughness .005 } }
      }
      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma7.gif" inverse scale <1, 6/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate <-Tile_Size/2, 0, 4*Tile_Size>
      texture { Stone8 finish { reflection 2/6 specular 2/6 roughness .005 } }
      }
      
   difference
      {
      box { <0, -1, 0>+Small_Number <.95, 1, .95> }
      height_field { gif "plasma8.gif" inverse scale <1, 7/6, 1> }
      scale <Tile_Size-1, 1 Tile_Size-1>
      translate z*Tile_Size*5
      texture { Stone8 finish { reflection 1/6 specular 1/6 roughness .005 } }
      }
   }
