//
// tstone.inc - Tomb stone
//
// By Robert S. Creager - December 1994
// robc@bigb.stortek.com
//
// For the December 'Games' Internet ray tracing contest.
//
// This image took 16 hours - 00 minutes on a Sparc 5 with +a0.1 at 800x600.
// This image took 40 hours - ?? minutes on a 486-66  with +a0.1 at 800x600.
//
// The anti-aliasing needed to be that low to give me an acceptable look on
//   the buggy top.
//
// There are four include files - buggy.inc, tstone.inc, tile.inc & chars.inc
// There are eight height field gif maps - plasma1-8.gif  I used 8 so that
//   each tile would look different
//
// The base scale is in inches.
//
// This is my first pov scene, so comments/suggestions are more than welcome
//
// Permissions: Distribute as you wish.  Not for commercial use without
//              prior permission from the artist.
// 
// If you use any thing out of here, please mention me, and I would also
//   appreciate a copy of the final image/and/or the pov files :-)

#declare Char_Texture = texture { Rob_Marble scale .1 finish { ambient 1 } }

#declare Word_THE =
union
   {
   object { Char_T translate x*Width*0 }
   object { Char_H translate x*Width*1 }
   object { Char_E translate x*Width*2 }
   }

#declare Word_GAME =
union
   {
   object { Char_G translate x*Width*0 }
   object { Char_A translate x*Width*1 }
   object { Char_M translate x*Width*2 }
   object { Char_E translate x*Width*3 }
   }

#declare Word_OF =
union
   {
   object { Char_O translate x*Width*0 }
   object { Char_F translate x*Width*1 }
   }

#declare Word_LIFE =
union
   {
   object { Char_L translate x*Width*0 }
   object { Char_I translate x*Width*1 }
   object { Char_F translate x*Width*2 }
   object { Char_E translate x*Width*3 }
   }

#declare Word_IS =
union
   {
   object { Char_I translate x*Width*0 }
   object { Char_S translate x*Width*1 }
   }

#declare Word_OVERColon =
union
   {
   object { Char_O translate x*Width*0 }
   object { Char_V translate x*Width*1 }
   object { Char_E translate x*Width*2 }
   object { Char_R translate x*Width*3 }
   object { Char_Colon translate x*Width*15/4 }
   }

#declare Word_INFINITE =
union
   {
   object { Char_I translate x*Width*0 }
   object { Char_N translate x*Width*1 }
   object { Char_F translate x*Width*2 }
   object { Char_I translate x*Width*3 }
   object { Char_N translate x*Width*4 }
   object { Char_I translate x*Width*5 }
   object { Char_T translate x*Width*6 }
   object { Char_E translate x*Width*7 }
   }

#declare Word_CONTINUES =
union
   {
   object { Char_C translate x*Width*0 }
   object { Char_O translate x*Width*1 }
   object { Char_N translate x*Width*2 }
   object { Char_T translate x*Width*3 }
   object { Char_I translate x*Width*4 }
   object { Char_N translate x*Width*5 }
   object { Char_U translate x*Width*6 }
   object { Char_E translate x*Width*7 }
   object { Char_S translate x*Width*8 }
   }

#declare Word_RIP =
union
   {
   object { Char_R translate x*Width*0/2 }
   object { Char_I translate x*Width*3/2 }
   object { Char_P translate x*Width*6/2 }
   }

#declare Word_1994 =
union
   {
   object { Char_1 translate x*Width*0/2 }
   object { Char_9 translate x*Width*2/2 }
   object { Char_9 translate x*Width*4/2 }
   object { Char_4 translate x*Width*6/2 }
   }

#declare Word_Signature =
union
   {
   object { Char_C translate x*Width*0 }
   object { Char_R translate x*Width*1 }
   object { Char_E translate x*Width*2 }
   object { Char_A translate x*Width*3 }
   object { Char_G translate x*Width*4 }
   object { Char_E translate x*Width*5 }
   object { Char_R translate x*Width*6 }
   }

#declare Line_0 =
object
   {
   object { Word_RIP }
   texture { Char_Texture }
   translate < -6*Width/4, Height*4/2, 0>
   }

#declare Line_1 =
union
   {
   object { Word_THE }
   object { Word_GAME translate x*Width*4 }
   object { Word_OF translate x*Width*17/2 }
   texture { Char_Texture }
   translate < -(19*Width/4), 0, 0>
   }

#declare Line_2 =
union
   {
   object { Word_LIFE }
   object { Word_IS translate x*Width*9/2 }
   object { Word_OVERColon translate x*Width*7 }
   texture { Char_Texture }
   translate < -(20*Width/4), -Height*3/2, 0>
   }

#declare Line_3 =
union
   {
   object { Word_THE }
   object { Word_INFINITE translate x*Width*7/2 }
   texture { Char_Texture }
   translate < -(21*Width/4), -Height*6/2, 0>
   }

#declare Line_4 =
object
   {
   object { Word_GAME }
   texture { Char_Texture }
   translate < -3*Width/2, -Height*9/2, 0>
   }

#declare Line_5 =
object
   {
   object { Word_CONTINUES }
   texture { Char_Texture }
   translate < -8*Width/2, -Height*12/2, 0>
   }

#declare Line_6 =
union
   {
   object { Word_1994 }
   object { Word_Signature translate x*Width*9/2 }
   texture { Char_Texture }
   translate < -(21*Width/4), -Height*15/2, 0>
   }

#declare Tomb_Stone =
difference
   {
   merge
      {
      cylinder { -z*(1+Small_Number) z*(1+Small_Number) 1 }
      box { <-1, -8/3, -1> <1, 0, 1> }
      texture { Blood_Marble scale .3
                finish { reflection .3 ambient 0 diffuse .7 brilliance 1
                         specular .7 roughness .0002 }
                pigment { quick_color Grey } }
      scale <15, 15, 6>
      bounded_by { box { <-15, -40, -6> <15, 15, 6> } }
      }
   object { Line_0 translate -z*6 }
   object { Line_1 translate -z*6 }
   object { Line_2 translate -z*6 }
   object { Line_3 translate -z*6 }
   object { Line_4 translate -z*6 }
   object { Line_5 translate -z*6 }
   object { Line_5 translate -z*6 }
   object { Line_6 translate -z*6 }
   }
