// wjgjenga.pov -- the game Jenga.
//
// 12.31.94   Joey Gibson <wjg@atl.ema.eds.com>
//
// (C) Copyright 1994 Joey Gibson
//
// @(#) $Header: /usr1/wjg/src/scenes/contest/dec/RCS/j2.pov,v 1.5 1994/12/28 06:07:18 wjg Exp wjg $
//
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

#include "sky.inc"                              // blue sky
#include "ttop.inc"                             // a nice marble table top
#include "tleg.inc"                             // stand for the table top

#declare VertSpace  = 0.1525                    // vertical spacing distance
#declare HorzSpace  = 0.27                      // horizontal spacing distance
#declare PieceLength = 0.75                     // how long a Jenga piece is
#declare PieceHeight = 0.15                     // how high
#declare PieceDepth  = 0.25                     // how deep

//////////////////////////////////////////////////////////////////////////////
// Jenga Block                                                              //
//////////////////////////////////////////////////////////////////////////////
#declare JengaPiece = box {                     // this is the Jenga block
                                                // will be centered at <0,0,0>
  <-(PieceLength/2), 0, -(PieceDepth/2)>,
  <PieceLength/2, PieceHeight, PieceDepth/2>
}

//////////////////////////////////////////////////////////////////////////////
// OneTwoThree - a level with all three blocks still there                  //
//////////////////////////////////////////////////////////////////////////////
#declare OneTwoThree = union {
  object {                                      // middle piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate -90*y
      rotate 30*x
    }
  }
  object {                                      // left piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate 90*y
      rotate 40*x
    }
    translate (- HorzSpace)*z
  }
  object {                                      // right piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 1000>
      rotate -90*y
      rotate 32*x
    }
    translate HorzSpace*z                   
  }
}

//////////////////////////////////////////////////////////////////////////////
// OneTwo - level with only left & middle blocks still there                //
//////////////////////////////////////////////////////////////////////////////
#declare OneTwo = union {
  object {                                      // middle piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate 90*y
      rotate 30*x
    }
  }
  object {                                      // right piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate -90*y
      rotate 120*x
    }
    translate HorzSpace*z
  }
}

//////////////////////////////////////////////////////////////////////////////
// OneThree - level with middle block missing                               //
//////////////////////////////////////////////////////////////////////////////
#declare OneThree = union {
  object {                                      // left piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate -90*y
      rotate 38*x
    }
    translate (-HorzSpace)*z
  }
  object {                                      // right piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 750>
      rotate 90*y
      rotate 120*x
    }
    translate HorzSpace*z
  }
}

//////////////////////////////////////////////////////////////////////////////
// TwoThree - level with left block missing                                 //
//////////////////////////////////////////////////////////////////////////////
#declare TwoThree = union {
  object {                                      // middle piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate -90*y
      rotate 30*x
    }
  }
  object {                                      // left piece
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate 90*y
      rotate 35*x
    }
    translate (-HorzSpace)*z
  }
}

//////////////////////////////////////////////////////////////////////////////
// OneOrThree - level with only an outside block                            //
//////////////////////////////////////////////////////////////////////////////
#declare OneOrThree = object {
  JengaPiece
  texture {
    Yellow_Pine
    scale <1, 1, 640>
    rotate 90*y
    rotate 31*x
  }
  translate (-HorzSpace)*z
}

//////////////////////////////////////////////////////////////////////////////
// The Camera                                                               //
//////////////////////////////////////////////////////////////////////////////
camera {
  location <0, 2.55, -3>
  up <0, 1.3, 0>
  right <1.36, 0, 0>
  look_at  <0, 2.2, 0>
}

//////////////////////////////////////////////////////////////////////////////
// Light Sources                                                            //
//////////////////////////////////////////////////////////////////////////////
light_source { <2,  20, -5> color White }
light_source { <-2, 20, -5> color White }
light_source { <0, 2,  -5>  color White }

//////////////////////////////////////////////////////////////////////////////
// Begin the Jenga Tower                                                    //
//////////////////////////////////////////////////////////////////////////////
union {
  object {                                      // level 1
    OneThree
  }
  object {                                      // level 2
    OneThree
    rotate -90*y
    translate VertSpace*y
  }
  object {                                      // level 3
    TwoThree
    translate (2*VertSpace)*y
  }
  object {                                      // level 4
    OneTwoThree
    rotate -90*y
    translate (3*VertSpace)*y
  }
  object {                                      // level 5
    OneThree
    translate (4*VertSpace)*y
  }
  object {                                      // level 6
    OneTwo
    rotate -90*y
    translate (5*VertSpace)*y
  }
  object {                                      // level 7
    OneTwo
    translate (6*VertSpace)*y
  }
  object {                                      // level 8
    OneThree
    rotate -90*y
    translate (7*VertSpace)*y
  }
  object {                                      // level 9
    OneThree
    translate (8*VertSpace)*y
  }
  object {                                      // level 10
    OneThree
    rotate -90*y
    translate (9*VertSpace)*y
  }
  object {                                      // level 11
    OneThree
    translate (10*VertSpace)*y
  }
  object {                                      // level 12
    OneTwoThree
    rotate -90*y
    translate (11*VertSpace)*y
  }
  object {                                      // level 13
    OneTwo
    translate (12*VertSpace)*y
  }
  object {                                      // level 14
    TwoThree
    rotate -90*y
    translate (13*VertSpace)*y
  }
  object {                                      // level 15
    OneTwo
    translate (14*VertSpace)*y
  }
  object {                                      // level 16
    OneThree
    rotate -90*y
    translate (15*VertSpace)*y
  }
  object {                                      // level 17
    JengaPiece
    texture {
      Yellow_Pine
      scale <1, 1, 500>
      rotate -90*y
      rotate 30*x
    }
    translate (16*VertSpace)*y
  }
  object {                                      // level 18
    OneTwoThree
    rotate -90*y
    translate (17*VertSpace)*y
  }
  object {                                      // level 19
    OneTwoThree
    translate (18*VertSpace)*y
  }
  object {                                      // level 20
    OneTwoThree
    rotate -90*y
    translate (19*VertSpace)*y
  }
  object {                                      // level 21
    OneTwoThree
    translate (20*VertSpace)*y
  }
  object {                                      // level 22
    OneTwoThree
    rotate -90*y
    translate (21*VertSpace)*y
  }
  object {                                      // level 23
    OneTwoThree
    translate (22*VertSpace)*y
  }
  object {                                      // level 24
    OneOrThree
    rotate -90*y
    translate (23*VertSpace)*y
  }
  bounded_by {
    box { <-0.375, 0, -0.405>, <0.375, 3.66, 0.405> }
  }
  scale <0.5, 0.5, 0.5>
  rotate -70*y
  translate 2*y
}

//////////////////////////////////////////////////////////////////////////////
// The Blue Sky                                                             //
//////////////////////////////////////////////////////////////////////////////
object {
  TheBlueSky
}

//////////////////////////////////////////////////////////////////////////////
// Marble Table Top                                                         //
//////////////////////////////////////////////////////////////////////////////
object {                                        // the table top
  TableTop
  scale <1.5, 1, 1.5>
  translate 1.99*y                              // so it is just below the
}                                               // jenga tower

//////////////////////////////////////////////////////////////////////////////
// Grassy Yard                                                              //
//////////////////////////////////////////////////////////////////////////////
plane {                                         // the ground
  <0, 1, 0>, 0
  texture {
    pigment {
      granite
      color_map {
        [1.0 color DarkGreen]
      }
    }
    normal {
      bumps 0.4
      scale 0.2
    }
  }
}

//////////////////////////////////////////////////////////////////////////////
// Concrete Patio                                                           //
//////////////////////////////////////////////////////////////////////////////
box {                                           // the patio
  <0, 0, 0>, <6, 0.1, 6>
  pigment {
    granite
    color_map{
      [0.3 color Gray40]
      [0.5 color Gray60]
      [0.7 color Gray05]
      [1.0 color Gray70]
    }
  }
  translate <-3, 0, -3>
}

//////////////////////////////////////////////////////////////////////////////
// The Table Leg                                                            //
//////////////////////////////////////////////////////////////////////////////
object {                                        // the table leg
  TableLeg
  scale <0.5, 1, 0.5>
  translate <0, -0.1, 0>
  pigment { color Black }
  finish  { phong 1 }
}

    
