/*

	It's a quarter to three, there's no one in the place,
	Except you and me.

	I've always been fascinated with the "beam" that a spot
	or search light shows in the air through which it passes.

	So make it one for my baby, and one more for the road.

	Copyright (C) 1995
	Russ Jones
	Wichita, KS
	rjones@southwind.net
	http://www2.southwind.net/~rjones

*/

#include "colors.inc"
#include "textures.inc"

/* mic stand */
#declare mic_metal = texture
{
  Polished_Chrome
  finish
  {
    ambient 0.9
  }
}

#declare base =
difference
{
  sphere
  {
    <0, 0, 0>
    1
    scale <1, 0.2, 1>
  }
  box
  {
    <-1, -1, -1>
    < 1, 0.02, 1>
  }
  texture
  {
    pigment { Gray20 }
    finish
    {
      roughness 0.1
      ambient 0.5
    }
  }
}

#declare rod1 = cylinder
{
  <0, 0, 0>
  <0, 3.5, 0>
  0.1
  texture { mic_metal }
}

#declare rod2 = cylinder
{
  <0, 3.5, 0>
  <0, 6, 0>
  0.06
  texture { mic_metal }
}

#declare joint = cylinder
{
  <0, 3.4, 0>
  <0, 3.6, 0>
  0.12
  texture { mic_metal }
}

#declare ball = union
{
  sphere
  {
    <0, 0, 0>
    0.15
    texture
    {
      pigment { Gray50 }
      finish { ambient 0.5 crand 0.5 }
    }
  }
  torus
  {
    0.15 0.01
    texture { mic_metal } 
    rotate <0, 0, 90>
  }
}

#declare mic = union
{
  object {ball translate <0, 0, -0.4>}
  cone
  {
    <0, 0, -0.4> 0.1
    <0, 0,  0.4> 0.06
    texture { mic_metal }
  }
  rotate <15, 0, 0>
  translate <0, 6, 0>
}    

#declare mic_stand = union
{
  object {base}
  object {rod1}
  object {rod2}
  object {joint}
  object {mic}
  bounded_by
  {
    box
    {
      <-1, 0, -1>
      < 1  7,  1>
    }
  }
}

object
{
  mic_stand
  translate <0, 0, 7>
}


/* Wooden stool */

#declare wood_txt =
texture
{
  pigment { color red 1.0 green 0.71875 blue 0.25 }
  finish {ambient 0.5}
  scale <15, 0.1, 0.1>
}

#declare stool_leg =
cylinder
{
  <-0.67, 0, 0>
  <-0.5, 3.5, 0>
  0.08
}

#declare rung1 = cylinder
{
  <-0.62, 1, 0>
  <0, 1, 0.62>
  0.05
}

#declare rung2 = cylinder
{
  <- 0.64, 0.5, 0>
  <0, 0.5, 0.64>
  0.05
}

#declare rung3 = cylinder
{
  <- 0.6, 1.5, 0>
  <0, 1.5, 0.6>
  0.05
}

#declare water_glass =
difference
{
  cone
  {
    <0, 3.6, 0> 0.15
    <0, 4.5, 0> 0.20
  }
  cone
  {
    <0.2, 3.62, 0.15> 0.13
    <0.2, 4.50001, 0.15> 0.18
  }
  texture
  {
    Glass3
    finish { ambient 0.45 }
  }
}

#declare stool =
union
{
  object {stool_leg}
  object {stool_leg rotate <0, 90, 0>}
  object {stool_leg rotate <0, 180, 0>}
  object {stool_leg rotate <0, 270, 0>}
  object { rung1 rotate <0, 90, 0>}
  object { rung1 rotate <0, 270, 0>}
  object { rung2}
  object { rung2 rotate <0, 180, 0>}
  object { rung3 }
  object { rung3 rotate <0, 180, 0>}
  cylinder
  {
    < 0, 3.5, 0>
    < 0, 3.6, 0>
    0.7
  }
  object { water_glass }
  texture {wood_txt}
  scale <1, 0.75, 1>
}

object
{
  stool
  rotate <0, 15, 0>
  translate < -1.6, 0, -2.35>
}



/* Spot light */

#declare spot =
light_source
{
  < 0, 40, 100>
  color White
  spotlight
  point_at <0, 0, 0>
  radius 2
  falloff 2.5
  tightness 6
  looks_like
  {
    sphere
    {
      <0, 0, 0> 0.3
      texture
      {
	pigment { White }
	finish { Luminous ambient 4 }
      }
    }
  }
}

object { spot }
object { spot }
object { spot }
object { spot }

difference
{
  sphere
  {
    <0, 40, 100>
    4
  }
  sphere
  {
    <0, 40, 100>
    3.99
  }
  texture { Glass3 finish { Phong_Glossy ambient 0.25 } }
  no_shadow
}  

difference
{
  sphere
  {
    <0, 40, 100>
    2.5
  }
  sphere
  {
    <0, 40, 100>
    2.49
  }
  texture { Glass3 finish { Phong_Glossy ambient 0.25 } }
  no_shadow
}

#declare Glint =
disc
{
  <0, 0, 0>
  z,
  1.0
  texture
  {
    pigment
    {
      onion
      color_map
      {
	[0.0, 1.0001 color White
		     color Clear]
      }
    }
    finish { Phong_Glossy ambient 0.65 }
  }
  scale <15, 1, 1>
}

object
{
  Glint
  rotate <0, 0, 15>
  translate <0, 40, 100.1>
}

object
{
  Glint
  rotate <0, 0, 105>
  translate <0, 40, 100.1>
}
  

light_source
{
  < 30, 35, 750>
  color White
  spotlight
  point_at <0, 40, 100>
  radius 2
  falloff 2.5
  tightness 6
}

/* the spotlight's beam */

plane
{
  y, 0
  texture
  {
    pigment
    {
      gradient z
      color_map
      {
        [0.0 color White filter 1.00]
        [1.0 color White filter 0.0]
      }
      scale <1, 1, 107>
    }
    finish { ambient 0.4 }
  }
  rotate <-21.801, 0, 0>
  clipped_by
  {
    cone
    {
      <0, 0, 0> 4
      <0, 40, 100> 0.2
    }
  }
  no_shadow
}

/* The Stage */

plane
{
  y, 0
  texture
  {
    pigment { White }
    finish
    {
      ambient 0.0
      diffuse 0.9
      roughness 0.05
    }
  }
}



camera
{
  location <10, 7, -40>
  direction <0, 0, 1.5>
  look_at <0, 7, 10>
}
