#include "colors.inc"
#include "textures.inc"

camera { 
	location <1,0,-3>
	right <4/3, 0, 0>
	up y
 	look_at <1,-1,3>

}
//background { color NeonPink }

//light_source { <100, 200, -500> color Gray85 }
/*light_source { 
	<0,100,0> 
	color Gray50 
	spotlight
	point_at <0,0,0>
	radius 200
}*/
//light_source { <-160, 320, -40> color White }
//light_source { <-16, 32, -40> color White }

//background {color Pink}

default
{
pigment { color White }
}

#declare switch = difference {
	box {
		<-.1,-.025, -0.075>, <.1,.025,.075>
	}
	cylinder {
		<0,.2125,-1>, <0,.2125,1>,.2125
	}
	scale <1.1,1,1>
}

#declare base = union {
	cylinder { <0,.075,0>,<0,0,0>,1 }
	cylinder { <0,.18,0>,<0,.075,0>,.82 }
	difference {
		cylinder { <0,.18,0>,<0,.85,0>,.64 }
		box { <0,1,2>,<1,-1,-2> }
		cylinder { <0,0,.64>, <0,.87,.64>, .18 }
		translate <-.01,0,0>
	}
	difference {
		cylinder { <0,.18,0>,<0,.85,0>,.64 }
		box {<0,1,2>,<-1,-1,-2> }
		cylinder { <0,0,.64>, <0,.87,.64>, .18 }
		translate <.01,0,0>
	}
	difference {
		cone { <0,.85,0>, .64, <0,.87,0>, .59 }
		box { <0,1,2>,<1,-1,-2> }
		cylinder { <0,0,.64>, <0,.9,.64>, .18 }
		translate <-.01,0,0>
	}
	 difference {
                cone { <0,.85,0>, .64, <0,.87,0>, .59 }
                box { <0,1,2>,<-1,-1,-2> }
		cylinder { <0,0,.64>, <0,.90,.64>, .18 }                
		translate <.01,0,0>
        }
	cylinder { <0,.18, .64>, <0, .79, .64>, .18 }
	
}

#declare segment = union
{
	cylinder {<0,0,0>,<0,.02,0>,.08}
	cylinder {<0,.02,0>,<0,.04,0>,.075}
}


#declare stempart = union // ugh
{
	object { segment translate <0,.130, 0.00> rotate -00.0*x }
	object { segment translate <0,.155, 0.01> rotate -02.7*x }
	object { segment translate <0,.180, 0.02> rotate -05.4*x }
	object { segment translate <0,.205, 0.03> rotate -08.1*x }
	object { segment translate <0,.230, 0.04> rotate -10.8*x }
	object { segment translate <0,.255, 0.05> rotate -13.5*x }
	object { segment translate <0,.280, 0.06> rotate -16.2*x }
	object { segment translate <0,.305, 0.07> rotate -18.9*x }
	object { segment translate <0,.330, 0.08> rotate -21.6*x }
	object { segment translate <0,.355, 0.09> rotate -24.3*x }
	object { segment translate <0,.380, 0.10> rotate -27.0*x }
	object { segment translate <0,.405, 0.11> rotate -29.7*x }
	object { segment translate <0,.430, 0.12> rotate -32.4*x }
	object { segment translate <0,.455, 0.13> rotate -35.1*x }
	object { segment translate <0,.480, 0.14> rotate -37.8*x }
	object { segment translate <0,.505, 0.15> rotate -40.5*x }
	object { segment translate <0,.530, 0.16> rotate -43.2*x }
}

#declare stem = union 
{
	cone {<0,0,0>, .09, <0,.13, 0>, .08 }
	stempart
	object { 
                cylinder {<0,0,0>,<0,2,0>,.08}
                rotate -57*x
                translate <0,.50,-.25>
        }
	object {stempart rotate -57*x translate <0,1.523,-1.816>}
}
	
#declare head = union 
{
	difference {
		sphere { <0,0,0>, .5 }
		box { <-1,0,-1>,<1,-1,1> }
		box { <-1,0,-1>,<0,1,1>}
		sphere { <0,0,0>, .47 }
		translate <.01,0,0>
	}
	difference {
		sphere { <0,0,0>,.5}
		box { <-1,0,-1>,<1,-1,1> }
		box { <1,0,-1>,<0,1,1>}
		sphere { <0,0,0>,.47}
		translate <-.01,0,0>
	}
	cone { <0,.15,.4>,.1,<0,.15,.6>,.09}
	difference {
		sphere { <0,0,0>, .485 }
                box { <-1,0,-1>,<1,-1,1> }
                sphere { <0,0,0>, .47 }
        }
	difference {
		sphere {<0,0,0>,.47 }
		box {<-1,0,-1>,<1,-1,1> }
		difference {
			sphere {<0,0,0>,.455}
			box {<-.5,0,.1>,<.5,.5,.6>}
		}
		
		texture { Silver_Texture }
		finish {
			diffuse 0.85
			crand 0.3
			reflection 0.5
		}
	}
	light_source { 
		<0,.10,0> color White 
		area_light <.05,.06,.15>,<-.05,.01,-.05>,10,10
		jitter
	}
	light_source {
		<0,.10,0> color White
		spotlight
		point_at <0,-1,0>
		radius 50
	}
}

#declare lamp = union {

	object {
		base	
		translate <0,0,0>
	}

	object {
		switch
		scale .8
		translate <0,.885,-.38>
	}
	object {
		stem
		translate <0,.79 , .64>
	}
	object {
		head
		translate <0,2.3,-2.2>
	}
	finish { ambient .65324 }
}

#declare mywood = pigment  //"borrowed" from scenes/level2/oak2.pov 
{
	wood
	turbulence 0.1
	color_map {
      	[0.00 0.10 color SemiSweetChoc color SemiSweetChoc]
      	[0.10 0.90 color SemiSweetChoc color DarkWood ]
      	[0.90 1.01 color DarkWood      color DarkWood ]
   }
}

plane {
	z,8
	pigment { color White }
	finish { ambient .5 }
}
 
box {
	<-10,-1,7>,<4,-10,-5>
	texture {
		pigment {
			mywood
			scale <0.45, 0.45, 0.7>
			rotate 90*y
		}
		finish {
			Shiny
			reflection 0.35
			ambient 0.5 diffuse 0.85 //ambient used to be 0.075
			phong 0
			phong_size 0
		}
	}
	texture {
		finish {
			Shiny
			ambient 0.5 diffuse 0.7
			phong 0
			phong_size 0
		}
		pigment { Clear }
	}
	translate <0,-1,0>
}

box {
	<0,-1,0>,<1,-1,-1.01>
	translate <0.1,0,1.2>
	pigment {
		color White
	}
	finish {
		ambient .7
	}

}

object { 
	lamp 
	translate <-1, -2, 6>
	rotate 30*y
}
