#declare driveTx = texture { Copper_Metal }

#declare gearTx = texture { Gold_Metal }

#declare blob1 = 
object {
  intersection {
    blob {
      threshold 0.13
      component 1, 5, < 0, 0, 0>
      component 1, 3.5, < 5, 0, 0>
    }
    box { <-8.5, -1.5, -8.5>, < 8.5, 1.5, 8.5> }
  }
}

#declare notes =
object {
  union {
    object { blob1 }
    object { blob1 rotate y*90 }
    object { blob1 rotate y*130 }
    object { blob1 rotate y*180 }
    object { blob1 rotate y*270 }
    cylinder { <0, -1.51, 0>, <0, 1.51, 0>, 5 }
  }
}

object {
  union {
    cylinder { < 0, 10, 0>, < 0, 84, 0>, 4 }
    object { notes translate < 0, 74, 0 > }   
    object { notes translate < 0, 54, 0 > rotate y*45 }   
    object { notes translate < 0, 34, 0 > rotate y*-45 }   
    object { notes translate < 0, 14, 0 > rotate y*180 }   
  }
  texture { driveTx } 
  bounded_by { cylinder { < 0, 9.9, 0>, < 0, 84.1, 0>, 8.6 } }
  translate < -83.2, 0, 0 >
}

object { // Base
  cylinder { < 0, -35, 0>, <0, -23, 0>, 5 texture { driveTx } translate < -83.2, 0, 0> }
}

#declare tooth =
object {
  union {
    triangle { <-7,  0,  0>, < 7,  0,  0>, <0,  0, 11> } //top 
    triangle { <-7, -5,  0>, < 7, -5,  0>, <0, -5, 11> } //bottom
    triangle { <-7,  0,  0>, <-7, -5,  0>, <0,  0, 11> } //face1
    triangle { < 0, -5, 11>, <-7, -5,  0>, <0,  0, 11> }
    triangle { < 7,  0,  0>, < 7, -5,  0>, <0,  0, 11> } //face2
    triangle { < 0, -5, 11>, < 7, -5,  0>, <0,  0, 11> }
  }
}

#declare teeth = object {
  union {
    object { tooth }
    object { tooth rotate y*40 }
    object { tooth rotate y*80 }
    object { tooth rotate y*120 }
    object { tooth rotate y*160 }
    object { tooth rotate y*200 }
    object { tooth rotate y*240 }
    object { tooth rotate y*280 }
    object { tooth rotate y*320 }
  } 
}

#declare gearWheel = 
object {
  union {
    cylinder { < 0, 0, 0>, < 0, -5, 0>, 7 }
    object { teeth }
  }
  clipped_by { cylinder { <0,-6,0>, <0,1,0>, 10 } }
}

object { // Drive gear on main beam
  union {
    cylinder { < 0, 10, 0>, < 0, -35, 0>, 1 }
    object { gearWheel }
  }
  texture { gearTx }
  translate < -83.2, 0, 0 >
}


object { // Horizonal drive
  gearWheel
  texture { gearTx }
  rotate x*90
  rotate z*20
  translate < -83.2, -11, -9 >
}
