#declare holderTx = texture { Copper_Metal }
#declare vWireTx = texture { Copper_Metal }

// Holder for pipe
object { 
  union {
    torus { 30, 1 translate < 0, -33, 0 > }
    torus { 11, 1 translate < 0, -6.5, 0 > }
    cylinder { < 30, -33,   0 >, < 10, -6.5,   0 >, 1 }
    cylinder { <-30, -33,   0 >, <-10, -6.5,   0 >, 1 }
    cylinder { <  0, -33,  30 >, < 0,  -6.5,  10 >, 1 }
    cylinder { <  0, -33, -30 >, < 0,  -6.5, -10 >, 1 }
    texture { holderTx }
  }
}

// Holder for hands
#declare handSup = object {
  union {
    // Rings for horizontal wires to go through.  NB Offset due to gravity!
    // H Wires centred at y=14, 34, 54, 74.
    // They are radius 2.
    torus { 3, 1.2 rotate x*90 rotate y*90 translate <-50, 15.8, 0 > }
    torus { 3, 1.2 rotate x*90 rotate y*90 translate <-50, 35.8, 0 > }
    torus { 3, 1.2 rotate x*90 rotate y*90 translate <-50, 55.8, 0 > }
    torus { 3, 1.2 rotate x*90 rotate y*90 translate <-50, 75.8, 0 > }

    // Base
    torus { 2.4, 1.2 translate <-50, -26.6, 0> }
    torus { 3.6, 1.2 translate <-50, -29.0, 0> }
    torus { 4.8, 1.2 translate <-50, -31.4, 0> }
    torus { 6.0, 1.2 translate <-50, -33.8, 0> }

    // Join em up
    cylinder { <-50, -25.4, 0>,  <-50, 12.8, 0>, 1.2 }
    cylinder { <-50, 18.8, 0>, <-50, 32.8, 0>, 1.2 }
    cylinder { <-50, 38.8, 0>, <-50, 52.8, 0>, 1.2 }
    cylinder { <-50, 58.8, 0>, <-50, 72.8, 0>, 1.2 }
  }
  texture { vWireTx }
}

object { handSup translate < 5, 0, 0> }
object { handSup translate <-8, 0, 0> }

// Extra stuff in base
object {
  union {
    cylinder { <-58, -26.6, -2.4>, <-45, -26.6, -2.4>, 1.2 }
    cylinder { <-58, -26.6,  2.4>, <-45, -26.6,  2.4>, 1.2 }
    cylinder { <-58, -29.0, -3.6>, <-45, -29.0, -3.6>, 1.2 }
    cylinder { <-58, -29.0,  3.6>, <-45, -29.0,  3.6>, 1.2 }
    cylinder { <-58, -31.4, -4.8>, <-45, -31.4, -4.8>, 1.2 }
    cylinder { <-58, -31.4,  4.8>, <-45, -31.4,  4.8>, 1.2 }
    cylinder { <-58, -33.8, -6.0>, <-45, -33.8, -6.0>, 1.2 }
    cylinder { <-58, -33.8,  6.0>, <-45, -33.8,  6.0>, 1.2 }
  }
  texture { vWireTx }
}

