// Scene File: HORNJRC.INC, for POV-Ray v2.x
//
// Include file for HORNJRC.POV - Joel R. Cheves
//
// Created on 2/13/95 at 12:41 am

#declare Textures_Inc_Temp = version
#version 2.0

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "povcolr.inc"

#declare Jrc_Marble = 
 pigment 
  {agate
   color_map 
    {[0.0, 0.3   color blue 1.00
                 color blue 0.94]
     [0.3, 1.001 color blue 0.94
                 color blue 0.75]
     }
  }
 
#declare Polished_Brass = texture {
    pigment { color red 0.578 green 0.422 blue 0.195 }
    finish {
        metallic
        ambient 0.1
        diffuse 0.8
        brilliance 6.0
        reflection 0.4
        phong 0.8
        phong_size 120
   }
}

#declare jrc_Brass = texture {
  pigment { color red 0.63 green 0.47 blue 0.11 }     
   finish {
       metallic
        ambient 0.1
        diffuse 0.6  //.8
        brilliance 3      //6.0
        reflection 0.4
        phong 0.8
        phong_size 120
      }
}

#declare Horntop =
union {                 //object 6
  cone { <0, -0.6, 0>, 0.02, <0, 0, 0>, .013
     rotate <0.0, 0.0, 90.0>
     translate <-0.287658, 0.0, -0.044>
      texture {Polished_Brass}
    }
  object {          //object 1       
    torus {0.3, 0.02
     rotate <90.0, 0.0, 0.0>
     translate <0.30957, -0.298272, -0.044>
      texture {Polished_Brass}
     }
   clipped_by {
  union {
    plane { <1, 0, 0>, 0 inverse  // object 12
     scale <0.03, 0.03, 0.03>
     translate <0.307041, -0.002875, -0.044458>
   }
    plane { <0, 1, 0>, 0 //inverse  object 8
     scale <0.03, 0.03, 0.03>
     translate <0.010665, -0.297665, -0.052833>
    } 
   }
  }
 }
}

#declare Piston_bar =
union {
  cylinder {<0, -0.265, 0>, <0, 0.265, 0>, 0.02
  rotate <-4.25, 0.0, 90.0>
  translate <0.320738, -0.2465, -0.0225>
       texture {Polished_Brass}
     }
  object {
 torus {0.055, 0.02  //#3
   rotate <90.0, -3.0, 0.0>
   translate <0.064667, -0.299193, -0.041496>
       texture {Polished_Brass}
     }
   clipped_by {
    plane { <1, 0, 0>, 0   // object 10
     scale <0.03, 0.03, 0.03>
     translate <0.065849, -0.242667, -0.003067>
     }
    plane { <0, 1, 0>, 0 inverse  // object 8
     scale <0.03, 0.03, 0.03>
     translate <0.010665, -0.297665, -0.052833>
     } 
   }
 }
}

#declare Floogle =   //object 2
object {
 union {
 object {        //2
   torus {0.45, 0.02
    rotate <90.0, 0.0, 0.0>
    translate <0.210326, -0.450963, 0.0>   //0.220326=x  211326=2y
         texture {Polished_Brass}
     }

  clipped_by {
  union {
  plane { <1, 0, 0>, 0  //object 13
    scale <0.03, 0.03, 0.03> 
    translate <0.220542, 0.001, -0.003067>
     }
    plane { <0, 1, 0>, 0   // object 9
     scale <0.03, 0.03, 0.03>
     rotate <0.0, 0.0, 17.5>
     translate <0.626222, -0.285867, 0.0>
 
     } 
   }
  }
 }
 object {        //4 connector
   torus {0.055, 0.02
    rotate <90.0, -4.1, 0.0>
    translate <0.576421, -0.299276, -0.003>
       texture {Polished_Brass}
     }
  clipped_by {
   plane { <1, 0, 0>, 0 inverse  //object 11 
     scale <0.03, 0.03, 0.03>
     translate <0.579667, -0.242875, -0.003067>
   }
    plane { <0, 1, 0>, 0 inverse   // object 9
     scale <0.03, 0.03, 0.03>
     rotate <0.0, 0.0, 17.5>
     translate <0.626222, -0.285867, 0.0>
     } 
    }
   }
 }   //end union
}   //end object

#declare Disks =  //#s 25,26,27
  disc { <0, 0, 0>, <0, 1, 0>, 0.034, 0.0001
   translate <0.229166, -0.14, -0.05>
      texture {Polished_Brass}
   }
 disc { <0, 0, 0>, <0, 1, 0>, 0.034, 0.0001
   translate <0.319, -0.14, -0.045>
      texture {Polished_Brass}
   }
  disc { <0, 0, 0>, <0, 1, 0>, 0.034, 0.0001
   translate <0.4087, -0.14, -0.04>
      texture {Polished_Brass}
   }

#declare Drop =
union {
 object {        
 torus {0.05, 0.015  // TORUS # 28
   rotate <0.0, 90.0, 90.0>
   translate <0.22279, -0.45, -0.08>
    texture {Polished_Brass}
     }

  clipped_by {
 plane { <0, 1, 0>, 0  // PLANE # 34
   scale <0.03, 0.03, 0.03>
   rotate <90.0, 0.0, 0.0>
   translate <0.223061, -0.4, -0.07>
   }
 plane { <0, 1, 0>, 0 inverse  // PLANE #33
   scale <0.03, 0.03, 0.03>
   translate <0.223816, -0.45, -0.13>
   } 
  }
 }

 cylinder {<0, -0.125, 0>, <0, 0.125, 0>, 0.015  // #31
   translate <0.22279, -0.573, -0.13>
     texture {Polished_Brass}
}

 object {
 torus {0.05, 0.015   //#30
  rotate <0.0, 90.0, 90.0>
  translate <0.412552, -0.45, -0.07>
    texture {Polished_Brass}
     }
  clipped_by {
 plane { <0, 1, 0>, 0   //#36
  scale <0.03, 0.03, 0.03>
  rotate <90.0, 0.0, 0.0>
  translate <0.412416, -0.41, -0.058>
   }
 plane { <0, 1, 0>, 0 inverse  //#35 
  scale <0.03, 0.03, 0.03>
  translate <0.412552, -0.45, -0.12>
   } 
  }
 }
 cylinder {<0, -0.125, 0>, <0, 0.125, 0>, 0.015  //#32
   translate <0.412552, -0.573, -0.12>
     texture {Polished_Brass}
    }
  } //end object 32

 object {      //#29
  torus {0.095, 0.015
    rotate <90.0, -3.0, 0.0>
    translate <0.31788, -0.697, -0.125>
     texture {Polished_Brass}
    }
  clipped_by {
  plane { <0, 1, 0>, 0   //#37
   scale <0.13, 0.03, 0.03>
   translate <0.317192, -0.697, -0.123>
   }
 }
}
