// DRAPES.INC
//
// Drapery Object - Borrowed from Dan Farmer's Drapery Kit
//
// Neil Clark - 2/95
//
// For the 2/95 'Sound/Music' Ray Tracing Contest
//

#declare Fabric = height_field {
    tga "drapemap.tga" smooth
    scale <1, 0.2, 4>
    rotate x * 90
    translate -x * 0.5
}

#declare Drapes =
object { Fabric clipped_by { object { Cube scale <0.1, 5, 1> inverse }}}

#declare Valance = 
object {
    Fabric
    scale <2, 0.15, 1>
    rotate y*180
}

#declare My_Drapes = union {
   // Nice long curtain...
   object { Fabric  scale <4, 1, 1> translate <1.5,0,0> }
   object { Fabric  scale <4, 1, 1> translate <-1,0,0> }
   object { Fabric  scale <4, 1, 1> translate <-4,0,0> }
   object { Valance scale <4, 1, 1> translate <0, -0.075, -0.075>}
   pigment {
       gradient x
       color_map {
           // blue set
           [0.3 color MidnightBlue ]
           [0.6 color Blue ]
           [1.0 color Navy ]
       }
   scale 0.1
   }
 translate y * 2
}

