// KEY.INC
//
// Piano Keys Object - For PIANO.POV
//
// Neil Clark - 2/95
//
// For the 2/95 'Sound/Music' Ray Tracing Contest
//

#declare white_key_texture = texture
 {
  pigment { colour  White } finish { Shiny }
 }

#declare black_key_texture = texture {
   pigment { colour Black } finish { Shiny }
}

#declare key_body = union
  {
   object { box { <0, 0, 0.02>, <0.875, 0.98, 5.75> }} // sides
   object { box { <0.02, 0, 0.02>, <0.873, 1, 5.75> }} // top
   object { box { <0.02, 0, 0>, <0.873, 0.98, 5.75> }} // end
   // left-top curve
   object { cylinder { <0.02,  0.98, 0> < 0.02,  0.98, 5.75> 0.02 }}
   // right-top curve
   object { cylinder { <0.873,  0.98, 0> < 0.873,  0.98, 5.75> 0.02 }}
   // top-front curve
   object { cylinder { <0.02,  0.98, 0> < 0.873,  0.98, 0.02> 0.02 }}
   // left-front curve
   object { cylinder { <0.02,  0, 0.02> < 0.02,  0.98, 0.02> 0.02 }}
   // right-front curve
   object { cylinder { <0.873,  0, 0.02> < 0.873,  0.98, 0.02> 0.02 }}
   // left-front ball
   object { sphere { <0.02,  0.98, 0>  0.02 }}
   // right-front ball
   object { sphere { <0.873,  0.98, 0.01>  0.02 }}
   texture { white_key_texture }
}

#declare Black_Key = object
  {
    box { <0, 0, 1.9>, <0.5, 1.5, 5.75> } texture { black_key_texture }
    clipped_by {
      plane { -z, 0 }
      rotate <25, 0, 0>
      translate <0, 0, 1.45>
    }
   texture { black_key_texture }
  }


#declare C_Key = difference
 {
  object { key_body }
  object { box { <0.5,-1, 1.875>,< 1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare D_Key = difference
 {
  object { key_body }
  object { box { <-0.5, -1, 1.875>,< 0.1875, 2, 6> } texture { white_key_texture }}
  object { box { <0.6875, -1, 1.875>,< 1.1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare E_Key = difference
 {
  object { key_body }
  object { box { <-1,-1, 1.875>,< 0.375, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare F_Key = difference
 {
  object { key_body }
  object { box { <0.5,-1, 1.875>,< 1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare G_Key = difference
 {
  object { key_body }
  object { box { <-0.5, -1, 1.875>,< 0.125, 2, 6> } texture { white_key_texture }}
  object { box { <0.625, -1, 1.875>,< 1.1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare A_Key = difference
 {
  object { key_body }
  object { box { <-0.5, -1, 1.875>,< 0.25, 2, 6> } texture { white_key_texture }}
  object { box { <0.75, -1, 1.875>,< 1.1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare Low_A_Key = difference
 {
  object { key_body }
  object { box { <0.75, -1, 1.875>,< 1.1, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare B_Key = difference
 {
  object { key_body }
  object { box { <-1,-1, 1.875>,< 0.375, 2, 6> } texture { white_key_texture }}
  rotate <0, 0, 0>
  translate <0, 0, 0>
  bounded_by { box { <-1,-1,-1>,<2,2,8> }}
 }

#declare Chord = union
{
 object { C_Key rotate <0,0,0> translate <0,-1,0> }
 object { Black_Key translate <0.6,-1,0> }
 object { D_Key rotate <0,0,0> translate <1,-1,0> }
 object { Black_Key translate <1.8, -1, 0> }
 object { E_Key rotate <0,0,0> translate <2,-1,0> }
 object { F_Key rotate <0,0,0> translate <3,-1,0> }
 object { Black_Key translate <3.6, -1, 0> }
 object { G_Key rotate <0,0,0> translate <4,-1,0> }
 object { Black_Key translate <4.7, -1, 0> }
 object { A_Key rotate <0,0,0> translate <5,-1,0> }
 object { Black_Key translate <5.8, -1, 0> }
 object { B_Key rotate <0,0,0> translate <6,-1,0> }
}

#declare All_Keys = union
 {
  // 2 lower white keys
  object { Low_A_Key rotate <0,0,0> translate <-2,-1,0> }
  object { Black_Key translate <-1.2, -1, 0> }
  object { B_Key rotate <0,0,0> translate <-1,-1,0> }
  // chord ranges
  object { Chord }
  object { Chord translate <7,0,0> }
  object { Chord translate <14,0,0> }
  object { Chord translate <21,0,0> }
  object { Chord translate <28,0,0> }
  object { Chord translate <35,0,0> }
  object { Chord translate <42,0,0> }
  // high - c
  object { key_body translate <49,-1,0> }
 }

